/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import java.util.zip.CRC32;
import org.vishia.mainCmd.MainCmd;
import org.vishia.util.FileSystem;
import org.vishia.util.StringFormatter;
import org.vishia.util.StringFunctions;

public class FileList {
    public static final int version = 20130808;
    final Args args;
    final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd_HH:mm:ss");
    final StringFormatter formatter = new StringFormatter(new StringBuilder(100));
    final CRC32 crcCalculator = new CRC32();

    public FileList(Args args) {
        this.args = args;
        if (args.out == null) {
            args.out = System.out;
        }
    }

    public static void list(String string, String string2, String string3) throws IOException {
        Args args = new Args();
        args.sDirectory = string;
        args.crc = true;
        args.sMask = string2;
        args.sFileList = string + "/" + string3;
        FileList fileList = new FileList(args);
        fileList.list();
    }

    protected void list() throws IOException {
        LinkedList<FileSystem.FileAndBasePath> linkedList = new LinkedList<FileSystem.FileAndBasePath>();
        FileSystem.addFilesWithBasePath(new File(this.args.sDirectory), this.args.sMask, linkedList);
        TreeMap<String, FileSystem.FileAndBasePath> treeMap = new TreeMap<String, FileSystem.FileAndBasePath>();
        for (FileSystem.FileAndBasePath object : linkedList) {
            boolean bl = false;
            if (object.localPath.startsWith("/.bzr")) {
                bl = true;
            }
            if (bl) continue;
            treeMap.put(object.localPath, object);
        }
        Object object = null;
        object = new FileWriter(this.args.sFileList);
        for (Map.Entry entry : treeMap.entrySet()) {
            this.writeOneFile((Writer)object, (FileSystem.FileAndBasePath)entry.getValue());
        }
        if (object != null) {
            try {
                ((Writer)object).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void writeOneFile(Writer writer, FileSystem.FileAndBasePath fileAndBasePath) throws IOException {
        long l = fileAndBasePath.file.lastModified();
        l = (l + 5000L) / 10000L * 10000L;
        long l2 = fileAndBasePath.file.length();
        this.formatter.reset();
        this.formatter.addint(l2, "2222'222'222'222 ");
        StringBuilder stringBuilder = new StringBuilder("       ");
        if (fileAndBasePath.file.isDirectory()) {
            stringBuilder.setCharAt(1, 'D');
        }
        if (fileAndBasePath.file.canExecute()) {
            stringBuilder.setCharAt(2, 'x');
        }
        if (!fileAndBasePath.file.canRead()) {
            stringBuilder.setCharAt(3, 'h');
        }
        if (!fileAndBasePath.file.canWrite()) {
            stringBuilder.setCharAt(4, 'r');
        }
        if (fileAndBasePath.file.isHidden()) {
            stringBuilder.setCharAt(5, 'H');
        }
        int n = 0;
        if (this.args.crc && fileAndBasePath.file.isDirectory()) {
            this.formatter.add("==DIR===");
        } else {
            try {
                int n2;
                this.crcCalculator.reset();
                FileInputStream fileInputStream = new FileInputStream(fileAndBasePath.file);
                byte[] byArray = new byte[4096];
                while ((n2 = ((InputStream)fileInputStream).read(byArray)) > 0) {
                    this.crcCalculator.update(byArray, 0, n2);
                }
                ((InputStream)fileInputStream).close();
                n = (int)this.crcCalculator.getValue();
                this.formatter.addHex(n, 8);
            }
            catch (Exception exception) {
                this.formatter.add("????????");
            }
        }
        this.formatter.add(' ');
        writer.append(this.dateFormat.format(new Date(l)));
        writer.append(stringBuilder);
        writer.append(this.formatter.getBuffer());
        writer.append(fileAndBasePath.localPath);
        writer.append("\n");
    }

    public static void touch(String string, String string2, Appendable appendable) throws IOException {
        Args args = new Args();
        args.out = appendable;
        args.sDirectory = string;
        args.crc = true;
        args.sMask = "*";
        args.sFileList = string + "/" + string2;
        FileList fileList = new FileList(args);
        fileList.touch();
    }

    public void touch() {
        BufferedReader bufferedReader = null;
        File file = new File(this.args.sDirectory);
        try {
            String string;
            bufferedReader = new BufferedReader(new FileReader(this.args.sFileList));
            while ((string = bufferedReader.readLine()) != null) {
                this.readOneLine(string, file);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        if (bufferedReader != null) {
            try {
                bufferedReader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void readOneLine(String string, File file) {
        try {
            Date date = this.dateFormat.parse(string);
            long l = date.getTime();
            long l2 = StringFunctions.parseLong(string, 26, 16, 10, null, " '");
            String string2 = string.substring(53);
            File file2 = new File(file, string2);
            if (!file2.exists()) {
                this.args.out.append("FileList - touch, file not exist; ").append(string2).append("\n");
            } else if (!file2.isDirectory()) {
                long l3 = file2.lastModified();
                if (file2.length() == l2) {
                    if (Math.abs(l - l3) > 6000L) {
                        int n;
                        this.crcCalculator.reset();
                        FileInputStream fileInputStream = new FileInputStream(file2);
                        byte[] byArray = new byte[4096];
                        while ((n = ((InputStream)fileInputStream).read(byArray)) > 0) {
                            this.crcCalculator.update(byArray, 0, n);
                        }
                        ((InputStream)fileInputStream).close();
                        int n2 = (int)this.crcCalculator.getValue();
                        int n3 = StringFunctions.parseIntRadix(string, 43, 8, 16, null);
                        if (n2 == n3) {
                            file2.setLastModified(l);
                            this.args.out.append("FileList - touching; ").append(string2).append("\n");
                        } else {
                            this.args.out.append("FileList - touch, file with same length is changed; ").append(string2).append("\n");
                        }
                    }
                } else {
                    this.args.out.append("FileList - touch, file is changed; ").append(string2).append("\n");
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        FileList.smain(stringArray, true);
    }

    public static String smain(String[] stringArray) {
        return FileList.smain(stringArray, false);
    }

    private static String smain(String[] stringArray, boolean bl) {
        String string = null;
        Args args = new Args();
        CmdLine cmdLine = new CmdLine(args, stringArray);
        try {
            try {
                cmdLine.parseArguments();
            }
            catch (Exception exception) {
                string = "Jbat - Argument error ;" + exception.getMessage();
                cmdLine.report(string, exception);
                cmdLine.setExitErrorLevel(5);
            }
            if (args.cCmd != '\u0000') {
                FileList fileList = new FileList(args);
                if (string == null) {
                    try {
                        switch (args.cCmd) {
                            case 'L': {
                                fileList.list();
                                break;
                            }
                            case 'T': {
                                fileList.touch();
                            }
                        }
                    }
                    catch (Exception exception) {
                        string = "Jbat - Any internal error;" + exception.getMessage();
                        cmdLine.report(string, exception);
                        exception.printStackTrace(System.out);
                        cmdLine.setExitErrorLevel(3);
                    }
                }
            } else {
                cmdLine.writeHelpInfo(null);
            }
        }
        catch (Exception exception) {
            string = exception.getMessage();
        }
        if (bl) {
            cmdLine.exit();
        }
        return string;
    }

    protected static class CmdLine
    extends MainCmd {
        public final Args argData;
        protected final MainCmd.Argument[] argList = new MainCmd.Argument[]{new MainCmd.Argument("", "[L|T|C|D]: List, Touch date, Compare, last files per Date", new MainCmd.SetArgument(){

            @Override
            public boolean setArgument(String string) {
                CmdLine.this.argData.cCmd = string.charAt(0);
                return true;
            }
        }), new MainCmd.Argument("-l", ":<files.txt> The list file ", new MainCmd.SetArgument(){

            @Override
            public boolean setArgument(String string) {
                CmdLine.this.argData.sFileList = string;
                return true;
            }
        }), new MainCmd.Argument("-d", ":<directory path>  ", new MainCmd.SetArgument(){

            @Override
            public boolean setArgument(String string) {
                CmdLine.this.argData.sDirectory = string;
                return true;
            }
        }), new MainCmd.Argument("-m", ":<Mask> mask of files", new MainCmd.SetArgument(){

            @Override
            public boolean setArgument(String string) {
                CmdLine.this.argData.sMask = string;
                return true;
            }
        })};

        protected CmdLine(Args args, String[] stringArray) {
            super(stringArray);
            this.argData = args;
            super.addAboutInfo("Generating a list of files or evaluating it");
            super.addAboutInfo("made by HSchorrig, Version 1.0, 2013-08-07..2013-08-07");
            super.addArgument(this.argList);
            super.addStandardHelpInfo();
        }

        @Override
        protected void callWithoutArguments() {
        }

        @Override
        protected boolean checkArguments() {
            return true;
        }
    }

    public static class Args {
        public char cCmd;
        public String sDirectory;
        public String sMask;
        public Appendable out;
        public boolean crc = true;
        public String sFileList;
    }
}

