/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.states;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.EventObject;
import java.util.LinkedList;
import java.util.Map;
import org.vishia.event.EventTimeout;
import org.vishia.states.StateAction;
import org.vishia.states.StateComposite;
import org.vishia.states.StateMachine;
import org.vishia.states.StateParallel;
import org.vishia.util.Assert;
import org.vishia.util.DataAccess;
import org.vishia.util.Debugutil;
import org.vishia.util.IndexMultiTable;
import org.vishia.util.InfoAppend;

public abstract class StateSimple
implements InfoAppend {
    public static final int version = 20130511;
    public static final int notTransit = 0;
    public static final int mEventConsumed = 1;
    public static final int mEventDonotRelinquish = 2;
    private static final int mMaskReservedInEventConsumer = 65532;
    public static final int mTransit = 131072;
    public static final int mStateEntered = 262144;
    public static final int mStateLeaved = 524288;
    public static final int mRunToComplete = 0x100000;
    public static final int mEventNotConsumed = 0x200000;
    public static final int mFlatHistory = 0x400000;
    public static final int mDeepHistory = 0x800000;
    protected StateMachine stateMachine;
    protected StateSimple enclState;
    protected StateComposite stateCtrl;
    private Object auxInfo;
    protected StateSimple[] statePath;
    protected String stateId;
    int millisectimeout;
    private Timeout transTimeout;
    EventTimeout evTimeout;
    protected final int modeTrans;
    public int ctEntry;
    public long dateLastEntry;
    public long durationLast;
    protected StateAction entry;
    protected Runnable exit;
    private Method entryMethod;
    private Method exitMethod;
    private boolean bCheckTransitionArray;
    private Trans[] aTransitions;

    protected StateSimple() {
        this.modeTrans = 0x100000;
    }

    public void setAuxInfo(Object object) {
        this.auxInfo = object;
    }

    public Object auxInfo() {
        return this.auxInfo;
    }

    public StateComposite stateCtrl() {
        return this.stateCtrl;
    }

    protected int entry(EventObject eventObject) {
        if (this.entry != null) {
            return this.entry.exec(eventObject);
        }
        return 0;
    }

    protected void exit() {
        if (this.exit != null) {
            this.exit.run();
        }
    }

    void buildStatePathSubstates(StateSimple stateSimple, int n) {
        this.buildStatePath(stateSimple);
    }

    final void buildStatePath(StateSimple stateSimple) {
        if (stateSimple == null) {
            this.statePath = new StateSimple[1];
            this.statePath[0] = this;
        } else {
            StateSimple stateSimple2 = this.enclState;
            while (stateSimple2 != null && !(stateSimple2 instanceof StateComposite) && !(stateSimple2 instanceof StateParallel)) {
                stateSimple2 = stateSimple2.enclState;
            }
            if (stateSimple2 instanceof StateComposite) {
                this.stateCtrl = (StateComposite)stateSimple2;
            }
            int n = stateSimple.statePath.length;
            this.statePath = new StateSimple[n + 1];
            System.arraycopy(stateSimple.statePath, 0, this.statePath, 0, n);
            this.statePath[n] = this;
        }
    }

    void createTransitionListSubstate(int n) {
        this.createTransitionList(this, null, 0);
    }

    void createTransitionList(Object object, Trans trans, int n) {
        Object[] objectArray;
        IndexMultiTable<String, Object> indexMultiTable = new IndexMultiTable<String, Object>(IndexMultiTable.providerString);
        Class<?> clazz = object.getClass();
        if (n > 2) {
            Debugutil.stop();
        }
        if (n > 10) {
            throw new IllegalArgumentException("too many recursion, choice-transition; state=" + this.stateId);
        }
        try {
            Object object2;
            Object object3;
            Object object42;
            Object object5;
            int n2;
            Class<?>[] classArray = clazz.getDeclaredClasses();
            objectArray = classArray;
            int n3 = objectArray.length;
            for (n2 = 0; n2 < n3; ++n2) {
                Object object6 = objectArray[n2];
                if (!DataAccess.isOrExtends(object6, Trans.class)) continue;
                object5 = ((Class)object6).getDeclaredConstructors();
                object42 = ((Class)object6).getDeclaredConstructor(this.getClass());
                ((Constructor)object42).setAccessible(true);
                object3 = (Trans)((Constructor)object42).newInstance(this);
                ((Trans)object3).transId = ((Class)object6).getSimpleName();
                indexMultiTable.add("", object3);
                ((Trans)object3).parent = trans;
                this.checkBuiltTransition((Trans)object3, n);
            }
            Object[] objectArray2 = objectArray = clazz.getDeclaredFields();
            n2 = objectArray2.length;
            for (int i = 0; i < n2; ++i) {
                object5 = objectArray2[i];
                ((Field)object5).setAccessible(true);
                object42 = ((Field)object5).get(object);
                if (object42 == null || !DataAccess.isOrExtends(object42.getClass(), Trans.class)) continue;
                object3 = ((Field)object5).getName();
                if (DataAccess.isReferenceToEnclosing((Field)object5)) continue;
                object2 = (Trans)object42;
                object2.transId = object3;
                indexMultiTable.add("", object2);
                object2.parent = trans;
                this.checkBuiltTransition((Trans)object2, n);
            }
            for (Object object42 : objectArray2 = clazz.getDeclaredMethods()) {
                object3 = ((Method)object42).getName();
                object2 = ((Method)object42).getParameterTypes();
                Class<?> clazz2 = ((Method)object42).getReturnType();
                if (((Class<?>[])object2).length != 2 || object2[0] != EventObject.class || clazz2 != Trans.class || object2[1] != Trans.class) continue;
                Trans trans2 = null;
                try {
                    ((Method)object42).setAccessible(true);
                    Object object7 = ((Method)object42).invoke(object, new Object[]{null, null});
                    trans2 = (Trans)object7;
                    trans2.transId = ((Method)object42).getName();
                    trans2.check = new StateTransitionMethod(trans2, (Method)object42);
                    trans2.buildTransitionPath();
                    trans2.parent = trans;
                    indexMultiTable.add("", trans2);
                }
                catch (Exception exception) {
                    throw new IllegalArgumentException("stateTrans-method failure");
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (indexMultiTable.size() > 0) {
            int n4 = indexMultiTable.size();
            objectArray = new Trans[n4];
            int n5 = -1;
            for (Map.Entry entry : indexMultiTable.entrySet()) {
                objectArray[++n5] = (Trans)entry.getValue();
            }
            if (trans == null) {
                this.aTransitions = objectArray;
            } else {
                trans.choice = objectArray;
            }
        }
    }

    public void prepareTransitions() {
        if (this.aTransitions != null) {
            for (Trans trans : this.aTransitions) {
                this.checkBuiltTransition(trans, 0);
            }
        }
    }

    public void createTransitions(int n) {
        this.aTransitions = new Trans[n];
    }

    public void addTransition(Trans trans) {
        int n;
        for (n = 0; n < this.aTransitions.length && this.aTransitions[n] != null; ++n) {
        }
        if (n >= this.aTransitions.length) {
            throw new IllegalArgumentException("too many states to add");
        }
        this.aTransitions[n] = trans;
    }

    private void checkBuiltTransition(Trans trans, int n) {
        if (trans.dst != null) {
            trans.buildTransitionPath();
        }
        if (trans instanceof Timeout) {
            this.transTimeout = (Timeout)trans;
            this.millisectimeout = this.transTimeout.millisec;
            this.searchOrCreateTimerEvent();
        }
        if (trans instanceof Choice) {
            this.createTransitionList(trans, trans, n + 1);
        }
    }

    private void searchOrCreateTimerEvent() {
        if (this.stateMachine.theThread == null) {
            throw new IllegalArgumentException("This statemachine needs a thread and a timer manager because timeouts are used. Use StateMachine(thread, timer); to construct it");
        }
        StateSimple stateSimple = this;
        while (stateSimple.enclState != null && !(stateSimple.enclState instanceof StateParallel)) {
            stateSimple = stateSimple.enclState;
        }
        if (stateSimple.evTimeout == null) {
            stateSimple.evTimeout = new EventTimeout(this.stateMachine, this.stateMachine.theThread);
        }
        this.evTimeout = stateSimple.evTimeout;
    }

    public final boolean isInState() {
        if (this.stateCtrl != null) {
            return this.stateCtrl.isActive && this.stateCtrl.isInState(this);
        }
        if (this.enclState == null) {
            return true;
        }
        return this.enclState.isInState();
    }

    protected Trans selectTrans(EventObject eventObject) {
        this.bCheckTransitionArray = true;
        return null;
    }

    int processEvent(EventObject eventObject) {
        return this.checkTransitions(eventObject);
    }

    /*
     * WARNING - void declaration
     */
    final int checkTransitions(EventObject eventObject) {
        int n = 0;
        if (this.aTransitions != null) {
            for (Trans object2 : this.aTransitions) {
                object2.doneEntry = false;
                object2.doneAction = false;
                object2.doneExit = false;
                object2.retTrans = 0;
            }
        }
        Object object = null;
        if (this.transTimeout != null && eventObject == this.evTimeout && eventObject != null) {
            object = this.transTimeout;
        }
        if (object != null || !this.bCheckTransitionArray) {
            try {
                if (object == null) {
                    object = this.selectTrans(eventObject);
                }
                if (object != null) {
                    if (!((Trans)object).doneExit) {
                        ((Trans)object).doExit();
                    }
                    if (!((Trans)object).doneAction) {
                        ((Trans)object).doAction(eventObject, 0);
                    }
                    if (!((Trans)object).doneEntry) {
                        ((Trans)object).doEntry(eventObject);
                    }
                    ((Trans)object).retTrans |= 0x20000;
                    return ((Trans)object).retTrans;
                }
            }
            catch (Exception exception) {
                if (this.stateMachine.permitException) {
                    StringBuilder stringBuilder = new StringBuilder(1000);
                    stringBuilder.append("StateSimple trans exception - ");
                    this.stateMachine.infoAppend(stringBuilder);
                    stringBuilder.append(";");
                    if (eventObject != null) {
                        stringBuilder.append("event: ").append(eventObject.toString());
                    }
                    CharSequence charSequence = Assert.exceptionInfo(stringBuilder, exception, 0, 50);
                    System.err.append(charSequence);
                    object = null;
                }
                throw new RuntimeException(exception);
            }
        }
        if (this.bCheckTransitionArray && this.aTransitions != null) {
            void var6_13;
            Trans[] transArray = this.aTransitions;
            int n2 = transArray.length;
            boolean bl = false;
            while (var6_13 < n2) {
                Trans trans = transArray[var6_13];
                trans.doneEntry = false;
                trans.doneAction = false;
                trans.doneExit = false;
                try {
                    n = trans.doTrans(eventObject);
                    if ((n & 0x20001) != 0) {
                        break;
                    }
                }
                catch (Exception exception) {
                    if (this.stateMachine.permitException) {
                        CharSequence charSequence = Assert.exceptionInfo("StateSimple -" + this.stateId, exception, 0, 20);
                        System.err.append(charSequence);
                    }
                    throw new RuntimeException(exception);
                }
                ++var6_13;
            }
        }
        return n;
    }

    final int entryTheState(EventObject eventObject, int n) {
        int n2;
        if (this.stateCtrl != null) {
            this.stateCtrl.stateAct = this;
            this.stateCtrl.isActive = true;
        }
        ++this.ctEntry;
        this.dateLastEntry = System.currentTimeMillis();
        this.durationLast = 0L;
        if (this instanceof StateComposite) {
            StateComposite stateComposite = (StateComposite)this;
            if ((n & 0xC00000) != 0) {
                stateComposite.stateAct = null;
                stateComposite.isActive = true;
            } else {
                stateComposite.stateAct = null;
                stateComposite.isActive = true;
            }
        }
        if (this.transTimeout != null && this.evTimeout != null) {
            this.evTimeout.activateAt(System.currentTimeMillis() + (long)this.millisectimeout);
        }
        try {
            n2 = this.entry(eventObject);
        }
        catch (Exception exception) {
            if (this.stateMachine.permitException) {
                StringBuilder stringBuilder = new StringBuilder(1000);
                stringBuilder.append("StateSimple entry exception - ");
                this.stateMachine.infoAppend(stringBuilder);
                stringBuilder.append(";");
                if (eventObject != null) {
                    stringBuilder.append("event: ").append(eventObject.toString());
                }
                CharSequence charSequence = Assert.exceptionInfo(stringBuilder, exception, 0, 50);
                System.err.append(charSequence);
                n2 = 0;
            }
            throw new RuntimeException(exception);
        }
        return n2 | 0x40000 | this.modeTrans;
    }

    void exitTheState() {
        this.durationLast = System.currentTimeMillis() - this.dateLastEntry;
        if (this.enclState instanceof StateComposite) {
            ((StateComposite)this.enclState).isActive = false;
        }
        if (this.evTimeout != null && this.evTimeout.used()) {
            this.stateMachine.theThread.removeTimeOrder(this.evTimeout);
        }
        try {
            this.exit();
        }
        catch (Exception exception) {
            if (this.stateMachine.permitException) {
                StringBuilder stringBuilder = new StringBuilder(1000);
                stringBuilder.append("StateSimple exit exception - ");
                this.stateMachine.infoAppend(stringBuilder);
                stringBuilder.append(";");
                CharSequence charSequence = Assert.exceptionInfo(stringBuilder, exception, 0, 50);
                System.err.append(charSequence);
            }
            throw new RuntimeException(exception);
        }
    }

    CharSequence getStatePath() {
        StringBuilder stringBuilder = new StringBuilder(120);
        StateSimple stateSimple = this;
        while ((stateSimple = stateSimple.enclState) != null) {
            stringBuilder.insert(0, '.').insert(0, stateSimple.stateId);
        }
        stringBuilder.append('.').append(this.stateId);
        return stringBuilder;
    }

    public String getName() {
        return this.stateId;
    }

    @Override
    public CharSequence infoAppend(StringBuilder stringBuilder) {
        if (stringBuilder != null) {
            stringBuilder.append(this.stateId);
            return stringBuilder;
        }
        return this.stateId;
    }

    public String toString() {
        return this.stateId;
    }

    private class StateTransitionMethod
    implements StateAction {
        final Method transMethod;
        final Trans trans;

        StateTransitionMethod(Trans trans, Method method) {
            this.transMethod = method;
            this.trans = trans;
        }

        @Override
        public int exec(EventObject eventObject) {
            Object var2_2 = null;
            try {
                this.transMethod.invoke((Object)StateSimple.this, eventObject, this.trans);
            }
            catch (IllegalAccessException illegalAccessException) {
                System.err.println(illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getCause();
                throw new RuntimeException("StateSimple.execTransMethod - exception", throwable);
            }
            return this.trans.retTrans;
        }
    }

    class TransitionMethod
    extends Trans {
        private final Method transitionMethod;

        TransitionMethod(String string, Method method) {
            super(new Class[0]);
            this.transId = string;
            this.transitionMethod = method;
        }

        @Override
        protected void check(EventObject eventObject) {
            try {
                this.transitionMethod.invoke((Object)StateSimple.this, eventObject);
            }
            catch (Exception exception) {
                System.err.println(Assert.exceptionInfo("exit " + StateSimple.this.stateId, exception, 1, 10));
            }
        }
    }

    class ExitMethodAction
    implements Runnable {
        ExitMethodAction() {
        }

        @Override
        public void run() {
            try {
                StateSimple.this.exitMethod.invoke((Object)StateSimple.this, new Object[0]);
            }
            catch (Exception exception) {
                System.err.println(Assert.exceptionInfo("exit " + StateSimple.this.stateId, exception, 1, 10));
            }
        }
    }

    private class EntryMethodAction
    implements StateAction {
        private EntryMethodAction() {
        }

        @Override
        public int exec(EventObject eventObject) {
            try {
                StateSimple.this.entryMethod.invoke((Object)StateSimple.this, eventObject);
            }
            catch (Exception exception) {
                System.err.println(Assert.exceptionInfo("entry " + StateSimple.this.stateId, exception, 1, 10));
            }
            return 0;
        }
    }

    public class Join
    extends Trans {
        StateSimple[] joinStates;
        Class<?>[] joinStateClasses;

        public Join(Class<?> ... classArray) {
            super(classArray);
            this.transId = "join";
        }

        protected void buildJoinStates() {
            this.joinStates = new StateSimple[this.joinStateClasses.length];
            int n = -1;
            Class<?>[] classArray = this.joinStateClasses;
            int n2 = classArray.length;
            for (int i = 0; i < n2; ++i) {
                Class<?> clazz;
                Class<?> clazz2 = clazz = classArray[i];
                StateSimple stateSimple = StateSimple.this.stateMachine.getState(clazz2);
                this.joinStates[++n] = stateSimple;
            }
        }

        public boolean joined() {
            for (StateSimple stateSimple : this.joinStates) {
                if (stateSimple.isInState()) continue;
                return false;
            }
            return true;
        }
    }

    public class Timeout
    extends Trans {
        int millisec;

        public Timeout(int n, Class<?> ... classArray) {
            super(classArray);
            this.transId = "timeout";
            this.millisec = n;
        }
    }

    public abstract class Choice
    extends Trans {
        protected Trans nullTrans;

        public Choice() {
            super(new Class[0]);
            this.nullTrans = new Trans(new Class[0]);
        }

        public abstract Trans checkTrans();
    }

    public class TransFlatHistory
    extends Trans {
        public TransFlatHistory(Class<?> ... classArray) {
            super(classArray);
            this.retTrans |= 0x400000;
        }
    }

    public class TransDeepHistory
    extends Trans {
        public TransDeepHistory(Class<?> ... classArray) {
            super(classArray);
            this.retTrans |= 0x800000;
        }
    }

    public class Trans {
        public int retTrans;
        final int[] dst;
        protected StateAction check;
        protected StateAction action;
        protected Trans[] choice;
        Trans parent;
        StateSimple[] exitStates;
        StateSimple[] entryStates;
        String transId;
        boolean doneExit;
        boolean doneAction;
        boolean doneEntry;

        public Trans(Class<?> ... classArray) {
            if (classArray == null || classArray.length == 0) {
                this.dst = null;
            } else {
                this.dst = new int[classArray.length];
                for (int i = 0; i < classArray.length; ++i) {
                    this.dst[i] = classArray[i].hashCode();
                }
            }
        }

        public Trans(String string, int[] nArray) {
            this.transId = string;
            this.dst = nArray;
        }

        public Trans eventConsumed() {
            this.retTrans |= 1;
            return this;
        }

        void buildTransitionPath() {
            if (this.choice != null) {
                Trans[] transArray = this.choice;
                int n = transArray.length;
                for (int i = 0; i < n; ++i) {
                    Trans trans;
                    Trans trans2 = trans = transArray[i];
                    trans2.getClass();
                    BuildTransitionPath buildTransitionPath = trans2.new BuildTransitionPath(this.exitStates);
                    buildTransitionPath.execute();
                }
            } else {
                BuildTransitionPath buildTransitionPath = new BuildTransitionPath(this.exitStates);
                buildTransitionPath.execute();
            }
        }

        protected void check(EventObject eventObject) {
            if (this.check != null) {
                int n = this.check.exec(eventObject);
                this.retTrans |= n;
            }
        }

        protected void action(EventObject eventObject) {
            if (this.action != null) {
                this.action.exec(eventObject);
            }
        }

        final int doTrans(EventObject eventObject) {
            this.retTrans = 0;
            this.check(eventObject);
            if (this.retTrans == 0) {
                return 0;
            }
            if (this.choice != null) {
                for (Trans trans : this.choice) {
                    int n = trans.doTrans(eventObject);
                    if (n == 0) continue;
                    return this.retTrans | n;
                }
                return 0;
            }
            if (this.choice == null) {
                if (!this.doneExit) {
                    this.doExit();
                }
                if (!this.doneAction) {
                    this.doAction(eventObject, 0);
                }
                if (!this.doneEntry) {
                    this.doEntry(eventObject);
                }
            }
            return this.retTrans;
        }

        final void doAction(EventObject eventObject, int n) {
            if (n > 20) {
                throw new IllegalArgumentException("too many recursions");
            }
            if (this.parent != null) {
                this.parent.doAction(eventObject, n + 1);
            }
            try {
                this.action(eventObject);
            }
            catch (Exception exception) {
                if (StateSimple.this.stateMachine.permitException) {
                    StringBuilder stringBuilder = new StringBuilder(1000);
                    stringBuilder.append("StateSimple trans action exception - ");
                    StateSimple.this.stateMachine.infoAppend(stringBuilder);
                    stringBuilder.append(";");
                    if (eventObject != null) {
                        stringBuilder.append("event: ").append(eventObject.toString());
                    }
                    CharSequence charSequence = Assert.exceptionInfo(stringBuilder, exception, 0, 50);
                    System.err.append(charSequence);
                }
                throw new RuntimeException(exception);
            }
            this.doneAction = true;
        }

        public final void doExit() {
            this.retTrans |= 0x80000;
            if (this.exitStates != null) {
                for (StateSimple stateSimple : this.exitStates) {
                    stateSimple.exitTheState();
                }
            }
            this.doneExit = true;
        }

        public final void doEntry(EventObject eventObject) {
            this.doEntry(eventObject, 0);
        }

        public final void doEntry(EventObject eventObject, int n) {
            if (this.entryStates != null) {
                for (int i = 0; i < this.entryStates.length; ++i) {
                    StateSimple stateSimple = this.entryStates[i];
                    int n2 = i == this.entryStates.length - 1 ? n : 0;
                    this.retTrans |= stateSimple.entryTheState(eventObject, n2);
                }
            }
            this.doneEntry = true;
        }

        public String toString() {
            return this.transId == null ? "-unknown transId" : this.transId;
        }

        private class BuildTransitionPath {
            final StateSimple[] dstStates;
            final StateSimple[] exitStates;
            int[] XXXsamePaths;
            int[] ixInStatePath;
            int ixEntryStatesOld;

            public BuildTransitionPath(StateSimple[] stateSimpleArray) {
                this.dstStates = Trans.this.dst == null ? null : new StateSimple[Trans.this.dst.length];
                this.XXXsamePaths = this.dstStates == null ? null : new int[this.dstStates.length];
                this.ixInStatePath = this.dstStates == null ? null : new int[this.dstStates.length];
                this.ixEntryStatesOld = -1;
                this.exitStates = stateSimpleArray;
            }

            void execute() {
                if (StateSimple.this.stateId.equals("Ready")) {
                    Debugutil.stop();
                }
                this.buildDstStates();
                this.searchStateCommon();
                this.buildExitPath();
                this.buildEntryStates();
            }

            private void buildDstStates() {
                if (Trans.this.dst != null) {
                    for (int i = 0; i < Trans.this.dst.length; ++i) {
                        this.dstStates[i] = StateSimple.this.enclState.stateMachine.stateMap.get(new Integer(Trans.this.dst[i]));
                    }
                }
            }

            private void searchStateCommon() {
                int n;
                StateSimple stateSimple;
                boolean bl = true;
                int n2 = StateSimple.this.statePath.length - 2;
                do {
                    stateSimple = StateSimple.this.statePath[n2];
                    n = -1;
                    while (stateSimple != null && ++n < this.dstStates.length) {
                        StateSimple stateSimple2 = this.dstStates[n];
                        this.ixInStatePath[n] = stateSimple2.statePath.length - 1;
                        while (stateSimple != null && stateSimple2.statePath[this.ixInStatePath[n]] != stateSimple) {
                            int n3 = n;
                            this.ixInStatePath[n3] = this.ixInStatePath[n3] - 1;
                            if (this.ixInStatePath[n3] >= 0) continue;
                            stateSimple = null;
                        }
                    }
                } while (stateSimple == null && --n2 >= 0);
                if (stateSimple == null) {
                    throw new IllegalArgumentException("no common state found");
                }
                Trans.this.exitStates = new StateSimple[StateSimple.this.statePath.length - (n2 + 1)];
                n = 0;
                while (n < Trans.this.dst.length) {
                    int n4 = n++;
                    this.ixInStatePath[n4] = this.ixInStatePath[n4] + 1;
                }
            }

            private void buildExitPath() {
                int n = StateSimple.this.statePath.length;
                for (int i = 0; i < Trans.this.exitStates.length; ++i) {
                    Trans.this.exitStates[i] = StateSimple.this.statePath[--n];
                }
            }

            private void buildEntryStates() {
                int n;
                StateSimple[] stateSimpleArray = new StateSimple[this.dstStates.length];
                if (stateSimpleArray.length == 3) {
                    Debugutil.stop();
                }
                if (Trans.this.transId.equals("Trans_Running0")) {
                    Debugutil.stop();
                }
                LinkedList<StateSimple> linkedList = new LinkedList<StateSimple>();
                int n2 = this.ixInStatePath[0];
                do {
                    int n3;
                    n = this.ixInStatePath.length;
                    for (n3 = 0; n3 < this.ixInStatePath.length; ++n3) {
                        stateSimpleArray[n3] = null;
                    }
                    for (n3 = 0; n3 < this.ixInStatePath.length; ++n3) {
                        StateSimple[] stateSimpleArray2 = this.dstStates[n3].statePath;
                        if (n2 < stateSimpleArray2.length) {
                            int n4;
                            StateSimple stateSimple = stateSimpleArray2[n2];
                            if (n3 == 0) {
                                n4 = stateSimpleArray.length;
                            } else {
                                for (n4 = 0; n4 < stateSimpleArray.length && stateSimpleArray[n4] != stateSimple; ++n4) {
                                }
                            }
                            if (n4 != stateSimpleArray.length) continue;
                            stateSimpleArray[n3] = stateSimple;
                            linkedList.add(stateSimple);
                            continue;
                        }
                        --n;
                    }
                    ++n2;
                } while (n > 0);
                Trans.this.entryStates = linkedList.toArray(new StateSimple[linkedList.size()]);
            }
        }
    }
}

