/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.stateMGen;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.script.ScriptException;
import org.vishia.cmd.JZcmdExecuter;
import org.vishia.mainCmd.MainCmd;
import org.vishia.mainCmd.MainCmd_ifc;
import org.vishia.states.StateComposite;
import org.vishia.states.StateCompositeFlat;
import org.vishia.states.StateMachine;
import org.vishia.states.StateParallel;
import org.vishia.states.StateSimple;
import org.vishia.util.DataShow;
import org.vishia.zbnf.ZbnfJavaOutput;
import org.vishia.zcmd.JZcmd;
import org.vishia.zcmd.Zbnf2Text;

public class StateMGen {
    public static final String sVersion = "2014-06-26";
    final MainCmd_ifc console;
    GenStateMachine genStm;

    public static void main(String[] stringArray) {
        Args args = new Args();
        CmdLine cmdLine = new CmdLine(stringArray, args);
        boolean bl = true;
        try {
            cmdLine.parseArguments();
        }
        catch (Exception exception) {
            cmdLine.setExitErrorLevel(5);
            bl = false;
        }
        if (bl) {
            StateMGen stateMGen = new StateMGen(cmdLine, args);
            try {
                stateMGen.execute(args);
            }
            catch (Exception exception) {
                stateMGen.console.report("Uncatched Exception on main level:", exception);
                stateMGen.console.setExitErrorLevel(3);
            }
        }
        cmdLine.exit();
    }

    public StateMGen(MainCmd_ifc mainCmd_ifc, Args args) {
        this.console = mainCmd_ifc;
    }

    void execute(Args args) throws IOException, IllegalAccessException {
        ZbnfResultData zbnfResultData = this.parseAndStoreInput(args);
        if (zbnfResultData != null) {
            FileWriter fileWriter;
            GenStateMachine genStateMachine = this.prepareStateData(zbnfResultData);
            if (args.sFileData != null) {
                fileWriter = new FileWriter(args.sFileData);
                DataShow.dataTree(genStateMachine, fileWriter, 20);
                ((Writer)fileWriter).close();
                fileWriter = new FileWriter(args.sFileData + ".xml");
                DataShow.dataTreeXml(genStateMachine, fileWriter, 20);
                ((Writer)fileWriter).close();
                fileWriter = new FileWriter(args.sFileData + ".html");
                DataShow.outHtml(genStateMachine, fileWriter);
                ((Writer)fileWriter).close();
            }
            fileWriter = args.sScriptCheck != null ? new FileWriter(args.sScriptCheck) : null;
            for (Zbnf2Text.Out out : args.listOut) {
                File file = new File(out.sFileOut);
                File file2 = new File(out.sFileScript);
                JZcmdExecuter jZcmdExecuter = new JZcmdExecuter(this.console);
                if (fileWriter != null) {
                    fileWriter.append("===================").append(out.sFileScript);
                }
                FileWriter fileWriter2 = new FileWriter(file);
                jZcmdExecuter.setScriptVariable("sOutfile", 'S', file.getAbsolutePath(), true);
                jZcmdExecuter.setScriptVariable("stm", 'O', genStateMachine, true);
                try {
                    JZcmd.execute(jZcmdExecuter, file2, fileWriter2, this.console.currdir(), true, args.sScriptCheck == null ? null : new File(args.sScriptCheck), this.console);
                    this.console.writeInfoln("SUCCESS outfile: " + file.getAbsolutePath());
                }
                catch (ScriptException scriptException) {
                    this.console.writeError(scriptException.getMessage());
                }
                ((Writer)fileWriter2).close();
            }
            if (fileWriter != null) {
                fileWriter.close();
            }
        } else {
            this.console.writeInfoln("ERROR");
        }
    }

    GenStateMachine prepareStateData(ZbnfResultData zbnfResultData) {
        StateSimple[] stateSimpleArray = new StateSimple[zbnfResultData.subStates.size()];
        this.genStm = new GenStateMachine(zbnfResultData, stateSimpleArray);
        StateMachine.StateCompositeTop stateCompositeTop = this.genStm.stateTop();
        this.genStm.rootStates.add(stateCompositeTop);
        stateCompositeTop.setAuxInfo(new GenStateInfo(null));
        this.gatherStatesOfComposite(stateCompositeTop, stateCompositeTop, zbnfResultData);
        this.gatherAllTransitions();
        this.genStm.prepare();
        this.prepareAllTransitions();
        return this.genStm;
    }

    StateCompositeFlat gatherStatesOfComposite(StateCompositeFlat stateCompositeFlat, StateComposite stateComposite, ZbnfStateCompositeBase zbnfStateCompositeBase) {
        GenStateInfo genStateInfo = (GenStateInfo)stateComposite.auxInfo();
        assert (genStateInfo != null);
        if (genStateInfo.subStates == null) {
            genStateInfo.subStates = new LinkedList<StateSimple>();
        }
        for (ZbnfState zbnfState : zbnfStateCompositeBase.subStates) {
            StateSimple stateSimple;
            if (zbnfState.isPrepared) continue;
            if (zbnfState.subStates != null && zbnfState.subStates.size() > 0) {
                StateSimple stateSimple2;
                if (zbnfState.stateParallel) {
                    stateSimple2 = new GenStateParallel(stateCompositeFlat, stateComposite, this.genStm, zbnfState);
                    stateSimple = this.gatherStatesOfParallel((StateParallel)stateSimple2, stateComposite, zbnfState);
                } else {
                    StateComposite stateComposite2;
                    if (zbnfState.hasHistory) {
                        stateSimple2 = new GenStateComposite(stateCompositeFlat, stateComposite, this.genStm, zbnfState);
                        stateComposite2 = (StateComposite)stateSimple2;
                        this.genStm.rootStates.add(stateComposite2);
                    } else {
                        stateSimple2 = new GenStateCompositeFlat(stateCompositeFlat, stateComposite, this.genStm, zbnfState);
                        stateComposite2 = stateComposite;
                    }
                    stateSimple = this.gatherStatesOfComposite((StateCompositeFlat)stateSimple2, stateComposite2, zbnfState);
                }
            } else {
                stateSimple = new GenStateSimple(stateCompositeFlat, stateComposite, this.genStm, zbnfState);
            }
            stateCompositeFlat.addState(stateSimple.hashCode(), stateSimple);
            genStateInfo.subStates.add(stateSimple);
            this.genStm.allStates.put(stateSimple.getName(), stateSimple);
            this.genStm.listStates.add(stateSimple);
        }
        return stateCompositeFlat;
    }

    StateParallel gatherStatesOfParallel(StateParallel stateParallel, StateComposite stateComposite, ZbnfStateCompositeBase zbnfStateCompositeBase) {
        GenStateInfo genStateInfo = (GenStateInfo)stateComposite.auxInfo();
        assert (genStateInfo != null);
        if (genStateInfo.subStates == null) {
            genStateInfo.subStates = new LinkedList<StateSimple>();
        }
        for (ZbnfState zbnfState : zbnfStateCompositeBase.subStates) {
            StateSimple stateSimple;
            if (zbnfState.isPrepared) continue;
            if (zbnfState.subStates != null && zbnfState.subStates.size() > 0) {
                if (zbnfState.stateParallel) {
                    throw new IllegalArgumentException("the next level of StateParallel cannot be a StateParallel");
                }
                StateComposite stateComposite2 = null;
                GenStateComposite genStateComposite = new GenStateComposite(stateParallel, stateComposite2, this.genStm, zbnfState);
                StateComposite stateComposite3 = genStateComposite;
                this.genStm.rootStates.add(stateComposite3);
                stateSimple = this.gatherStatesOfComposite(genStateComposite, stateComposite3, zbnfState);
            } else {
                stateSimple = new GenStateSimple(stateParallel, stateComposite, this.genStm, zbnfState);
            }
            stateParallel.addState(stateSimple.hashCode(), stateSimple);
            genStateInfo.subStates.add(stateSimple);
            this.genStm.allStates.put(stateSimple.getName(), stateSimple);
            this.genStm.listStates.add(stateSimple);
        }
        return stateParallel;
    }

    void gatherAllTransitions() {
        for (StateSimple stateSimple : this.genStm.listStates) {
            int n;
            GenStateInfo genStateInfo = (GenStateInfo)stateSimple.auxInfo();
            ZbnfState zbnfState = genStateInfo.zsrcState;
            if (zbnfState.trans == null || zbnfState.trans.size() <= 0 || (n = zbnfState.trans.size()) <= 0) continue;
            stateSimple.createTransitions(n);
            for (ZbnfTrans zbnfTrans : zbnfState.trans) {
                Object object;
                Object object2;
                Object object3;
                int n2 = zbnfTrans.dstStates != null ? 1 + zbnfTrans.dstStates.size() : 1;
                int[] nArray = new int[n2];
                int n3 = -1;
                if (zbnfTrans.dstStates != null) {
                    object3 = zbnfTrans.dstStates.iterator();
                    while (object3.hasNext()) {
                        object2 = object3.next();
                        object = this.genStm.allStates.get(object2);
                        if (object == null) {
                            throw new IllegalArgumentException("faulty dst state in transition;" + (String)object2 + "; from state " + stateSimple.getName());
                        }
                        nArray[++n3] = object.hashCode();
                    }
                }
                if ((object3 = this.genStm.allStates.get(zbnfTrans.dstState)) == null) {
                    throw new IllegalArgumentException("faulty dst state in transition;" + zbnfTrans.dstState + "; from state " + stateSimple.getName());
                }
                nArray[++n3] = object3.hashCode();
                object2 = new GenStateTrans(zbnfTrans, stateSimple, nArray);
                if (zbnfTrans.time != null) {
                    genStateInfo.timeCondition = zbnfTrans.time;
                    object = (GenStateInfo)stateSimple.stateCtrl().auxInfo();
                    ((GenStateInfo)object).hasTimer = true;
                }
                stateSimple.addTransition((StateSimple.Trans)object2);
            }
        }
    }

    void prepareAllTransitions() {
        for (StateSimple stateSimple : this.genStm.listStates) {
            stateSimple.prepareTransitions();
        }
    }

    private ZbnfResultData parseAndStoreInput(Args args) {
        ZbnfResultData zbnfResultData = new ZbnfResultData();
        File file = new File(args.sFileIn);
        File file2 = new File(args.sFileZbnf);
        String string = ZbnfJavaOutput.parseFileAndFillJavaObject(zbnfResultData.getClass(), zbnfResultData, file, file2, this.console, 1200);
        if (string != null) {
            this.console.writeError("ERROR Parsing file: " + file.getAbsolutePath() + "\n" + string);
            return null;
        }
        this.console.writeInfoln("SUCCESS parsed: " + file.getAbsolutePath());
        return zbnfResultData;
    }

    void stop() {
    }

    static class GenStateTrans
    extends StateSimple.Trans {
        public final ZbnfTrans zsrcTrans;

        GenStateTrans(ZbnfTrans zbnfTrans, StateSimple stateSimple, int[] nArray) {
            StateSimple stateSimple2 = stateSimple;
            stateSimple2.getClass();
            super(stateSimple2, "Trans_" + stateSimple.getName() + zbnfTrans.nrTrans, nArray);
            this.zsrcTrans = zbnfTrans;
        }
    }

    static class GenStateParallel
    extends StateParallel {
        GenStateParallel(StateCompositeFlat stateCompositeFlat, StateComposite stateComposite, GenStateMachine genStateMachine, ZbnfState zbnfState) {
            super(zbnfState.stateName, genStateMachine, zbnfState.nrofSubstates == 0 ? null : new StateComposite[zbnfState.nrofSubstates]);
            super.setAuxInfo(new GenStateInfo(zbnfState));
            this.enclState = stateCompositeFlat;
            this.stateCtrl = stateComposite;
            this.stateId = zbnfState.stateName;
        }

        void genStatePrepareTransitions() {
            super.prepareTransitions();
        }
    }

    static class GenStateComposite
    extends StateComposite {
        GenStateComposite(StateSimple stateSimple, StateComposite stateComposite, GenStateMachine genStateMachine, ZbnfState zbnfState) {
            super(zbnfState.stateName, genStateMachine, zbnfState.nrofSubstates == 0 ? null : new StateSimple[zbnfState.nrofSubstates]);
            super.setAuxInfo(new GenStateInfo(zbnfState));
            this.enclState = stateSimple;
            this.stateCtrl = stateComposite;
            this.stateId = zbnfState.stateName;
        }

        void genStatePrepareTransitions() {
            super.prepareTransitions();
        }
    }

    static class GenStateCompositeFlat
    extends StateCompositeFlat {
        GenStateCompositeFlat(StateSimple stateSimple, StateComposite stateComposite, GenStateMachine genStateMachine, ZbnfState zbnfState) {
            super(zbnfState.stateName, genStateMachine, zbnfState.nrofSubstates == 0 ? null : new StateSimple[zbnfState.nrofSubstates]);
            super.setAuxInfo(new GenStateInfo(zbnfState));
            this.enclState = stateSimple;
            this.stateCtrl = stateComposite;
            this.stateId = zbnfState.stateName;
        }

        void genStatePrepareTransitions() {
            super.prepareTransitions();
        }
    }

    static class GenStateSimple
    extends StateSimple {
        GenStateSimple(StateSimple stateSimple, StateComposite stateComposite, StateMachine stateMachine, ZbnfState zbnfState) {
            super.setAuxInfo(new GenStateInfo(zbnfState));
            this.enclState = stateSimple;
            this.stateCtrl = stateComposite;
            this.stateMachine = stateMachine;
            this.stateId = zbnfState.stateName;
        }

        void genStatePrepareTransitions() {
            super.prepareTransitions();
        }
    }

    static class GenStateInfo {
        public final ZbnfState zsrcState;
        public List<StateSimple> subStates;
        public String timeCondition;
        public boolean hasTimer;

        public GenStateInfo(ZbnfState zbnfState) {
            this.zsrcState = zbnfState;
        }
    }

    public static class GenStateMachine
    extends StateMachine {
        public final ZbnfResultData zsrcFile;
        public final List<StateComposite> rootStates = new LinkedList<StateComposite>();
        public final List<StateSimple> listStates = new LinkedList<StateSimple>();
        Map<String, StateSimple> allStates = new TreeMap<String, StateSimple>();

        GenStateMachine(ZbnfResultData zbnfResultData, StateSimple[] stateSimpleArray) {
            super(stateSimpleArray);
            this.zsrcFile = zbnfResultData;
        }

        StateMachine.StateCompositeTop stateTop() {
            return this.topState;
        }

        void prepare() {
            this.topState.prepare();
        }
    }

    public static class ZbnfResultData
    extends ZbnfStateCompositeBase {
        public XXXStateStructure stateStructure;
        public List<String> includeLines = new LinkedList<String>();
        public List<String> statefnargs = new LinkedList<String>();
        public StringBuilder formalArgs;
        public StringBuilder callingArgs;
        private final Map<String, String> idxStateVariables = new HashMap<String, String>();
        private final Map<String, ZbnfSimpleState> topStates = new TreeMap<String, ZbnfSimpleState>();
        final List<ZbnfSimpleState> states = new ArrayList<ZbnfSimpleState>();
        final Map<String, String> variables = new TreeMap<String, String>();

        public ZbnfNameValue new_variable() {
            return new ZbnfNameValue();
        }

        public void add_variable(ZbnfNameValue zbnfNameValue) {
            this.variables.put(zbnfNameValue.name, zbnfNameValue.value);
        }

        public void set_statefnarg(String string) {
            string = string.trim();
            int n = string.lastIndexOf(32) + 1;
            String string2 = string.substring(n);
            this.statefnargs.add(string);
            if (this.formalArgs == null) {
                this.formalArgs = new StringBuilder(string);
                this.callingArgs = new StringBuilder(string2);
            } else {
                this.formalArgs.append(", ").append(string);
                this.callingArgs.append(", ").append(string2);
            }
        }

        public void set_includeLine(String string) {
            this.includeLines.add(string);
        }
    }

    public static class ZbnfNameValue {
        public String name;
        public String value;
    }

    public static class ZbnfDstState {
        public String name;
        ZbnfSimpleState srcState;
        ZbnfSimpleState entryState;
        private List<ZbnfDstState> entrySubStates;

        public String toString() {
            return this.name;
        }
    }

    public static class ZbnfTrans {
        public String description;
        public int nrTrans = 0;
        public String additionaldescription;
        public String tododescription;
        public String cond;
        public String time;
        private List<String> joinStatesSrc;
        public List<ZbnfSimpleState> joinStates;
        public String event;
        public String code;
        private final List<ZbnfTrans> subCondition = new LinkedList<ZbnfTrans>();
        private final List<ZbnfSimpleState> exitStates = new LinkedList<ZbnfSimpleState>();
        private ZbnfDstState dstStateTree;
        public List<String> dstStates;
        public String dstState;

        public ZbnfTrans new_subCondition() {
            return new ZbnfTrans();
        }

        public void add_subCondition(ZbnfTrans zbnfTrans) {
            this.subCondition.add(zbnfTrans);
        }

        public void set_dstState(String string) {
            this.dstState = string;
        }

        public void set_fork() {
            if (this.dstStates == null) {
                this.dstStates = new LinkedList<String>();
            }
            this.dstStates.add(this.dstState);
            this.dstState = null;
        }

        public void set_condP(String string) {
            int n = string.lastIndexOf(41);
            this.cond = n > 0 ? string.substring(0, n) : string;
        }

        public void set_timeP(String string) {
            int n = string.lastIndexOf(41);
            this.time = n > 0 ? string.substring(0, n) : string;
        }

        public void set_joinState(String string) {
            if (this.joinStatesSrc == null) {
                this.joinStatesSrc = new LinkedList<String>();
            }
            this.joinStatesSrc.add(string);
        }

        public void set_history() {
        }
    }

    public static class ZbnfExit {
        public String description;
        public String additionaldescription;
        public String tododescription;
        public String code;
    }

    public static class ZbnfEntry {
        public String description;
        public String additionaldescription;
        public String tododescription;
        public String code;
    }

    public static class ZbnfCompositeState
    extends ZbnfSimpleState {
        public Map<String, ZbnfSimpleState> subStates;
        public Map<String, ZbnfSimpleState> subStatesVariable;
        public Map<String, ZbnfCompositeState> parallelStates;
        public ZbnfConstDef constDef;

        ZbnfCompositeState(ZbnfState zbnfState) {
            super(zbnfState);
            this.isComposite = true;
        }

        ZbnfCompositeState(ZbnfSimpleState zbnfSimpleState) {
            super(zbnfSimpleState.src);
            this.isComposite = true;
            this.stateVariableName = zbnfSimpleState.stateVariableName;
        }

        public String toString() {
            return this.src.stateName;
        }
    }

    public static class ZbnfSimpleState {
        ZbnfState src;
        boolean isComposite;
        public String stateVariableName;

        ZbnfSimpleState(ZbnfState zbnfState) {
            this.src = zbnfState;
        }
    }

    public static class ZbnfState
    extends ZbnfStateCompositeBase {
        public String stateName;
        public String stateNr;
        public String parallelParentState;
        public boolean stateParallel;
        public String description;
        public String shortdescription;
        public String additionaldescription;
        public String tododescription;
        public boolean hasHistory;
        public ZbnfEntry entry;
        public ZbnfExit exit;
        public ZbnfEntry instate;
        public List<ZbnfTrans> trans;
        boolean isPrepared = false;

        public ZbnfEntry new_instate() {
            return new ZbnfEntry();
        }

        public void set_instate(ZbnfEntry zbnfEntry) {
            this.instate = zbnfEntry;
        }

        public void set_hasHistory() {
            this.hasHistory = true;
        }

        public String toString() {
            return this.stateName;
        }
    }

    public static class ZbnfStateCompositeBase {
        List<ZbnfState> subStates;
        int nrofSubstates;
        int nrofParallelStates;
        final Map<String, ZbnfState> idxSrcStates = new TreeMap<String, ZbnfState>();
        final Map<String, ZbnfSimpleState> idxStates = new TreeMap<String, ZbnfSimpleState>();

        public ZbnfState new_state() {
            return new ZbnfState();
        }

        public void add_state(ZbnfState zbnfState) {
            if (zbnfState.parallelParentState != null) {
                if (this.idxStates.get(zbnfState.parallelParentState) == null) {
                    ZbnfCompositeState zbnfCompositeState = new ZbnfCompositeState(new ZbnfState());
                    zbnfCompositeState.src.stateName = zbnfState.parallelParentState;
                    zbnfCompositeState.src.shortdescription = "Parallel state machine inside " + zbnfState.parallelParentState;
                    this.idxStates.put(zbnfState.parallelParentState, zbnfCompositeState);
                }
                ++this.nrofParallelStates;
            } else {
                ++this.nrofSubstates;
            }
            if (this.subStates == null) {
                this.subStates = new ArrayList<ZbnfState>();
            }
            this.subStates.add(zbnfState);
            this.idxSrcStates.put(zbnfState.stateName, zbnfState);
        }
    }

    public static class ZbnfConstDef {
        public String description;
        public List<String> ident;
        public String code;
    }

    public static class XXXStateStructure {
        public final List<XXXCompositeState> compositeStates = new LinkedList<XXXCompositeState>();

        public XXXCompositeState new_CompositeState() {
            return new XXXCompositeState();
        }

        public void add_CompositeState(XXXCompositeState xXXCompositeState) {
            this.compositeStates.add(xXXCompositeState);
        }
    }

    public static class XXXParallelState
    extends XXXCompositeState {
    }

    public static class XXXCompositeState {
        public String stateName;
        public String description;
        public List<XXXSimpleState> simpleState;
        public List<XXXCompositeState> compositeState;
        public List<XXXParallelState> parallelState;
    }

    public static class XXXSimpleState {
        public String stateName;
        public String enclState;
        public String description;
    }

    static class CmdLine
    extends MainCmd {
        final Args cmdlineArgs;

        private CmdLine(String[] stringArray, Args args) {
            super(stringArray);
            this.cmdlineArgs = args;
            super.addAboutInfo("Conversion Statemachine-script to any output");
            super.addAboutInfo("made by Hartmut Schorrig, 2012-10-06");
            super.addHelpInfo("Conversion Statemachine-script to any output V 2012-10-06");
            super.addHelpInfo("param: -i:INPUT -s:ZBNF -c:OUTCTRL -y:OUTPUT");
            super.addHelpInfo("-i:INPUT    inputfilepath, this file is testing.");
            super.addHelpInfo("-s:ZBNF     syntaxfilepath, this file is read.");
            super.addHelpInfo("-c:ZBNF     output script, this file is read.");
            super.addHelpInfo("-y:OUTPUT   outputfilepath, this file is written.");
            super.addStandardHelpInfo();
        }

        @Override
        protected boolean testArgument(String string, int n) {
            boolean bl = true;
            if (string.startsWith("-i:")) {
                this.cmdlineArgs.sFileIn = this.getArgument(3);
            } else if (string.startsWith("-s:")) {
                this.cmdlineArgs.sFileZbnf = this.getArgument(3);
            } else if (string.startsWith("-d:")) {
                this.cmdlineArgs.sFileData = this.getArgument(3);
            } else if (string.startsWith("-scriptcheck:")) {
                this.cmdlineArgs.sScriptCheck = this.getArgument(13);
            } else if (string.startsWith("-y:")) {
                if (this.cmdlineArgs.lastOut == null) {
                    this.cmdlineArgs.lastOut = new Zbnf2Text.Out();
                    this.cmdlineArgs.listOut.add(this.cmdlineArgs.lastOut);
                }
                this.cmdlineArgs.lastOut.sFileOut = this.getArgument(3);
                if (this.cmdlineArgs.lastOut.sFileScript != null) {
                    this.cmdlineArgs.lastOut = null;
                }
            } else if (string.startsWith("-c:")) {
                if (this.cmdlineArgs.lastOut == null) {
                    this.cmdlineArgs.lastOut = new Zbnf2Text.Out();
                    this.cmdlineArgs.listOut.add(this.cmdlineArgs.lastOut);
                }
                this.cmdlineArgs.lastOut.sFileScript = this.getArgument(3);
                if (this.cmdlineArgs.lastOut.sFileOut != null) {
                    this.cmdlineArgs.lastOut = null;
                }
            } else if (string.startsWith("-t:")) {
                if (this.cmdlineArgs.lastOut == null) {
                    this.cmdlineArgs.lastOut = new Zbnf2Text.Out();
                    this.cmdlineArgs.listOut.add(this.cmdlineArgs.lastOut);
                }
                this.cmdlineArgs.lastOut.sFileOut = this.getArgument(3);
                if (this.cmdlineArgs.lastOut.sFileScript != null) {
                    this.cmdlineArgs.lastOut = null;
                }
            } else if (string.startsWith("-c:")) {
                if (this.cmdlineArgs.lastOut == null) {
                    this.cmdlineArgs.lastOut = new Zbnf2Text.Out();
                    this.cmdlineArgs.listOut.add(this.cmdlineArgs.lastOut);
                }
                this.cmdlineArgs.lastOut.sFileScript = this.getArgument(3);
                if (this.cmdlineArgs.lastOut.sFileOut != null) {
                    this.cmdlineArgs.lastOut = null;
                }
            }
            return bl;
        }

        @Override
        protected void callWithoutArguments() throws ParseException {
            super.callWithoutArguments();
        }

        @Override
        protected boolean checkArguments() {
            boolean bl = true;
            if (this.cmdlineArgs.sFileIn == null) {
                bl = false;
                this.writeError("ERROR argument -i is obligat.");
            } else if (this.cmdlineArgs.sFileIn.length() == 0) {
                bl = false;
                this.writeError("ERROR argument -i without content.");
            }
            if (!bl) {
                this.setExitErrorLevel(5);
            }
            return bl;
        }
    }

    public static class Args
    extends Zbnf2Text.Args {
        String sFileIn = null;
        String sFileZbnf = null;
        String sFileData = null;
        String sScriptCheck = null;

        public void setInput(String string) {
            this.sFileIn = string;
        }
    }
}

