/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.sclConversions;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.text.ParseException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.vishia.byteData.PositionElementInStruct;
import org.vishia.cmd.JZcmdExecuter;
import org.vishia.cmd.JZcmdScript;
import org.vishia.mainCmd.MainCmd;
import org.vishia.mainCmd.MainCmdLogging_ifc;
import org.vishia.mainCmd.MainCmd_ifc;
import org.vishia.util.Assert;
import org.vishia.util.FileSystem;
import org.vishia.util.ShortenString;
import org.vishia.zbnf.ZbnfJavaOutput;
import org.vishia.zcmd.JZcmd;

public class SCLstruct2Lists {
    public static final int version = 20130908;
    final MainCmd_ifc console;
    final Args args;
    GenerateVariableImport generateVariableImport;
    private final Map<String, TypeConversion> indexTypes = new TreeMap<String, TypeConversion>();
    final Map<String, Variable> indexVariables = new TreeMap<String, Variable>();
    ShortenString shortenScl24Names = new ShortenString(24);
    List<OamVariable> oamVariables = new LinkedList<OamVariable>();
    Map<String, SaveDataStruct> allDataStruct = new TreeMap<String, SaveDataStruct>();
    GenerateDbConfigAccess genDbConfig;

    public static void main(String[] stringArray) {
        Args args = new Args();
        CmdLine cmdLine = new CmdLine(stringArray, args);
        boolean bl = true;
        try {
            cmdLine.parseArguments();
        }
        catch (Exception exception) {
            cmdLine.setExitErrorLevel(5);
            bl = false;
        }
        if (bl) {
            SCLstruct2Lists sCLstruct2Lists = new SCLstruct2Lists(cmdLine, args);
            try {
                sCLstruct2Lists.execute(args);
            }
            catch (Exception exception) {
                sCLstruct2Lists.console.report("Uncatched Exception on main level:", exception);
                sCLstruct2Lists.console.setExitErrorLevel(3);
            }
        }
        cmdLine.exit();
    }

    static Variable createVariable(String string, ZbnfVariable zbnfVariable) {
        Variable variable = new Variable(zbnfVariable);
        variable.sName = string;
        int n = zbnfVariable.arrayStartIx >= 0 ? zbnfVariable.arrayEndIx - zbnfVariable.arrayStartIx + 1 : 1;
        variable.nrofElements = n;
        if (zbnfVariable.structZbnfVariables != null) {
            variable.structVariables = new LinkedList<Variable>();
            for (ZbnfVariable zbnfVariable2 : zbnfVariable.structZbnfVariables) {
                for (String string2 : zbnfVariable2.name) {
                    String string3 = string + "." + string2;
                    Variable variable2 = SCLstruct2Lists.createVariable(string3, zbnfVariable2);
                    variable.structVariables.add(variable2);
                }
            }
        }
        return variable;
    }

    static void completeVariableWithType(Variable variable, TypeConversion typeConversion, PositionOfVariable positionOfVariable) {
        if (typeConversion.typeCharJava == 'Z') {
            variable.boolMask = positionOfVariable.getMaskBit();
            variable.nrofBytes = 0;
            variable.posVarAbs = positionOfVariable.getIxByte();
        } else {
            variable.posVarAbs = positionOfVariable.getIxByte();
            variable.nrofBytes = typeConversion.typeCharJava == 's' ? variable.zbnfVariable.stringlen + 2 : typeConversion.nrofBytes;
        }
    }

    static void completeVariableStruct(Variable variable, PositionOfVariable positionOfVariable) {
        variable.posVarAbs = positionOfVariable.getIxByte();
    }

    static void completeVariableAfterStructGeneration(Variable variable, int n) {
        variable.nrofBytes = n;
    }

    SCLstruct2Lists(MainCmd_ifc mainCmd_ifc, Args args) {
        this.console = mainCmd_ifc;
        this.args = args;
    }

    void execute(Args args) throws IOException, IllegalAccessException {
        ZbnfResultDataCfg zbnfResultDataCfg = args.sFileCfg != null ? this.parseAndStoreCfg(args) : null;
        if (zbnfResultDataCfg != null) {
            String string;
            BufferedWriter bufferedWriter;
            if (args.sFileWinccVarCsv != null) {
                File file = new File(args.sFileWinccVarCsv);
                FileWriter fileWriter = new FileWriter(file);
                bufferedWriter = new BufferedWriter(fileWriter);
                string = file.getName();
            } else {
                string = null;
                bufferedWriter = null;
            }
            if (args.sFileDbVariables != null) {
                this.genDbConfig = new GenerateDbConfigAccess(args.sFileDbVariables);
            }
            this.generateVariableImport = new GenerateVariableImport(string, zbnfResultDataCfg, bufferedWriter);
            this.generateVariableImport.generateOutFiles(args.sSrcPath);
            if (bufferedWriter != null) {
                bufferedWriter.close();
            }
            if (this.genDbConfig != null) {
                this.genDbConfig.writeFile();
            }
            this.console.writeInfoln("SUCCESS creation: " + string);
            this.console.writeInfoln("");
        }
    }

    private ZbnfResultDataCfg parseAndStoreCfg(Args args) throws IOException {
        ZbnfResultDataCfg zbnfResultDataCfg = new ZbnfResultDataCfg();
        File file = new File(args.sFileCfg);
        File file2 = new File(args.sPathZbnf + "/sclVarCfg.zbnf");
        String string = ZbnfJavaOutput.parseFileAndFillJavaObject(zbnfResultDataCfg.getClass(), zbnfResultDataCfg, file, file2, this.console, 1200);
        if (string != null) {
            this.console.writeError("ERROR Parsing file: " + file.getAbsolutePath() + "\n" + string);
            return null;
        }
        this.console.writeInfoln("SUCCESS parsed: " + file.getCanonicalPath());
        return zbnfResultDataCfg;
    }

    void stop() {
    }

    class GenerateOneSCLfile {
        ZbnfResult_SclStruct zbnfResultDataUDT;

        GenerateOneSCLfile() {
        }

        ZbnfResult_SclStruct parseSclFile(String string) throws IOException {
            ZbnfResult_SclStruct zbnfResult_SclStruct = new ZbnfResult_SclStruct();
            if (string.contains("VariablesHead.SCL")) {
                Assert.stop();
            }
            File file = new File(string);
            File file2 = new File(SCLstruct2Lists.this.args.sPathZbnf + "/sclStruct.zbnf");
            String string2 = ZbnfJavaOutput.parseFileAndFillJavaObject(zbnfResult_SclStruct.getClass(), zbnfResult_SclStruct, file, file2, SCLstruct2Lists.this.console, 1200);
            if (string2 != null) {
                SCLstruct2Lists.this.console.writeError("ERROR Parsing file: " + file.getAbsolutePath() + "\n" + string2);
                return null;
            }
            SCLstruct2Lists.this.console.writeInfoln("SCLstruct2Lists - SUCCESS parsed; " + file.getCanonicalPath() + ";  ");
            return zbnfResult_SclStruct;
        }

        void generateOneSclFile(String string, ZbnfVariablenBlock zbnfVariablenBlock, PositionOfVariable positionOfVariable) throws IOException {
            this.zbnfResultDataUDT = this.parseSclFile(string + zbnfVariablenBlock.pathUDT);
            if (this.zbnfResultDataUDT != null) {
                if (zbnfVariablenBlock.structName != null) {
                    SaveDataStruct saveDataStruct = new SaveDataStruct(zbnfVariablenBlock.structName);
                    SCLstruct2Lists.this.allDataStruct.put(zbnfVariablenBlock.structName, saveDataStruct);
                    int n = this.generateForVariables("", this.zbnfResultDataUDT.variable, saveDataStruct, zbnfVariablenBlock, saveDataStruct.position, 0);
                    saveDataStruct.position.adjustNonBool(n);
                    saveDataStruct.nrofBytes = n;
                } else {
                    this.generateForVariables("", this.zbnfResultDataUDT.variable, null, zbnfVariablenBlock, positionOfVariable, 0);
                }
            }
        }

        int generateForVariables(String string, List<Variable> list, SaveDataStruct saveDataStruct, ZbnfVariablenBlock zbnfVariablenBlock, PositionOfVariable positionOfVariable, int n) throws IOException {
            int n2 = 0;
            if (zbnfVariablenBlock.dbName != null && zbnfVariablenBlock.dbName.equals("SES_ctrl_MainD")) {
                Assert.stop();
            }
            for (Variable variable : list) {
                if (variable.sName.equals("cub2")) {
                    SCLstruct2Lists.this.stop();
                }
                if (variable.zbnfVariable.atName != null) {
                    int n3;
                    Variable variable2 = SCLstruct2Lists.this.indexVariables.get(variable.zbnfVariable.atName);
                    if (variable2 == null) {
                        System.err.println("SCLstruct2List - AT-variable not found; " + variable.zbnfVariable.atName);
                        continue;
                    }
                    PositionOfVariable positionOfVariable2 = new PositionOfVariable();
                    positionOfVariable2.setStartPos(variable2.posVarAbs);
                    variable.nrofElements = n3 = this.generateForSimpleOrStructVariable(string, variable, saveDataStruct, zbnfVariablenBlock, positionOfVariable2, n);
                    continue;
                }
                if (variable.structVariables != null) {
                    if (n > 10) {
                        throw new IllegalArgumentException("too many recursions");
                    }
                    SCLstruct2Lists.completeVariableStruct(variable, positionOfVariable);
                    int n4 = this.generateForVariables(string, variable.structVariables, saveDataStruct, zbnfVariablenBlock, positionOfVariable, n + 1);
                    SCLstruct2Lists.completeVariableAfterStructGeneration(variable, n4);
                    SCLstruct2Lists.this.indexVariables.put(variable.sName, variable);
                    n2 += n4;
                    continue;
                }
                int n5 = this.generateForSimpleOrStructVariable(string, variable, saveDataStruct, zbnfVariablenBlock, positionOfVariable, n);
                n2 += n5;
            }
            return n2;
        }

        int generateForSimpleOrStructVariable(String string, Variable variable, SaveDataStruct saveDataStruct, ZbnfVariablenBlock zbnfVariablenBlock, PositionOfVariable positionOfVariable, int n) throws IOException {
            int n2;
            Object object;
            variable.type = (TypeConversion)SCLstruct2Lists.this.indexTypes.get(variable.zbnfVariable.type);
            if (variable.type == null) {
                object = variable.zbnfVariable.type;
                if (((String)object).equals("TEST")) {
                    Assert.stop();
                }
                if (((String)object).equals("TEST_t")) {
                    Assert.stop();
                }
                variable.type = SCLstruct2Lists.this.allDataStruct.get(object);
            }
            if (variable.type == null) {
                SCLstruct2Lists.this.console.writeError("unknown type: " + variable.zbnfVariable.type);
                n2 = 0;
            } else {
                SCLstruct2Lists.completeVariableWithType(variable, variable.type, positionOfVariable);
                if (saveDataStruct != null) {
                    saveDataStruct.saveVariable(variable);
                    n2 = 0;
                } else if (variable.type.typeCharS7 == 'O') {
                    object = (SaveDataStruct)variable.type;
                    String string2 = string + variable.sName + ".";
                    n2 = this.generateForVariables(string2, ((SaveDataStruct)object).variables, saveDataStruct, zbnfVariablenBlock, positionOfVariable, n + 1);
                    if (SCLstruct2Lists.this.genDbConfig != null) {
                        for (Variable variable2 : ((SaveDataStruct)object).variables) {
                            String string3 = variable.sName + "." + variable2.sName;
                            SCLstruct2Lists.this.genDbConfig.generateDbVariableLine(variable, variable.sName + ".", zbnfVariablenBlock, SCLstruct2Lists.this.genDbConfig.posVariable);
                        }
                        SCLstruct2Lists.this.genDbConfig.posVariable += ((SaveDataStruct)object).position.getIxByte();
                    }
                } else {
                    this.generateForSimpleVariables(string, variable, saveDataStruct, zbnfVariablenBlock, positionOfVariable);
                    n2 = variable.type.nrofBytes;
                }
                SCLstruct2Lists.this.indexVariables.put(variable.sName, variable);
            }
            return n2;
        }

        void generateForSimpleVariables(String string, Variable variable, SaveDataStruct saveDataStruct, ZbnfVariablenBlock zbnfVariablenBlock, PositionOfVariable positionOfVariable) throws IOException {
            SCLstruct2Lists.this.console.reportln(4, "DB" + positionOfVariable.getIxByte() + " " + variable.sName + ":" + variable.type.winccType);
            if (saveDataStruct != null) {
                saveDataStruct.saveVariable(variable);
            } else {
                if (variable.zbnfVariable.otherRepresentation != null) {
                    TypeConversion typeConversion = (TypeConversion)SCLstruct2Lists.this.indexTypes.get(variable.zbnfVariable.otherType);
                    if (variable.type == null) {
                        SCLstruct2Lists.this.console.writeError("unknown type: " + variable.zbnfVariable.otherType);
                    } else {
                        this.generatevariableEntry(variable.zbnfVariable.otherRepresentation, typeConversion, positionOfVariable.getIxByte(), positionOfVariable.getIxBit(), zbnfVariablenBlock);
                    }
                }
                if (SCLstruct2Lists.this.generateVariableImport.output != null && variable.zbnfVariable.winCC && (variable.zbnfVariable.otherRepresentation == null || variable.zbnfVariable.additional)) {
                    this.generatevariableEntry(variable.sName, variable.type, positionOfVariable.getIxByte(), positionOfVariable.getIxBit(), zbnfVariablenBlock);
                }
                if (SCLstruct2Lists.this.args.bAllVariable || variable.zbnfVariable.oam || variable.zbnfVariable.winCC) {
                    this.generateVariableOam(string, variable, zbnfVariablenBlock, positionOfVariable);
                }
                if (SCLstruct2Lists.this.genDbConfig != null) {
                    SCLstruct2Lists.this.genDbConfig.generateDbVariableLine(variable.sName, variable.type, zbnfVariablenBlock);
                }
            }
        }

        void generatevariableEntry(String string, TypeConversion typeConversion, int n, int n2, ZbnfVariablenBlock zbnfVariablenBlock) throws IOException {
            String string2 = "";
            String string3 = "1";
            int n3 = 2;
            String string4 = "500 ms";
            if (zbnfVariablenBlock.winCCfolder != null) {
                SCLstruct2Lists.this.generateVariableImport.sbOut.append(zbnfVariablenBlock.winCCfolder + "/");
            }
            SCLstruct2Lists.this.generateVariableImport.sbOut.append(zbnfVariablenBlock.prefix + string + zbnfVariablenBlock.suffix);
            SCLstruct2Lists.this.generateVariableImport.sbOut.append("\tWinAC\tDB ").append(zbnfVariablenBlock.nrDB);
            SCLstruct2Lists.this.generateVariableImport.sbOut.append(" DB").append(typeConversion.typeCharS7).append(" ").append(n);
            if (typeConversion.typeCharJava == 'Z') {
                SCLstruct2Lists.this.generateVariableImport.sbOut.append("." + n2);
            }
            SCLstruct2Lists.this.generateVariableImport.sbOut.append("\t").append(typeConversion.winccType);
            SCLstruct2Lists.this.generateVariableImport.sbOut.append("\t").append(string2);
            SCLstruct2Lists.this.generateVariableImport.sbOut.append("\t").append(string3);
            SCLstruct2Lists.this.generateVariableImport.sbOut.append("\t").append(n3);
            SCLstruct2Lists.this.generateVariableImport.sbOut.append("\t").append(string4);
            SCLstruct2Lists.this.generateVariableImport.sbOut.append("\t").append("\t\t\t\t\t0\t10\t0\t100\t0\t0\t");
            SCLstruct2Lists.this.generateVariableImport.output.write(SCLstruct2Lists.this.generateVariableImport.sbOut.append("\r\n").toString());
            SCLstruct2Lists.this.generateVariableImport.sbOut.setLength(0);
        }

        void generateVariableOam(String string, Variable variable, ZbnfVariablenBlock zbnfVariablenBlock, PositionOfVariable positionOfVariable) {
            int n;
            int n2;
            String string2 = variable.sName;
            if (string2.equals("ev")) {
                SCLstruct2Lists.this.stop();
            }
            StringBuilder stringBuilder = new StringBuilder(zbnfVariablenBlock.prefix + string.replace('.', '_') + string2 + zbnfVariablenBlock.suffix);
            String string3 = stringBuilder.toString();
            while ((n2 = stringBuilder.indexOf(".")) >= 0) {
                stringBuilder.replace(n2, n2 + 1, "");
                stringBuilder.setCharAt(n2, Character.toUpperCase(stringBuilder.charAt(n2)));
            }
            String string4 = SCLstruct2Lists.this.shortenScl24Names.adjustLength(stringBuilder.toString());
            if (variable.type.typeCharJava == 'Z') {
                n = positionOfVariable.getMaskBit();
            } else {
                positionOfVariable.adjustNonBool(variable.type.nrofBytes);
                n = 0;
            }
            int n3 = positionOfVariable.getIxByte();
            SCLstruct2Lists.this.oamVariables.add(new OamVariable(string4, variable, string, string3, n3, n, zbnfVariablenBlock));
            if (variable.type.typeCharJava == 's') {
                variable.nrofBytes = variable.zbnfVariable.stringlen + 2;
                positionOfVariable.incrPos(0, variable.nrofBytes, 1);
            } else {
                positionOfVariable.incrPos(variable.zbnfVariable.arrayStartIx, variable.zbnfVariable.arrayEndIx, variable.type.nrofBytes);
            }
        }
    }

    private class GenerateVariableImport {
        PositionOfVariable posOamVariable = new PositionOfVariable();
        StringBuilder sbOut = new StringBuilder(10000);
        final String sNameVariableImport;
        final ZbnfResultDataCfg configData;
        final GenerateOneSCLfile generateOneSclFile = new GenerateOneSCLfile();
        final Writer output;
        static final String sNewline = "\r\n";
        static final String spaces = "                                                  ";

        public GenerateVariableImport(String string, ZbnfResultDataCfg zbnfResultDataCfg, Writer writer) {
            this.sNameVariableImport = string;
            this.configData = zbnfResultDataCfg;
            this.output = writer;
            SCLstruct2Lists.this.indexTypes.put("BYTE", new TypeConversion(1, 'B', 'B', "BYTE", "int8", "Byte"));
            SCLstruct2Lists.this.indexTypes.put("INT", new TypeConversion(2, 'W', 'S', "INT", "int16", "Int"));
            SCLstruct2Lists.this.indexTypes.put("DINT", new TypeConversion(4, 'D', 'I', "DINT", "int32", "Dint"));
            SCLstruct2Lists.this.indexTypes.put("WORD", new TypeConversion(2, 'W', 'S', "WORD", "uint16", "Int"));
            SCLstruct2Lists.this.indexTypes.put("DWORD", new TypeConversion(4, 'D', 'I', "DWORD", "uint32", "Dint"));
            SCLstruct2Lists.this.indexTypes.put("BOOL", new TypeConversion(0, 'B', 'Z', "BOOL", "int8", "Bool"));
            SCLstruct2Lists.this.indexTypes.put("REAL", new TypeConversion(4, 'D', 'F', "REAL", "float", "Real"));
            SCLstruct2Lists.this.indexTypes.put("STRING", new TypeConversion(4, 'S', 's', "STRING", "string", "String"));
        }

        protected boolean generateOutFiles(String string) throws IOException, IllegalAccessException {
            JZcmdScript jZcmdScript;
            File file;
            File file2;
            Object object2;
            JZcmdExecuter jZcmdExecuter = new JZcmdExecuter(SCLstruct2Lists.this.console);
            jZcmdExecuter.setScriptVariable("scl", 'O', SCLstruct2Lists.this, true);
            if (this.output != null) {
                this.output.write("# WinCC flexible 2008 Variablen-Import\r\n");
                this.output.write("# Generated by SCLstruct2Lists, made by Hartmut Schorrig, Version 2010-03-26\r\n");
            }
            File file3 = new File(SCLstruct2Lists.this.args.sFileCfg);
            File file4 = FileSystem.getDirectory(file3);
            String string2 = string != null ? string + "/" : file4.getAbsolutePath() + "/";
            this.posOamVariable.setStartPos(this.configData.startOffset);
            for (Object object2 : this.configData.variablenBlock) {
                this.generateOneSclFile.generateOneSclFile(string2, (ZbnfVariablenBlock)object2, this.posOamVariable);
            }
            String string3 = "<:file>FUNCTION_BLOCK OamVariables\nVAR\n<:for:var:oamVariables>\n  <:><*$var.name24>: <.>  <:if:$var.variable.nrofElements ?gt 1>  <:>ARRAY[<*$var.variable.zbnfVariable.arrayStartIx>..<*$var.variable.zbnfVariable.arrayEndIx>] OF <.><.if>  <:><*$var.variable.type.s7Type>;\n<.>\n<.for>END_VAR\nBEGIN\n<:for:var:oamVariables>\n  <:><*$var.name24> := <.>  <:if:$var.block.dbName><*$var.block.dbName><:else>DB<*$var.block.nrDB><.if>  <:>.<*$var.sDataPath><*$var.variable.sName>;\n<.>\n<.for>END_FUNCTION_BLOCK\n<.file>";
            if (SCLstruct2Lists.this.args.sFileScl != null) {
                object2 = new FileWriter(SCLstruct2Lists.this.args.sFileScl);
                try {
                    file2 = new File(SCLstruct2Lists.this.args.sPathZbnf + "/" + SCLstruct2Lists.this.args.sFileSclCtrl);
                    if (!file2.exists()) {
                        file2 = new File(SCLstruct2Lists.this.args.sFileSclCtrl);
                    }
                    file = SCLstruct2Lists.this.args.sCheckXml == null ? null : new File(SCLstruct2Lists.this.args.sCheckXml + "_checkCtrl.txt");
                    jZcmdScript = SCLstruct2Lists.this.args.sFileSclCtrl != null ? JZcmd.translateAndSetGenCtrl(file2, file, SCLstruct2Lists.this.console) : JZcmd.translateAndSetGenCtrl(string3, (MainCmdLogging_ifc)SCLstruct2Lists.this.console);
                    jZcmdExecuter.execute(jZcmdScript, true, false, (Appendable)object2, null);
                }
                catch (Throwable throwable) {
                    throw new RuntimeException(throwable);
                }
                ((Writer)object2).close();
                jZcmdExecuter.removeScriptVariable("text");
            }
            if (SCLstruct2Lists.this.args.sFileOamVariables != null) {
                file2 = new File(SCLstruct2Lists.this.args.sPathZbnf + "/" + SCLstruct2Lists.this.args.sFileOamVariablesCtrl);
                if (!file2.exists()) {
                    file2 = new File(SCLstruct2Lists.this.args.sFileOamVariablesCtrl);
                }
                file = SCLstruct2Lists.this.args.sCheckXml == null ? null : new File(SCLstruct2Lists.this.args.sCheckXml + SCLstruct2Lists.this.args.sFileOamVariablesCtrl + "_check.txt");
                object2 = new FileWriter(SCLstruct2Lists.this.args.sFileOamVariables);
                try {
                    jZcmdScript = JZcmd.translateAndSetGenCtrl(file2, file, SCLstruct2Lists.this.console);
                    jZcmdExecuter.execute(jZcmdScript, true, false, (Appendable)object2, null);
                }
                catch (Throwable throwable) {
                    throw new RuntimeException(throwable);
                }
                ((Writer)object2).close();
            }
            if (this.output != null) {
                this.output.write(this.sbOut.toString());
            }
            return true;
        }
    }

    private static class TypeConversion {
        int nrofBytes;
        final char typeCharS7;
        final char typeCharJava;
        final String s7Type;
        final String winccType;
        final String cType;

        private TypeConversion(int n, char c, char c2, String string, String string2, String string3) {
            this.nrofBytes = n;
            this.typeCharS7 = c;
            this.typeCharJava = c2;
            this.s7Type = string;
            this.cType = string2;
            this.winccType = string3;
        }
    }

    private static class GenerateDbConfigAccess {
        int posVariable = 0;
        int bitMask = 1;
        final StringBuilder dbList = new StringBuilder(8000);
        final String sFile;

        public GenerateDbConfigAccess(String string) {
            this.sFile = string;
        }

        void generateDbVariableLine(String string, TypeConversion typeConversion, ZbnfVariablenBlock zbnfVariablenBlock) {
            String string2;
            String string3 = zbnfVariablenBlock.prefix + string + zbnfVariablenBlock.suffix;
            if (typeConversion.typeCharJava == 'Z') {
                string2 = Integer.toHexString(this.bitMask);
                this.dbList.append("\n").append(zbnfVariablenBlock.winCCfolder).append('/').append(string3).append(": ").append(typeConversion.typeCharJava).append(" @").append(this.posVariable).append(".0x").append(Integer.toHexString(this.bitMask)).append(";//DB").append(zbnfVariablenBlock.nrDB);
                this.bitMask <<= 1;
                if (this.bitMask > 128) {
                    this.bitMask = 1;
                    ++this.posVariable;
                }
            } else {
                if (this.bitMask != 1) {
                    this.bitMask = 1;
                    ++this.posVariable;
                }
                if (typeConversion.nrofBytes > 1 && (this.posVariable & 1) != 0) {
                    ++this.posVariable;
                }
                this.dbList.append("\n").append(zbnfVariablenBlock.winCCfolder).append('/').append(string3).append(": ").append(typeConversion.typeCharJava).append(" @").append(this.posVariable).append(";  //DB").append(zbnfVariablenBlock.nrDB);
                this.posVariable += typeConversion.nrofBytes;
            }
            string2 = zbnfVariablenBlock.dbName != null ? zbnfVariablenBlock.dbName : "DB" + zbnfVariablenBlock.nrDB;
        }

        void generateDbVariableLine(Variable variable, String string, ZbnfVariablenBlock zbnfVariablenBlock, int n) {
            String string2 = zbnfVariablenBlock.prefix + string + variable.sName + zbnfVariablenBlock.suffix;
            String string3 = zbnfVariablenBlock.dbName != null ? zbnfVariablenBlock.dbName : "DB" + zbnfVariablenBlock.nrDB;
            if (variable.type.typeCharJava == 'Z') {
                String string4 = Integer.toHexString(this.bitMask);
                this.dbList.append("\n").append(zbnfVariablenBlock.winCCfolder).append('/').append(string2).append(": ").append(variable.type.typeCharJava).append(" @").append(variable.posVarAbs + n).append(".0x").append(Integer.toHexString(variable.boolMask)).append(";//DB").append(zbnfVariablenBlock.nrDB);
            } else {
                this.dbList.append("\n").append(zbnfVariablenBlock.winCCfolder).append('/').append(string2).append(": ").append(variable.type.typeCharJava).append(" @").append(variable.posVarAbs + n).append(" +").append(variable.nrofBytes);
                if (variable.nrofElements > 1) {
                    this.dbList.append(" *").append(variable.nrofElements);
                }
                this.dbList.append(";  //").append(string3);
            }
        }

        void writeFile() throws IOException {
            FileWriter fileWriter = new FileWriter(this.sFile);
            fileWriter.write("==AllVariableFromDB==");
            fileWriter.write(this.dbList.toString());
            ((Writer)fileWriter).close();
        }
    }

    private static class SaveDataStruct
    extends TypeConversion {
        final PositionOfVariable position = new PositionOfVariable();
        List<Variable> variables = new LinkedList<Variable>();

        public SaveDataStruct(String string) {
            super(0, 'O', 'O', string, string, string);
        }

        void saveVariable(Variable variable) {
            this.variables.add(variable);
        }
    }

    static class Variable {
        String sName;
        int posVarAbs;
        int boolMask;
        TypeConversion type;
        int nrofBytes;
        int nrofElements;
        List<Variable> structVariables;
        final ZbnfVariable zbnfVariable;

        Variable(ZbnfVariable zbnfVariable) {
            this.zbnfVariable = zbnfVariable;
        }

        public String toString() {
            return this.sName + "@" + this.posVarAbs + ":" + (this.type == null ? "?" : Character.valueOf(this.type.typeCharS7));
        }
    }

    public static class ZbnfResultDataCfg {
        private final List<ZbnfVariablenBlock> variablenBlock = new LinkedList<ZbnfVariablenBlock>();
        public int startOffset;

        public ZbnfVariablenBlock new_variablenBlock() {
            return new ZbnfVariablenBlock();
        }

        public void add_variablenBlock(ZbnfVariablenBlock zbnfVariablenBlock) {
            this.variablenBlock.add(zbnfVariablenBlock);
        }
    }

    public static class ZbnfResultStructVariable {
        private final List<ZbnfVariable> variable = new LinkedList<ZbnfVariable>();

        public ZbnfVariable new_variable() {
            return new ZbnfVariable();
        }

        public void add_variable(ZbnfVariable zbnfVariable) {
            this.variable.add(zbnfVariable);
        }
    }

    public static class ZbnfResult_SclStruct {
        private final List<Variable> variable = new LinkedList<Variable>();
        public String typeIdent;

        public ZbnfVariable new_shortPtr() {
            ZbnfVariable zbnfVariable = new ZbnfVariable();
            zbnfVariable.isShortPtr = true;
            return zbnfVariable;
        }

        public void add_shortPtr(ZbnfVariable zbnfVariable) {
            this.add_variable(zbnfVariable);
        }

        public ZbnfVariable new_variable() {
            return new ZbnfVariable();
        }

        public void add_variable(ZbnfVariable zbnfVariable) {
            for (String string : zbnfVariable.name) {
                Variable variable = SCLstruct2Lists.createVariable(string, zbnfVariable);
                this.variable.add(variable);
            }
        }

        public void set_comment(String string) {
        }
    }

    public static class ZbnfVariablenBlock {
        public String structName = null;
        public String winCCfolder = null;
        public String prefix = "";
        public String suffix = "";
        public String pathUDT;
        public String dbName;
        public int nrDB;
        public int nrByte;

        public String toString() {
            return this.pathUDT + "/" + this.dbName;
        }
    }

    public static class ZbnfVariable {
        public List<String> name;
        String atName;
        boolean isShortPtr;
        private List<ZbnfVariable> structZbnfVariables;
        public String type;
        public int stringlen;
        public int arrayStartIx;
        public int arrayEndIx;
        public String assignment = "";
        public String otherRepresentation = null;
        public String otherType = null;
        public boolean additional;
        private boolean winCC;
        private boolean oam;
        public String comment;
        public String comment2;

        public void set_winCC() {
            this.winCC = true;
        }

        public void set_oam() {
            this.oam = true;
        }

        public void set_atName(String string) {
            this.atName = string;
        }

        public ZbnfVariable new_structVariable() {
            return new ZbnfVariable();
        }

        public void add_structVariable(ZbnfVariable zbnfVariable) {
            if (this.structZbnfVariables == null) {
                this.structZbnfVariables = new LinkedList<ZbnfVariable>();
            }
            this.structZbnfVariables.add(zbnfVariable);
        }

        public String toString() {
            return this.name.toString();
        }
    }

    static class PositionOfVariable
    extends PositionElementInStruct {
        int XXXposVariable = 0;
        int XXXbitMask = 1;

        PositionOfVariable() {
        }
    }

    static class OamVariable {
        final String name24;
        final Variable variable;
        final String structPath;
        final String dataPath;
        final ZbnfVariablenBlock block;
        final int posByte;
        final int maskBitInByte;

        OamVariable(String string, Variable variable, String string2, String string3, int n, int n2, ZbnfVariablenBlock zbnfVariablenBlock) {
            this.name24 = string;
            this.variable = variable;
            this.structPath = string2;
            this.dataPath = string3;
            this.block = zbnfVariablenBlock;
            this.posByte = n;
            this.maskBitInByte = n2;
        }
    }

    static class CmdLine
    extends MainCmd {
        final Args cmdlineArgs;

        private CmdLine(String[] stringArray, Args args) {
            super(stringArray);
            this.cmdlineArgs = args;
            super.addAboutInfo("Conversion SCL-Files (Simatic) for oam");
            super.addAboutInfo("made by Hartmut Schorrig, 2010-08-01, 2010-10-15");
            super.addHelpInfo("made by Hartmut Schorrig, 2010-08-01, 2010-10-15");
            super.addHelpInfo("-srcpath=PATH Path base to sources, additional to config file. If not given,");
            super.addHelpInfo("              then the source path is the directory of the config file.");
            super.addHelpInfo("-z:ZBNFPATH path, should contain sclVarCfg.zbnf and sclStruct.zbnf.");
            super.addHelpInfo("-y:TEST start path for some intermediate files for checking the translation.");
            super.addHelpInfo("param: TODO");
            super.addStandardHelpInfo();
        }

        @Override
        protected boolean testArgument(String string, int n) {
            boolean bl = true;
            if (string.startsWith("-cfg=")) {
                this.cmdlineArgs.sFileCfg = this.getArgument(5);
            } else if (string.startsWith("-srcpath=")) {
                this.cmdlineArgs.sSrcPath = this.getArgument(9);
            } else if (string.startsWith("-wincc=")) {
                this.cmdlineArgs.sFileWinccVarCsv = this.getArgument(7);
            } else if (string.startsWith("-scl=")) {
                this.cmdlineArgs.sFileScl = this.getArgument(5);
            } else if (string.startsWith("-sclCtrl=")) {
                this.cmdlineArgs.sFileSclCtrl = this.getArgument(9);
            } else if (string.startsWith("-oam=")) {
                this.cmdlineArgs.sFileOamVariables = this.getArgument(5);
            } else if (string.startsWith("-oamCtrl=")) {
                this.cmdlineArgs.sFileOamVariablesCtrl = this.getArgument(9);
            } else if (string.startsWith("-db=")) {
                this.cmdlineArgs.sFileDbVariables = this.getArgument(4);
            } else if (string.startsWith("-z=")) {
                this.cmdlineArgs.sPathZbnf = this.getArgument(3);
            } else if (string.startsWith("-y=")) {
                this.cmdlineArgs.sCheckXml = this.getArgument(3);
            } else if (string.startsWith("-all")) {
                this.cmdlineArgs.bAllVariable = true;
            } else {
                bl = false;
            }
            return bl;
        }

        @Override
        protected void callWithoutArguments() throws ParseException {
            super.callWithoutArguments();
        }

        @Override
        protected boolean checkArguments() {
            boolean bl = true;
            if (this.cmdlineArgs.sFileCfg == null) {
                bl = false;
                this.writeError("ERROR argument -i is obligat.");
            } else if (this.cmdlineArgs.sFileCfg.length() == 0) {
                bl = false;
                this.writeError("ERROR argument -i without content.");
            }
            if (!bl) {
                this.setExitErrorLevel(5);
            }
            return bl;
        }
    }

    private static class Args {
        String sSrcPath = null;
        String sFileCfg = null;
        String sFileWinccVarCsv = null;
        String sFileScl = null;
        String sFileSclCtrl = null;
        String sFileOamVariables = null;
        String sFileOamVariablesCtrl = null;
        String sFileDbVariables = null;
        String sPathZbnf = null;
        String sCheckXml = null;
        boolean bAllVariable = false;

        private Args() {
        }
    }
}

