/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.msgDispatch;

import java.io.File;
import java.util.TimeZone;
import org.vishia.mainCmd.MainCmd;
import org.vishia.msgDispatch.LogMessage;
import org.vishia.msgDispatch.LogMessageStream;
import org.vishia.msgDispatch.MsgConfig;
import org.vishia.msgDispatch.MsgDispatcher;
import org.vishia.msgDispatch.MsgPrintStream;
import org.vishia.util.Assert;

public class MsgRedirectConsole
extends MsgDispatcher {
    public static final int version = 20130126;
    public static final int ixMsgOutputStdOut = 0;
    public static final int ixMsgOutputStdErr = 1;
    public static final int ixMsgOutputFile = 2;
    public final MsgPrintStream printOut;
    public final MsgPrintStream printErr;
    private final TimeZone timeZoneForFile = TimeZone.getTimeZone("GMT");
    public final LogMessage cmdlineOut;
    public final LogMessage cmdlineErr;
    private final MsgConfig msgConfig = new MsgConfig();

    public MsgRedirectConsole(int n, int n2, int n3, int n4, MainCmd mainCmd, int n5, int n6, int n7, int n8, Runnable runnable) {
        super(n5, n6, n7, 0, n8, runnable);
        Assert.check(true);
        this.printOut = new MsgPrintStream(this, n, n3, n4);
        this.printErr = n2 >= 0 ? new MsgPrintStream(this, n2, n3, n4) : null;
        int n9 = 0;
        if (mainCmd == null) {
            this.cmdlineOut = new LogMessageStream(System.out);
            this.cmdlineErr = new LogMessageStream(System.err);
        } else {
            this.cmdlineOut = mainCmd.getLogMessageOutputConsole();
            this.cmdlineErr = mainCmd.getLogMessageErrorConsole();
            mainCmd.setLogMessageDestination(this);
            this.setOutputRoutine(2, "stdlog", true, true, mainCmd.getLogMessageOutputFile());
        }
        this.setOutputRoutine(0, "stdout", false, true, this.cmdlineOut);
        this.setOutputRoutine(1, "stderr", false, true, this.cmdlineErr);
        this.setOutputRange(0, 49999, n9 | 1, 50669, 0);
        this.setOutputRange(50000, Integer.MAX_VALUE, n9 | 2, 50669, 0);
        if (mainCmd == null) {
            this.setOutputRange(0, Integer.MAX_VALUE, 4, 51933, 0);
        }
        System.setOut(this.printOut.getPrintStreamLog(""));
        if (this.printErr != null) {
            System.setErr(this.printErr.getPrintStreamLog(""));
        }
    }

    public MsgRedirectConsole(MainCmd mainCmd, int n, Runnable runnable) {
        this(10000, 40000, 10000, 100, mainCmd, 10000, 1000, n + 3, 9999, runnable);
    }

    public void setMsgIdents(MsgConfig msgConfig, String string) {
        super.setMsgTextConverter(msgConfig);
        this.printOut.setMsgIdents(msgConfig);
        if (this.printErr != null) {
            this.printOut.setMsgIdents(msgConfig);
        }
        msgConfig.setMsgDispaching(this, string);
    }

    public String readConfig(File file) {
        String string = this.msgConfig.readConfig(file);
        if (string == null) {
            this.setMsgIdents(this.msgConfig, "dfl");
        } else {
            System.err.println("MsgRedirectConsole.readConfig - syntax error; " + string);
        }
        return string;
    }
}

