/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.msgDispatch;

import java.io.IOException;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Formatter;
import java.util.IllegalFormatConversionException;
import java.util.IllegalFormatPrecisionException;
import java.util.Locale;
import java.util.MissingFormatArgumentException;
import java.util.TimeZone;
import org.vishia.bridgeC.ConcurrentLinkedQueue;
import org.vishia.bridgeC.OS_TimeStamp;
import org.vishia.bridgeC.Va_list;
import org.vishia.msgDispatch.LogMessage;
import org.vishia.msgDispatch.MsgDispatcherCore;
import org.vishia.util.FileWriter;

public class LogMessageFile
implements LogMessage {
    public static final int version = 20130324;
    final StringBuilder sFilenameBuffer = new StringBuilder(120);
    final StringBuffer sDateformatBuffer = new StringBuffer(32);
    String sFormatTimestampFilename;
    final SimpleDateFormat formatTimestamp = new SimpleDateFormat();
    int counterMultifile = 0;
    final FieldPosition formatField = new FieldPosition(3);
    final char[] charsFormatTimestampFilename = new char[32];
    int posTimestampInFilename;
    int posMultifileInFilename;
    int currentLengthMultifileNr;
    final FileWriter file = new FileWriter();
    final OS_TimeStamp timeOpen = new OS_TimeStamp();
    boolean bNewFile = true;
    final OS_TimeStamp timeWrite = new OS_TimeStamp();
    final OS_TimeStamp timeClose = new OS_TimeStamp();
    final int nrofSecondsToFlush;
    final int nrofSecondsToClose;
    int cntAllNonFlushedWrite;
    int cntNonFlushedWrite;
    int maxCntNonFlushedWrite;
    boolean shouldFlushed = false;
    LogMessage msgOpenClose;
    int msgIdentOpenClose;
    public static final int kMsgOpen = 0;
    public static final int kMsgNewFile = 1;
    public static final int kMsgOpenError = 2;
    public static final int kMsgClose = 3;
    int nrofHoursPerFile;
    final Dbg dbg = new Dbg();
    final ConcurrentLinkedQueue<MsgDispatcherCore.Entry> parkedOrders = new ConcurrentLinkedQueue(false);
    final ConcurrentLinkedQueue<MsgDispatcherCore.Entry> freeEntries;
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss,SSS; ");
    private final Locale localization;
    private final TimeZone timeZone;
    private final StringBuilder sBuffer = new StringBuilder(1000);

    public LogMessageFile(String string, int n, int n2, Locale locale, TimeZone timeZone, ConcurrentLinkedQueue<MsgDispatcherCore.Entry> concurrentLinkedQueue) {
        this.localization = locale == null ? Locale.ROOT : locale;
        this.timeZone = timeZone == null ? TimeZone.getTimeZone("GMT") : timeZone;
        this.dateFormat.setTimeZone(this.timeZone);
        this.formatTimestamp.setTimeZone(this.timeZone);
        this.freeEntries = concurrentLinkedQueue;
        if (concurrentLinkedQueue != null) {
            this.parkedOrders.shareNodePool(concurrentLinkedQueue);
        }
        if (n > 0) {
            this.nrofSecondsToFlush = n;
            this.nrofSecondsToClose = -1;
        } else {
            this.nrofSecondsToClose = -n;
            this.nrofSecondsToFlush = -1;
        }
        this.nrofHoursPerFile = n2;
        this.posTimestampInFilename = string.indexOf(36);
        if (this.posTimestampInFilename >= 0) {
            int n3 = string.indexOf(36, this.posTimestampInFilename + 1);
            if (n3 <= 0) {
                throw new IllegalArgumentException("second $ to delimit timestamp in filename missing.");
            }
            String string2 = string.substring(this.posTimestampInFilename + 1, n3);
            int n4 = string2.length();
            string2.getChars(0, n4, this.charsFormatTimestampFilename, 0);
            this.sFormatTimestampFilename = new String(this.charsFormatTimestampFilename, 0, n4);
            this.formatTimestamp.applyPattern(this.sFormatTimestampFilename);
            this.sFilenameBuffer.append(string.substring(0, this.posTimestampInFilename));
            if (string.indexOf(42) >= 0) {
                this.timeOpen.set(OS_TimeStamp.os_getDateTime());
                this.sDateformatBuffer.setLength(0);
                this.formatTimestamp.format((Date)this.timeOpen, this.sDateformatBuffer, this.formatField);
                String string3 = this.sDateformatBuffer.toString();
                this.sFilenameBuffer.append(string3);
                this.posTimestampInFilename = -1;
            } else {
                this.sFilenameBuffer.append(this.sFormatTimestampFilename);
            }
            this.sFilenameBuffer.append(string.substring(n3 + 1));
        } else {
            this.sFilenameBuffer.append(string);
            this.bNewFile = false;
        }
        this.posMultifileInFilename = this.sFilenameBuffer.toString().indexOf(42);
        this.currentLengthMultifileNr = 1;
    }

    public void setLogMessageOpenClose(LogMessage logMessage, int n) {
        this.msgOpenClose = logMessage;
        this.msgIdentOpenClose = n;
    }

    @Override
    public boolean sendMsg(int n, String string, Object ... objectArray) {
        Va_list va_list = new Va_list(objectArray);
        return this.sendMsgVaList(n, OS_TimeStamp.os_getDateTime(), string, va_list);
    }

    @Override
    public final boolean sendMsgTime(int n, OS_TimeStamp oS_TimeStamp, String string, Object ... objectArray) {
        Va_list va_list = new Va_list(objectArray);
        return this.sendMsgVaList(n, oS_TimeStamp, string, va_list);
    }

    @Override
    public boolean sendMsgVaList(int n, OS_TimeStamp oS_TimeStamp, String string, Va_list va_list) {
        boolean bl;
        int n2;
        int n3;
        Object object;
        LogMessage logMessage = this.msgOpenClose;
        if (!this.bNewFile && this.nrofHoursPerFile != 0) {
            object = new OS_TimeStamp();
            ((OS_TimeStamp)object).set(OS_TimeStamp.os_getDateTime());
            n3 = ((OS_TimeStamp)object).time_sec - this.timeOpen.time_sec;
            int n4 = n2 = this.nrofHoursPerFile > 0 ? 3600 * this.nrofHoursPerFile : -this.nrofHoursPerFile;
            if (n3 >= n2) {
                if (this.file.isOpen()) {
                    this.file.close();
                }
                this.bNewFile = true;
            }
        }
        if (!this.file.isOpen()) {
            boolean bl2;
            if (this.nrofSecondsToClose > 0) {
                OS_TimeStamp oS_TimeStamp2 = new OS_TimeStamp();
                oS_TimeStamp2.set(OS_TimeStamp.os_getDateTime());
                n2 = oS_TimeStamp2.time_sec - this.timeClose.time_sec;
                bl2 = n2 >= this.nrofSecondsToClose;
            } else {
                bl2 = true;
            }
            if (bl2) {
                n3 = 0;
                n2 = 0;
                do {
                    if (this.bNewFile && this.posTimestampInFilename >= 0) {
                        this.timeOpen.set(OS_TimeStamp.os_getDateTime());
                        this.sDateformatBuffer.setLength(0);
                        this.formatTimestamp.format((Date)this.timeOpen, this.sDateformatBuffer, this.formatField);
                        String string2 = this.sDateformatBuffer.toString();
                        this.sFilenameBuffer.replace(this.posTimestampInFilename, this.posTimestampInFilename + string2.length(), string2);
                    } else if (this.bNewFile && this.posMultifileInFilename >= 0) {
                        StringBuilder stringBuilder = new StringBuilder(20);
                        stringBuilder.append(++this.counterMultifile);
                        String string3 = stringBuilder.toString();
                        this.sFilenameBuffer.replace(this.posMultifileInFilename, this.posMultifileInFilename + this.currentLengthMultifileNr, string3);
                        this.currentLengthMultifileNr = string3.length();
                    } else {
                        this.bNewFile = false;
                    }
                    int n5 = this.file.open(this.sFilenameBuffer.toString(), !this.bNewFile);
                    if (n5 >= 0) {
                        n3 = 1;
                        this.bNewFile = false;
                        if (logMessage == null) continue;
                        logMessage.sendMsg(this.msgIdentOpenClose + 0, "open %s", this.sFilenameBuffer.toString());
                        continue;
                    }
                    if (n2 == 0) {
                        this.bNewFile = true;
                        n2 = 1;
                        ++this.dbg.cntCreateNewBecauseOpenFailed;
                        if (logMessage == null) continue;
                        logMessage.sendMsg(this.msgIdentOpenClose + 1, "new File", new Object[0]);
                        continue;
                    }
                    n2 = 0;
                    ++this.dbg.cntOpenFailed;
                    if (logMessage == null) continue;
                    logMessage.sendMsg(this.msgIdentOpenClose + 2, "fatalOpenError", new Object[0]);
                } while (n3 == 0 && n2 != 0);
            }
        }
        if (this.file.isOpen()) {
            do {
                if ((object = (MsgDispatcherCore.Entry)this.parkedOrders.poll()) == null) continue;
                this.writeInFile(((MsgDispatcherCore.Entry)object).ident, ((MsgDispatcherCore.Entry)object).timestamp, ((MsgDispatcherCore.Entry)object).text, ((MsgDispatcherCore.Entry)object).values.get_va_list());
                ((MsgDispatcherCore.Entry)object).values.clean();
                ((MsgDispatcherCore.Entry)object).ident = 0;
                this.freeEntries.offer(object);
            } while (object != null);
            this.writeInFile(n, oS_TimeStamp, string, va_list);
            bl = true;
        } else if (this.freeEntries != null) {
            object = (MsgDispatcherCore.Entry)this.freeEntries.poll();
            if (object == null) {
                bl = false;
            } else {
                ((MsgDispatcherCore.Entry)object).dst = 0;
                ((MsgDispatcherCore.Entry)object).ident = n;
                ((MsgDispatcherCore.Entry)object).text = string;
                ((MsgDispatcherCore.Entry)object).timestamp.set(oS_TimeStamp);
                ((MsgDispatcherCore.Entry)object).values.copyFrom(string, va_list);
                this.parkedOrders.offer(object);
                bl = true;
            }
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    public void flush() {
        int n;
        OS_TimeStamp oS_TimeStamp;
        if (this.nrofSecondsToClose > 0 && this.file.isOpen()) {
            oS_TimeStamp = new OS_TimeStamp(true);
            n = oS_TimeStamp.time_sec - this.timeWrite.time_sec;
            if (n >= this.nrofSecondsToClose) {
                this.file.close();
                if (this.maxCntNonFlushedWrite < this.cntNonFlushedWrite) {
                    this.maxCntNonFlushedWrite = this.cntNonFlushedWrite;
                }
                this.shouldFlushed = false;
                this.timeClose.set(oS_TimeStamp);
                if (this.msgOpenClose != null) {
                    this.msgOpenClose.sendMsg(this.msgIdentOpenClose + 3, "close", new Object[0]);
                }
            }
        }
        if (this.nrofSecondsToFlush > 0 && this.shouldFlushed) {
            oS_TimeStamp = new OS_TimeStamp(true);
            n = oS_TimeStamp.time_sec - this.timeOpen.time_sec;
            if (n >= this.nrofSecondsToFlush) {
                try {
                    this.file.flush();
                }
                catch (IOException iOException) {
                    ++this.dbg.cntCloseError;
                }
                if (this.maxCntNonFlushedWrite < this.cntNonFlushedWrite) {
                    this.maxCntNonFlushedWrite = this.cntNonFlushedWrite;
                }
                this.shouldFlushed = false;
            }
        }
    }

    void writeInFile(int n, OS_TimeStamp oS_TimeStamp, String string, Va_list va_list) {
        String string2;
        CharSequence charSequence;
        Object object;
        StringBuilder stringBuilder = new StringBuilder(1000);
        if (va_list.size() > 0) {
            object = new Formatter(stringBuilder, this.localization);
            try {
                ((Formatter)object).format(string, va_list.get());
            }
            catch (IllegalFormatConversionException illegalFormatConversionException) {
                stringBuilder.append("error in text format: ").append(string);
            }
            catch (IllegalFormatPrecisionException illegalFormatPrecisionException) {
                stringBuilder.append("error-precision in text format: ").append(string);
            }
            catch (MissingFormatArgumentException missingFormatArgumentException) {
                stringBuilder.append("error-argument in text format: ").append(string);
            }
            catch (Exception exception) {
                stringBuilder.append("error-unknown in text format: ").append(string);
            }
            charSequence = stringBuilder;
        } else {
            charSequence = string;
        }
        object = new StringBuffer(30);
        this.dateFormat.format((Date)oS_TimeStamp, (StringBuffer)object, this.formatField);
        this.sBuffer.setLength(0);
        if (n >= 0) {
            string2 = "+";
        } else {
            string2 = "-";
            n = -n;
        }
        this.sBuffer.append((StringBuffer)object).append("; ").append(n).append(";").append(string2).append(";").append(charSequence).append("\r\n");
        try {
            this.file.write(this.sBuffer.toString());
            if (this.nrofSecondsToFlush == 0) {
                this.file.flush();
            } else if (!this.shouldFlushed) {
                this.timeWrite.set(OS_TimeStamp.os_getDateTime());
                this.cntNonFlushedWrite = 1;
                this.shouldFlushed = true;
            } else {
                ++this.cntAllNonFlushedWrite;
                ++this.cntNonFlushedWrite;
            }
        }
        catch (IOException iOException) {
            ++this.dbg.cntWriteError;
        }
    }

    @Override
    public void close() {
        this.file.close();
        this.bNewFile = true;
    }

    @Override
    public boolean isOnline() {
        return true;
    }

    static final class Dbg {
        int cntWriteError;
        int cntCloseError;
        int cntOpenFailed;
        int cntCreateNewBecauseOpenFailed;
        int cntFilePathIncorrect;

        Dbg() {
        }
    }
}

