/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.mainCmd;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.vishia.bridgeC.OS_TimeStamp;
import org.vishia.bridgeC.Va_list;
import org.vishia.mainCmd.MainCmdLogging_ifc;
import org.vishia.util.Assert;

public class MainCmdLoggingStream
implements MainCmdLogging_ifc {
    protected OutputStream out;
    private final StringBuilder u = new StringBuilder();
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("MMM-dd HH:mm:ss.SSS: ");
    private static String sLeft = "                                                                ";
    int reportLevel = 5;

    public MainCmdLoggingStream(OutputStream outputStream) {
        this.out = outputStream;
    }

    public MainCmdLoggingStream(OutputStream outputStream, int n) {
        this.out = outputStream;
        this.reportLevel = n;
    }

    @Override
    public void flushReport() {
        this.flush();
    }

    @Override
    public int getExitErrorLevel() {
        return 0;
    }

    @Override
    public int getReportLevel() {
        return this.reportLevel;
    }

    @Override
    public int getReportLevelFromIdent(int n) {
        return n <= 6 ? n : 3;
    }

    @Override
    public void openReportfile(String string, boolean bl) throws FileNotFoundException {
        this.out = new FileOutputStream(string);
    }

    @Override
    public void report(int n, String string) {
        if ((n & 7) <= this.reportLevel) {
            this.u.append(string);
        }
    }

    void writeBuffer() {
        try {
            this.out.write(this.u.toString().getBytes());
        }
        catch (IOException iOException) {
            System.err.println("MainCmdLoggingStream - IOException;");
        }
        this.u.setLength(0);
    }

    void writeln(int n, int n2, CharSequence charSequence) {
        if (this.u.length() > 0) {
            for (int i = 0; i < this.u.length(); ++i) {
                if (this.u.charAt(i) >= ' ') continue;
                this.u.setCharAt(i, '|');
            }
            this.u.append("\n");
            this.writeBuffer();
        }
        this.u.append(this.dateFormat.format(new Date(System.currentTimeMillis())));
        this.u.append(n).append(": ").append(sLeft.subSequence(0, n2)).append(charSequence);
    }

    @Override
    public void report(String string, Throwable throwable) {
        CharSequence charSequence = Assert.exceptionInfo(string, throwable, 0, 20);
        this.writeln(1, 0, charSequence);
    }

    @Override
    public void reportln(int n, int n2, String string) {
        if ((n & 7) <= this.reportLevel) {
            this.writeln(n, n2, string);
        }
    }

    @Override
    public void reportln(int n, String string) {
        this.reportln(n, 0, string);
    }

    @Override
    public void setExitErrorLevel(int n) {
    }

    @Override
    public void setOutputChannels(Appendable appendable, Appendable appendable2) {
    }

    @Override
    public void setReportLevelToIdent(int n, int n2) {
    }

    @Override
    public void writeError(String string) {
        this.reportln(1, string);
    }

    @Override
    public void writeError(String string, Throwable throwable) {
        this.report(string, throwable);
    }

    @Override
    public void writeInfo(String string) {
        this.report(3, string);
    }

    @Override
    public void writeInfoln(String string) {
        this.reportln(3, string);
    }

    @Override
    public void writeStackTrace(Exception exception) {
        exception.printStackTrace(new PrintStream(this.out, true));
    }

    @Override
    public void writeWarning(String string) {
        this.reportln(2, string);
    }

    @Override
    public void close() {
        if (this.u.length() > 0) {
            this.u.append("\n");
            this.writeBuffer();
        }
    }

    @Override
    public void flush() {
        if (this.u.length() > 0) {
            this.writeBuffer();
        }
        try {
            this.out.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public boolean isOnline() {
        return this.out != null;
    }

    @Override
    public boolean sendMsg(int n, String string, Object ... objectArray) {
        return this.sendMsgTime(n, new OS_TimeStamp(System.currentTimeMillis()), string, objectArray);
    }

    @Override
    public boolean sendMsgTime(int n, OS_TimeStamp oS_TimeStamp, String string, Object ... objectArray) {
        String string2 = this.dateFormat.format(oS_TimeStamp) + "; " + n + "; " + String.format(string, objectArray);
        try {
            this.out.write(string2.getBytes());
            this.out.write(10);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    @Override
    public boolean sendMsgVaList(int n, OS_TimeStamp oS_TimeStamp, String string, Va_list va_list) {
        String string2 = "?";
        try {
            string2 = this.dateFormat.format(oS_TimeStamp) + "; " + n + "; " + String.format(string, va_list.get());
        }
        catch (Exception exception) {
            string2 = this.dateFormat.format(oS_TimeStamp) + "; " + n + "; " + string;
        }
        try {
            this.out.write(string2.getBytes());
            this.out.write(10);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }
}

