/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.header2Reflection;

import java.io.File;
import java.text.ParseException;
import java.util.LinkedList;
import java.util.List;
import org.vishia.mainCmd.MainCmd_ifc;
import org.vishia.util.FileSystem;
import org.vishia.zbnf.ZbnfJavaOutput;
import org.vishia.zbnf.ZbnfParseResultItem;
import org.vishia.zbnf.ZbnfParser;

public class CheaderParser {
    public static final String sVersion = "2014-10-25";
    private final MainCmd_ifc console;

    public CheaderParser(MainCmd_ifc mainCmd_ifc) {
        this.console = mainCmd_ifc;
    }

    public ZbnfResultData execute(Args args) {
        ZbnfResultData zbnfResultData = this.parseAndStoreInput(args);
        return zbnfResultData;
    }

    private ZbnfResultData parseAndStoreInput(Args args) {
        ZbnfResultData zbnfResultData = new ZbnfResultData();
        ZbnfParser zbnfParser = new ZbnfParser(this.console);
        File file = new File(args.sFileZbnf);
        if (!file.exists()) {
            throw new IllegalArgumentException("CheaderParser - syntax file not found; " + file.getAbsolutePath());
        }
        try {
            zbnfParser.setSyntax(FileSystem.readFile(file));
        }
        catch (ParseException parseException) {
            String string = "CheaderParser - ERROR in syntax prescript; " + parseException.getMessage();
            throw new IllegalArgumentException(string);
        }
        for (SrcFile srcFile : args.srcFiles) {
            Object object;
            System.out.println(srcFile.name);
            File file2 = new File(srcFile.path);
            boolean bl = false;
            try {
                bl = zbnfParser.parseFile(file2);
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("CheaderParser - file ERROR; " + file2.getAbsolutePath());
            }
            ZbnfParseResultItem zbnfParseResultItem = zbnfParser.getFirstParseResult();
            if (!bl) {
                object = zbnfParser.getSyntaxErrorReport();
                System.err.println("ERROR Parsing file: " + file2.getAbsolutePath() + "\n" + (String)object);
                continue;
            }
            object = new ZbnfResultFile(srcFile.name, srcFile.path);
            try {
                ZbnfJavaOutput.setOutput(object, zbnfParseResultItem, this.console);
            }
            catch (Exception exception) {
                throw new IllegalStateException("CheaderParser - internal ERROR storing parse result; " + exception.getMessage());
            }
            zbnfResultData.files.add((ZbnfResultFile)object);
        }
        return zbnfResultData;
    }

    public static class RefCastingValue
    extends Value {
        public Type type;

        RefCastingValue() {
            super('c');
        }
    }

    public static class Variable
    extends ValueEntry {
        public boolean preDecrement;
        public boolean preIncrement;
        public boolean postDecrement;
        public boolean postIncrement;
        public String simpleVariable;
        public ExternObject externObject;
        public Value index;

        public Variable() {
            super('V');
        }
    }

    public static class ExternObject {
        public List<Value> entries;

        public void set_association(String string) {
            Value value = new Value();
            value.data = string;
            this.addEntry(value);
        }

        private void addEntry(Value value) {
            if (this.entries == null) {
                this.entries = new LinkedList<Value>();
            }
            this.entries.add(value);
        }
    }

    public static class Number
    extends ValueEntry {
        public double number;
        public String floatModifier;
        public String longModifier;

        Number(char c) {
            super(c);
        }

        public Number() {
            super('n');
        }
    }

    public static class ValueEntry {
        public char whatisit;
        public String data;
        public String unaryOperator;

        public ValueEntry(char c, String string) {
            this.whatisit = c;
            this.data = string;
        }

        public ValueEntry(char c) {
            this.whatisit = c;
        }
    }

    public static class Value
    extends ValueEntry {
        public List<ValueEntry> entries = new LinkedList<ValueEntry>();
        ValueEntry entry1;
        public String unaryOperator;
        public Value value_true;
        public Value value_false;

        Value(char c) {
            super(c);
        }

        public Value() {
            super('v');
        }

        public void set_variable(String string) {
        }

        public Variable new_variable() {
            return new Variable();
        }

        public void add_variable(Variable variable) {
            this.entries.add(variable);
        }

        public Value new_value() {
            Value value = new Value();
            value.unaryOperator = this.unaryOperator;
            this.unaryOperator = null;
            return value;
        }

        public void add_value(Value value) {
            this.entries.add(value);
        }

        public Assignment new_assignment() {
            Assignment assignment = new Assignment();
            assignment.unaryOperator = this.unaryOperator;
            this.unaryOperator = null;
            return assignment;
        }

        public void add_assignment(Assignment assignment) {
            this.entries.add(assignment);
        }

        public RefCastingValue new_refCastingValue() {
            return new RefCastingValue();
        }

        public void add_refCastingValue(RefCastingValue refCastingValue) {
            this.entries.add(refCastingValue);
        }

        public Number set_number(int n) {
            Number number = new Number('f');
            this.entry1 = number;
            this.entries.add(this.entry1);
            return number;
        }

        public Number set_floatNumber(int n) {
            Number number = new Number('f');
            this.entry1 = number;
            this.entries.add(this.entry1);
            return number;
        }

        public void set_floatModifier(String string) {
            ((Number)this.entry1).floatModifier = string;
        }

        public void set_longModifier(String string) {
            ((Number)this.entry1).floatModifier = string;
        }

        public Number new_number() {
            Number number = new Number('f');
            this.entry1 = number;
            return number;
        }

        public void add_number(Number number) {
            this.entries.add(number);
        }

        public MethodCall new_methodCall() {
            return new MethodCall();
        }

        public void add_methodCall(MethodCall methodCall) {
            this.entries.add(methodCall);
        }

        public void set_binaryOperator(String string) {
            this.entries.add(new ValueEntry('b', string));
        }
    }

    public static class MethodCall
    extends Statement {
        public String methodname;
        List<Value> args;

        public MethodCall() {
            super('m');
        }

        public Value new_actualParameter() {
            return new Value();
        }

        public void add_actualParameter(Value value) {
            if (this.args == null) {
                this.args = new LinkedList<Value>();
            }
            this.args.add(value);
        }

        public MethodCall new_simpleMethodCall() {
            return this;
        }

        public void add_simpleMethodCall(MethodCall methodCall) {
        }
    }

    public static class ConditionalStatement
    extends Statement {
        public Value condition;
        public StatementBlock statementBlock;

        ConditionalStatement(char c) {
            super(c);
        }

        public StatementBlock new_statement() {
            this.statementBlock = new StatementBlock();
            return this.statementBlock;
        }

        public void set_statement(StatementBlock statementBlock) {
        }
    }

    public static class VariableDefinition
    extends Statement {
        public Description description;
        public Type type;
        public String name;
        public int bitField;
        public Arraysize arraysize;
        public Value value;

        public VariableDefinition() {
            super('d');
        }
    }

    public static class Assignment
    extends Statement {
        public Variable variable;
        public String assignOperator;
        public Value value;

        public Assignment() {
            super('=');
        }
    }

    public static class Statement
    extends ValueEntry {
        public Statement(char c) {
            super(c);
        }
    }

    public static class StatementBlock
    extends Statement {
        List<Statement> statements = new LinkedList<Statement>();

        public StatementBlock() {
            super('{');
        }

        public StatementBlock new_statement() {
            return this;
        }

        public void add_statement(StatementBlock statementBlock) {
        }

        public StatementBlock new_statementBlock() {
            return new StatementBlock();
        }

        public void add_statementBlock(StatementBlock statementBlock) {
            this.statements.add(statementBlock);
        }

        public MethodCall new_simpleMethodCall() {
            return new MethodCall();
        }

        public void add_simpleMethodCall(MethodCall methodCall) {
            this.statements.add(methodCall);
        }

        public Assignment new_assignment() {
            return new Assignment();
        }

        public void add_assignment(Assignment assignment) {
            this.statements.add(assignment);
        }

        public VariableDefinition new_variabledefinition() {
            return new VariableDefinition();
        }

        public void add_variabledefinition(VariableDefinition variableDefinition) {
            this.statements.add(variableDefinition);
        }

        public ConditionalStatement new_if_statement() {
            return new ConditionalStatement('i');
        }

        public void add_if_statement(ConditionalStatement conditionalStatement) {
            this.statements.add(conditionalStatement);
        }

        public Value new_returnAssignment() {
            Assignment assignment = new Assignment();
            assignment.assignOperator = "return";
            this.statements.add(assignment);
            assignment.value = new Value();
            return assignment.value;
        }

        public void add_returnAssignment(Value value) {
        }
    }

    public static class MethodDef
    extends HeaderBlockEntry {
        public Type type;
        public String name;
        public boolean inline;
        public List<AttributeOrTypedef> args;
        StatementBlock body;

        MethodDef() {
            super("method");
        }

        public AttributeOrTypedef new_typedParameter() {
            return new AttributeOrTypedef();
        }

        public void add_typedParameter(AttributeOrTypedef attributeOrTypedef) {
            if (this.args == null) {
                this.args = new LinkedList<AttributeOrTypedef>();
            }
            this.args.add(attributeOrTypedef);
        }

        public StatementBlock new_statementBlock() {
            this.body = new StatementBlock();
            return this.body;
        }

        public void add_statementBlock(StatementBlock statementBlock) {
        }
    }

    public static class Arraysize {
        public int value;
        public String symbolValue;
    }

    public static class Type {
        public String name;
        public String forward;
        public boolean pointer;
        public boolean pointer2;
        public boolean constPointer;
        public boolean constPointer2;
    }

    public static class AttributeOrTypedef
    extends HeaderBlockEntry {
        public Description description;
        public Type type;
        public String name;
        public int bitField;
        public Arraysize arraysize;

        AttributeOrTypedef(String string) {
            super(string);
        }

        AttributeOrTypedef() {
            super("Attribute");
        }
    }

    public static class StructContent
    extends HeaderBlock {
        StructContent(String string) {
            super(string);
        }
    }

    public static class StructDefinition
    extends StructContent {
        public String tagname;
        public String name;
        public Description description;

        StructDefinition() {
            super("structDefinition");
        }
    }

    public static class StructDecl
    extends HeaderBlockEntry {
        public String name;

        StructDecl() {
            super("structDecl");
        }
    }

    public static class DefineParameter {
        public String name;
    }

    public static class DefineDefinition
    extends HeaderBlockEntry {
        public String name;
        public Description description;
        public String valueDef = "";
        public int intvalue;
        public int hexvalue;
        public int fractPart;
        public List<String> args;

        DefineDefinition() {
            super("#define");
        }

        public void set_value(String string) {
            this.valueDef = this.valueDef + string;
        }

        public DefineParameter new_parameter() {
            return new DefineParameter();
        }

        public void add_parameter(DefineParameter defineParameter) {
            if (this.args == null) {
                this.args = new LinkedList<String>();
            }
            this.args.add(defineParameter.name);
        }
    }

    public static class Define
    extends HeaderBlockEntry {
        public String name;

        Define() {
            super("xxdefine");
        }
    }

    public static class ConditionBlock
    extends HeaderBlock {
        public String conditionDef;
        public boolean not;
        public List<OrCondition> orConditions;
        public String elseConditionBlock;
        public HeaderBlock elseBlock;

        ConditionBlock() {
            super("#ifdef");
        }

        public void conditionDef(String string) {
            this.not = false;
            this.conditionDef = string;
        }

        public void set_conditionDefNot(String string) {
            this.not = true;
            this.conditionDef = string;
        }

        public OrCondition new_OrCondition() {
            return new OrCondition();
        }

        public void add_OrCondition(OrCondition orCondition) {
            if (this.orConditions == null) {
                this.orConditions = new LinkedList<OrCondition>();
            }
            this.orConditions.add(orCondition);
        }

        public HeaderBlock new_elseConditionBlock() {
            return new HeaderBlock();
        }

        public void add_elseConditionBlock(HeaderBlock headerBlock) {
            this.elseBlock = headerBlock;
        }

        public static class OrCondition
        extends ConditionDef {
            public String conditionDef;
            public boolean not;
            public List<ConditionDef> andConditions;

            public ConditionDef new_AndCondition() {
                return new ConditionDef();
            }

            public void add_AndCondition(ConditionDef conditionDef) {
                if (this.andConditions == null) {
                    this.andConditions = new LinkedList<ConditionDef>();
                }
                this.andConditions.add(conditionDef);
            }
        }
    }

    public static class ConditionDef {
        public String conditionDef;
        public boolean not;
        public Value conditionValue;

        public Value new_condition() {
            return new Value();
        }

        public void add_condition(Value value) {
            this.conditionValue = value;
        }
    }

    public static class ParamDescription {
        public String name;
        public String text;
    }

    public static class Description
    extends HeaderBlockEntry {
        public String text;
        public String simulinkTag;
        public ParamDescription returnDescription;
        public List<ParamDescription> paramDescriptions;
        public List<ParamDescription> auxDescriptions;

        Description(String string) {
            super(string);
        }

        public Description() {
            super("description");
        }

        public final ParamDescription new_paramDescription() {
            return new ParamDescription();
        }

        public final void add_paramDescription(ParamDescription paramDescription) {
            if (this.paramDescriptions == null) {
                this.paramDescriptions = new LinkedList<ParamDescription>();
            }
            this.paramDescriptions.add(paramDescription);
        }

        public final ParamDescription new_returnDescription() {
            return new ParamDescription();
        }

        public final void add_returnDescription(ParamDescription paramDescription) {
            paramDescription.name = "return";
            this.returnDescription = paramDescription;
        }

        public final ParamDescription new_auxDescription() {
            return new ParamDescription();
        }

        public final void add_auxDescription(ParamDescription paramDescription) {
            if (this.auxDescriptions == null) {
                this.auxDescriptions = new LinkedList<ParamDescription>();
            }
            this.auxDescriptions.add(paramDescription);
        }

        public final void set_auxDescription(String string) {
        }
    }

    public static class HeaderBlockEntry {
        public String whatisit;
        public Description description;
        public List<Description> implementDescriptions;

        HeaderBlockEntry(String string) {
            this.whatisit = string;
        }

        public Description new_implementDescription() {
            return new Description("implementDescription");
        }

        public void add_implementDescription(Description description) {
            if (this.implementDescriptions == null) {
                this.implementDescriptions = new LinkedList<Description>();
            }
            this.implementDescriptions.add(description);
        }
    }

    public static class HeaderBlock
    extends HeaderBlockEntry {
        List<HeaderBlockEntry> entries = new LinkedList<HeaderBlockEntry>();

        HeaderBlock() {
            super("{}");
        }

        HeaderBlock(String string) {
            super(string);
        }

        public Define new_undefDefinition() {
            return new Define();
        }

        public void add_undefDefinition(Define define) {
            this.entries.add(define);
        }

        public ConditionBlock new_conditionBlock() {
            return new ConditionBlock();
        }

        public void add_conditionBlock(ConditionBlock conditionBlock) {
            this.entries.add(conditionBlock);
        }

        public DefineDefinition new_defineDefinition() {
            return new DefineDefinition();
        }

        public void add_defineDefinition(DefineDefinition defineDefinition) {
            this.entries.add(defineDefinition);
        }

        public StructDecl new_structDecl() {
            return new StructDecl();
        }

        public void add_structDecl(StructDecl structDecl) {
            this.entries.add(structDecl);
        }

        public StructDefinition new_structDefinition() {
            return new StructDefinition();
        }

        public void add_structDefinition(StructDefinition structDefinition) {
            this.entries.add(structDefinition);
        }

        public AttributeOrTypedef new_typedef() {
            return new AttributeOrTypedef("typedef");
        }

        public void add_typedef(AttributeOrTypedef attributeOrTypedef) {
            this.entries.add(attributeOrTypedef);
        }

        public AttributeOrTypedef new_attribute() {
            return new AttributeOrTypedef();
        }

        public void add_attribute(AttributeOrTypedef attributeOrTypedef) {
            this.entries.add(attributeOrTypedef);
        }

        public MethodDef new_methodDef() {
            return new MethodDef();
        }

        public void add_methodDef(MethodDef methodDef) {
            this.entries.add(methodDef);
        }

        public MethodDef new_inlineMethod() {
            return new MethodDef();
        }

        public void add_inlineMethod(MethodDef methodDef) {
            methodDef.inline = true;
            this.entries.add(methodDef);
        }

        @Override
        public Description new_implementDescription() {
            return new Description("implementDescription");
        }

        @Override
        public void add_implementDescription(Description description) {
            this.entries.add(description);
        }

        public void set_modifier(String string) {
        }
    }

    public static class ClassC
    extends HeaderBlock {
        public String name;

        public HeaderBlock new_HeaderBlock() {
            return this;
        }

        public void add_HeaderBlock(HeaderBlock headerBlock) {
        }
    }

    public static class IncludeDef {
        public String file;
        public String ext;
        public String path;
        public boolean sysInclude;
    }

    public static class ZbnfResultFile {
        public final String fileName;
        public final String filePath;
        public List<IncludeDef> includeDef = new LinkedList<IncludeDef>();
        public String headerEntry;
        public String headerEntryDef;
        public List<ClassC> listClassC;

        public ZbnfResultFile(String string, String string2) {
            this.fileName = string;
            this.filePath = string2;
        }

        public void XXset_HeaderEntry(String string) {
        }

        public void XXset_HeaderEntryDef(String string) {
        }

        public IncludeDef XXnew_includeDef() {
            return new IncludeDef();
        }

        public void XXadd_includeDef(IncludeDef includeDef) {
        }

        public ClassC new_CLASS_C() {
            ClassC classC = new ClassC();
            return classC;
        }

        public void add_CLASS_C(ClassC classC) {
            if (this.listClassC == null) {
                this.listClassC = new LinkedList<ClassC>();
            }
            this.listClassC.add(classC);
        }

        public ClassC new_outside() {
            ClassC classC = this.new_CLASS_C();
            classC.name = "--outside--";
            return classC;
        }

        public void add_outside(ClassC classC) {
            this.add_CLASS_C(classC);
        }
    }

    public static class ZbnfResultData {
        public List<ZbnfResultFile> files = new LinkedList<ZbnfResultFile>();
    }

    public static class Args {
        List<SrcFile> srcFiles = new LinkedList<SrcFile>();
        String sFileDst;
        String sFileZbnf;

        public void addSrc(String string, String string2) {
            SrcFile srcFile = new SrcFile(string2, string);
            this.srcFiles.add(srcFile);
        }

        public void setZbnfHeader(String string) {
            this.sFileZbnf = string;
        }

        public void setDst(String string) {
            this.sFileDst = string;
        }
    }

    public static class SrcFile {
        public final String name;
        public final String path;

        public SrcFile(CharSequence charSequence, CharSequence charSequence2) {
            this.name = charSequence.toString();
            this.path = charSequence2.toString();
        }
    }
}

