/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.fileRemote;

import java.io.File;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.vishia.fileRemote.FileCluster;
import org.vishia.fileRemote.FileRemote;
import org.vishia.util.TreeNodeBase;

public class FileZip
extends FileRemote {
    private static final long serialVersionUID = 8789821733982259444L;
    final FileRemote theFile;
    final ZipFile zipFile;
    final ZipEntry zipEntry;
    final String sPathZip;
    TreeNodeBase.TreeNode<FileZip> children;

    public FileZip(FileRemote fileRemote) {
        super(fileRemote.itsCluster, fileRemote.device, null, fileRemote.getName(), 0L, 0L, 0L, 0L, 0, null, true);
        this.theFile = fileRemote;
        ZipFile zipFile = null;
        this.children = new TreeNodeBase.TreeNode<FileZip>("/", this);
        try {
            zipFile = new ZipFile(fileRemote);
        }
        catch (Exception exception) {
            zipFile = null;
        }
        this.zipFile = zipFile;
        this.zipEntry = null;
        this.sPathZip = "";
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            FileZip fileZip;
            TreeNodeBase.TreeNode treeNode;
            ZipEntry zipEntry = enumeration.nextElement();
            String string = zipEntry.getName();
            int n = string.lastIndexOf(47);
            if (n < 0) continue;
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1);
            if (string3.length() > 0) {
                treeNode = (TreeNodeBase.TreeNode)this.children.getOrCreateNode(string2, "/");
                fileZip = new FileZip(this.theFile, zipFile, zipEntry);
                treeNode.addNode(string3, fileZip);
                continue;
            }
            n = string2.lastIndexOf(47);
            treeNode = n >= 0 ? (TreeNodeBase.TreeNode)this.children.getOrCreateNode(string2, "/") : this.children;
            fileZip = new FileZip((FileZip)treeNode.data, this.theFile, zipFile, zipEntry);
        }
    }

    public FileZip(FileZip fileZip, FileRemote fileRemote, ZipFile zipFile, ZipEntry zipEntry) {
        super(fileZip.itsCluster, fileZip.device, fileZip, zipEntry.getName(), zipEntry.getSize(), zipEntry.getTime(), 0L, 0L, 0, null, true);
        this.sPathZip = zipEntry.getName();
        this.theFile = fileRemote;
        String string = zipEntry.getName();
        int n = string.length();
        if (string.endsWith("/")) {
            --n;
        }
        int n2 = string.lastIndexOf(47, n - 1);
        String string2 = string.substring(n2 + 1, n);
        this.children = new TreeNodeBase.TreeNode<FileZip>(string2, this);
        fileZip.children.addNode(this.children);
        this.zipFile = zipFile;
        this.zipEntry = zipEntry;
    }

    public FileZip(FileRemote fileRemote, ZipFile zipFile, ZipEntry zipEntry) {
        super(fileRemote.itsCluster, fileRemote.device, null, zipFile.getName() + '/' + zipEntry.getName(), zipEntry.getSize(), zipEntry.getTime(), 0L, 0L, 0, null, true);
        this.sPathZip = zipEntry.getName();
        this.theFile = fileRemote;
        this.children = null;
        this.zipFile = zipFile;
        this.zipEntry = zipEntry;
    }

    public FileZip[] listFiles() {
        int n;
        int n2 = this.children == null ? 0 : (n = this.children.nrofChildren() + (this.children.leafData == null ? 0 : this.children.leafData.size()));
        if (n > 0) {
            int n3 = -1;
            FileZip[] fileZipArray = new FileZip[n];
            if (this.children.hasChildren()) {
                Iterator<Object> iterator = this.children.iterator().iterator();
                while (iterator.hasNext()) {
                    Object object = (TreeNodeBase.TreeNode)iterator.next();
                    fileZipArray[++n3] = (FileZip)((TreeNodeBase.TreeNode)object).data;
                }
            }
            if (this.children.leafData != null) {
                for (Object object : this.children.leafData) {
                    fileZipArray[++n3] = object;
                }
            }
            return fileZipArray;
        }
        return null;
    }

    @Override
    public boolean isDirectory() {
        return this.children != null && this.children.hasChildren();
    }

    @Override
    public boolean exists() {
        return true;
    }

    @Override
    public String getName() {
        if (this.zipEntry != null) {
            return this.zipEntry.getName();
        }
        return this.theFile.getName();
    }

    @Override
    public FileRemote getParentFile() {
        FileRemote fileRemote = this.children != null && this.children.parent() != null ? (FileRemote)((TreeNodeBase.TreeNode)this.children.parent()).data : this.theFile;
        return fileRemote;
    }

    @Override
    public String getParent() {
        FileRemote fileRemote = this.getParentFile();
        return ((File)fileRemote).getAbsolutePath();
    }

    @Override
    public String toString() {
        return this.sPathZip;
    }

    public static void main(String[] stringArray) {
        FileCluster fileCluster = new FileCluster();
        FileRemote fileRemote = fileCluster.getDir("/home/hartmut/vishia/Java/srcJava_Zbnf.zip");
        FileZip fileZip = new FileZip(fileRemote);
        fileZip.listFiles();
    }
}

