/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.fileRemote;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.vishia.event.EventCmdtypeWithBackEvent;
import org.vishia.fileRemote.FileRemote;
import org.vishia.fileRemote.FileRemoteAccessor;
import org.vishia.fileRemote.FileRemoteCallback;
import org.vishia.fileRemote.FileRemoteProgressTimeOrder;
import org.vishia.util.Assert;
import org.vishia.util.TreeNodeBase;
import org.vishia.util.UnexpectedException;

public class FileAccessZip
extends FileRemoteAccessor {
    public static final int version = 20120721;
    private static FileAccessZip instance;

    public static FileAccessZip getInstance() {
        if (instance == null) {
            instance = new FileAccessZip();
        }
        return instance;
    }

    public static FileRemote examineZipFile(FileRemote fileRemote) {
        FileZipData fileZipData = new FileZipData();
        FileAccessZip fileAccessZip = FileAccessZip.getInstance();
        int n = 19;
        String string = fileRemote.getAbsolutePath();
        FileRemote fileRemote2 = new FileRemote(fileRemote.itsCluster, fileAccessZip, fileRemote, "!Zip", fileRemote.length(), fileRemote.lastModified(), 0L, 0L, n, fileZipData, true);
        fileZipData.childrenZip = new TreeNodeBase.TreeNode<FileRemote>("/", fileRemote2);
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(fileRemote);
        }
        catch (Exception exception) {
            zipFile = null;
        }
        fileZipData.theFile = fileRemote;
        fileZipData.zipEntry = null;
        if (zipFile != null) {
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                TreeNodeBase.TreeNode treeNode;
                String string2;
                String string3;
                ZipEntry zipEntry = enumeration.nextElement();
                String string4 = zipEntry.getName();
                int n2 = string4.lastIndexOf(47);
                int n3 = 131075;
                if (n2 >= 0) {
                    string3 = string4.substring(0, n2);
                    string2 = string4.substring(n2 + 1);
                    if (string2.length() == 0) {
                        n3 |= 0x10;
                        n2 = string3.lastIndexOf(47);
                        string2 = string3.substring(n2 + 1);
                        string3 = n2 >= 0 ? string3.substring(0, n2) : "";
                    } else {
                        n3 |= 0x20;
                    }
                } else {
                    n3 |= 0x20;
                    string2 = string4;
                    string3 = null;
                }
                if (n2 >= 0) {
                    treeNode = (TreeNodeBase.TreeNode)fileZipData.childrenZip.getNode(string3, "/");
                    if (treeNode == null) {
                        treeNode = (TreeNodeBase.TreeNode)fileZipData.childrenZip.getOrCreateNode(string3, "/");
                    }
                } else {
                    treeNode = fileZipData.childrenZip;
                }
                FileZipData fileZipData2 = new FileZipData();
                fileZipData2.theFile = fileRemote;
                fileZipData2.zipEntry = zipEntry;
                String string5 = string + string3;
                long l = zipEntry.getSize();
                long l2 = zipEntry.getTime();
                if (treeNode == null) {
                    Assert.stop();
                    continue;
                }
                FileRemote fileRemote3 = (FileRemote)treeNode.data;
                FileRemote fileRemote4 = new FileRemote(fileRemote3.itsCluster, fileAccessZip, fileRemote3, string2, l, l2, 0L, 0L, n3, fileZipData2, true);
                if ((n3 & 0x10) != 0) {
                    fileZipData2.childrenZip = new TreeNodeBase.TreeNode<FileRemote>(string2, fileRemote4);
                    treeNode.addNode(fileZipData2.childrenZip);
                    continue;
                }
                treeNode.addNode(string2, fileRemote4);
            }
        } else {
            System.err.println("FileAccessZip - Problem reading zipfile; " + fileRemote.getAbsolutePath());
        }
        try {
            if (zipFile != null) {
                zipFile.close();
            }
        }
        catch (IOException iOException) {
            throw new UnexpectedException(iOException);
        }
        return fileRemote2;
    }

    @Override
    public void close() throws IOException {
    }

    public void close(FileRemote fileRemote) throws IOException {
        FileZipData fileZipData = (FileZipData)fileRemote.oFile;
        if (fileZipData != null) {
            fileZipData.zipFile.close();
        }
    }

    @Override
    public void refreshFileProperties(FileRemote fileRemote, FileRemote.CallbackEvent callbackEvent) {
        if (callbackEvent != null) {
            callbackEvent.sendEvent(FileRemote.CallbackCmd.done);
        }
    }

    @Override
    public void refreshFilePropertiesAndChildren(FileRemote fileRemote, FileRemote.CallbackEvent callbackEvent) {
        int n;
        FileZipData fileZipData = (FileZipData)fileRemote.oFile;
        int n2 = fileZipData == null ? 0 : (fileZipData.childrenZip == null ? 0 : (n = (fileZipData.childrenZip.hasChildren() ? 0 : fileZipData.childrenZip.nrofChildren()) + (fileZipData.childrenZip.leafData == null ? 0 : fileZipData.childrenZip.leafData.size())));
        if (n > 0) {
            int n3 = -1;
            if (fileZipData.childrenZip.hasChildren()) {
                Iterator<Object> iterator = fileZipData.childrenZip.iterator().iterator();
                while (iterator.hasNext()) {
                    Object object = (TreeNodeBase.TreeNode)iterator.next();
                    fileRemote.putNewChild((FileRemote)((TreeNodeBase.TreeNode)object).data);
                }
            }
            if (fileZipData.childrenZip.leafData != null) {
                for (Object object : fileZipData.childrenZip.leafData) {
                    fileRemote.putNewChild((FileRemote)object);
                }
            }
        }
        if (callbackEvent != null) {
            callbackEvent.sendEvent(FileRemote.CallbackCmd.done);
        }
    }

    @Override
    public List<File> getChildren(FileRemote fileRemote, FileFilter fileFilter) {
        int n;
        FileZipData fileZipData = (FileZipData)fileRemote.oFile;
        ArrayList<File> arrayList = new ArrayList<File>();
        int n2 = fileZipData == null ? 0 : (fileZipData.childrenZip == null ? 0 : (n = (fileZipData.childrenZip.hasChildren() ? 0 : fileZipData.childrenZip.nrofChildren()) + (fileZipData.childrenZip.leafData == null ? 0 : fileZipData.childrenZip.leafData.size())));
        if (n > 0) {
            int n3 = -1;
            if (fileZipData.childrenZip.hasChildren()) {
                Iterator<Object> iterator = fileZipData.childrenZip.iterator().iterator();
                while (iterator.hasNext()) {
                    Object object = (TreeNodeBase.TreeNode)iterator.next();
                    if (fileFilter != null && !fileFilter.accept((File)((TreeNodeBase.TreeNode)object).data)) continue;
                    arrayList.add((File)((TreeNodeBase.TreeNode)object).data);
                }
            }
            if (fileZipData.childrenZip.leafData != null) {
                for (Object object : fileZipData.childrenZip.leafData) {
                    if (fileFilter != null && !fileFilter.accept((File)object)) continue;
                    arrayList.add((File)object);
                }
            }
        }
        return arrayList;
    }

    @Override
    public boolean createNewFile(FileRemote fileRemote, FileRemote.CallbackEvent callbackEvent) throws IOException {
        if (callbackEvent != null) {
            callbackEvent.sendEvent(FileRemote.CallbackCmd.errorDelete);
        }
        return false;
    }

    @Override
    public boolean mkdir(FileRemote fileRemote, boolean bl, FileRemote.CallbackEvent callbackEvent) {
        return false;
    }

    @Override
    public boolean delete(FileRemote fileRemote, FileRemote.CallbackEvent callbackEvent) {
        if (callbackEvent != null) {
            callbackEvent.sendEvent(FileRemote.CallbackCmd.errorDelete);
        }
        return false;
    }

    @Override
    public void copyChecked(FileRemote fileRemote, String string, String string2, int n, FileRemoteCallback fileRemoteCallback, FileRemoteProgressTimeOrder fileRemoteProgressTimeOrder) {
    }

    @Override
    public ReadableByteChannel openRead(FileRemote fileRemote, long l) {
        return null;
    }

    @Override
    public InputStream openInputStream(FileRemote fileRemote, long l) {
        FileZipData fileZipData = (FileZipData)fileRemote.oFile;
        try {
            ZipFile zipFile = new ZipFile(fileZipData.theFile);
            InputStream inputStream = zipFile.getInputStream(fileZipData.zipEntry);
            FileZipInputStream fileZipInputStream = new FileZipInputStream(inputStream, zipFile);
            return fileZipInputStream;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public WritableByteChannel openWrite(FileRemote fileRemote, long l) {
        return null;
    }

    @Override
    public FileRemote.CmdEvent prepareCmdEvent(int n, EventCmdtypeWithBackEvent<?, FileRemote.CmdEvent> eventCmdtypeWithBackEvent) {
        return null;
    }

    @Override
    public boolean isLocalFileSystem() {
        return true;
    }

    @Override
    public CharSequence getStateInfo() {
        return "";
    }

    @Override
    public boolean setLastModified(FileRemote fileRemote, long l) {
        return false;
    }

    @Override
    public void walkFileTree(FileRemote fileRemote, boolean bl, boolean bl2, boolean bl3, String string, int n, int n2, FileRemoteCallback fileRemoteCallback) {
    }

    static class FileZipInputStream
    extends InputStream {
        final InputStream s;
        final ZipFile zipFile;

        FileZipInputStream(InputStream inputStream, ZipFile zipFile) {
            this.s = inputStream;
            this.zipFile = zipFile;
        }

        @Override
        public int read() throws IOException {
            return this.s.read();
        }

        @Override
        public int read(byte[] byArray) throws IOException {
            return this.s.read(byArray);
        }

        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            return this.s.read(byArray, n, n2);
        }

        @Override
        public long skip(long l) throws IOException {
            return this.s.skip(l);
        }

        @Override
        public int available() throws IOException {
            return this.s.available();
        }

        @Override
        public void close() throws IOException {
            this.s.close();
            this.zipFile.close();
        }

        @Override
        public synchronized void mark(int n) {
            this.s.mark(n);
        }

        @Override
        public synchronized void reset() throws IOException {
            this.s.reset();
        }

        @Override
        public boolean markSupported() {
            return this.s.markSupported();
        }
    }

    static class FileZipData {
        File theFile;
        ZipFile zipFile;
        ZipEntry zipEntry;
        TreeNodeBase.TreeNode<FileRemote> childrenZip;

        FileZipData() {
        }
    }
}

