/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.fileLocalAccessor;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.EventObject;
import java.util.Map;
import java.util.Queue;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.vishia.event.EventCmdtypeWithBackEvent;
import org.vishia.event.EventConsumer;
import org.vishia.event.EventSource;
import org.vishia.event.EventTimerThread;
import org.vishia.event.EventTimerThread_ifc;
import org.vishia.fileRemote.FileRemote;
import org.vishia.fileRemote.FileRemoteCallback;
import org.vishia.fileRemote.FileRemoteCopyOrder;
import org.vishia.fileRemote.FileRemoteProgressTimeOrder;
import org.vishia.states.StateComposite;
import org.vishia.states.StateMachine;
import org.vishia.states.StateSimple;
import org.vishia.util.Assert;
import org.vishia.util.Debugutil;
import org.vishia.util.FileSystem;
import org.vishia.util.StringFunctions;

public class FileLocalAccessorCopyStateM
implements EventConsumer {
    public static final String version = "2015-01-04";
    EventSource evSrc = new EventSource("FileRemoteCopy"){

        @Override
        public void notifyDequeued() {
        }

        @Override
        public void notifyConsumed(int n) {
        }

        @Override
        public void notifyRelinquished(int n) {
        }

        @Override
        public void notifyShouldSentButInUse() {
            throw new RuntimeException("event usage error");
        }

        @Override
        public void notifyShouldOccupyButInUse() {
            throw new RuntimeException("event usage error");
        }
    };
    static final int mAsk = 65536;
    static final int mNextFile = 131072;
    static final int mCopyContent = 262144;
    EventTimerThread stateThread = new EventTimerThread("FileRemoteCopy");
    final EventInternal evCpy;
    private final EventInternal evStart;
    int modeCopyOper;
    FileRemote.Cmd cmdFile;
    boolean bAbortDirectory;
    boolean bOverwrfile;
    long timestart;
    long timeActionMax = 300L;
    FileInputStream in = null;
    FileOutputStream out = null;
    int zBytesFileCopied;
    private long zBytesFile;
    private int zFilesCheck;
    private int zFilesCopied;
    private long zBytesAllCheck;
    private long zBytesAllCopied;
    byte[] buffer = new byte[0x100000];
    boolean bCopyFinished;
    private long checkOrderCounter;
    private final Map<Long, FileRemoteCopyOrder> checkedOrders = new TreeMap<Long, FileRemoteCopyOrder>();
    private final ConcurrentLinkedQueue<CopyOrder> copyOrders = new ConcurrentLinkedQueue();
    private CopyOrder copyOrder;
    final ConcurrentLinkedQueue<FileRemote.CmdEvent> storedCopyEvents = new ConcurrentLinkedQueue();
    DataSetCopy1Recurs actData;
    FileRemote fileSrc;
    boolean bOnlyOneFile;
    FileRemote.CallbackEvent evBackInfo;
    public final States statesCopy = new States();

    public FileLocalAccessorCopyStateM() {
        this.evCpy = new EventInternal((EventConsumer)this.statesCopy, (EventTimerThread_ifc)this.stateThread);
        this.evStart = new EventInternal((EventConsumer)this.statesCopy, (EventTimerThread_ifc)this.stateThread);
    }

    public void copyChecked(FileRemote fileRemote, String string, String string2, int n, FileRemoteCallback fileRemoteCallback, FileRemoteProgressTimeOrder fileRemoteProgressTimeOrder) {
        CopyOrder copyOrder = new CopyOrder();
        copyOrder.fileSrc = fileRemote;
        copyOrder.callbackUser = fileRemoteCallback;
        copyOrder.mode = n;
        copyOrder.nameModification = string2;
        copyOrder.pathDst = string;
        copyOrder.timeOrderProgress = fileRemoteProgressTimeOrder;
        this.copyOrders.add(copyOrder);
        this.evCpy.sendInternalEvent(CmdIntern.start, false);
    }

    public String getStateInfo() {
        if (this.stateThread != null) {
            StringBuilder stringBuilder = new StringBuilder();
            if (this.statesCopy.toogleDebugState()) {
                stringBuilder.append(" Log trans;");
            }
            this.statesCopy.infoAppend(stringBuilder);
            return stringBuilder.toString();
        }
        return this.statesCopy.toString();
    }

    @Override
    public int processEvent(EventObject eventObject) {
        return this.statesCopy.processEvent(eventObject);
    }

    void sendEventAsk(FileRemote fileRemote, FileRemote.CallbackCmd callbackCmd) {
        if (this.evBackInfo != null) {
            if (0 != this.evBackInfo.occupyRecall(1000, this.evSrc, true)) {
                String string = fileRemote.getAbsolutePath();
                if (string.length() > this.evBackInfo.fileName.length - 1) {
                    string = "..." + string.substring(this.evBackInfo.fileName.length - 4);
                }
                StringFunctions.copyToBuffer(string, this.evBackInfo.fileName);
                this.evBackInfo.sendEvent(callbackCmd);
            } else {
                Assert.checkMsg(false, null);
            }
        } else if (this.copyOrder.timeOrderProgress != null) {
            this.copyOrder.timeOrderProgress.currFile = fileRemote;
            this.copyOrder.timeOrderProgress.requAnswer(callbackCmd, this.statesCopy);
        } else assert (false);
    }

    int execCheckSubdir() {
        int n = 0;
        if (this.actData.src != null && this.evBackInfo != null && this.evBackInfo.occupyRecall(this.evSrc, false)) {
            Object object = this.actData.src.getAbsolutePath();
            if (((String)object).length() > this.evBackInfo.fileName.length - 1) {
                object = "..." + ((String)object).substring(this.evBackInfo.fileName.length - 4);
            }
            StringFunctions.copyToBuffer((String)object, this.evBackInfo.fileName);
            this.evBackInfo.sendEvent(FileRemote.CallbackCmd.copyDir);
            if (this.cmdFile == FileRemote.Cmd.copyChecked || this.cmdFile == FileRemote.Cmd.moveChecked) {
                this.actData.dst.mkdirs();
            }
        } else if (this.actData.src != null && this.copyOrder.timeOrderProgress != null) {
            this.copyOrder.timeOrderProgress.currFile = this.actData.src;
            this.copyOrder.timeOrderProgress.show(FileRemote.CallbackCmd.copyDir, this.statesCopy);
            if (this.cmdFile == FileRemote.Cmd.copyChecked || this.cmdFile == FileRemote.Cmd.moveChecked) {
                this.actData.dst.mkdirs();
            }
        }
        if (this.actData.src.children() != null) {
            for (Map.Entry entry : this.actData.src.children().entrySet()) {
                FileRemote fileRemote = (FileRemote)entry.getValue();
                if (!fileRemote.exists() || !fileRemote.isMarked(3)) continue;
                String string = fileRemote.getName();
                fileRemote.resetMarked(1);
                FileRemote fileRemote2 = this.actData.dst == null ? null : this.actData.dst.child(string);
                this.actData.addNewEntry(fileRemote, fileRemote2);
            }
        }
        if (this.actData.listChildren == null || this.actData.listChildren.size() == 0) {
            this.evCpy.sendInternalEvent(CmdIntern.emptyDir, true);
        } else {
            this.actData = this.actData.listChildren.poll();
            this.evCpy.sendInternalEvent(CmdIntern.subDir, true);
        }
        return n;
    }

    public void execMove(FileRemote.CmdEvent cmdEvent) {
        FileRemote.CallbackCmd callbackCmd;
        this.timestart = System.currentTimeMillis();
        FileRemote.CallbackEvent callbackEvent = cmdEvent.getOpponent();
        boolean bl = false;
        if (cmdEvent.namesSrc != null && cmdEvent.namesSrc.length() > 0) {
            FileRemote fileRemote;
            String string;
            FileRemote fileRemote2;
            String[] stringArray;
            String[] stringArray2 = stringArray = cmdEvent.namesSrc.split(":");
            int n = stringArray2.length;
            for (int i = 0; i < n && (bl = (fileRemote2 = cmdEvent.filesrc.child((string = stringArray2[i]).trim())).renameTo(fileRemote = cmdEvent.filedst.child(string.trim()))); ++i) {
            }
        } else {
            FileRemote fileRemote = cmdEvent.filedst.exists() ? (cmdEvent.filedst.isDirectory() ? cmdEvent.filedst.child(cmdEvent.filesrc.getName()) : null) : cmdEvent.filedst;
            if (fileRemote == null) {
                callbackCmd = FileRemote.CallbackCmd.error;
                System.err.println("FileAccessorLocalJava7 - forbidden move file;" + cmdEvent.filesrc + "; to " + cmdEvent.filedst + "; success=" + (Object)((Object)callbackCmd));
            } else {
                bl = cmdEvent.filesrc.renameTo(fileRemote);
            }
        }
        if (bl) {
            callbackCmd = FileRemote.CallbackCmd.done;
            System.out.println("FileAccessorLocalJava7 - move file;" + cmdEvent.filesrc + "; to " + cmdEvent.filedst + "; success=" + (Object)((Object)callbackCmd));
        } else {
            callbackCmd = FileRemote.CallbackCmd.error;
            System.err.println("FileAccessorLocalJava7 - error move file;" + cmdEvent.filesrc + "; to " + cmdEvent.filedst + "; success=" + (Object)((Object)callbackCmd));
        }
        callbackEvent.occupy(this.evSrc, true);
        callbackEvent.sendEvent(callbackCmd);
    }

    int startCopyFile() {
        int n = 0;
        this.bCopyFinished = false;
        if (this.actData.dst.exists()) {
            if (this.bOverwrfile) {
                this.bOverwrfile = false;
                boolean bl = true;
                if (!this.actData.dst.canWrite()) {
                    bl = this.actData.dst.setWritable(true);
                }
                if (!bl) {
                    this.sendEventAsk(this.actData.dst, FileRemote.CallbackCmd.askDstNotAbletoOverwr);
                    n |= 0x10000;
                }
            } else if ((this.modeCopyOper & 0xF0) == 64) {
                n |= 0x20000;
            } else if (this.actData.dst.canWrite()) {
                long l = this.actData.src.lastModified();
                long l2 = this.actData.dst.lastModified();
                switch (this.modeCopyOper & 0xF0) {
                    case 0: {
                        this.sendEventAsk(this.actData.dst, FileRemote.CallbackCmd.askDstOverwr);
                        n |= 0x10000;
                        break;
                    }
                    case 16: {
                        if (l - l2 >= 0L) break;
                        n |= 0x20000;
                        break;
                    }
                    case 32: {
                        if (l - l2 <= 0L) break;
                        n |= 0x20000;
                    }
                }
            } else {
                switch (this.modeCopyOper & 0xF) {
                    case 0: {
                        this.sendEventAsk(this.actData.dst, FileRemote.CallbackCmd.askDstReadonly);
                        n |= 0x10000;
                        break;
                    }
                    case 1: {
                        n |= 0x20000;
                        break;
                    }
                    case 3: {
                        boolean bl = this.actData.dst.setWritable(true);
                        if (bl) break;
                        this.sendEventAsk(this.actData.dst, FileRemote.CallbackCmd.askDstNotAbletoOverwr);
                        n |= 0x10000;
                    }
                }
            }
        }
        if ((n & 0x10000) == 0) {
            this.zBytesFile = this.actData.src.length();
            this.zBytesFileCopied = 0;
            try {
                FileSystem.mkDirPath(this.actData.dst);
                this.out = new FileOutputStream(this.actData.dst);
            }
            catch (IOException iOException) {
                this.sendEventAsk(this.actData.dst, FileRemote.CallbackCmd.askErrorDstCreate);
                n |= 0x10000;
            }
            try {
                this.in = new FileInputStream(this.actData.src);
            }
            catch (IOException iOException) {
                this.sendEventAsk(this.actData.src, FileRemote.CallbackCmd.askErrorSrcOpen);
                n |= 0x10000;
            }
        }
        if ((n & 0x30000) == 0) {
            this.evCpy.sendInternalEvent(CmdIntern.copyFileContent, true);
        }
        return n;
    }

    int execCopyFileContent() {
        int n = 0;
        boolean bl = true;
        do {
            try {
                int n2 = this.in.read(this.buffer);
                if (n2 > 0) {
                    this.zBytesFileCopied += n2;
                    this.zBytesAllCopied += (long)n2;
                    this.out.write(this.buffer, 0, n2);
                    long l = System.currentTimeMillis();
                    if (l <= this.timestart + this.timeActionMax) continue;
                    this.timestart = l;
                    if (this.evBackInfo != null && this.evBackInfo.occupyRecall(this.evSrc, false)) {
                        this.evBackInfo.promilleCopiedBytes = (int)((float)this.zBytesFileCopied / (float)this.zBytesFile * 1000.0f);
                        this.evBackInfo.promilleCopiedFiles = this.zBytesAllCheck > 0L ? (int)((float)this.zBytesAllCopied / (float)this.zBytesAllCheck * 1000.0f) : 0;
                        this.evBackInfo.nrofFiles = this.zFilesCheck - this.zFilesCopied;
                        this.evBackInfo.nrofBytesInFile = this.zBytesFile - (long)this.zBytesFileCopied;
                        this.evBackInfo.nrofBytesAll = this.zBytesAllCheck - this.zBytesAllCopied;
                        String string = this.actData.src.getAbsolutePath();
                        if (string.length() > this.evBackInfo.fileName.length - 1) {
                            string = "..." + string.substring(this.evBackInfo.fileName.length - 4);
                        }
                        StringFunctions.copyToBuffer(string, this.evBackInfo.fileName);
                        this.evBackInfo.sendEvent(FileRemote.CallbackCmd.nrofFilesAndBytes);
                    } else if (this.copyOrder.timeOrderProgress != null) {
                        this.copyOrder.timeOrderProgress.currFile = this.actData.src;
                        this.copyOrder.timeOrderProgress.nrofBytesFileCopied = this.zBytesFileCopied;
                        this.copyOrder.timeOrderProgress.nrofBytesFile = this.zBytesFile;
                        this.copyOrder.timeOrderProgress.nrFilesProcessed = this.zFilesCopied;
                        this.copyOrder.timeOrderProgress.nrofBytesFile = this.zBytesFileCopied;
                        this.copyOrder.timeOrderProgress.show(FileRemote.CallbackCmd.nrofFilesAndBytes, this.statesCopy);
                    }
                    this.evCpy.sendInternalEvent(CmdIntern.copyFileContent, true);
                    bl = false;
                    continue;
                }
                if (n2 != -1) continue;
                this.bCopyFinished = true;
                n |= 0x20000;
                bl = false;
            }
            catch (IOException iOException) {
                System.err.printf("FileAccessorLocalJava7 - Copy error; %s\n", iOException.getMessage());
                this.sendEventAsk(this.actData.dst, FileRemote.CallbackCmd.askErrorCopy);
                n |= 0x10000;
                bl = false;
            }
        } while (bl);
        return n;
    }

    void closeCopyFileContent() {
        try {
            if (this.in != null) {
                ++this.zFilesCopied;
                this.in.close();
                this.actData.src.resetMarked(0xF000001);
                this.actData.src.setDirShouldRefresh();
                this.actData.dst.setDirShouldRefresh();
                this.in = null;
            }
            if (this.out != null) {
                this.out.close();
                this.out = null;
                if (this.actData != null && this.actData.dst != null) {
                    if (!this.bCopyFinished) {
                        if (!this.actData.dst.delete()) {
                            System.err.println("FileAccessorLocalJava7 - Problem delete after abort; " + this.actData.dst.getAbsolutePath());
                        }
                    } else {
                        long l = this.actData.src.lastModified();
                        this.actData.dst.setLastModified(l);
                        this.actData.dst.resetMarked(-1);
                    }
                }
            }
        }
        catch (IOException iOException) {
            System.err.printf("FileAccessorLocalJava7 - Problem close; %s\n", this.actData.dst.getAbsolutePath());
        }
    }

    void execNextFile() {
        boolean bl;
        if (this.actData == null) {
            Debugutil.stop();
        } else {
            this.actData.src.resetMarked(1);
        }
        if (this.in != null) {
            ++this.zFilesCopied;
            try {
                this.in.close();
            }
            catch (IOException iOException) {
                System.err.printf("FileAccessorLocalJava7 -Copy close src while abort, unexpected error; %s\n", iOException.getMessage());
            }
            this.in = null;
        }
        if (this.out != null) {
            try {
                this.out.close();
            }
            catch (IOException iOException) {
                System.err.printf("FileAccessorLocalJava7 -Copy close dst while abort, unexpected error; %s\n", iOException.getMessage());
            }
            this.out = null;
        }
        do {
            if (this.actData == null || this.actData.parent == null) {
                this.actData = null;
                bl = false;
            } else {
                DataSetCopy1Recurs dataSetCopy1Recurs;
                this.actData = this.actData.parent;
                if (!this.bAbortDirectory && this.actData.listChildren != null && (dataSetCopy1Recurs = this.actData.listChildren.poll()) != null) {
                    this.actData = dataSetCopy1Recurs;
                    bl = false;
                } else {
                    bl = true;
                    if (this.actData.src != null) {
                        this.actData.src.resetMarked(1);
                    }
                }
            }
            this.bAbortDirectory = false;
        } while (bl);
        if (this.actData == null) {
            // empty if block
        }
    }

    private DataSetCopy1Recurs getNextCopyData() {
        this.actData = new DataSetCopy1Recurs(null);
        this.actData.src = this.fileSrc;
        return this.actData;
    }

    void copyAbort() {
        this.zBytesAllCheck = 0L;
        this.zFilesCheck = 0;
        try {
            this.storedCopyEvents.clear();
            this.zBytesAllCopied = 0L;
            this.zBytesAllCheck = 0L;
            this.zFilesCopied = 0;
            this.zFilesCheck = 0;
            try {
                if (this.out != null) {
                    this.out.close();
                    this.out = null;
                }
                if (this.in != null) {
                    ++this.zFilesCopied;
                    this.in.close();
                    this.in = null;
                }
            }
            catch (IOException iOException) {}
        }
        catch (Exception exception) {
            System.err.println("Copy_FileLocalAccJava7.abort() - Exception; " + exception.getMessage());
        }
        this.actData = null;
    }

    public final class States
    extends StateMachine {
        public States() {
            super("FileRemoteCopy", FileLocalAccessorCopyStateM.this.stateThread);
            this.permitException = true;
        }

        boolean toogleDebugState() {
            this.debugState = !this.debugState;
            return this.debugState;
        }

        @Override
        public int eventDebug(EventObject eventObject) {
            return super.eventDebug(eventObject);
        }

        final class Process
        extends StateComposite {
            int mResult;
            StateSimple.Trans transAsk = new StateSimple.Trans((StateSimple)this, Ask.class);
            StateSimple.Trans transNextFile = new StateSimple.Trans((StateSimple)this, NextFile.class);
            StateSimple.Trans transAbort = new StateSimple.Trans((StateSimple)this, Ready.class);

            Process() {
            }

            @Override
            protected StateSimple.Trans selectTrans(EventObject eventObject) {
                FileRemote.CmdEvent cmdEvent = null;
                if (eventObject instanceof FileRemote.CmdEvent && (cmdEvent = (FileRemote.CmdEvent)eventObject).getCmd() == FileRemote.Cmd.abortAll) {
                    return this.transAbort;
                }
                if (eventObject == ((FileLocalAccessorCopyStateM)FileLocalAccessorCopyStateM.this).copyOrder.timeOrderProgress.evAnswer && ((FileLocalAccessorCopyStateM)FileLocalAccessorCopyStateM.this).copyOrder.timeOrderProgress.evAnswer.getCmd() == FileRemoteProgressTimeOrder.Answer.abortFile) {
                    return this.transNextFile;
                }
                if ((this.mResult & 0x10000) != 0) {
                    this.mResult &= 0xFFFEFFFF;
                    return this.transAsk;
                }
                if ((this.mResult & 0x20000) != 0) {
                    this.mResult &= 0xFFFDFFFF;
                    return this.transNextFile;
                }
                return null;
            }

            @Override
            protected int entry(EventObject eventObject) {
                this.mResult = 0;
                return 0;
            }

            @Override
            protected void exit() {
            }

            class Ask
            extends StateSimple {
                StateSimple.Trans transDirOrFile = new StateSimple.Trans(new Class[]{DirOrFile.class}){

                    @Override
                    protected void action(EventObject eventObject) {
                        FileLocalAccessorCopyStateM.this.modeCopyOper = ((FileLocalAccessorCopyStateM)FileLocalAccessorCopyStateM.this).copyOrder.timeOrderProgress.modeCopyOper;
                        FileLocalAccessorCopyStateM.this.bOverwrfile = true;
                        ((FileLocalAccessorCopyStateM)FileLocalAccessorCopyStateM.this).copyOrder.timeOrderProgress.clearAnswer();
                    }
                };
                StateSimple.Trans transAbortFile = new StateSimple.Trans(new Class[]{NextFile.class}){

                    @Override
                    protected void action(EventObject eventObject) {
                        FileLocalAccessorCopyStateM.this.modeCopyOper = ((FileLocalAccessorCopyStateM)FileLocalAccessorCopyStateM.this).copyOrder.timeOrderProgress.modeCopyOper;
                        ((FileLocalAccessorCopyStateM)FileLocalAccessorCopyStateM.this).copyOrder.timeOrderProgress.clearAnswer();
                    }
                };
                StateSimple.Trans transAbortDir = new StateSimple.Trans(new Class[]{NextFile.class}){

                    @Override
                    protected void action(EventObject eventObject) {
                        FileLocalAccessorCopyStateM.this.modeCopyOper = ((FileRemote.CmdEvent)eventObject).modeCopyOper;
                        FileLocalAccessorCopyStateM.this.bAbortDirectory = true;
                    }
                };
                StateSimple.Trans transAbortAll = new StateSimple.Trans(new Class[]{NextFile.class}){

                    @Override
                    protected void action(EventObject eventObject) {
                        FileLocalAccessorCopyStateM.this.modeCopyOper = ((FileRemote.CmdEvent)eventObject).modeCopyOper;
                        FileLocalAccessorCopyStateM.this.copyAbort();
                    }
                };

                Ask() {
                }

                @Override
                protected int entry(EventObject eventObject) {
                    Process.this.mResult &= 0xFFFEFFFF;
                    FileLocalAccessorCopyStateM.this.closeCopyFileContent();
                    return 0;
                }

                @Override
                protected StateSimple.Trans selectTrans(EventObject eventObject) {
                    FileRemoteProgressTimeOrder.Answer answer;
                    if (eventObject == ((FileLocalAccessorCopyStateM)FileLocalAccessorCopyStateM.this).copyOrder.timeOrderProgress.evAnswer) {
                        answer = (FileRemoteProgressTimeOrder.Answer)((Object)((FileLocalAccessorCopyStateM)FileLocalAccessorCopyStateM.this).copyOrder.timeOrderProgress.evAnswer.getCmd());
                        FileLocalAccessorCopyStateM.this.modeCopyOper = ((FileLocalAccessorCopyStateM)FileLocalAccessorCopyStateM.this).copyOrder.timeOrderProgress.evAnswer.modeCopyOper;
                    } else {
                        answer = FileRemoteProgressTimeOrder.Answer.noCmd;
                    }
                    if (answer == FileRemoteProgressTimeOrder.Answer.abortAll) {
                        return this.transAbortAll.eventConsumed();
                    }
                    if (answer == FileRemoteProgressTimeOrder.Answer.abortDir) {
                        return this.transAbortDir.eventConsumed();
                    }
                    if (answer == FileRemoteProgressTimeOrder.Answer.abortFile) {
                        return this.transAbortFile;
                    }
                    if (answer == FileRemoteProgressTimeOrder.Answer.overwrite) {
                        return this.transDirOrFile;
                    }
                    return null;
                }
            }

            class NextFile
            extends StateSimple {
                StateSimple.Trans transReady = new StateSimple.Trans(new Class[]{Ready.class}){

                    @Override
                    protected void action(EventObject eventObject) {
                        if (FileLocalAccessorCopyStateM.this.evBackInfo != null && FileLocalAccessorCopyStateM.this.evBackInfo.occupyRecall(1000, FileLocalAccessorCopyStateM.this.evSrc, false) != 0) {
                            FileRemote.CmdEvent cmdEvent;
                            FileLocalAccessorCopyStateM.this.evBackInfo.sendEvent(FileRemote.CallbackCmd.done);
                            while ((cmdEvent = FileLocalAccessorCopyStateM.this.storedCopyEvents.poll()) != null) {
                                cmdEvent.sendEvent();
                            }
                        } else if (((FileLocalAccessorCopyStateM)FileLocalAccessorCopyStateM.this).copyOrder.timeOrderProgress != null) {
                            ((FileLocalAccessorCopyStateM)FileLocalAccessorCopyStateM.this).copyOrder.timeOrderProgress.currFile = ((FileLocalAccessorCopyStateM)FileLocalAccessorCopyStateM.this).copyOrder.fileSrc;
                            ((FileLocalAccessorCopyStateM)FileLocalAccessorCopyStateM.this).copyOrder.timeOrderProgress.nrofBytesFileCopied = FileLocalAccessorCopyStateM.this.zBytesFileCopied;
                            ((FileLocalAccessorCopyStateM)FileLocalAccessorCopyStateM.this).copyOrder.timeOrderProgress.nrofBytesFile = FileLocalAccessorCopyStateM.this.zBytesFile;
                            ((FileLocalAccessorCopyStateM)FileLocalAccessorCopyStateM.this).copyOrder.timeOrderProgress.nrFilesProcessed = FileLocalAccessorCopyStateM.this.zFilesCopied;
                            ((FileLocalAccessorCopyStateM)FileLocalAccessorCopyStateM.this).copyOrder.timeOrderProgress.nrofBytesFile = FileLocalAccessorCopyStateM.this.zBytesFileCopied;
                            ((FileLocalAccessorCopyStateM)FileLocalAccessorCopyStateM.this).copyOrder.timeOrderProgress.bDone = true;
                            ((FileLocalAccessorCopyStateM)FileLocalAccessorCopyStateM.this).copyOrder.timeOrderProgress.show(FileRemote.CallbackCmd.done, null);
                        }
                    }
                };
                StateSimple.Trans transDirOrFile = new StateSimple.Trans((StateSimple)this, DirOrFile.class);

                NextFile() {
                }

                @Override
                protected int entry(EventObject eventObject) {
                    FileLocalAccessorCopyStateM.this.execNextFile();
                    return 0x100000;
                }

                @Override
                protected StateSimple.Trans selectTrans(EventObject eventObject) {
                    if (FileLocalAccessorCopyStateM.this.actData == null) {
                        return this.transReady;
                    }
                    return this.transDirOrFile;
                }
            }

            class CopyFileContent
            extends StateSimple {
                boolean bContinue_dontClose;
                StateSimple.Trans transCopyContent_continue = new StateSimple.Trans((StateSimple)this, CopyFileContent.class);
                StateSimple.Trans transAbortFile = new StateSimple.Trans((StateSimple)this, NextFile.class);
                StateSimple.Trans transAbortCopyDir = new StateSimple.Trans(new Class[]{NextFile.class}){

                    @Override
                    protected void action(EventObject eventObject) {
                        FileLocalAccessorCopyStateM.this.bAbortDirectory = true;
                    }
                };
                StateSimple.Trans transNextFile = new StateSimple.Trans((StateSimple)this, NextFile.class);

                CopyFileContent() {
                }

                @Override
                protected int entry(EventObject eventObject) {
                    this.bContinue_dontClose = false;
                    Process.this.mResult = FileLocalAccessorCopyStateM.this.execCopyFileContent();
                    return 0x100000;
                }

                @Override
                protected void exit() {
                    if (!this.bContinue_dontClose) {
                        FileLocalAccessorCopyStateM.this.closeCopyFileContent();
                    }
                }

                @Override
                protected StateSimple.Trans selectTrans(EventObject eventObject) {
                    FileRemoteProgressTimeOrder.Answer answer;
                    if (eventObject == ((FileLocalAccessorCopyStateM)FileLocalAccessorCopyStateM.this).copyOrder.timeOrderProgress.evAnswer) {
                        answer = (FileRemoteProgressTimeOrder.Answer)((Object)((FileLocalAccessorCopyStateM)FileLocalAccessorCopyStateM.this).copyOrder.timeOrderProgress.evAnswer.getCmd());
                        FileLocalAccessorCopyStateM.this.modeCopyOper = ((FileLocalAccessorCopyStateM)FileLocalAccessorCopyStateM.this).copyOrder.timeOrderProgress.evAnswer.modeCopyOper;
                    } else {
                        answer = FileRemoteProgressTimeOrder.Answer.noCmd;
                    }
                    if (eventObject instanceof EventInternal && ((EventInternal)eventObject).getCmd() == CmdIntern.copyFileContent) {
                        this.bContinue_dontClose = true;
                        return this.transCopyContent_continue.eventConsumed();
                    }
                    if (answer == FileRemoteProgressTimeOrder.Answer.abortFile) {
                        return this.transAbortFile.eventConsumed();
                    }
                    if (answer == FileRemoteProgressTimeOrder.Answer.abortDir) {
                        return this.transAbortCopyDir.eventConsumed();
                    }
                    return null;
                }
            }

            class CopyFile
            extends StateSimple {
                StateSimple.Trans trans_CopyFileContent = new StateSimple.Trans((StateSimple)this, CopyFileContent.class);

                CopyFile() {
                }

                @Override
                protected int entry(EventObject eventObject) {
                    Process.this.mResult = FileLocalAccessorCopyStateM.this.startCopyFile();
                    return 0x100000;
                }

                @Override
                protected StateSimple.Trans selectTrans(EventObject eventObject) {
                    if (eventObject instanceof EventInternal && ((EventInternal)eventObject).getCmd() == CmdIntern.copyFileContent) {
                        return this.trans_CopyFileContent.eventConsumed();
                    }
                    return null;
                }
            }

            class Subdir
            extends StateSimple {
                StateSimple.Trans transSubdir_DirOrFile = new StateSimple.Trans((StateSimple)this, DirOrFile.class);
                StateSimple.Trans transEmptydir_NextFile = new StateSimple.Trans((StateSimple)this, NextFile.class);

                Subdir() {
                }

                @Override
                protected int entry(EventObject eventObject) {
                    Process.this.mResult = FileLocalAccessorCopyStateM.this.execCheckSubdir();
                    return 0x100000;
                }

                @Override
                protected StateSimple.Trans selectTrans(EventObject eventObject) {
                    if (eventObject instanceof EventInternal && ((EventInternal)eventObject).getCmd() == CmdIntern.subDir) {
                        return this.transSubdir_DirOrFile.eventConsumed();
                    }
                    if (eventObject instanceof EventInternal && ((EventInternal)eventObject).getCmd() == CmdIntern.emptyDir) {
                        return Process.this.transNextFile.eventConsumed();
                    }
                    return null;
                }
            }

            class DirOrFile
            extends StateSimple {
                final boolean isDefault = true;
                StateSimple.Trans transCopySubdir = new StateSimple.Trans((StateSimple)this, Subdir.class);
                StateSimple.Trans transDelFile = new StateSimple.Trans((StateSimple)this, DelFile.class);
                StateSimple.Trans transMoveFile = new StateSimple.Trans((StateSimple)this, MoveFile.class);
                StateSimple.Trans transStartCopy = new StateSimple.Trans((StateSimple)this, CopyFile.class);

                DirOrFile() {
                }

                @Override
                protected StateSimple.Trans selectTrans(EventObject eventObject) {
                    if (FileLocalAccessorCopyStateM.this.actData.src.isDirectory()) {
                        return this.transCopySubdir;
                    }
                    if (FileLocalAccessorCopyStateM.this.cmdFile == FileRemote.Cmd.delChecked) {
                        return this.transDelFile;
                    }
                    if (FileLocalAccessorCopyStateM.this.cmdFile == FileRemote.Cmd.move) {
                        return this.transMoveFile;
                    }
                    return this.transStartCopy;
                }
            }

            class DelFile
            extends StateSimple {
                boolean bdelete = false;
                boolean bskip = false;

                DelFile() {
                }

                @Override
                protected int entry(EventObject eventObject) {
                    if (FileLocalAccessorCopyStateM.this.actData.src.getName().equals("src-html")) {
                        Debugutil.stop();
                    }
                    if (FileLocalAccessorCopyStateM.this.actData.src.exists()) {
                        if (!FileLocalAccessorCopyStateM.this.actData.src.canWrite()) {
                            if ((FileLocalAccessorCopyStateM.this.modeCopyOper & 1) != 0) {
                                this.bdelete = false;
                            } else if ((FileLocalAccessorCopyStateM.this.modeCopyOper & 0) != 0) {
                                Process.this.mResult |= 0x10000;
                            } else if (!FileLocalAccessorCopyStateM.this.actData.src.setWritable(true)) {
                                Process.this.mResult |= 0x10000;
                            } else {
                                this.bdelete = true;
                            }
                        } else {
                            this.bdelete = true;
                        }
                    } else {
                        this.bskip = true;
                    }
                    if (this.bdelete && !FileLocalAccessorCopyStateM.this.actData.src.delete()) {
                        Process.this.mResult |= 0x10000;
                    }
                    return 0;
                }
            }

            class MoveFile
            extends StateSimple {
                boolean bmove = false;
                boolean bskip = false;

                MoveFile() {
                }

                @Override
                protected int entry(EventObject eventObject) {
                    if (FileLocalAccessorCopyStateM.this.actData.src.exists()) {
                        if (!FileLocalAccessorCopyStateM.this.actData.src.canWrite()) {
                            if ((FileLocalAccessorCopyStateM.this.modeCopyOper & 1) != 0) {
                                this.bmove = false;
                            } else if ((FileLocalAccessorCopyStateM.this.modeCopyOper & 0) != 0) {
                                Process.this.mResult |= 0x10000;
                            } else if (!FileLocalAccessorCopyStateM.this.actData.src.setWritable(true)) {
                                Process.this.mResult |= 0x10000;
                            } else {
                                this.bmove = true;
                            }
                        }
                        if (this.bmove && FileLocalAccessorCopyStateM.this.actData.dst.exists() && FileLocalAccessorCopyStateM.this.actData.dst.canWrite() && !FileLocalAccessorCopyStateM.this.actData.dst.delete()) {
                            Process.this.mResult |= 0x10000;
                        }
                    } else {
                        this.bskip = true;
                    }
                    if (this.bmove && !FileLocalAccessorCopyStateM.this.actData.src.renameTo(FileLocalAccessorCopyStateM.this.actData.dst)) {
                        Process.this.mResult |= 0x10000;
                    }
                    Process.this.mResult |= 0x20000;
                    return 0x100000;
                }
            }
        }

        final class Ready
        extends StateSimple {
            final boolean isDefault = true;
            StateSimple.Trans transStart_DirOrFile = new StateSimple.Trans((StateSimple)this, Process.DirOrFile.class);

            Ready() {
            }

            @Override
            protected StateSimple.Trans selectTrans(EventObject eventObject) {
                FileRemote.CmdEvent cmdEvent;
                FileRemote.Cmd cmd;
                StateSimple.Trans trans = null;
                if (FileLocalAccessorCopyStateM.this.copyOrders.size() > 0) {
                    FileLocalAccessorCopyStateM.this.copyOrder = (CopyOrder)FileLocalAccessorCopyStateM.this.copyOrders.poll();
                    trans = this.transStart_DirOrFile;
                    FileLocalAccessorCopyStateM.this.cmdFile = FileRemote.Cmd.copyChecked;
                    trans.doExit();
                    FileLocalAccessorCopyStateM.this.modeCopyOper = ((FileLocalAccessorCopyStateM)FileLocalAccessorCopyStateM.this).copyOrder.mode;
                    FileLocalAccessorCopyStateM.this.actData = FileLocalAccessorCopyStateM.this.getNextCopyData();
                    FileLocalAccessorCopyStateM.this.actData.src = ((FileLocalAccessorCopyStateM)FileLocalAccessorCopyStateM.this).copyOrder.fileSrc;
                    String string = ((FileLocalAccessorCopyStateM)FileLocalAccessorCopyStateM.this).copyOrder.pathDst;
                    String string2 = null;
                    if (!FileLocalAccessorCopyStateM.this.actData.src.isDirectory()) {
                        int n = string.lastIndexOf(47);
                        string2 = string.substring(n + 1);
                        string = n > 0 ? string.substring(0, n) : "";
                    }
                    FileLocalAccessorCopyStateM.this.actData.dst = FileLocalAccessorCopyStateM.this.actData.src.itsCluster.getFile(string, string2);
                    FileLocalAccessorCopyStateM.this.evBackInfo = null;
                    FileLocalAccessorCopyStateM.this.timestart = System.currentTimeMillis();
                    FileLocalAccessorCopyStateM.this.zBytesAllCopied = (FileLocalAccessorCopyStateM.this.zFilesCopied = 0);
                } else if (eventObject instanceof FileRemote.CmdEvent && ((cmd = (cmdEvent = (FileRemote.CmdEvent)eventObject).getCmd()) == FileRemote.Cmd.copyChecked || cmd == FileRemote.Cmd.moveChecked)) {
                    trans = this.transStart_DirOrFile;
                    FileLocalAccessorCopyStateM.this.cmdFile = cmd;
                    trans.doExit();
                    FileLocalAccessorCopyStateM.this.modeCopyOper = cmdEvent.modeCopyOper;
                    FileLocalAccessorCopyStateM.this.actData = FileLocalAccessorCopyStateM.this.getNextCopyData();
                    FileLocalAccessorCopyStateM.this.actData.src = cmdEvent.filesrc();
                    String string = cmdEvent.nameDst;
                    String string3 = null;
                    if (!FileLocalAccessorCopyStateM.this.actData.src.isDirectory()) {
                        int n = string.lastIndexOf(47);
                        string3 = string.substring(n + 1);
                        string = n > 0 ? string.substring(0, n) : "";
                    }
                    FileLocalAccessorCopyStateM.this.actData.dst = FileLocalAccessorCopyStateM.this.actData.src.itsCluster.getFile(string, string3);
                    FileLocalAccessorCopyStateM.this.evBackInfo = cmdEvent.getOpponent();
                    FileLocalAccessorCopyStateM.this.timestart = System.currentTimeMillis();
                    FileLocalAccessorCopyStateM.this.zBytesAllCopied = (FileLocalAccessorCopyStateM.this.zFilesCopied = 0);
                }
                return trans;
            }
        }
    }

    private static class CopyOrder {
        FileRemote fileSrc;
        String pathDst;
        String nameModification;
        int mode;
        FileRemoteCallback callbackUser;
        FileRemoteProgressTimeOrder timeOrderProgress;

        private CopyOrder() {
        }
    }

    private static class DataSetCopy1Recurs {
        FileRemote src;
        FileRemote dst;
        boolean selectAnyFile;
        final DataSetCopy1Recurs parent;
        Queue<DataSetCopy1Recurs> listChildren = null;

        DataSetCopy1Recurs(DataSetCopy1Recurs dataSetCopy1Recurs) {
            this.parent = dataSetCopy1Recurs;
        }

        DataSetCopy1Recurs addNewEntry(FileRemote fileRemote, FileRemote fileRemote2) {
            DataSetCopy1Recurs dataSetCopy1Recurs = new DataSetCopy1Recurs(this);
            dataSetCopy1Recurs.src = fileRemote;
            dataSetCopy1Recurs.dst = fileRemote2;
            if (this.listChildren == null) {
                this.listChildren = new ConcurrentLinkedQueue<DataSetCopy1Recurs>();
            }
            this.listChildren.add(dataSetCopy1Recurs);
            return dataSetCopy1Recurs;
        }

        public String toString() {
            return (this.src != null ? this.src.toString() : "NoSrc") + (this.listChildren != null ? ", listDirs.size=" + this.listChildren.size() : "");
        }
    }

    public final class EventInternal
    extends EventCmdtypeWithBackEvent<CmdIntern, EventInternal> {
        private static final long serialVersionUID = 0L;

        EventInternal(EventConsumer eventConsumer, EventTimerThread_ifc eventTimerThread_ifc) {
            super(null, eventConsumer, eventTimerThread_ifc, new EventInternal(eventConsumer, eventTimerThread_ifc, true));
        }

        EventInternal(EventConsumer eventConsumer, EventTimerThread_ifc eventTimerThread_ifc, boolean bl) {
            super(null, eventConsumer, eventTimerThread_ifc, null);
        }

        public boolean sendInternalEvent(CmdIntern cmdIntern, boolean bl) {
            EventInternal eventInternal;
            boolean bl2 = this.occupy(FileLocalAccessorCopyStateM.this.evSrc, false);
            if (bl2) {
                eventInternal = this;
            } else {
                eventInternal = (EventInternal)this.getOpponent();
                bl2 = eventInternal.occupy(FileLocalAccessorCopyStateM.this.evSrc, bl);
            }
            if (bl2) {
                eventInternal.sendEvent(cmdIntern);
            }
            return bl2;
        }
    }

    private static enum CmdIntern {
        start,
        subDir,
        copyFileContent,
        dir,
        ask,
        emptyDir,
        check;

    }
}

