/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.event;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.EventObject;
import java.util.concurrent.atomic.AtomicLong;
import org.vishia.event.EventConsumer;
import org.vishia.event.EventSource;
import org.vishia.event.EventTimerThread;
import org.vishia.event.EventTimerThread_ifc;
import org.vishia.util.DateOrder;

public class EventWithDst
extends EventObject {
    private static final long serialVersionUID = 3976120105528632683L;
    public static final String version = "2015-01-03";
    EventTimerThread_ifc evDstThread;
    EventConsumer evDst;
    public char stateOfEvent;
    boolean bAwaitReserve;
    protected int ctConsumed;
    protected long orderId;
    protected final AtomicLong dateCreation = new AtomicLong();
    int dateOrder;
    static final SimpleDateFormat toStringDateFormat = new SimpleDateFormat("MMM-dd HH:mm:ss.SSS");

    public EventWithDst(Object object) {
        super(object);
    }

    public EventWithDst() {
        super(EventSource.nullSource);
        this.dateCreation.set(0L);
    }

    public EventWithDst(EventSource eventSource, EventConsumer eventConsumer, EventTimerThread_ifc eventTimerThread_ifc) {
        super(EventSource.nullSource);
        if (eventSource == null) {
            this.dateCreation.set(0L);
        } else {
            this.source = eventSource;
            DateOrder dateOrder = DateOrder.get();
            this.dateCreation.set(dateOrder.date);
            this.dateOrder = dateOrder.order;
        }
        this.evDst = eventConsumer;
        this.evDstThread = eventTimerThread_ifc;
    }

    public void setOrderId(long l) {
        this.orderId = l;
    }

    @Deprecated
    public void XXXdonotRelinquish() {
        if (this.stateOfEvent == 'r') {
            this.stateOfEvent = (char)112;
        }
    }

    public EventConsumer evDst() {
        return this.evDst;
    }

    public Date dateCreation() {
        long l = this.dateCreation.get();
        return l == 0L ? null : new Date(l);
    }

    public boolean hasDst() {
        return this.evDst != null;
    }

    public void setDst(EventConsumer eventConsumer) {
        this.evDst = eventConsumer;
    }

    public boolean occupy(EventSource eventSource, EventConsumer eventConsumer, EventTimerThread eventTimerThread, boolean bl) {
        DateOrder dateOrder = DateOrder.get();
        if (this.dateCreation.compareAndSet(0L, dateOrder.date)) {
            this.dateOrder = dateOrder.order;
            this.source = eventSource == null ? EventSource.nullSource : eventSource;
            this.ctConsumed = 0;
            if (eventConsumer != null) {
                this.evDst = eventConsumer;
                this.evDstThread = eventTimerThread;
            }
            this.stateOfEvent = (char)97;
            return true;
        }
        if (bl) {
            this.notifyShouldOccupyButInUse();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean occupy(int n, EventSource eventSource, EventConsumer eventConsumer, EventTimerThread eventTimerThread) {
        boolean bl = this.occupy(eventSource, eventConsumer, eventTimerThread, false);
        if (!bl) {
            EventWithDst eventWithDst = this;
            synchronized (eventWithDst) {
                this.bAwaitReserve = true;
                try {
                    this.wait(n);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.bAwaitReserve = false;
                bl = this.occupy((EventSource)this.source, eventConsumer, eventTimerThread, false);
            }
        }
        return bl;
    }

    public boolean occupy(EventSource eventSource, boolean bl) {
        return this.occupy(eventSource, null, null, bl);
    }

    public boolean occupyRecall(EventSource eventSource, EventConsumer eventConsumer, EventTimerThread eventTimerThread, boolean bl) {
        boolean bl2 = this.occupy(eventSource, eventConsumer, eventTimerThread, false);
        if (!bl2 && this.evDstThread != null && (bl2 = this.evDstThread.removeFromQueue(this))) {
            this.relinquish();
            bl2 = this.occupy(eventSource, eventConsumer, eventTimerThread, false);
        }
        if (!bl2 && bl) {
            this.notifyShouldOccupyButInUse();
        }
        return bl2;
    }

    public boolean occupyRecall(EventSource eventSource, boolean bl) {
        return this.occupyRecall(eventSource, null, null, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int occupyRecall(int n, EventSource eventSource, EventConsumer eventConsumer, EventTimerThread eventTimerThread, boolean bl) {
        int n2 = 0;
        boolean bl2 = this.occupy(eventSource, eventConsumer, eventTimerThread, false);
        if (bl2) {
            n2 = 1;
        }
        if (!bl2 && this.evDstThread != null && (bl2 = this.evDstThread.removeFromQueue(this))) {
            this.relinquish();
            bl2 = this.occupy(eventSource, eventConsumer, eventTimerThread, false);
            if (bl2) {
                n2 = 2;
            }
        }
        if (!bl2) {
            long l = System.currentTimeMillis();
            EventWithDst eventWithDst = this;
            synchronized (eventWithDst) {
                this.bAwaitReserve = true;
                try {
                    this.wait(n);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.bAwaitReserve = false;
            }
            bl2 = this.occupy(eventSource, eventConsumer, eventTimerThread, false);
            if (bl2) {
                n2 = 1;
            } else {
                eventWithDst = this;
                synchronized (eventWithDst) {
                    long l2 = this.dateCreation.get();
                    if (!bl2 && l2 != 0L && l2 - l < 0L) {
                        this.bAwaitReserve = false;
                        this.stateOfEvent = (char)114;
                        this.relinquish();
                        bl2 = this.occupy(eventSource, eventConsumer, eventTimerThread, false);
                    }
                }
                if (bl2) {
                    n2 = 3;
                }
            }
        }
        if (!bl2 && bl) {
            this.notifyShouldOccupyButInUse();
        }
        return n2;
    }

    public int occupyRecall(int n, EventSource eventSource, boolean bl) {
        return this.occupyRecall(n, eventSource, null, null, bl);
    }

    public boolean isOccupied() {
        return this.dateCreation.get() != 0L;
    }

    public EventTimerThread_ifc getDstThread() {
        return this.evDstThread;
    }

    public EventConsumer getDst() {
        return this.evDst;
    }

    public boolean removeFromQueue() {
        if (this.evDstThread != null) {
            return this.evDstThread.removeFromQueue(this);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void relinquish() {
        EventSource eventSource = (EventSource)this.source;
        if (eventSource != null) {
            eventSource.notifyRelinquished(this.ctConsumed);
        }
        this.orderId = 0L;
        this.source = EventSource.nullSource;
        this.dateCreation.set(0L);
        if (this.bAwaitReserve) {
            EventWithDst eventWithDst = this;
            synchronized (eventWithDst) {
                this.notify();
            }
        }
        this.stateOfEvent = (char)102;
    }

    public boolean sendEvent() {
        if (this.evDst == null) {
            throw new IllegalArgumentException("event should have a destination");
        }
        if (this.evDstThread != null) {
            this.evDstThread.storeEvent(this);
        } else {
            int n = 0;
            try {
                this.stateOfEvent = (char)114;
                n = this.evDst.processEvent(this);
            }
            catch (Exception exception) {
                System.err.println("Exception while processing an event: " + exception.getMessage());
                exception.printStackTrace(System.err);
            }
            if ((n & 2) == 0) {
                this.relinquish();
            }
        }
        return true;
    }

    public void consumed() {
        ++this.ctConsumed;
        EventSource eventSource = (EventSource)this.source;
        if (eventSource != null) {
            eventSource.notifyConsumed(this.ctConsumed);
        }
    }

    void notifyDequeued() {
        EventSource eventSource = (EventSource)this.source;
        if (eventSource != null) {
            eventSource.notifyDequeued();
        }
    }

    private void notifyShouldSentButInUse() {
        EventSource eventSource = (EventSource)this.source;
        if (eventSource != null) {
            eventSource.notifyShouldSentButInUse();
        }
    }

    private void notifyShouldOccupyButInUse() {
        EventSource eventSource = (EventSource)this.source;
        if (eventSource != null) {
            eventSource.notifyShouldOccupyButInUse();
        }
    }
}

