/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.event;

import java.io.Closeable;
import java.util.EventObject;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.vishia.event.EventConsumer;
import org.vishia.event.EventTimeout;
import org.vishia.event.EventTimerThread_ifc;
import org.vishia.event.EventWithDst;
import org.vishia.event.TimeOrder;
import org.vishia.util.Assert;
import org.vishia.util.InfoAppend;

public class EventTimerThread
implements EventTimerThread_ifc,
Closeable,
InfoAppend {
    public static final String version = "2015-01-11";
    private int debugPrint;
    protected final String threadName;
    private Thread threadTimer;
    private EventConsumer eventProcessor;
    private final ConcurrentLinkedQueue<EventObject> queueEvents = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<EventTimeout> queueDelayedOrders = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<EventTimeout> queueDelayedTempOrders = new ConcurrentLinkedQueue();
    private boolean bThreadRun;
    private long timeCheckNew = System.currentTimeMillis() + 86400000L;
    private long timeSleep;
    char stateThreadTimer = (char)63;
    private final AtomicBoolean extEventSet = new AtomicBoolean(false);
    private boolean startOnDemand;
    private int ctWaitEmptyQueue;
    protected int maxCtWaitEmptyQueue = 5;
    private boolean preserveRecursiveInfoAppend;
    public Runnable runTimer = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            EventTimerThread.this.bThreadRun = true;
            EventTimerThread.this.stateThreadTimer = (char)114;
            while (EventTimerThread.this.stateThreadTimer == 'r' && EventTimerThread.this.bThreadRun) {
                int n = EventTimerThread.this.stepThread();
                if ((EventTimerThread.this.debugPrint & 1) != 0) {
                    System.out.printf("TimeOrderMng wait %d\n", n);
                }
                if (n < 2) {
                    n = 2;
                }
                Runnable runnable = EventTimerThread.this.runTimer;
                synchronized (runnable) {
                    EventTimerThread.this.stateThreadTimer = (char)87;
                    try {
                        EventTimerThread.this.runTimer.wait(n);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (EventTimerThread.this.stateThreadTimer == 'W') {
                        EventTimerThread.this.stateThreadTimer = (char)114;
                    }
                }
            }
            EventTimerThread.this.stateThreadTimer = (char)102;
        }
    };

    public EventTimerThread(String string) {
        this.threadName = string;
    }

    public final void setStdEventProcessor(EventConsumer eventConsumer) {
        this.eventProcessor = eventConsumer;
    }

    public void start() {
        this.startThread();
    }

    public void startThread() {
        if (this.threadTimer == null && !this.bThreadRun) {
            this.threadTimer = new Thread(this.runTimer, this.threadName);
            this.startOnDemand = false;
            this.threadTimer.start();
        }
    }

    @Override
    public void storeEvent(EventObject eventObject) {
        if (eventObject instanceof EventWithDst) {
            ((EventWithDst)eventObject).stateOfEvent = (char)113;
        }
        this.queueEvents.offer(eventObject);
        this.startOrNotify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startOrNotify() {
        if (this.threadTimer == null) {
            this.startThread();
            this.startOnDemand = true;
        } else {
            Runnable runnable = this.runTimer;
            synchronized (runnable) {
                if (this.stateThreadTimer == 'W') {
                    this.runTimer.notify();
                }
            }
        }
    }

    @Override
    public void close() {
        this.bThreadRun = false;
        this.notifyTimer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addTimeOrder(EventTimeout eventTimeout) {
        long l = eventTimeout.timeToExecution();
        if (l >= 0L) {
            String string = eventTimeout.toString();
            if (string.equals("showFilesProcessing")) {
                System.out.println("addTimeOrder;" + eventTimeout.toString());
            }
            this.queueDelayedOrders.offer(eventTimeout);
            long l2 = eventTimeout.timeExecution - this.timeCheckNew;
            if (l2 < -2L) {
                boolean bl;
                this.timeCheckNew = eventTimeout.timeExecution;
                Runnable runnable = this.runTimer;
                synchronized (runnable) {
                    boolean bl2 = bl = this.stateThreadTimer == 'W';
                    if (bl) {
                        this.runTimer.notify();
                    }
                }
                if (bl) {
                    if ((this.debugPrint & 0x100) != 0) {
                        System.out.printf("TimeOrderMng notify %d\n", l2);
                    }
                } else if ((this.debugPrint & 0x200) != 0) {
                    System.out.printf("TimeOrderMng not notified because checking %d\n", l2);
                }
            } else if ((this.debugPrint & 0x400) != 0) {
                System.out.printf("TimeOrderMng not notified, future %d\n", l2);
            }
        } else {
            if ((this.debugPrint & 0x800) != 0) {
                System.out.printf("TimeOrderMng yet %d\n", l);
            }
            eventTimeout.doTimeElapsed();
        }
    }

    @Override
    public boolean removeTimeOrder(EventTimeout eventTimeout) {
        boolean bl = this.queueDelayedOrders.remove(eventTimeout);
        return bl;
    }

    @Override
    public boolean removeFromQueue(EventObject eventObject) {
        boolean bl = this.queueEvents.remove(eventObject);
        if (bl && eventObject instanceof EventWithDst) {
            ((EventWithDst)eventObject).stateOfEvent = (char)97;
        }
        return bl;
    }

    private final void applyEvent(EventObject eventObject) {
        if (eventObject instanceof EventWithDst) {
            EventWithDst eventWithDst = (EventWithDst)eventObject;
            eventWithDst.stateOfEvent = (char)101;
            eventWithDst.notifyDequeued();
            int n = 0;
            try {
                eventWithDst.stateOfEvent = (char)114;
                EventConsumer eventConsumer = eventWithDst.evDst;
                if (eventConsumer == null && eventObject instanceof TimeOrder) {
                    ((TimeOrder)eventObject).executeOrder();
                } else {
                    n = eventConsumer.processEvent(eventWithDst);
                }
            }
            catch (Exception exception) {
                CharSequence charSequence = Assert.exceptionInfo("EventThread.applyEvent exception", exception, 0, 50);
                System.err.append(charSequence);
            }
            if ((n & 2) == 0) {
                eventWithDst.relinquish();
            }
        } else if (this.eventProcessor != null) {
            this.eventProcessor.processEvent(eventObject);
        } else {
            throw new IllegalStateException("destination for event execution is unknown. Use setStdEventProcessor(...). ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkEventAndRun() {
        boolean bl;
        block7: {
            bl = false;
            try {
                EventObject eventObject = this.queueEvents.poll();
                if (eventObject == null) break block7;
                this.ctWaitEmptyQueue = 0;
                EventTimerThread eventTimerThread = this;
                synchronized (eventTimerThread) {
                    if (this.stateThreadTimer != 'x') {
                        this.stateThreadTimer = (char)98;
                    }
                }
                if (this.stateThreadTimer == 'b') {
                    this.applyEvent(eventObject);
                    bl = true;
                }
            }
            catch (Exception exception) {
                CharSequence charSequence = Assert.exceptionInfo("EventThread unexpected Exception - ", exception, 0, 50);
                System.err.append(charSequence);
            }
        }
        return bl;
    }

    private int checkTimeOrders() {
        EventTimeout eventTimeout;
        int n = 10000;
        this.timeCheckNew = System.currentTimeMillis() + (long)n;
        long l = System.currentTimeMillis();
        while ((eventTimeout = this.queueDelayedOrders.poll()) != null) {
            long l2 = eventTimeout.timeExecution - l;
            if (l2 < 3L) {
                eventTimeout.doTimeElapsed();
                l = System.currentTimeMillis();
                continue;
            }
            if (l2 < (long)n) {
                this.timeCheckNew = eventTimeout.timeExecution;
                n = (int)l2;
            }
            this.queueDelayedTempOrders.offer(eventTimeout);
        }
        while ((eventTimeout = this.queueDelayedTempOrders.poll()) != null) {
            this.queueDelayedOrders.offer(eventTimeout);
        }
        return n;
    }

    private int stepThread() {
        int n;
        boolean bl;
        do {
            this.stateThreadTimer = (char)99;
            this.timeSleep = System.currentTimeMillis();
            n = (int)(this.timeCheckNew - this.timeSleep);
            if (n < 0) {
                n = this.checkTimeOrders();
            }
            bl = false;
            while (this.checkEventAndRun()) {
                bl = true;
            }
            if (!bl || (this.debugPrint & 2) == 0) continue;
            System.out.printf("TimeOrderMng not wait %d\n", n);
        } while (bl);
        return n;
    }

    public boolean isCurrentThread() {
        return this.threadTimer == Thread.currentThread();
    }

    public char getState() {
        return this.stateThreadTimer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyTimer() {
        Runnable runnable = this.runTimer;
        synchronized (runnable) {
            if (this.stateThreadTimer == 'W') {
                this.runTimer.notify();
            }
        }
    }

    @Override
    public CharSequence infoAppend(StringBuilder stringBuilder) {
        if (stringBuilder == null) {
            stringBuilder = new StringBuilder();
        }
        stringBuilder.append("Thread ");
        stringBuilder.append("; ");
        return stringBuilder;
    }

    public String toString() {
        if (this.preserveRecursiveInfoAppend) {
            return this.threadName;
        }
        return this.infoAppend(null).toString();
    }
}

