/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.cmd;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.script.CompiledScript;
import javax.script.ScriptContext;
import javax.script.ScriptException;
import org.vishia.cmd.JZcmdEngine;
import org.vishia.cmd.JZcmdExecuter;
import org.vishia.mainCmd.MainCmdLogging_ifc;
import org.vishia.util.Assert;
import org.vishia.util.CalculatorExpr;
import org.vishia.util.DataAccess;
import org.vishia.util.Debugutil;
import org.vishia.util.FilePath;
import org.vishia.util.FileSet;
import org.vishia.util.SetLineColumn_ifc;
import org.vishia.util.StringFunctions;
import org.vishia.xmlSimple.XmlNode;

public class JZcmdScript
extends CompiledScript {
    public static final String sVersion = "2014-07-07";
    final MainCmdLogging_ifc console;
    final File fileScript;
    final JZcmdEngine scriptEngine;
    final Map<String, Subroutine> subroutinesAll = new TreeMap<String, Subroutine>();
    Subroutine mainRoutine;
    protected JZcmditem checkJZcmdFile;
    JZcmditem checkJZcmdXmlFile;
    XmlNode xmlSrc;
    JZcmdClass scriptClass;

    public JZcmdScript(MainCmdLogging_ifc mainCmdLogging_ifc, File file, JZcmdEngine jZcmdEngine) {
        this.console = mainCmdLogging_ifc;
        this.fileScript = file;
        this.scriptEngine = jZcmdEngine;
    }

    @Override
    public Object eval(ScriptContext scriptContext) throws ScriptException {
        if (scriptContext instanceof JZcmdExecuter.ExecuteLevel) {
            JZcmdExecuter.ExecuteLevel executeLevel = (JZcmdExecuter.ExecuteLevel)scriptContext;
            try {
                executeLevel.executer().initialize(this, false, null, null);
                Subroutine subroutine = this.getMain();
                executeLevel.execSubroutine(subroutine, null, null, 0);
            }
            catch (Throwable throwable) {
                if (throwable instanceof Exception) {
                    throw new ScriptException((Exception)throwable);
                }
                throw new RuntimeException("JZcmdScript.eval - unexpected Throwable", throwable);
            }
        } else {
            throw new ScriptException("faulty context");
        }
        return null;
    }

    @Override
    public JZcmdEngine getEngine() {
        return this.scriptEngine;
    }

    public JZcmdClass scriptClass() {
        return this.scriptClass;
    }

    public final Subroutine getMain() {
        return this.mainRoutine;
    }

    public Subroutine getSubroutine(CharSequence charSequence) {
        return this.subroutinesAll.get(charSequence.toString());
    }

    public void writeStruct(Appendable appendable) throws IOException {
        this.scriptClass.writeStruct(0, appendable);
    }

    public static class Scriptfile {
        public List<JZcmdInclude> includes;
        Subroutine mainRoutine;

        public Subroutine getMainRoutine() {
            return this.mainRoutine;
        }
    }

    public static final class ZbnfJZcmdScript
    extends JZcmdClass {
        private final JZcmdScript compiledScript;
        public Scriptfile scriptfile;

        public ZbnfJZcmdScript(JZcmdScript jZcmdScript) {
            this.compiledScript = jZcmdScript;
            jZcmdScript.scriptClass = this;
        }

        public JZcmdInclude new_include() {
            return new JZcmdInclude(this);
        }

        public void add_include(JZcmdInclude jZcmdInclude) {
            if (this.scriptfile.includes == null) {
                this.scriptfile.includes = new ArrayList<JZcmdInclude>();
            }
            this.scriptfile.includes.add(jZcmdInclude);
        }

        public StatementList new_mainRoutine() {
            this.scriptfile.mainRoutine = new Subroutine(this.compiledScript.scriptClass);
            this.scriptfile.mainRoutine.statementlist = new StatementList(null);
            return this.scriptfile.mainRoutine.statementlist;
        }

        public void add_mainRoutine(StatementList statementList) {
        }

        public JZcmditem new_checkJZcmdFile() {
            return new JZcmditem(this, '\u0000');
        }

        public void add_checkJZcmdFile(JZcmditem jZcmditem) {
            this.compiledScript.checkJZcmdFile = jZcmditem;
        }

        public JZcmditem new_checkXmlFile() {
            return new JZcmditem(this, '\u0000');
        }

        public void add_checkXmlFile(JZcmditem jZcmditem) {
            this.compiledScript.checkJZcmdXmlFile = jZcmditem;
        }

        public void setMainRoutine(Subroutine subroutine) {
            this.compiledScript.mainRoutine = subroutine;
        }

        public boolean isXmlSrcNecessary() {
            return this.compiledScript.checkJZcmdXmlFile != null;
        }

        public void setXmlSrc(XmlNode xmlNode) {
            this.compiledScript.xmlSrc = xmlNode;
        }
    }

    public static final class JZcmdInclude
    extends JZcmditem {
        public String path;
        public String envVar;

        JZcmdInclude(StatementList statementList) {
            super(statementList, '.');
        }
    }

    public class JZcmdClass
    extends StatementList {
        List<JZcmdClass> classes;
        final Map<String, Subroutine> subroutines = new TreeMap<String, Subroutine>();

        protected JZcmdClass() {
        }

        public final List<JZcmdClass> classes() {
            return this.classes;
        }

        public final Map<String, Subroutine> subroutines() {
            return this.subroutines;
        }

        public JZcmdClass new_subClass() {
            return new JZcmdClass();
        }

        public void add_subClass(JZcmdClass jZcmdClass) {
            if (this.classes == null) {
                this.classes = new ArrayList<JZcmdClass>();
            }
            this.classes.add(jZcmdClass);
        }

        public Subroutine new_subroutine() {
            return new Subroutine(this);
        }

        public void add_subroutine(Subroutine subroutine) {
            if (subroutine.name == null) {
                subroutine.name = "main";
            }
            String string = subroutine.name.toString();
            this.subroutines.put(string, subroutine);
            String string2 = this.cmpnName == null ? string : this.cmpnName + "." + string;
            JZcmdScript.this.subroutinesAll.put(string2, subroutine);
        }

        public void writeStruct(int n, Appendable appendable) throws IOException {
            if (this.statements != null) {
                for (JZcmditem object : this.statements) {
                    object.writeStruct(n + 1, appendable);
                }
            }
            for (Map.Entry entry : this.subroutines.entrySet()) {
                Subroutine subroutine = (Subroutine)entry.getValue();
                subroutine.writeStruct(0, appendable);
            }
            if (this.classes != null) {
                for (JZcmdClass jZcmdClass : this.classes) {
                    jZcmdClass.writeStruct(n + 1, appendable);
                }
            }
        }
    }

    public static class StatementList
    implements SetLineColumn_ifc {
        String srcFile = "srcFile-yet-unknown";
        int srcLine;
        final JZcmditem parentStatement;
        public String cmpnName;
        public final List<JZcmditem> statements = new ArrayList<JZcmditem>();
        List<Onerror> onerrorAccu;
        List<JZcmditem> withoutOnerror = new LinkedList<JZcmditem>();
        public boolean bContainsVariableDef;
        int indentText;
        public final List<StatementList> addToList = new ArrayList<StatementList>();

        public StatementList() {
            this.parentStatement = null;
        }

        public StatementList(JZcmditem jZcmditem) {
            this.parentStatement = jZcmditem;
        }

        @Override
        public void setLineColumnFile(int n, int n2, String string) {
            this.srcLine = n;
            this.indentText = n2;
            this.srcFile = string;
        }

        @Override
        public int setLineColumnFileMode() {
            return 7;
        }

        public StatementList new_statementBlock() {
            JZcmditem jZcmditem = new JZcmditem(this, 'B');
            this.statements.add(jZcmditem);
            this.onerrorAccu = null;
            this.withoutOnerror.add(jZcmditem);
            jZcmditem.statementlist = new StatementList(jZcmditem);
            return jZcmditem.statementlist;
        }

        public void add_statementBlock(StatementList statementList) {
        }

        public JZcmditem new_debug() {
            return new JZcmditem(this, 'D');
        }

        public void add_debug(JZcmditem jZcmditem) {
            this.statements.add(jZcmditem);
            this.onerrorAccu = null;
            this.withoutOnerror.add(jZcmditem);
        }

        public void set_debug() {
            this.statements.add(new JZcmditem(this, 'D'));
        }

        public void set_scriptdir() {
            TextOut textOut = new TextOut(this, 't');
            int n = this.srcFile.lastIndexOf(47);
            textOut.textArg = this.srcFile.substring(0, n);
            this.statements.add(textOut);
        }

        public TextOut new_textOut() {
            return new TextOut(this, 'T');
        }

        public void add_textOut(TextOut textOut) {
            this.statements.add(textOut);
        }

        public StatementList new_textExpr() {
            JZcmditem jZcmditem = new JZcmditem(this, ':');
            this.statements.add(jZcmditem);
            jZcmditem.statementlist = new StatementList(jZcmditem);
            return jZcmditem.statementlist;
        }

        public void add_textExpr(StatementList statementList) {
        }

        public DefVariable new_textVariable() {
            this.bContainsVariableDef = true;
            return new DefVariable(this, 'S');
        }

        public void add_textVariable(DefVariable defVariable) {
            this.statements.add(defVariable);
            this.onerrorAccu = null;
            this.withoutOnerror.add(defVariable);
        }

        public DefVariable new_Pipe() {
            this.bContainsVariableDef = true;
            return new DefVariable(this, 'P');
        }

        public void add_Pipe(DefVariable defVariable) {
            this.statements.add(defVariable);
            this.onerrorAccu = null;
            this.withoutOnerror.add(defVariable);
        }

        public DefVariable new_Stringjar() {
            this.bContainsVariableDef = true;
            return new DefVariable(this, 'U');
        }

        public void add_Stringjar(DefVariable defVariable) {
            this.statements.add(defVariable);
            this.onerrorAccu = null;
            this.withoutOnerror.add(defVariable);
        }

        public DefVariable new_List() {
            this.bContainsVariableDef = true;
            return new DefVariable(this, 'L');
        }

        public void add_List(DefVariable defVariable) {
            this.statements.add(defVariable);
            this.onerrorAccu = null;
            this.withoutOnerror.add(defVariable);
        }

        public DefVariable new_DefMapVar() {
            this.bContainsVariableDef = true;
            DefVariable defVariable = new DefVariable(this, 'M');
            this.statements.add(defVariable);
            this.onerrorAccu = null;
            this.withoutOnerror.add(defVariable);
            return defVariable;
        }

        public void add_DefMapVar(DefVariable defVariable) {
        }

        public DefVariable new_Openfile() {
            this.bContainsVariableDef = true;
            return new DefVariable(this, 'W');
        }

        public void add_Openfile(DefVariable defVariable) {
            this.statements.add(defVariable);
            this.onerrorAccu = null;
            this.withoutOnerror.add(defVariable);
        }

        public DefVariable new_DefFilepath() {
            this.bContainsVariableDef = true;
            return new DefVariable(this, 'F');
        }

        public void add_DefFilepath(DefVariable defVariable) {
            this.statements.add(defVariable);
            this.onerrorAccu = null;
            this.withoutOnerror.add(defVariable);
        }

        public UserFileset new_DefFileset() {
            this.bContainsVariableDef = true;
            return new UserFileset(this);
        }

        public void add_DefFileset(UserFileset userFileset) {
            this.statements.add(userFileset);
            this.onerrorAccu = null;
            this.withoutOnerror.add(userFileset);
        }

        public Zmake new_zmake() {
            this.bContainsVariableDef = true;
            return new Zmake(this);
        }

        public void add_zmake(Zmake zmake) {
            this.statements.add(zmake);
            this.onerrorAccu = null;
            this.withoutOnerror.add(zmake);
        }

        public DefVariable new_DefObjVar() {
            this.bContainsVariableDef = true;
            return new DefVariable(this, 'O');
        }

        public void add_DefObjVar(DefVariable defVariable) {
            this.statements.add(defVariable);
            this.onerrorAccu = null;
            this.withoutOnerror.add(defVariable);
        }

        public DefClasspathVariable new_DefClasspath() {
            this.bContainsVariableDef = true;
            return new DefClasspathVariable(this);
        }

        public void add_DefClasspath(DefClasspathVariable defClasspathVariable) {
            this.statements.add(defClasspathVariable);
            this.onerrorAccu = null;
            this.withoutOnerror.add(defClasspathVariable);
        }

        public DefClassVariable new_DefClassVar() {
            this.bContainsVariableDef = true;
            return new DefClassVariable(this);
        }

        public void add_DefClassVar(DefClassVariable defClassVariable) {
            this.statements.add(defClassVariable);
            this.onerrorAccu = null;
            this.withoutOnerror.add(defClassVariable);
        }

        public DefVariable new_DefNumVar() {
            this.bContainsVariableDef = true;
            return new DefVariable(this, 'K');
        }

        public void add_DefNumVar(DefVariable defVariable) {
            this.statements.add(defVariable);
            this.onerrorAccu = null;
            this.withoutOnerror.add(defVariable);
        }

        public DefVariable new_DefBoolVar() {
            this.bContainsVariableDef = true;
            return new DefVariable(this, 'Q');
        }

        public void add_DefBoolVar(DefVariable defVariable) {
            this.statements.add(defVariable);
            this.onerrorAccu = null;
            this.withoutOnerror.add(defVariable);
        }

        public DefVariable new_setEnvVar() {
            return new DefVariable(this, 'S');
        }

        public void add_setEnvVar(DefVariable defVariable) {
            List<DataAccess.DatapathElement> list = defVariable.defVariable.datapath();
            int n = list.size() - 1;
            DataAccess.DatapathElement datapathElement = list.get(n);
            datapathElement.setIdent("$" + datapathElement.ident());
            this.statements.add(defVariable);
            this.onerrorAccu = null;
            this.withoutOnerror.add(defVariable);
        }

        public DataText new_dataText() {
            return new DataText(this);
        }

        public void add_dataText(DataText dataText) {
            this.statements.add(dataText);
            this.onerrorAccu = null;
            this.withoutOnerror.add(dataText);
        }

        public void set_textReplLf(String string) {
        }

        public TextColumn new_setColumn() {
            return new TextColumn(this);
        }

        public void add_setColumn(TextColumn textColumn) {
            this.statements.add(textColumn);
        }

        public void set_plainText(String string) {
            JZcmditem jZcmditem = new JZcmditem(this, 't');
            jZcmditem.textArg = string;
            this.statements.add(jZcmditem);
            this.onerrorAccu = null;
            this.withoutOnerror.add(jZcmditem);
        }

        public void set_transliteration(String string) {
            JZcmditem jZcmditem = new JZcmditem(this, '\\');
            char c = string.charAt(0);
            switch (c) {
                case 'n': {
                    jZcmditem.textArg = "\n";
                    break;
                }
                case 'r': {
                    jZcmditem.textArg = "\r";
                    break;
                }
                case 't': {
                    jZcmditem.textArg = "\t";
                    break;
                }
                case '\"': 
                case '#': 
                case '<': {
                    jZcmditem.textArg = string;
                }
            }
            this.statements.add(jZcmditem);
            this.onerrorAccu = null;
            this.withoutOnerror.add(jZcmditem);
        }

        public void set_newline() {
            JZcmditem jZcmditem = new JZcmditem(this, 'n');
            this.statements.add(jZcmditem);
            this.onerrorAccu = null;
            this.withoutOnerror.add(jZcmditem);
        }

        public AssignExpr new_assignExpr() {
            return new AssignExpr(this, '=');
        }

        public void add_assignExpr(AssignExpr assignExpr) {
            this.statements.add(assignExpr);
            this.onerrorAccu = null;
            this.withoutOnerror.add(assignExpr);
        }

        public JZcmditem new_throw() {
            return new JZcmditem(this, 'r');
        }

        public void add_throw(JZcmditem jZcmditem) {
            this.statements.add(jZcmditem);
            this.onerrorAccu = null;
            this.withoutOnerror.add(jZcmditem);
        }

        public void set_throwonerror(int n) {
            Onerror onerror = new Onerror(this);
            onerror.elementType = (char)118;
            onerror.errorLevel = n;
            this.statements.add(onerror);
        }

        public void set_errorToOutput(String string) {
            JZcmditem jZcmditem = new JZcmditem(this, ',');
            if (string.equals("1")) {
                jZcmditem.textArg = string;
            }
            this.statements.add(jZcmditem);
        }

        public Onerror new_onerror() {
            return new Onerror(this);
        }

        public void add_onerror(Onerror onerror) {
            if (onerror.errorLevel != Integer.MIN_VALUE) {
                onerror.setCmdError();
            }
            this.statements.add(onerror);
            this.withoutOnerror.clear();
        }

        public Onerror new_iferrorlevel() {
            return new Onerror(this);
        }

        public void add_iferrorlevel(Onerror onerror) {
            onerror.setCmdError();
            this.statements.add(onerror);
        }

        public void set_breakBlock() {
            JZcmditem jZcmditem = new JZcmditem(this, 'b');
            this.statements.add(jZcmditem);
        }

        public IfStatement new_ifCtrl() {
            StatementList statementList = new StatementList(this.parentStatement);
            IfStatement ifStatement = new IfStatement(this, 'i');
            ifStatement.statementlist = statementList;
            return ifStatement;
        }

        public void add_ifCtrl(IfStatement ifStatement) {
            this.statements.add(ifStatement);
            this.onerrorAccu = null;
            this.withoutOnerror.add(ifStatement);
        }

        public JZcmditem new_hasNext() {
            JZcmditem jZcmditem = new JZcmditem(this, 'N');
            this.statements.add(jZcmditem);
            this.onerrorAccu = null;
            this.withoutOnerror.add(jZcmditem);
            return jZcmditem;
        }

        public void add_hasNext(JZcmditem jZcmditem) {
        }

        public ForStatement new_forCtrl() {
            ForStatement forStatement = new ForStatement(this, 'f');
            this.statements.add(forStatement);
            this.onerrorAccu = null;
            this.withoutOnerror.add(forStatement);
            return forStatement;
        }

        public void add_forCtrl(ForStatement forStatement) {
        }

        public CondStatement new_whileCtrl() {
            CondStatement condStatement = new CondStatement(this, 'w');
            this.statements.add(condStatement);
            this.onerrorAccu = null;
            this.withoutOnerror.add(condStatement);
            return condStatement;
        }

        public void add_whileCtrl(CondStatement condStatement) {
        }

        public CondStatement new_dowhileCtrl() {
            CondStatement condStatement = new CondStatement(this, 'u');
            this.statements.add(condStatement);
            this.onerrorAccu = null;
            this.withoutOnerror.add(condStatement);
            return condStatement;
        }

        public void add_dowhileCtrl(CondStatement condStatement) {
        }

        public ThreadBlock new_threadBlock() {
            ThreadBlock threadBlock = new ThreadBlock(this);
            this.statements.add(threadBlock);
            this.onerrorAccu = null;
            this.withoutOnerror.add(threadBlock);
            return threadBlock;
        }

        public void add_threadBlock(ThreadBlock threadBlock) {
        }

        public CallStatement new_call() {
            CallStatement callStatement = new CallStatement(this, 's');
            this.statements.add(callStatement);
            this.onerrorAccu = null;
            this.withoutOnerror.add(callStatement);
            return callStatement;
        }

        public void add_call(CallStatement callStatement) {
        }

        public CmdInvoke new_cmdWait() {
            CmdInvoke cmdInvoke = new CmdInvoke(this, 'c');
            this.statements.add(cmdInvoke);
            this.onerrorAccu = null;
            this.withoutOnerror.add(cmdInvoke);
            return cmdInvoke;
        }

        public void add_cmdWait(CmdInvoke cmdInvoke) {
        }

        public CmdInvoke new_cmdStart() {
            CmdInvoke cmdInvoke = new CmdInvoke(this, 'c');
            cmdInvoke.bShouldNotWait = true;
            this.statements.add(cmdInvoke);
            this.onerrorAccu = null;
            this.withoutOnerror.add(cmdInvoke);
            return cmdInvoke;
        }

        public void add_cmdStart(CmdInvoke cmdInvoke) {
        }

        public CallStatement new_move() {
            CallStatement callStatement = new CallStatement(this, 'm');
            this.statements.add(callStatement);
            this.onerrorAccu = null;
            this.withoutOnerror.add(callStatement);
            return callStatement;
        }

        public void add_move(CallStatement callStatement) {
        }

        public CallStatement new_copy() {
            CallStatement callStatement = new CallStatement(this, 'y');
            this.statements.add(callStatement);
            this.onerrorAccu = null;
            this.withoutOnerror.add(callStatement);
            return callStatement;
        }

        public void add_copy(CallStatement callStatement) {
        }

        public CallStatement new_del() {
            CallStatement callStatement = new CallStatement(this, 'l');
            this.statements.add(callStatement);
            this.onerrorAccu = null;
            this.withoutOnerror.add(callStatement);
            return callStatement;
        }

        public void add_del(CallStatement callStatement) {
        }

        public JZcmditem new_cd() {
            JZcmditem jZcmditem = new JZcmditem(this, 'd');
            this.statements.add(jZcmditem);
            this.onerrorAccu = null;
            this.withoutOnerror.add(jZcmditem);
            return jZcmditem;
        }

        public void add_cd(JZcmditem jZcmditem) {
        }

        public void set_name(String string) {
            this.cmpnName = string;
        }

        public void set_exitScript(int n) {
            ExitStatement exitStatement = new ExitStatement(this, n);
            this.statements.add(exitStatement);
        }
    }

    public static final class Onerror
    extends JZcmditem {
        public int errorLevel = Integer.MIN_VALUE;
        public char errorType = (char)63;

        public void set_errortype(String string) {
            this.errorType = string.charAt(0);
        }

        Onerror(StatementList statementList) {
            super(statementList, '?');
        }

        void setCmdError() {
            this.elementType = (char)35;
        }
    }

    public static class ThreadBlock
    extends JZcmditem {
        DataAccess threadVariable;

        ThreadBlock(StatementList statementList) {
            super(statementList, 'x');
        }

        public JZcmdDataAccess new_defThreadVar() {
            return new JZcmdDataAccess();
        }

        public void add_defThreadVar(JZcmdDataAccess jZcmdDataAccess) {
            jZcmdDataAccess.setTypeToLastElement('T');
            this.threadVariable = jZcmdDataAccess;
        }

        public JZcmdDataAccess new_assignThreadVar() {
            return new JZcmdDataAccess();
        }

        public void add_assignThreadVar(JZcmdDataAccess jZcmdDataAccess) {
            this.threadVariable = jZcmdDataAccess;
        }
    }

    public static class ExitStatement
    extends JZcmditem {
        int exitValue;

        ExitStatement(StatementList statementList, int n) {
            super(statementList, 'z');
            this.exitValue = n;
        }
    }

    public static class CmdInvoke
    extends AssignExpr {
        public List<JZcmditem> cmdArgs;
        public List<DataAccess> errorPipes;
        public DataAccess errorPipe;
        public DataAccess inputPipe;
        boolean bCmdCheck;
        public boolean bShouldNotWait;

        CmdInvoke(StatementList statementList, char c) {
            super(statementList, c);
        }

        public JZcmditem new_actualArgument() {
            return new JZcmditem(this.parentList, '.');
        }

        public void add_actualArgument(JZcmditem jZcmditem) {
            if (this.cmdArgs == null) {
                this.cmdArgs = new ArrayList<JZcmditem>();
            }
            this.cmdArgs.add(jZcmditem);
        }

        public JZcmdDataAccess new_argList() {
            JZcmdDataAccess jZcmdDataAccess;
            JZcmditem jZcmditem = new JZcmditem(this.parentList, 'L');
            jZcmditem.dataAccess = jZcmdDataAccess = new JZcmdDataAccess();
            if (this.cmdArgs == null) {
                this.cmdArgs = new ArrayList<JZcmditem>();
            }
            this.cmdArgs.add(jZcmditem);
            return jZcmdDataAccess;
        }

        public void add_argList(JZcmdDataAccess jZcmdDataAccess) {
        }

        public void set_argsCheck() {
            this.bCmdCheck = true;
        }
    }

    public static class CallStatement
    extends AssignExpr {
        JZcmditem call_Name;
        public List<Argument> actualArgs;

        CallStatement(StatementList statementList, char c) {
            super(statementList, c);
        }

        public JZcmditem new_callName() {
            this.call_Name = new Argument(this.parentList);
            return this.call_Name;
        }

        public void set_callName(JZcmditem jZcmditem) {
        }

        public Argument new_actualArgument() {
            return new Argument(this.parentList);
        }

        public void add_actualArgument(Argument argument) {
            if (this.actualArgs == null) {
                this.actualArgs = new ArrayList<Argument>();
            }
            this.actualArgs.add(argument);
        }

        @Override
        void writeStructAdd(int n, Appendable appendable) throws IOException {
            this.call_Name.writeStruct(0, appendable);
            if (this.actualArgs != null) {
                for (Argument argument : this.actualArgs) {
                    argument.writeStruct(n + 1, appendable);
                }
            }
            appendable.append("\n");
        }
    }

    public static class Subroutine
    extends JZcmditem {
        public String name;
        public boolean addLocals;
        public boolean useLocals;
        public List<DefVariable> formalArgs;

        Subroutine(StatementList statementList) {
            super(statementList, 'X');
        }

        public void set_name(String string) {
            this.name = string;
        }

        public void set_useLocals() {
            this.useLocals = true;
        }

        public void set_addLocals() {
            this.addLocals = true;
        }

        public Subroutine new_formalArgument() {
            return this;
        }

        public void add_formalArgument(Subroutine subroutine) {
        }

        public DefVariable new_DefObjVar() {
            return new DefVariable(this.parentList, 'O');
        }

        public void add_DefObjVar(DefVariable defVariable) {
            if (this.formalArgs == null) {
                this.formalArgs = new ArrayList<DefVariable>();
            }
            this.formalArgs.add(defVariable);
        }

        public DefVariable new_ClassObjVar() {
            return new DefVariable(this.parentList, 'C');
        }

        public void add_DefClassVar(DefVariable defVariable) {
            if (this.formalArgs == null) {
                this.formalArgs = new ArrayList<DefVariable>();
            }
            this.formalArgs.add(defVariable);
        }

        public DefVariable new_DefNumVar() {
            return new DefVariable(this.parentList, 'K');
        }

        public void add_DefNumVar(DefVariable defVariable) {
            if (this.formalArgs == null) {
                this.formalArgs = new ArrayList<DefVariable>();
            }
            this.formalArgs.add(defVariable);
        }

        public DefVariable new_DefBoolVar() {
            return new DefVariable(this.parentList, 'Q');
        }

        public void add_DefBoolVar(DefVariable defVariable) {
            if (this.formalArgs == null) {
                this.formalArgs = new ArrayList<DefVariable>();
            }
            this.formalArgs.add(defVariable);
        }

        public DefVariable new_textVariable() {
            return new DefVariable(this.parentList, 'S');
        }

        public void add_textVariable(DefVariable defVariable) {
            if (this.formalArgs == null) {
                this.formalArgs = new ArrayList<DefVariable>();
            }
            this.formalArgs.add(defVariable);
        }

        public DefVariable new_DefMapVar() {
            return new DefVariable(this.parentList, 'M');
        }

        public void add_DefMapVar(DefVariable defVariable) {
            if (this.formalArgs == null) {
                this.formalArgs = new ArrayList<DefVariable>();
            }
            this.formalArgs.add(defVariable);
        }

        public DefVariable new_DefFilepath() {
            return new DefVariable(this.parentList, 'F');
        }

        public void add_DefFilepath(DefVariable defVariable) {
            if (this.formalArgs == null) {
                this.formalArgs = new ArrayList<DefVariable>();
            }
            this.formalArgs.add(defVariable);
        }

        public UserFileset new_DefFileset() {
            return new UserFileset(this.parentList);
        }

        public void add_DefFileset(UserFileset userFileset) {
            if (this.formalArgs == null) {
                this.formalArgs = new ArrayList<DefVariable>();
            }
            this.formalArgs.add(userFileset);
        }

        public DefVariable new_setEnvVar() {
            return new DefVariable(this.parentList, 'S');
        }

        public void add_setEnvVar(DefVariable defVariable) {
            if (this.formalArgs == null) {
                this.formalArgs = new ArrayList<DefVariable>();
            }
            defVariable.defVariable.datapath().get(0).setIdent("$" + defVariable.defVariable.datapath().get(0).ident());
            this.formalArgs.add(defVariable);
        }

        @Override
        void writeStructAdd(int n, Appendable appendable) throws IOException {
            if (this.formalArgs != null) {
                for (DefVariable defVariable : this.formalArgs) {
                    defVariable.writeStruct(n + 1, appendable);
                }
            }
            appendable.append(")\n");
        }

        @Override
        void writeStructLine(Appendable appendable) {
            super.writeStructLine(appendable);
            try {
                if (this.name == null) {
                    appendable.append(" main(");
                } else {
                    appendable.append(" sub ").append(this.name).append("(");
                }
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
    }

    public static class ForStatement
    extends CondStatement {
        String forVariable;
        String checkForVariable;
        JZcmdDataAccess forContainer;

        ForStatement(StatementList statementList, char c) {
            super(statementList, c);
        }

        public void set_forVariable(String string) {
            this.forVariable = string;
        }

        public void set_checkForVariable(String string) {
            this.checkForVariable = string;
        }

        public JZcmdDataAccess new_forContainer() {
            return new JZcmdDataAccess();
        }

        public void add_forContainer(JZcmdDataAccess jZcmdDataAccess) {
            this.forContainer = jZcmdDataAccess;
        }
    }

    public static class IfCondition
    extends CondStatement {
        public boolean bElse;

        IfCondition(StatementList statementList, char c) {
            super(statementList, c);
        }
    }

    public static class CondStatement
    extends JZcmditem {
        public JZcmditem condition;

        CondStatement(StatementList statementList, char c) {
            super(statementList, c);
        }

        public JZcmdCalculatorExpr new_condition() {
            this.condition = new JZcmditem(this.statementlist, '.');
            return this.condition.new_numExpr();
        }

        public void add_condition(JZcmdCalculatorExpr jZcmdCalculatorExpr) {
            this.condition.add_numExpr(jZcmdCalculatorExpr);
        }
    }

    public static class IfStatement
    extends JZcmditem {
        IfStatement(StatementList statementList, char c) {
            super(statementList, c);
        }

        public IfCondition new_ifBlock() {
            IfCondition ifCondition = new IfCondition(this.parentList, 'g');
            this.statementlist.statements.add(ifCondition);
            this.statementlist.onerrorAccu = null;
            this.statementlist.withoutOnerror.add(ifCondition);
            return ifCondition;
        }

        public void add_ifBlock(IfCondition ifCondition) {
        }

        public StatementList new_elseBlock() {
            JZcmditem jZcmditem = new JZcmditem(this.parentList, 'E');
            jZcmditem.statementlist = new StatementList(this);
            this.statementlist.statements.add(jZcmditem);
            this.statementlist.onerrorAccu = null;
            this.statementlist.withoutOnerror.add(jZcmditem);
            return jZcmditem.statementlist;
        }

        public void add_elseBlock(StatementList statementList) {
        }
    }

    public static class TextColumn
    extends JZcmditem {
        CalculatorExpr minSpaces;

        TextColumn(StatementList statementList) {
            super(statementList, '@');
        }

        public CalculatorExpr new_minSpaces() {
            this.minSpaces = new CalculatorExpr();
            return this.minSpaces;
        }

        public void add_minSpaces() {
        }

        @Override
        void writeStructAdd(int n, Appendable appendable) throws IOException {
            appendable.append(" setColumn ").append(Integer.toString(0x7777777));
        }
    }

    public static class TextOut
    extends JZcmditem {
        public JZcmdDataAccess variable;

        TextOut(StatementList statementList, char c) {
            super(statementList, c);
        }

        public JZcmdDataAccess new_assign() {
            return new JZcmdDataAccess();
        }

        public void add_assign(JZcmdDataAccess jZcmdDataAccess) {
            this.variable = jZcmdDataAccess;
        }

        public void set_newline() {
            if (this.statementlist == null) {
                this.statementlist = new StatementList(this);
            }
            this.statementlist.statements.add(new JZcmditem(this.parentList, 'n'));
        }

        public void set_flush() {
            if (this.statementlist == null) {
                this.statementlist = new StatementList(this);
            }
            this.statementlist.statements.add(new JZcmditem(this.parentList, '!'));
        }

        public void set_close() {
            if (this.statementlist == null) {
                this.statementlist = new StatementList(this);
            }
            this.statementlist.statements.add(new JZcmditem(this.parentList, '_'));
        }
    }

    public static class AssignExpr
    extends JZcmditem {
        public List<JZcmdDataAccess> assignObjs;
        public JZcmdDataAccess variable;

        AssignExpr(StatementList statementList, char c) {
            super(statementList, c);
        }

        public JZcmdDataAccess new_assign() {
            return new JZcmdDataAccess();
        }

        public void add_assign(JZcmdDataAccess jZcmdDataAccess) {
            if (this.variable == null) {
                this.variable = jZcmdDataAccess;
            } else {
                if (this.assignObjs == null) {
                    this.assignObjs = new LinkedList<JZcmdDataAccess>();
                }
                this.assignObjs.add(jZcmdDataAccess);
            }
        }

        public void set_append() {
            if (this.elementType != '=') {
                throw new IllegalArgumentException("JZcmdScript - unexpected set_append");
            }
            this.elementType = (char)43;
        }

        @Override
        void writeStructLine(Appendable appendable) {
            super.writeStructLine(appendable);
            try {
                if (this.variable != null) {
                    appendable.append(" assign ");
                    this.variable.writeStruct(appendable);
                    appendable.append(" = ");
                } else {
                    appendable.append(" invoke ");
                }
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
    }

    public static class DefClasspathVariable
    extends DefVariable {
        List<AccessFilesetname> jarpaths = new ArrayList<AccessFilesetname>();
        String nameParentClasspath;

        DefClasspathVariable(StatementList statementList) {
            super(statementList, 'J');
        }

        @Override
        public AccessFilesetname new_filesetAccess() {
            return new AccessFilesetname(this.parentList);
        }

        @Override
        public void add_filesetAccess(AccessFilesetname accessFilesetname) {
            this.jarpaths.add(accessFilesetname);
        }

        public void set_parentClasspath(String string) {
            this.nameParentClasspath = string;
        }
    }

    public static class DefClassVariable
    extends DefVariable {
        JZcmdDataAccess loader;

        DefClassVariable(StatementList statementList) {
            super(statementList, 'C');
        }

        public JZcmdDataAccess new_loader() {
            return new JZcmdDataAccess();
        }

        public void add_loader(JZcmdDataAccess jZcmdDataAccess) {
            this.loader = jZcmdDataAccess;
        }
    }

    public static class DefVariable
    extends JZcmditem {
        public DataAccess defVariable;
        String typeVariable;
        boolean bConst;

        DefVariable(StatementList statementList, char c) {
            super(statementList, c);
        }

        public void set_const() {
            this.bConst = true;
        }

        public void set_type(String string) {
            this.typeVariable = string;
        }

        public JZcmdDataAccess new_defVariable() {
            return new JZcmdDataAccess();
        }

        public void add_defVariable(JZcmdDataAccess jZcmdDataAccess) {
            int n = "SPULOKQWMCJFG".indexOf(this.elementType);
            char c = "SPULOKQAMCJFG".charAt(n);
            if (this.bConst) {
                c = Character.toLowerCase(c);
            }
            jZcmdDataAccess.setTypeToLastElement(c);
            this.defVariable = jZcmdDataAccess;
        }

        String getVariableIdent() {
            List<DataAccess.DatapathElement> list = this.defVariable.datapath();
            int n = list.size();
            String string = list == null || n == 0 ? null : (list.size() == 1 ? this.defVariable.datapath().get(0).ident() : null);
            return string;
        }

        @Override
        void writeStructLine(Appendable appendable) {
            super.writeStructLine(appendable);
            try {
                appendable.append(" Defvariable ").append(this.defVariable != null ? this.defVariable.toString() : "no_Variable");
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
    }

    public static class DataText
    extends JZcmditem {
        public String format;

        public DataText(StatementList statementList) {
            super(statementList, 'e');
        }

        public void set_formatText(String string) {
            this.format = string;
        }
    }

    public static class AccessFilesetname
    extends JZcmditem {
        String filesetVariableName;

        public AccessFilesetname(StatementList statementList) {
            super(statementList, 'G');
        }

        public void set_accessPath(String string) {
            this.textArg = string;
        }

        public void set_accessPathOrFilesetVariable(String string) {
            if (string.startsWith("&") && StringFunctions.indexOfAnyChar(string, 0, string.length(), "\\/:") < 0) {
                this.filesetVariableName = string.substring(1);
            } else {
                this.textArg = string;
            }
        }

        public void set_zmakeFilesetVariable(String string) {
            if (this.filesetVariableName != null) {
                this.textArg = "&" + this.filesetVariableName;
            }
            this.filesetVariableName = string;
        }
    }

    public static class Zmake
    extends CallStatement {
        JZcmditem jzoutput;
        String name;
        List<AccessFilesetname> input = new ArrayList<AccessFilesetname>();

        Zmake(StatementList statementList) {
            super(statementList, 'Z');
        }

        public void set_name(String string) {
            this.name = string;
        }

        public JZcmditem new_zmakeOutput() {
            return new JZcmditem(this.parentList, '.');
        }

        public void add_zmakeOutput(JZcmditem jZcmditem) {
            this.jzoutput = jZcmditem;
        }

        @Override
        public AccessFilesetname new_filesetAccess() {
            return new AccessFilesetname(this.parentList);
        }

        @Override
        public void add_filesetAccess(AccessFilesetname accessFilesetname) {
            this.input.add(accessFilesetname);
        }
    }

    public static class DefFilepath
    extends DefVariable {
        FilePath filepath;

        DefFilepath(StatementList statementList) {
            super(statementList, 'F');
        }
    }

    public static class UserFileset
    extends DefVariable {
        final JZcmdScript script;
        final FileSet fileset = new FileSet();

        UserFileset(StatementList statementList, JZcmdScript jZcmdScript) {
            super(statementList, 'G');
            this.script = jZcmdScript;
        }

        public UserFileset(StatementList statementList) {
            super(statementList, 'G');
            this.script = null;
        }

        public void set_name(String string) {
            JZcmdDataAccess jZcmdDataAccess;
            this.dataAccess = jZcmdDataAccess = new JZcmdDataAccess();
            jZcmdDataAccess.set_startVariable(string);
        }

        public void set_commonPath(String string) {
            this.fileset.set_commonPath(string);
        }

        public void set_filePath(String string) {
            this.fileset.add_filePath(string);
        }
    }

    public static class JZcmdInstanceofExpr {
    }

    public static class JZcmdCalculatorExpr
    extends CalculatorExpr.SetExpr {
        JZcmdCalculatorExpr(Object object) {
            super(true, object);
        }

        @Override
        public JZcmdDataAccess new_dataAccess() {
            return (JZcmdDataAccess)super.new_dataAccess();
        }

        public void add_dataAccess(JZcmdDataAccess jZcmdDataAccess) {
        }

        @Override
        protected JZcmdDataAccess newDataAccessSet() {
            return new JZcmdDataAccess();
        }

        public JZcmdInstanceofExpr new_instanceof() {
            return new JZcmdInstanceofExpr();
        }

        public void add_instanceof(JZcmdInstanceofExpr jZcmdInstanceofExpr) {
        }
    }

    public static class JZcmdDatapathElementClass
    extends DataAccess.DatapathElementClass {
        JZcmdDataAccess dpathLoader;
        protected List<JZcmditem> fnArgsExpr;
        protected JZcmdDataAccess dpathClass;

        public JZcmditem new_argument() {
            return new JZcmditem(null, 'A');
        }

        public void add_argument(JZcmditem jZcmditem) {
            if (this.fnArgsExpr == null) {
                this.fnArgsExpr = new ArrayList<JZcmditem>();
            }
            this.fnArgsExpr.add(jZcmditem);
        }

        public JZcmdDataAccess new_Class_Var() {
            return new JZcmdDataAccess();
        }

        public void add_Class_Var(JZcmdDataAccess jZcmdDataAccess) {
            this.dpathClass = jZcmdDataAccess;
        }

        public JZcmdDataAccess new_Classpath_Var() {
            return new JZcmdDataAccess();
        }

        public void add_Classpath_Var(JZcmdDataAccess jZcmdDataAccess) {
            this.dpathLoader = jZcmdDataAccess;
        }
    }

    public static class JZcmdDatapathElement
    extends DataAccess.SetDatapathElement {
        protected List<JZcmditem> fnArgsExpr;
        protected JZcmdDataAccess indirectDatapath;

        public JZcmditem new_argument() {
            return new JZcmditem(null, 'A');
        }

        public void add_argument(JZcmditem jZcmditem) {
            if (this.fnArgsExpr == null) {
                this.fnArgsExpr = new ArrayList<JZcmditem>();
            }
            this.fnArgsExpr.add(jZcmditem);
        }

        public JZcmdDataAccess new_dataPath() {
            return new JZcmdDataAccess();
        }

        public void add_dataPath(JZcmdDataAccess jZcmdDataAccess) {
            this.indirectDatapath = jZcmdDataAccess;
        }

        public void writeStruct(int n, Appendable appendable) throws IOException {
            appendable.append(this.ident).append(':').append(this.whatisit);
            if (this.fnArgsExpr != null) {
                String string = "(";
                for (JZcmditem jZcmditem : this.fnArgsExpr) {
                    jZcmditem.writeStruct(n + 1, appendable);
                }
            }
        }
    }

    public static class JZcmdDataAccess
    extends DataAccess.DataAccessSet {
        public void XXXset_file(String string) {
            Debugutil.stop();
        }

        @Override
        public DataAccess.SetDatapathElement new_startDatapath() {
            return new JZcmdDatapathElement();
        }

        @Override
        public final JZcmdDatapathElement new_datapathElement() {
            return new JZcmdDatapathElement();
        }

        public final void add_datapathElement(JZcmdDatapathElement jZcmdDatapathElement) {
            super.add_datapathElement(jZcmdDatapathElement);
        }

        @Override
        public final JZcmdDatapathElementClass newDatapathElementClass() {
            return new JZcmdDatapathElementClass();
        }
    }

    public static class Argument
    extends JZcmditem {
        public String identArgJbat;

        public Argument(StatementList statementList) {
            super(statementList, '.');
        }

        public void set_name(String string) {
            this.identArgJbat = string;
        }

        public String getIdent() {
            return this.identArgJbat;
        }
    }

    public static class JZcmditem
    implements SetLineColumn_ifc {
        protected char elementType;
        protected char conversion = '\u0000';
        int srcLine;
        int srcColumn;
        String srcFile = "";
        final StatementList parentList;
        public StatementList statementlist;
        public JZcmdDataAccess dataAccess;
        public CalculatorExpr expression;
        JZcmditem subitem;
        public String textArg;
        static String sindentA = "                                                                               ";

        JZcmditem(StatementList statementList, char c) {
            if (statementList == null) {
                Assert.stop();
            }
            this.parentList = statementList;
            this.elementType = c;
        }

        @Override
        public void setLineColumnFile(int n, int n2, String string) {
            this.srcLine = n;
            this.srcColumn = n2;
            this.srcFile = string;
        }

        @Override
        public int setLineColumnFileMode() {
            return 7;
        }

        char elementType() {
            return this.elementType;
        }

        public StatementList statementlist() {
            return this.statementlist;
        }

        private void checkEmpty() {
            if (this.statementlist != null || this.dataAccess != null || this.expression != null || this.textArg != null) {
                throw new IllegalArgumentException("JZcmdItem with more as one content type.");
            }
        }

        public JZcmdDataAccess new_dataAccess() {
            this.checkEmpty();
            return new JZcmdDataAccess();
        }

        public void add_dataAccess(JZcmdDataAccess jZcmdDataAccess) {
            this.dataAccess = jZcmdDataAccess;
        }

        public void set_plainText(String string) {
            if (string.length() > 0) {
                this.set_text(string);
            }
        }

        public void set_text(String string) {
            CharSequence charSequence;
            this.checkEmpty();
            if (string.contains("\n=")) {
                StringBuilder stringBuilder = new StringBuilder(string);
                charSequence = stringBuilder;
                int n = 0;
                while ((n = stringBuilder.indexOf("\n=", n)) >= 0) {
                    stringBuilder.replace(n + 1, n + 2, "");
                }
            } else {
                charSequence = string;
            }
            this.textArg = charSequence.toString();
        }

        public StatementList new_dataStruct() {
            this.checkEmpty();
            this.statementlist = new StatementList(this);
            if (this.elementType != 'M') {
                this.elementType = (char)77;
            }
            return this.statementlist;
        }

        public void add_dataStruct(StatementList statementList) {
        }

        public StatementList new_statementBlock() {
            this.checkEmpty();
            this.statementlist = new StatementList(this);
            return this.statementlist;
        }

        public void add_statementBlock(StatementList statementList) {
        }

        public StatementList new_textExpr() {
            if (this.statementlist == null) {
                this.statementlist = new StatementList(this);
            }
            return this.statementlist;
        }

        public void add_textExpr(StatementList statementList) {
        }

        public JZcmdCalculatorExpr new_numExpr() {
            this.checkEmpty();
            return new JZcmdCalculatorExpr(this);
        }

        public void add_numExpr(JZcmdCalculatorExpr jZcmdCalculatorExpr) {
            DataAccess dataAccess = jZcmdCalculatorExpr.onlyDataAccess();
            if (dataAccess != null) {
                this.dataAccess = (JZcmdDataAccess)dataAccess;
            } else {
                jZcmdCalculatorExpr.closeExprPreparation();
                this.expression = jZcmdCalculatorExpr.expr;
            }
        }

        public JZcmdCalculatorExpr new_boolExpr() {
            this.checkEmpty();
            return new JZcmdCalculatorExpr(this);
        }

        public void add_boolExpr(JZcmdCalculatorExpr jZcmdCalculatorExpr) {
            DataAccess dataAccess = jZcmdCalculatorExpr.onlyDataAccess();
            if (dataAccess != null) {
                this.dataAccess = (JZcmdDataAccess)dataAccess;
            } else {
                jZcmdCalculatorExpr.closeExprPreparation();
                this.expression = jZcmdCalculatorExpr.expr;
            }
        }

        public JZcmditem new_File() {
            this.conversion = (char)69;
            return this;
        }

        public void add_File(JZcmditem jZcmditem) {
        }

        public JZcmditem new_Filepath() {
            this.conversion = (char)70;
            return this;
        }

        public void add_Filepath(JZcmditem jZcmditem) {
        }

        public AccessFilesetname new_filesetAccess() {
            return new AccessFilesetname(this.parentList);
        }

        public void add_filesetAccess(AccessFilesetname accessFilesetname) {
            this.conversion = (char)71;
            this.subitem = accessFilesetname;
        }

        public ScriptException scriptException(String string) {
            return new ScriptException(string, this.srcFile, this.srcLine, this.srcColumn);
        }

        final void writeStruct(int n, Appendable appendable) throws IOException {
            String string = 2 * n < sindentA.length() - 2 ? sindentA.substring(0, 2 * n) : sindentA;
            appendable.append(string);
            this.writeStructLine(appendable);
            this.writeStructAdd(n, appendable);
            if (this.textArg != null) {
                appendable.append("\"").append(this.textArg).append("\"");
            }
            if (this.dataAccess != null) {
                this.dataAccess.writeStruct(appendable);
            }
            if (this.expression != null) {
                String string2 = this.expression.toString();
                appendable.append(string2);
            }
            appendable.append("\n");
            if (this.statementlist != null) {
                for (JZcmditem jZcmditem : this.statementlist.statements) {
                    jZcmditem.writeStruct(n + 1, appendable);
                }
            }
        }

        void writeStructAdd(int n, Appendable appendable) throws IOException {
        }

        void writeStructLine(Appendable appendable) {
            try {
                appendable.append(" @").append(this.srcFile).append(':').append(Integer.toString(this.srcLine)).append(",").append(Integer.toString(this.srcColumn)).append("; ").append(this.elementType);
                switch (this.elementType) {
                    case 't': {
                        appendable.append(" text \"").append(this.textArg).append("\"");
                        break;
                    }
                    case 'e': {
                        appendable.append(" <*)");
                        break;
                    }
                    case 'B': {
                        appendable.append(" { statementblock }");
                        break;
                    }
                    case 'D': {
                        appendable.append(" debug");
                        break;
                    }
                    case 'I': {
                        appendable.append(" (?forInput?)...(/?)");
                        break;
                    }
                    case 'L': {
                        appendable.append(" List");
                        break;
                    }
                    case 'W': {
                        appendable.append(" Openfile");
                        break;
                    }
                    case 'Z': {
                        appendable.append(" zmake");
                        break;
                    }
                    case 'i': {
                        appendable.append(" if ");
                        break;
                    }
                    case 'F': {
                        appendable.append(" Filepath ");
                        break;
                    }
                    case 'G': {
                        appendable.append(" Fileset ");
                        break;
                    }
                    case 'g': {
                        appendable.append(" elsif ");
                        break;
                    }
                    case 'N': {
                        appendable.append(" <:hasNext> content <.hasNext>");
                        break;
                    }
                    case 'E': {
                        appendable.append(" else ");
                        break;
                    }
                    case 'Y': {
                        appendable.append(" <:file> ");
                        break;
                    }
                    case 'b': {
                        appendable.append(" break; ");
                        break;
                    }
                    case 'c': {
                        appendable.append(" cmd ");
                        break;
                    }
                    case 'm': {
                        appendable.append(" move ");
                        break;
                    }
                    case 'x': {
                        appendable.append(" thread ");
                        break;
                    }
                    case 'y': {
                        appendable.append(" copy ");
                        break;
                    }
                    case 'z': {
                        appendable.append(" exit ");
                        break;
                    }
                    case 'n': {
                        appendable.append(" newline ");
                        break;
                    }
                    case ':': {
                        appendable.append(" <:> ... <.>");
                        break;
                    }
                    case '!': {
                        appendable.append(" flush ");
                        break;
                    }
                    case '_': {
                        appendable.append(" close ");
                        break;
                    }
                    case ',': {
                        appendable.append(" errortoOutput ");
                        if (this.textArg != null) break;
                        appendable.append("off ");
                        break;
                    }
                    case 'M': {
                        appendable.append(" Map ");
                        break;
                    }
                }
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            this.writeStructLine(stringBuilder);
            return stringBuilder.toString();
        }
    }
}

