/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.cmd;

import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.script.Bindings;
import javax.script.ScriptContext;
import javax.script.ScriptException;
import org.vishia.cmd.CmdExecuter;
import org.vishia.cmd.JZcmdAccessFileset;
import org.vishia.cmd.JZcmdEngine;
import org.vishia.cmd.JZcmdFilepath;
import org.vishia.cmd.JZcmdFileset;
import org.vishia.cmd.JZcmdScript;
import org.vishia.cmd.JZcmdTester;
import org.vishia.cmd.JZcmdThread;
import org.vishia.cmd.ZmakeTarget;
import org.vishia.mainCmd.MainCmd;
import org.vishia.mainCmd.MainCmdLoggingStream;
import org.vishia.mainCmd.MainCmdLogging_ifc;
import org.vishia.util.Assert;
import org.vishia.util.CalculatorExpr;
import org.vishia.util.Conversion;
import org.vishia.util.DataAccess;
import org.vishia.util.Debugutil;
import org.vishia.util.FilePath;
import org.vishia.util.FileSystem;
import org.vishia.util.IndexMultiTable;
import org.vishia.util.StringFormatter;
import org.vishia.util.StringPartAppend;
import org.vishia.util.StringSeq;
import org.vishia.xmlSimple.SimpleXmlOutputter;

public class JZcmdExecuter {
    public static final String sVersion = "2014-12-14";
    protected String accessError = null;
    public static final short kBreak = -1;
    public static final short kReturn = -2;
    private static final short kFalse = -3;
    private static final short kException = -5;
    public static final short kSuccess = 0;
    public boolean bAccessPrivate;
    protected final MainCmdLogging_ifc log;
    StringFormatter textout;
    JZcmdScript jzcmdScript;
    final ExecuteLevel scriptLevel;
    final JZcmdThread scriptThread;
    protected final Queue<JZcmdThread> threads = new ConcurrentLinkedQueue<JZcmdThread>();
    private boolean bScriptVariableGenerated;
    public long startmilli;
    public long startnano;
    String newline = "\r\n";
    int nextNr_ = 0;
    private static CharSequence retException = new String("Exception");
    protected Locale locale = Locale.ENGLISH;

    public JZcmdExecuter(MainCmdLogging_ifc mainCmdLogging_ifc) {
        this.log = mainCmdLogging_ifc;
        this.scriptThread = new JZcmdThread();
        this.scriptLevel = new ExecuteLevel(this.scriptThread);
    }

    public JZcmdExecuter() {
        MainCmdLogging_ifc mainCmdLogging_ifc = MainCmd.getLogging_ifc();
        if (mainCmdLogging_ifc == null) {
            mainCmdLogging_ifc = new MainCmdLoggingStream(System.out);
        }
        this.log = mainCmdLogging_ifc;
        this.scriptThread = new JZcmdThread();
        this.scriptLevel = new ExecuteLevel(this.scriptThread);
    }

    public Map<String, DataAccess.Variable<Object>> scriptVariables() {
        return this.scriptLevel.localVariables;
    }

    public ExecuteLevel scriptLevel() {
        return this.scriptLevel;
    }

    public long calctime() {
        return System.currentTimeMillis() - this.startmilli;
    }

    public void setScriptVariable(String string, char c, Object object, boolean bl) throws IllegalAccessException {
        DataAccess.createOrReplaceVariable(this.scriptLevel.localVariables, string, c, object, bl);
    }

    private Map<String, DataAccess.Variable<Object>> genScriptVariables(JZcmdScript jZcmdScript, boolean bl, Map<String, DataAccess.Variable<Object>> map, CharSequence charSequence) throws ScriptException {
        this.bAccessPrivate = bl;
        try {
            Object object;
            if (charSequence == null && this.scriptLevel.currdir == null) {
                this.scriptLevel.currdir = new File("").getAbsoluteFile();
            } else if (charSequence != null) {
                this.scriptLevel.changeCurrDir(charSequence);
            }
            if (map != null) {
                for (Map.Entry<String, DataAccess.Variable<Object>> object22 : map.entrySet()) {
                    object = object22.getValue();
                    DataAccess.createOrReplaceVariable(this.scriptLevel.localVariables, ((DataAccess.Variable)object).name(), ((DataAccess.Variable)object).type(), ((DataAccess.Variable)object).value(), ((DataAccess.Variable)object).isConst());
                }
            }
            if (this.scriptLevel.localVariables.get("console") == null) {
                DataAccess.createOrReplaceVariable(this.scriptLevel.localVariables, "console", 'O', this.log, true);
            }
            if (this.scriptLevel.localVariables.get("out") == null) {
                DataAccess.createOrReplaceVariable(this.scriptLevel.localVariables, "out", 'A', System.out, true);
            }
            if (this.scriptLevel.localVariables.get("err") == null) {
                DataAccess.createOrReplaceVariable(this.scriptLevel.localVariables, "err", 'A', System.err, true);
            }
            if (this.scriptLevel.localVariables.get("null") == null) {
                DataAccess.createOrReplaceVariable(this.scriptLevel.localVariables, "null", 'O', null, true);
            }
            if (this.scriptLevel.localVariables.get("jzcmd") == null) {
                DataAccess.createOrReplaceVariable(this.scriptLevel.localVariables, "jzcmd", 'O', this, true);
            }
            if (this.scriptLevel.localVariables.get("test") == null) {
                DataAccess.createOrReplaceVariable(this.scriptLevel.localVariables, "test", 'O', new JZcmdTester(), true);
            }
            if (this.scriptLevel.localVariables.get("conv") == null) {
                DataAccess.createOrReplaceVariable(this.scriptLevel.localVariables, "conv", 'O', new Conversion(), true);
            }
            DataAccess.createOrReplaceVariable(this.scriptLevel.localVariables, "Math", 'C', Class.forName("java.lang.Math"), true);
            DataAccess.createOrReplaceVariable(this.scriptLevel.localVariables, "System", 'C', Class.forName("java.lang.System"), true);
            DataAccess.createOrReplaceVariable(this.scriptLevel.localVariables, "FileSystem", 'C', Class.forName("org.vishia.util.FileSystem"), true);
            DataAccess.createOrReplaceVariable(this.scriptLevel.localVariables, "StringFunctions", 'C', Class.forName("org.vishia.util.StringFunctions"), true);
            File file = jZcmdScript.fileScript;
            if (this.scriptLevel.localVariables.get("scriptfile") == null && file != null) {
                String string = file.getName();
                DataAccess.createOrReplaceVariable(this.scriptLevel.localVariables, "scriptfile", 'S', string, true);
                object = FileSystem.normalizePath(FileSystem.getDir(file));
                DataAccess.createOrReplaceVariable(this.scriptLevel.localVariables, "scriptdir", 'S', object, true);
            }
            if (this.scriptLevel.localVariables.get("nextNr") == null) {
                DataAccess.createOrReplaceVariable(this.scriptLevel.localVariables, "nextNr", 'O', new NextNr(), true);
            }
            Method method = this.getClass().getMethod("nextNr", new Class[0]);
            object = new DataAccess.ObjMethod(method, this);
            DataAccess.createOrReplaceVariable(this.scriptLevel.localVariables, "nextnr", 'M', object, true);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ScriptException("JZcmdExecuter.genScriptVariable - IllegalAccessException; " + illegalAccessException.getMessage());
        }
        catch (Exception exception) {
            throw new ScriptException("JZcmdExecuter.genScriptVariable - unexpected exception; " + exception.getMessage());
        }
        short s = this.scriptLevel.execute(jZcmdScript.scriptClass, null, 0, this.scriptLevel.localVariables, -1);
        if (s == -5) {
            throw new ScriptException(this.scriptThread.exception.getMessage(), this.scriptThread.excSrcfile, this.scriptThread.excLine, this.scriptThread.excColumn);
        }
        this.bScriptVariableGenerated = true;
        return this.scriptLevel.localVariables;
    }

    public CharSequence currdir() {
        return this.scriptLevel.currdir();
    }

    public void reset() {
        this.bScriptVariableGenerated = false;
        this.scriptLevel.localVariables.clear();
        this.jzcmdScript = null;
    }

    public void initialize(JZcmdScript jZcmdScript, boolean bl, Map<String, DataAccess.Variable<Object>> map, String string) throws ScriptException {
        this.scriptLevel.localVariables.clear();
        this.bAccessPrivate = bl;
        this.jzcmdScript = jZcmdScript;
        this.genScriptVariables(jZcmdScript, bl, map, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(JZcmdScript jZcmdScript, boolean bl, boolean bl2, Appendable appendable, String string) throws ScriptException {
        short s;
        OutputStreamWriter outputStreamWriter;
        Object object;
        Object object2;
        this.bAccessPrivate = bl;
        this.jzcmdScript = jZcmdScript;
        try {
            this.setScriptVariable("text", 'A', appendable, true);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ScriptException("JZcmd.execute - IllegalAccessException; " + illegalAccessException.getMessage());
        }
        if (!this.bScriptVariableGenerated) {
            this.genScriptVariables(this.jzcmdScript, bl, null, string);
        }
        ExecuteLevel executeLevel = new ExecuteLevel(this.jzcmdScript.scriptClass, this.scriptThread, this.scriptLevel, null);
        if (this.jzcmdScript.checkJZcmdXmlFile != null) {
            try {
                object2 = this.scriptLevel.evalString(this.jzcmdScript.checkJZcmdXmlFile);
            }
            catch (Exception exception) {
                throw new ScriptException("JZcmd.execute - String eval error on checkJZcmd; ", this.jzcmdScript.checkJZcmdXmlFile.srcFile, this.jzcmdScript.checkJZcmdXmlFile.srcLine, this.jzcmdScript.checkJZcmdXmlFile.srcColumn);
            }
            object = new SimpleXmlOutputter();
            try {
                outputStreamWriter = new OutputStreamWriter(new FileOutputStream(object2.toString()));
                ((SimpleXmlOutputter)object).write(outputStreamWriter, this.jzcmdScript.xmlSrc);
                outputStreamWriter.close();
                this.jzcmdScript.xmlSrc = null;
            }
            catch (IOException iOException) {
                throw new ScriptException(iOException);
            }
        }
        if (this.jzcmdScript.checkJZcmdFile != null) {
            try {
                object2 = executeLevel.evalString(this.jzcmdScript.checkJZcmdFile);
            }
            catch (Exception exception) {
                throw new ScriptException("JZcmd.execute - String eval error on checkJZcmd; ", this.jzcmdScript.checkJZcmdFile.srcFile, this.jzcmdScript.checkJZcmdFile.srcLine, this.jzcmdScript.checkJZcmdFile.srcColumn);
            }
            object = new File(object2.toString());
            try {
                outputStreamWriter = new FileWriter((File)object);
                this.jzcmdScript.writeStruct(outputStreamWriter);
                ((Writer)outputStreamWriter).close();
            }
            catch (IOException iOException) {
                throw new ScriptException("JZcmd.execute - File error on checkJZcmd; " + ((File)object).getAbsolutePath());
            }
        }
        object2 = this.jzcmdScript.getMain();
        this.startmilli = System.currentTimeMillis();
        this.startnano = System.nanoTime();
        this.textout = object = new StringFormatter(appendable, appendable instanceof Closeable, "\n", 200);
        if (object2 != null) {
            s = executeLevel.execute(((JZcmdScript.Subroutine)object2).statementlist, (StringFormatter)object, 0, executeLevel.localVariables, -1);
        } else {
            System.out.println("JZcmdExecuter - main routine not found.");
            s = 0;
        }
        try {
            ((StringFormatter)object).close();
        }
        catch (IOException iOException) {
            throw new RuntimeException("unexpected exception on close", iOException);
        }
        if (bl2) {
            boolean bl3 = true;
            while (bl3) {
                Queue<JZcmdThread> queue = this.threads;
                synchronized (queue) {
                    boolean bl4 = bl3 = this.threads.size() != 0;
                    if (bl3) {
                        try {
                            this.threads.wait(1000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
            }
        }
        if (s == -5) {
            if (this.scriptThread.exception instanceof ScriptException) {
                throw (ScriptException)this.scriptThread.exception;
            }
            throw new ScriptException(this.scriptThread.exception.toString(), this.scriptThread.excSrcfile, this.scriptThread.excLine, this.scriptThread.excColumn);
        }
    }

    public String execSub(JZcmdScript.Subroutine subroutine, Map<String, DataAccess.Variable<Object>> map, boolean bl, Appendable appendable, File file) throws Throwable {
        ExecuteLevel executeLevel = new ExecuteLevel(this.jzcmdScript.scriptClass, this.scriptThread, this.scriptLevel, null);
        executeLevel.localVariables.putAll(map);
        if (file != null) {
            executeLevel.changeCurrDir(file.getPath());
        }
        this.setScriptVariable("text", 'A', appendable, true);
        this.startmilli = System.currentTimeMillis();
        this.startnano = System.nanoTime();
        StringFormatter stringFormatter = new StringFormatter(appendable, appendable instanceof Closeable, "\n", 200);
        short s = executeLevel.execute(subroutine.statementlist, stringFormatter, 0, executeLevel.localVariables, -1);
        stringFormatter.close();
        if (s == -2 || s == -1) {
            s = 0;
        }
        if (s == -5) {
            throw this.scriptThread.exception;
        }
        return null;
    }

    public DataAccess.Variable<Object> getScriptVariable(String string) throws NoSuchFieldException {
        return DataAccess.getVariable(this.scriptLevel.localVariables, string, true);
    }

    public DataAccess.Variable<Object> removeScriptVariable(String string) {
        return this.scriptLevel.localVariables.remove(string);
    }

    protected IndexMultiTable<String, DataAccess.Variable<Object>> new_Variables() {
        return new IndexMultiTable<String, DataAccess.Variable<Object>>(IndexMultiTable.providerString);
    }

    public String nextNr() {
        return Integer.toString(++this.nextNr_);
    }

    void stop() {
    }

    protected static class JZcmdBindings
    implements Bindings {
        private final IndexMultiTable<String, DataAccess.Variable<Object>> vars;

        public JZcmdBindings(IndexMultiTable<String, DataAccess.Variable<Object>> indexMultiTable) {
            this.vars = indexMultiTable;
        }

        @Override
        public Object put(String string, Object object) {
            DataAccess.Variable<Object> variable = new DataAccess.Variable<Object>('O', string, object, false);
            return this.vars.put(string, variable);
        }

        @Override
        public boolean containsKey(Object object) {
            return this.vars.containsKey(object);
        }

        @Override
        public Object get(Object object) {
            DataAccess.Variable<Object> variable = this.vars.get(object);
            return variable == null ? null : variable.value();
        }

        @Override
        public void putAll(Map<? extends String, ? extends Object> map) {
        }

        @Override
        public Object remove(Object object) {
            return null;
        }

        @Override
        public void clear() {
        }

        @Override
        public boolean containsValue(Object object) {
            return false;
        }

        @Override
        public Set<Map.Entry<String, Object>> entrySet() {
            return null;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public Set<String> keySet() {
            return null;
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public Collection<Object> values() {
            return null;
        }
    }

    public static class ExitException
    extends Exception {
        private static final long serialVersionUID = 1L;
        public int exitLevel;

        public ExitException(int n) {
            this.exitLevel = n;
        }
    }

    public static class JZcmdThrow
    extends Exception {
        private static final long serialVersionUID = 1L;

        public JZcmdThrow(String string) {
            super(string);
        }
    }

    public static class CmdErrorLevelException
    extends Exception {
        private static final long serialVersionUID = 7785185972638755384L;
        public int errorLevel;

        public CmdErrorLevelException(int n) {
            super("cmd error level = " + n);
            this.errorLevel = n;
        }
    }

    public class NextNr {
        private int nr = 0;

        void start() {
            this.nr = 0;
        }

        void set(int n) {
            this.nr = n - 1;
        }

        public String toString() {
            return "" + ++this.nr;
        }
    }

    public final class ExecuteLevel
    implements ScriptContext,
    FilePath.FilePathEnvAccess {
        public final ExecuteLevel parent;
        int ctNesting = 0;
        final JZcmdThread threadData;
        final JZcmdScript.JZcmdClass jzClass;
        File currdir;
        public boolean bWriteErrorInOutput;
        public final IndexMultiTable<String, DataAccess.Variable<Object>> localVariables;
        public CmdExecuter cmdExecuter;
        private boolean isBreak;
        private boolean bForHasNext;
        private boolean debug_dataAccessArguments;
        public int cmdErrorlevel = 0;

        protected ExecuteLevel(JZcmdScript.JZcmdClass jZcmdClass, JZcmdThread jZcmdThread, ExecuteLevel executeLevel, Map<String, DataAccess.Variable<Object>> map) {
            this.parent = executeLevel;
            this.jzClass = jZcmdClass;
            this.threadData = jZcmdThread;
            if (executeLevel != null) {
                this.currdir = executeLevel.currdir;
            }
            this.localVariables = JZcmdExecuter.this.new_Variables();
            if (map != null) {
                this.localVariables.putAll(map);
            } else if (JZcmdExecuter.this.scriptLevel != null) {
                for (Map.Entry<String, DataAccess.Variable<Object>> entry : JZcmdExecuter.this.scriptLevel.localVariables.entrySet()) {
                    DataAccess.Variable<Object> variable = entry.getValue();
                    String string = entry.getKey();
                    if (string.equals("jzcmdsub")) continue;
                    if (variable.isConst()) {
                        this.localVariables.put(string, variable);
                        continue;
                    }
                    DataAccess.Variable<Object> variable2 = new DataAccess.Variable<Object>(variable);
                    this.localVariables.put(string, variable2);
                }
            }
            try {
                DataAccess.createOrReplaceVariable(this.localVariables, "jzcmdsub", 'O', this, true);
                this.localVariables.add("error", jZcmdThread.error);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new RuntimeException(illegalAccessException);
            }
        }

        protected ExecuteLevel(JZcmdThread jZcmdThread) {
            this(null, jZcmdThread, null, null);
        }

        public JZcmdExecuter executer() {
            return JZcmdExecuter.this;
        }

        public JZcmdEngine scriptEngine() {
            return JZcmdExecuter.this.jzcmdScript.getEngine();
        }

        public MainCmdLogging_ifc log() {
            return JZcmdExecuter.this.log;
        }

        public void setLocalVariable(String string, char c, Object object, boolean bl) throws IllegalAccessException {
            DataAccess.createOrReplaceVariable(this.localVariables, string, c, object, bl);
        }

        public short executeNewlevel(JZcmdScript.JZcmdClass jZcmdClass, JZcmdScript.StatementList statementList, StringFormatter stringFormatter, int n, int n2) throws Exception {
            ExecuteLevel executeLevel = statementList.bContainsVariableDef ? new ExecuteLevel(jZcmdClass, this.threadData, this, this.localVariables) : this;
            return executeLevel.execute(statementList, stringFormatter, n, executeLevel.localVariables, n2);
        }

        private short execute(JZcmdScript.StatementList statementList, StringFormatter stringFormatter, int n, Map<String, DataAccess.Variable<Object>> map, int n2) {
            ++this.ctNesting;
            int n3 = n;
            int n4 = -1;
            int n5 = 0;
            while (n5 == 0 && ++n4 < statementList.statements.size()) {
                char c;
                JZcmdScript.JZcmditem jZcmditem = statementList.statements.get(n4);
                int n6 = 0;
                if (jZcmditem.elementType() == 'D') {
                    n6 = this.debug(jZcmditem);
                    if (++n4 < statementList.statements.size()) {
                        jZcmditem = statementList.statements.get(n4);
                    }
                } else {
                    n6 = n2;
                }
                if (n6 >= 0) {
                    Debugutil.stop();
                }
                try {
                    switch (jZcmditem.elementType()) {
                        case 't': {
                            this.executeText(jZcmditem, stringFormatter, n3);
                            break;
                        }
                        case '@': {
                            this.execSetColumn((JZcmdScript.TextColumn)jZcmditem, stringFormatter);
                            break;
                        }
                        case 'n': {
                            stringFormatter.append(JZcmdExecuter.this.newline);
                            break;
                        }
                        case '!': {
                            stringFormatter.flush();
                            break;
                        }
                        case '_': {
                            stringFormatter.close();
                            stringFormatter = null;
                            break;
                        }
                        case '\\': {
                            stringFormatter.append(jZcmditem.textArg);
                            break;
                        }
                        case 'T': {
                            n5 = this.textAppendToVar((JZcmdScript.TextOut)jZcmditem, --n6);
                            break;
                        }
                        case ':': {
                            n5 = this.textAppendToOut(jZcmditem, stringFormatter, --n6);
                            break;
                        }
                        case 'A': {
                            break;
                        }
                        case 'U': {
                            n5 = this.defineExpr(map, (JZcmdScript.DefVariable)jZcmditem);
                            break;
                        }
                        case 'S': {
                            n5 = this.defineExpr(map, (JZcmdScript.DefVariable)jZcmditem);
                            break;
                        }
                        case 'P': {
                            StringBuilder stringBuilder = new StringBuilder();
                            this.executeDefVariable(map, (JZcmdScript.DefVariable)jZcmditem, 'P', stringBuilder, true);
                            break;
                        }
                        case 'L': {
                            ArrayList arrayList = this.evalObject(jZcmditem, true);
                            if (arrayList == retException) {
                                n5 = -5;
                                break;
                            }
                            if (arrayList != null && !(arrayList instanceof Iterable)) {
                                throw new NoSuchFieldException("JZcmdExecuter - exec variable must be of type Iterable ;" + ((JZcmdScript.DefVariable)jZcmditem).defVariable);
                            }
                            if (arrayList == null) {
                                arrayList = new ArrayList();
                            }
                            this.executeDefVariable(map, (JZcmdScript.DefVariable)jZcmditem, 'L', arrayList, true);
                            break;
                        }
                        case 'M': {
                            n5 = this.exec_DefMapVariable((JZcmdScript.DefVariable)jZcmditem, map);
                            break;
                        }
                        case 'W': {
                            n5 = this.executeOpenfile(map, (JZcmdScript.DefVariable)jZcmditem);
                            break;
                        }
                        case 'C': {
                            n5 = this.exec_DefClassVariable((JZcmdScript.DefClassVariable)jZcmditem, map);
                            break;
                        }
                        case 'J': {
                            n5 = this.addClassLoader((JZcmdScript.DefClasspathVariable)jZcmditem, map);
                            break;
                        }
                        case 'O': {
                            Object object = this.evalObject(jZcmditem, false);
                            if (object == retException) {
                                n5 = -5;
                                break;
                            }
                            this.executeDefVariable(map, (JZcmdScript.DefVariable)jZcmditem, 'O', object, false);
                            break;
                        }
                        case 'K': {
                            CalculatorExpr.Value value = this.evalValue(jZcmditem, false);
                            if (value == retException) {
                                n5 = -5;
                                break;
                            }
                            this.executeDefVariable(map, (JZcmdScript.DefVariable)jZcmditem, 'K', value, false);
                            break;
                        }
                        case 'Q': {
                            Boolean bl = new Boolean(this.evalCondition(jZcmditem));
                            if (bl == retException) {
                                n5 = -5;
                                break;
                            }
                            this.executeDefVariable(map, (JZcmdScript.DefVariable)jZcmditem, 'Q', bl, false);
                            break;
                        }
                        case 'e': {
                            n5 = this.executeDatatext((JZcmdScript.DataText)jZcmditem, stringFormatter);
                            break;
                        }
                        case 's': {
                            n5 = this.execCall((JZcmdScript.CallStatement)jZcmditem, null, stringFormatter, n3, --n6);
                            break;
                        }
                        case 'x': {
                            n5 = this.executeThread(map, (JZcmdScript.ThreadBlock)jZcmditem);
                            break;
                        }
                        case 'm': {
                            this.executeMove((JZcmdScript.CallStatement)jZcmditem);
                            break;
                        }
                        case 'y': {
                            this.executeCopy((JZcmdScript.CallStatement)jZcmditem);
                            break;
                        }
                        case 'l': {
                            this.executeDelete((JZcmdScript.CallStatement)jZcmditem);
                            break;
                        }
                        case 'c': {
                            this.exec_cmdline((JZcmdScript.CmdInvoke)jZcmditem);
                            break;
                        }
                        case 'd': {
                            n5 = this.executeChangeCurrDir(jZcmditem);
                            break;
                        }
                        case 'f': {
                            n5 = this.execForContainer((JZcmdScript.ForStatement)jZcmditem, stringFormatter, n3, --n6);
                            break;
                        }
                        case 'B': {
                            n5 = this.execNestedLevel(jZcmditem, stringFormatter, n3, --n6);
                            break;
                        }
                        case 'i': {
                            n5 = this.executeIfStatement((JZcmdScript.IfStatement)jZcmditem, stringFormatter, n3, --n6);
                            break;
                        }
                        case 'w': {
                            n5 = this.whileStatement((JZcmdScript.CondStatement)jZcmditem, stringFormatter, n3, --n6);
                            break;
                        }
                        case 'u': {
                            n5 = this.dowhileStatement((JZcmdScript.CondStatement)jZcmditem, stringFormatter, n3, --n6);
                            break;
                        }
                        case 'N': {
                            n5 = this.exec_hasNext(jZcmditem, stringFormatter, n3, --n6);
                            break;
                        }
                        case '=': {
                            n5 = this.assignStatement(jZcmditem);
                            break;
                        }
                        case '+': {
                            n5 = this.appendExpr((JZcmdScript.AssignExpr)jZcmditem);
                            break;
                        }
                        case '?': {
                            break;
                        }
                        case 'z': {
                            throw new ExitException(((JZcmdScript.ExitStatement)jZcmditem).exitValue);
                        }
                        case 'r': {
                            this.execThrow(jZcmditem);
                            break;
                        }
                        case 'v': {
                            this.execThrowonerror((JZcmdScript.Onerror)jZcmditem);
                            break;
                        }
                        case ',': {
                            this.bWriteErrorInOutput = jZcmditem.textArg != null;
                            break;
                        }
                        case 'b': {
                            this.isBreak = true;
                            n5 = -1;
                            break;
                        }
                        case '#': {
                            n5 = this.execCmdError((JZcmdScript.Onerror)jZcmditem, stringFormatter, n3);
                            break;
                        }
                        case 'F': {
                            n5 = this.createFilepath(map, (JZcmdScript.DefVariable)jZcmditem);
                            break;
                        }
                        case 'G': {
                            n5 = this.createFileSet(map, (JZcmdScript.UserFileset)jZcmditem);
                            break;
                        }
                        case 'Z': {
                            n5 = this.exec_zmake((JZcmdScript.Zmake)jZcmditem, stringFormatter, n3, --n6);
                            break;
                        }
                        case 'D': {
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("JZcmd.execute - unknown statement; ");
                        }
                    }
                }
                catch (Exception exception) {
                    this.threadData.exception = exception instanceof InvocationTargetException ? exception.getCause() : exception;
                    this.threadData.excStatement = jZcmditem;
                    this.threadData.excLine = jZcmditem.srcLine;
                    this.threadData.excColumn = jZcmditem.srcColumn;
                    this.threadData.excSrcfile = jZcmditem.srcFile;
                    StringBuilder stringBuilder = new StringBuilder(1000);
                    stringBuilder.append(this.threadData.exception.toString()).append("; in statement: ");
                    jZcmditem.writeStructLine(stringBuilder);
                    this.threadData.error.setValue(stringBuilder);
                    StringBuilder stringBuilder2 = stringBuilder;
                    if (this.bWriteErrorInOutput) {
                        try {
                            stringFormatter.append("<?? ").append(stringBuilder2).append(" ??>");
                        }
                        catch (IOException iOException) {
                            throw new RuntimeException(iOException);
                        }
                        this.threadData.error.setValue(null);
                        this.threadData.exception = null;
                        this.threadData.excStatement = null;
                    }
                    n5 = -5;
                }
                if (n5 != -5) continue;
                boolean bl = false;
                int n7 = 0;
                Throwable throwable = this.threadData.exception;
                if (throwable instanceof ExitException) {
                    c = 'e';
                    n7 = ((ExitException)throwable).exitLevel;
                } else {
                    c = throwable instanceof IOException ? (char)'f' : (throwable instanceof CmdErrorLevelException ? (char)'c' : (throwable instanceof NoSuchFieldException || throwable instanceof NoSuchMethodException ? (char)'n' : 'i'));
                }
                JZcmdScript.JZcmditem jZcmditem2 = null;
                while (++n4 < statementList.statements.size() && (jZcmditem2 = statementList.statements.get(n4)).elementType() != '?') {
                }
                if (n4 < statementList.statements.size()) {
                    assert (jZcmditem2 != null);
                    do {
                        JZcmdScript.Onerror onerror = (JZcmdScript.Onerror)jZcmditem2;
                        char c2 = onerror.errorType;
                        if (c2 != c && (c2 != '?' || c == 'e')) continue;
                        boolean bl2 = bl = c != 'e' || n7 >= onerror.errorLevel;
                    } while (!bl && ++n4 < statementList.statements.size() && (jZcmditem = statementList.statements.get(n4)).elementType() == '?');
                }
                if (bl) {
                    assert (jZcmditem2 != null);
                    n5 = this.execute(jZcmditem2.statementlist, stringFormatter, n3, this.localVariables, -1);
                    if (n5 == -5) continue;
                    this.threadData.error.setValue(null);
                    this.threadData.exception = null;
                    this.threadData.excStatement = null;
                    continue;
                }
                n5 = -5;
                assert (this.threadData.exception != null);
            }
            this.endExecution();
            return (short)n5;
        }

        private void endExecution() {
            if (--this.ctNesting <= 0) {
                assert (this.ctNesting == 0);
                if (this.cmdExecuter != null) {
                    this.cmdExecuter.close();
                    this.cmdExecuter = null;
                }
            }
        }

        void executeText(JZcmdScript.JZcmditem jZcmditem, Appendable appendable, int n) throws IOException {
            int n2;
            int n3 = 0;
            if (jZcmditem.textArg.startsWith("  ")) {
                JZcmdExecuter.this.stop();
            }
            int n4 = jZcmditem.textArg.length();
            do {
                int n5 = 10;
                n2 = jZcmditem.textArg.indexOf(n5, n3);
                int n6 = jZcmditem.textArg.indexOf(13, n3);
                if (n6 >= 0 && (n6 < n2 || n2 < 0)) {
                    n2 = n6;
                    n5 = 13;
                }
                if (n2 >= 0) {
                    appendable.append(jZcmditem.textArg.substring(n3, n2));
                    appendable.append(JZcmdExecuter.this.newline);
                    if (++n2 < n4) {
                        char c;
                        int n7;
                        if (n5 == 13) {
                            if (jZcmditem.textArg.charAt(n2) == '\n') {
                                ++n2;
                            }
                        } else if (jZcmditem.textArg.charAt(n2) == '\r') {
                            ++n2;
                        }
                        for (n7 = n; n7 > 0 && n2 < n4 && ((c = jZcmditem.textArg.charAt(n2)) == ' ' || c == '\t'); ++n2, --n7) {
                        }
                        while (--n7 >= 0 && n2 < n4 && (c = jZcmditem.textArg.charAt(n2)) == ':') {
                            ++n2;
                        }
                    }
                    n3 = n2;
                    continue;
                }
                appendable.append(jZcmditem.textArg.substring(n3));
            } while (n2 >= 0);
        }

        void execSetColumn(JZcmdScript.TextColumn textColumn, StringFormatter stringFormatter) throws Exception {
            int n = -1;
            int n2 = -1;
            if (textColumn.expression != null) {
                CalculatorExpr.Value value = this.calculateExpression(textColumn.expression);
                n = value.intValue();
            }
            stringFormatter.pos(n, n2);
        }

        void executeDefVariable(Map<String, DataAccess.Variable<Object>> map, JZcmdScript.DefVariable defVariable, char c, Object object, boolean bl) throws Exception {
            if (defVariable.typeVariable != null) {
                Debugutil.stop();
            }
            this.storeValue(defVariable.defVariable, map, object, JZcmdExecuter.this.bAccessPrivate);
        }

        short createFilepath(Map<String, DataAccess.Variable<Object>> map, JZcmdScript.DefVariable defVariable) throws Exception {
            CharSequence charSequence = this.evalString(defVariable);
            if (charSequence == retException) {
                return -5;
            }
            JZcmdFilepath jZcmdFilepath = new JZcmdFilepath(this, charSequence.toString());
            this.storeValue(defVariable.defVariable, map, jZcmdFilepath, false);
            return 0;
        }

        short createFileSet(Map<String, DataAccess.Variable<Object>> map, JZcmdScript.UserFileset userFileset) throws Exception {
            JZcmdFileset jZcmdFileset = new JZcmdFileset(this, userFileset);
            this.storeValue(userFileset.defVariable, map, jZcmdFileset, false);
            return 0;
        }

        private short execForContainer(JZcmdScript.ForStatement forStatement, StringFormatter stringFormatter, int n, int n2) throws Exception {
            JZcmdScript.StatementList statementList = forStatement.statementlist();
            ExecuteLevel executeLevel = this;
            DataAccess.Variable<Object> variable = DataAccess.createOrReplaceVariable(executeLevel.localVariables, forStatement.forVariable, 'O', null, false);
            Object object = this.dataAccess(forStatement.forContainer, this.localVariables, JZcmdExecuter.this.bAccessPrivate, true, false, null);
            boolean bl = true;
            short s = 0;
            boolean bl2 = this.bForHasNext;
            if (object instanceof String && ((String)object).startsWith("<?")) {
                throw new IllegalArgumentException("JZcmd.execFor - faulty container type;" + (String)object);
            }
            if (object != null && object instanceof Iterable) {
                Iterator iterator = ((Iterable)object).iterator();
                while (bl && !executeLevel.isBreak() && iterator.hasNext()) {
                    boolean bl3 = bl = s == 0;
                    if (bl && forStatement.condition != null) {
                        bl = this.evalCondition(forStatement.condition);
                    }
                    if (!bl) continue;
                    Object t = iterator.next();
                    variable.setValue(t);
                    this.bForHasNext = iterator.hasNext();
                    s = executeLevel.execute(statementList, stringFormatter, n, executeLevel.localVariables, n2);
                }
            } else if (object != null && object instanceof Map) {
                Map map = (Map)object;
                Set set = map.entrySet();
                Iterator iterator = set.iterator();
                while (bl && !executeLevel.isBreak() && iterator.hasNext()) {
                    boolean bl4 = bl = s == 0;
                    if (bl && forStatement.condition != null) {
                        bl = this.evalCondition(forStatement.condition);
                    }
                    if (!bl) continue;
                    Map.Entry entry = iterator.next();
                    Object v = entry.getValue();
                    variable.setValue(v);
                    this.bForHasNext = iterator.hasNext();
                    s = executeLevel.execute(statementList, stringFormatter, n, executeLevel.localVariables, n2);
                }
            } else if (object != null && object.getClass().isArray()) {
                Object[] objectArray = (Object[])object;
                int n3 = objectArray.length;
                int n4 = -1;
                while (bl && !executeLevel.isBreak() && ++n4 < n3) {
                    boolean bl5 = bl = s == 0;
                    if (bl && forStatement.condition != null) {
                        bl = this.evalCondition(forStatement.condition);
                    }
                    if (!bl) continue;
                    Object object2 = objectArray[n4];
                    variable.setValue(object2);
                    this.bForHasNext = n4 < n3 - 1;
                    s = executeLevel.execute(statementList, stringFormatter, n, executeLevel.localVariables, n2);
                }
            }
            this.bForHasNext = bl2;
            if (s == -1) {
                s = 0;
            }
            return s;
        }

        short exec_hasNext(JZcmdScript.JZcmditem jZcmditem, StringFormatter stringFormatter, int n, int n2) throws Exception {
            short s = 0;
            if (this.bForHasNext) {
                JZcmdScript.StatementList statementList = jZcmditem.statementlist();
                if (statementList != null) {
                    s = this.execute(jZcmditem.statementlist(), stringFormatter, n, this.localVariables, n2);
                } else if (jZcmditem.textArg != null) {
                    this.executeText(jZcmditem, stringFormatter, n);
                }
            }
            return s;
        }

        short executeIfStatement(JZcmdScript.IfStatement ifStatement, StringFormatter stringFormatter, int n, int n2) throws Exception {
            short s = -3;
            Iterator<JZcmdScript.JZcmditem> iterator = ifStatement.statementlist.statements.iterator();
            block4: while (iterator.hasNext() && s == -3) {
                JZcmdScript.JZcmditem jZcmditem = iterator.next();
                switch (jZcmditem.elementType()) {
                    case 'g': {
                        s = this.executeIfBlock((JZcmdScript.IfCondition)jZcmditem, stringFormatter, n, n2);
                        continue block4;
                    }
                    case 'E': {
                        s = this.execute(jZcmditem.statementlist, stringFormatter, n, this.localVariables, n2);
                        continue block4;
                    }
                }
                throw new IllegalArgumentException("JZcmd.execIf - unknown statement; " + jZcmditem.elementType());
            }
            if (s == -1) {
                s = -1;
            }
            if (s == -3) {
                s = 0;
            }
            return s;
        }

        short whileStatement(JZcmdScript.CondStatement condStatement, StringFormatter stringFormatter, int n, int n2) throws Exception {
            boolean bl;
            short s = 0;
            do {
                boolean bl2 = bl = s == 0 && this.evalCondition(condStatement.condition);
                if (!bl) continue;
                s = this.execute(condStatement.statementlist, stringFormatter, n, this.localVariables, n2);
            } while (bl);
            if (s == -1) {
                s = 0;
            }
            return s;
        }

        short dowhileStatement(JZcmdScript.CondStatement condStatement, StringFormatter stringFormatter, int n, int n2) throws Exception {
            short s;
            boolean bl;
            while (bl = (s = this.execute(condStatement.statementlist, stringFormatter, n, this.localVariables, n2)) == 0 && this.evalCondition(condStatement.condition)) {
            }
            if (s == -1) {
                s = 0;
            }
            return s;
        }

        short executeIfBlock(JZcmdScript.IfCondition ifCondition, StringFormatter stringFormatter, int n, int n2) throws Exception {
            boolean bl = this.evalCondition(ifCondition.condition);
            short s = bl ? this.execute(ifCondition.statementlist, stringFormatter, n, this.localVariables, n2) : (short)-3;
            return s;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        short textAppendToOut(JZcmdScript.JZcmditem jZcmditem, StringFormatter stringFormatter, int n) throws Exception {
            short s;
            if (jZcmditem.statementlist != null) {
                StringFormatter stringFormatter2 = stringFormatter;
                synchronized (stringFormatter2) {
                    s = this.execute(jZcmditem.statementlist, stringFormatter, jZcmditem.srcColumn, this.localVariables, n);
                }
            }
            CharSequence charSequence = this.evalString(jZcmditem);
            short s2 = s = charSequence == retException ? (short)-5 : 0;
            if (charSequence != null) {
                StringFormatter stringFormatter3 = stringFormatter;
                synchronized (stringFormatter3) {
                    stringFormatter.append(charSequence);
                }
            }
            return s;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        short textAppendToVar(JZcmdScript.TextOut textOut, int n) throws Exception {
            short s;
            StringFormatter stringFormatter;
            Object object;
            Object object2;
            if (textOut.variable != null) {
                object2 = this.dataAccess(textOut.variable, this.localVariables, JZcmdExecuter.this.bAccessPrivate, false, true, null);
                if (object2 instanceof DataAccess.Variable) {
                    DataAccess.Variable variable = (DataAccess.Variable)object2;
                    object = variable.value();
                    if (object == null && variable.type() == 'A') {
                        object = new StringPartAppend();
                        variable.setValue(object);
                    }
                } else {
                    object = object2;
                }
                if (object instanceof StringFormatter) {
                    stringFormatter = (StringFormatter)object;
                } else if (object instanceof Appendable) {
                    stringFormatter = new StringFormatter((Appendable)object, object instanceof Closeable, "\n", 200);
                } else {
                    this.throwIllegalDstArgument("variable should be Appendable", textOut.variable, textOut);
                    stringFormatter = new StringFormatter();
                }
            } else {
                stringFormatter = JZcmdExecuter.this.textout;
            }
            if (textOut.statementlist != null) {
                object = stringFormatter;
                synchronized (object) {
                    s = this.execute(textOut.statementlist, stringFormatter, textOut.srcColumn, this.localVariables, n);
                }
            }
            object = this.evalString(textOut);
            short s2 = s = object == retException ? (short)-5 : 0;
            if (object != null) {
                object2 = stringFormatter;
                synchronized (object2) {
                    stringFormatter.append((CharSequence)object);
                }
            }
            return s;
        }

        private short execCall(JZcmdScript.CallStatement callStatement, List<DataAccess.Variable<Object>> list, StringFormatter stringFormatter, int n, int n2) throws IllegalArgumentException, Exception {
            short s = 0;
            CharSequence charSequence = this.evalString(callStatement.call_Name);
            JZcmdScript.Subroutine subroutine = this.jzClass.subroutines.get(charSequence);
            if (subroutine == null) {
                subroutine = JZcmdExecuter.this.jzcmdScript.getSubroutine(charSequence);
            }
            if (subroutine == null) {
                throw new NoSuchElementException("JbatExecuter - subroutine not found; " + charSequence);
            }
            JZcmdScript.JZcmdClass jZcmdClass = (JZcmdScript.JZcmdClass)subroutine.parentList;
            ExecuteLevel executeLevel = subroutine.useLocals ? this : new ExecuteLevel(jZcmdClass, this.threadData, this, subroutine.useLocals ? this.localVariables : null);
            s = this.execSubroutine(subroutine, executeLevel, callStatement.actualArgs, list, stringFormatter, n, n2);
            if (s == 0 && (callStatement.variable != null || callStatement.assignObjs != null)) {
                DataAccess.Variable<Object> variable = executeLevel.localVariables.get("return");
                Object object = variable != null ? variable.value() : null;
                this.assignObj(callStatement, object, false);
            }
            return s;
        }

        public Object evalSubroutine(JZcmdScript.Subroutine subroutine, Map<String, DataAccess.Variable<Object>> map, StringFormatter stringFormatter, int n) throws ScriptException {
            short s;
            try {
                s = this.execSubroutine(subroutine, map, null, -1);
            }
            catch (Exception exception) {
                throw new ScriptException(exception);
            }
            if (s != 0) {
                throw new ScriptException(this.threadData.exception.getMessage(), this.threadData.excSrcfile, this.threadData.excLine, this.threadData.excColumn);
            }
            return null;
        }

        public short execSubroutine(JZcmdScript.Subroutine subroutine, Map<String, DataAccess.Variable<Object>> map, StringFormatter stringFormatter, int n) {
            short s;
            LinkedList<DataAccess.Variable<Object>> linkedList;
            JZcmdScript.JZcmdClass jZcmdClass = (JZcmdScript.JZcmdClass)subroutine.parentList;
            ExecuteLevel executeLevel = subroutine.useLocals ? this : new ExecuteLevel(jZcmdClass, this.threadData, this, subroutine.useLocals ? this.localVariables : null);
            if (map != null) {
                linkedList = new LinkedList<DataAccess.Variable<Object>>();
                for (Map.Entry<String, DataAccess.Variable<Object>> entry : map.entrySet()) {
                    linkedList.add(entry.getValue());
                }
            } else {
                linkedList = null;
            }
            try {
                s = this.execSubroutine(subroutine, executeLevel, null, linkedList, stringFormatter, n, -1);
            }
            catch (Exception exception) {
                s = -5;
            }
            return s;
        }

        private short execSubroutine(JZcmdScript.Subroutine subroutine, ExecuteLevel executeLevel, List<JZcmdScript.Argument> list, List<DataAccess.Variable<Object>> list2, StringFormatter stringFormatter, int n, int n2) throws Exception {
            short s = 0;
            if (subroutine.formalArgs != null) {
                char c;
                Object object;
                Object object2;
                TreeMap<String, JZcmdScript.DefVariable> treeMap = new TreeMap<String, JZcmdScript.DefVariable>();
                for (JZcmdScript.DefVariable object3 : subroutine.formalArgs) {
                    treeMap.put(object3.getVariableIdent(), object3);
                }
                if (list != null) {
                    for (JZcmdScript.Argument argument : list) {
                        object2 = this.evalObject(argument, false);
                        object = (JZcmdScript.DefVariable)treeMap.remove(argument.getIdent());
                        if (object == null) {
                            throw new IllegalArgumentException("execSubroutine - unexpected argument; " + argument.identArgJbat);
                        }
                        c = ((JZcmdScript.JZcmditem)object).elementType();
                        switch (c) {
                            case 'F': {
                                object2 = this.convert2FilePath(object2);
                            }
                        }
                        DataAccess.createOrReplaceVariable(executeLevel.localVariables, argument.identArgJbat, c, object2, false);
                    }
                }
                if (list2 != null) {
                    for (DataAccess.Variable variable : list2) {
                        object2 = variable.name();
                        object = (JZcmdScript.DefVariable)treeMap.remove(object2);
                        if (object == null) {
                            throw new IllegalArgumentException("execSubroutine - unexpected additial argument; " + (String)object2);
                        }
                        c = ((JZcmdScript.JZcmditem)object).elementType();
                        DataAccess.createOrReplaceVariable(executeLevel.localVariables, (String)object2, c, variable.value(), false);
                    }
                }
                for (Map.Entry entry : treeMap.entrySet()) {
                    object2 = (JZcmdScript.DefVariable)entry.getValue();
                    object = JZcmdExecuter.this.scriptLevel.evalObject((JZcmdScript.JZcmditem)object2, false);
                    String string = ((JZcmdScript.DefVariable)object2).getVariableIdent();
                    char c2 = ((JZcmdScript.JZcmditem)object2).elementType();
                    if (c2 == 'F' && !(object instanceof JZcmdFilepath)) {
                        object = new JZcmdFilepath(this, object.toString());
                    }
                    DataAccess.createOrReplaceVariable(executeLevel.localVariables, string, c2, object, false);
                }
            } else if (list != null) {
                throw new IllegalArgumentException("execSubroutine -  not expected arguments");
            }
            s = executeLevel.execute(subroutine.statementlist, stringFormatter, n, executeLevel.localVariables, n2);
            return s;
        }

        private short exec_zmake(JZcmdScript.Zmake zmake, StringFormatter stringFormatter, int n, int n2) throws IllegalArgumentException, Exception {
            ZmakeTarget zmakeTarget = new ZmakeTarget(this, zmake.name);
            Object object2 = this.evalObject(zmake.jzoutput, false);
            zmakeTarget.output = this.convert2FilePath(object2);
            for (JZcmdScript.AccessFilesetname object3 : zmake.input) {
                JZcmdAccessFileset jZcmdAccessFileset = new JZcmdAccessFileset(object3, object3.filesetVariableName, this);
                if (zmakeTarget.inputs == null) {
                    zmakeTarget.inputs = new ArrayList<JZcmdAccessFileset>();
                }
                zmakeTarget.inputs.add(jZcmdAccessFileset);
            }
            LinkedList linkedList = new LinkedList();
            DataAccess.Variable<ZmakeTarget> variable = new DataAccess.Variable<ZmakeTarget>('O', "target", zmakeTarget, true);
            linkedList.add(variable);
            return this.execCall(zmake, linkedList, stringFormatter, n, n2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private short executeThread(Map<String, DataAccess.Variable<Object>> map, JZcmdScript.ThreadBlock threadBlock) throws Exception {
            String string;
            JZcmdThread jZcmdThread;
            if (threadBlock.threadVariable != null) {
                try {
                    jZcmdThread = new JZcmdThread();
                    string = threadBlock.threadVariable.idents().toString();
                    this.storeValue(threadBlock.threadVariable, map, jZcmdThread, JZcmdExecuter.this.bAccessPrivate);
                }
                catch (Exception exception) {
                    throw new IllegalArgumentException("JZcmd - thread assign failure; path=" + threadBlock.threadVariable.toString());
                }
            } else {
                jZcmdThread = new JZcmdThread();
                string = "JZcmd";
            }
            ExecuteLevel executeLevel = new ExecuteLevel(this.jzClass, jZcmdThread, this, this.localVariables);
            Queue<JZcmdThread> queue = JZcmdExecuter.this.threads;
            synchronized (queue) {
                JZcmdExecuter.this.threads.add(jZcmdThread);
            }
            jZcmdThread.startThread(string, executeLevel, threadBlock);
            return 0;
        }

        private short execNestedLevel(JZcmdScript.JZcmditem jZcmditem, StringFormatter stringFormatter, int n, int n2) throws Exception {
            ExecuteLevel executeLevel = this;
            short s = executeLevel.execute(jZcmditem.statementlist, stringFormatter, n, executeLevel.localVariables, n2);
            if (s == -1) {
                s = 0;
            }
            return s;
        }

        private void exec_cmdline(JZcmdScript.CmdInvoke cmdInvoke) throws IllegalArgumentException, Exception {
            Object object;
            LinkedList<Appendable> linkedList;
            Object object2;
            Object object3;
            Object object4;
            boolean bl = true;
            CharSequence charSequence = cmdInvoke.textArg == null ? this.evalString(cmdInvoke) : cmdInvoke.textArg;
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(charSequence.toString());
            if (cmdInvoke.cmdArgs != null) {
                boolean bl2 = true;
                for (JZcmdScript.JZcmditem iterator : cmdInvoke.cmdArgs) {
                    Object object5;
                    if (iterator.elementType == 'L') {
                        object5 = this.dataAccess(iterator.dataAccess, this.localVariables, JZcmdExecuter.this.bAccessPrivate, false, false, null);
                        if (!(object5 instanceof List)) continue;
                        object4 = (List)object5;
                        object3 = object4.iterator();
                        while (object3.hasNext()) {
                            object2 = object3.next();
                            arrayList.add(object2.toString());
                        }
                        continue;
                    }
                    object5 = this.evalString(iterator).toString();
                    arrayList.add((String)object5);
                }
            }
            if (cmdInvoke.bCmdCheck) {
                this.setLocalVariable("argsCheck", 'L', arrayList, true);
            }
            if (cmdInvoke.variable != null) {
                linkedList = new LinkedList<Appendable>();
                object = this.dataAccess(cmdInvoke.variable, this.localVariables, JZcmdExecuter.this.bAccessPrivate, false, false, null);
                if (object instanceof Appendable) {
                    linkedList.add((Appendable)object);
                } else {
                    this.throwIllegalDstArgument("variable should be Appendable", cmdInvoke.variable, cmdInvoke);
                }
                if (cmdInvoke.assignObjs != null) {
                    for (Object object5 : cmdInvoke.assignObjs) {
                        object = this.dataAccess((JZcmdScript.JZcmdDataAccess)object5, this.localVariables, JZcmdExecuter.this.bAccessPrivate, false, false, null);
                        if (object instanceof Appendable) {
                            linkedList.add((Appendable)object);
                            continue;
                        }
                        this.throwIllegalDstArgument("variable should be Appendable", cmdInvoke.variable, cmdInvoke);
                    }
                }
            } else {
                linkedList = null;
            }
            if (this.cmdExecuter == null) {
                this.cmdExecuter = new CmdExecuter();
                object = this.cmdExecuter.environment();
                ListIterator<DataAccess.Variable<Object>> listIterator = this.localVariables.iterator("$");
                boolean bl2 = true;
                while (bl2 && listIterator.hasNext()) {
                    object4 = (DataAccess.Variable)listIterator.next();
                    object3 = ((DataAccess.Variable)object4).name();
                    object2 = ((DataAccess.Variable)object4).value();
                    if (((String)object3).startsWith("$") && object2 != null) {
                        String string = object2.toString();
                        object.put(((String)object3).substring(1), string);
                        continue;
                    }
                    bl2 = false;
                }
                this.cmdExecuter.setCurrentDir(this.currdir);
            }
            object = new String[arrayList.size()];
            arrayList.toArray((T[])object);
            this.cmdErrorlevel = this.cmdExecuter.execute((String[])object, cmdInvoke.bShouldNotWait, null, (List<Appendable>)linkedList, null);
        }

        short execCmdError(JZcmdScript.Onerror onerror, StringFormatter stringFormatter, int n) throws Exception {
            short s = 0;
            if (this.cmdErrorlevel >= onerror.errorLevel) {
                s = this.execute(onerror.statementlist, stringFormatter, n, this.localVariables, -1);
            }
            return s;
        }

        short executeChangeCurrDir(JZcmdScript.JZcmditem jZcmditem) throws Exception {
            CharSequence charSequence = this.evalString(jZcmditem);
            if (charSequence == retException) {
                return -5;
            }
            this.changeCurrDir(charSequence);
            return 0;
        }

        protected void changeCurrDir(CharSequence charSequence) throws IllegalAccessException {
            CharSequence charSequence2;
            boolean bl = FileSystem.isAbsolutePathOrDrive(charSequence);
            if (bl) {
                charSequence2 = FileSystem.normalizePath(charSequence);
            } else {
                if (this.currdir == null) {
                    this.currdir = new File("").getAbsoluteFile();
                }
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(this.currdir.getPath()).append(charSequence);
                charSequence2 = FileSystem.normalizePath(stringBuilder);
            }
            this.currdir = new File(charSequence2.toString());
            if (!this.currdir.exists() || !this.currdir.isDirectory()) {
                throw new IllegalArgumentException("JZcmdExecuter - cd, dir not exists; " + charSequence);
            }
            this.setLocalVariable("currdir", 'O', this.currdir, true);
        }

        private short executeDatatext(JZcmdScript.DataText dataText, Appendable appendable) throws IllegalArgumentException, Exception {
            CharSequence charSequence = "??";
            Object object = this.dataAccess(dataText.dataAccess, this.localVariables, JZcmdExecuter.this.bAccessPrivate, false, false, null);
            if (object == retException) {
                return -5;
            }
            if (dataText.format != null) {
                if (object instanceof CalculatorExpr.Value) {
                    object = ((CalculatorExpr.Value)object).objValue();
                }
                charSequence = String.format(JZcmdExecuter.this.locale, dataText.format, object);
            } else {
                charSequence = object == null ? null : (object instanceof CharSequence ? (CharSequence)object : object.toString());
            }
            if (charSequence != null) {
                appendable.append(charSequence);
            }
            return 0;
        }

        void executeMove(JZcmdScript.CallStatement callStatement) throws IllegalArgumentException, Exception {
            File file;
            CharSequence charSequence = this.evalString(callStatement.actualArgs.get(0));
            CharSequence charSequence2 = this.evalString(callStatement.actualArgs.get(1));
            File file2 = new File(charSequence.toString());
            boolean bl = file2.renameTo(file = new File(charSequence2.toString()));
            if (!bl) {
                throw new IOException("JbatchExecuter - move not successfully; " + file2.getAbsolutePath() + " to " + file.getAbsolutePath());
            }
        }

        void executeCopy(JZcmdScript.CallStatement callStatement) throws Exception {
            Object object;
            String string;
            File file;
            Object object2 = this.evalObject(callStatement.actualArgs.get(0), false);
            String string2 = object2 instanceof JZcmdFilepath ? ((JZcmdFilepath)object2).absfile().toString() : object2.toString();
            File file2 = new File(string2);
            int n = FileSystem.copyFile(file2, file = new File(string = (object = this.evalObject(callStatement.actualArgs.get(1), false)) instanceof JZcmdFilepath ? ((JZcmdFilepath)object).absfile().toString() : object.toString()));
            if (n < 0) {
                throw new FileNotFoundException("JbatchExecuter - copy src not found; " + file2.getAbsolutePath() + " to " + file.getAbsolutePath());
            }
        }

        void executeDelete(JZcmdScript.CallStatement callStatement) throws Exception {
            CharSequence charSequence = this.evalString(callStatement.actualArgs.get(0));
            boolean bl = FileSystem.delete(charSequence.toString());
            if (!bl) {
                throw new FileNotFoundException("JbatchExecuter - del not possible; " + charSequence);
            }
        }

        short executeOpenfile(Map<String, DataAccess.Variable<Object>> map, JZcmdScript.DefVariable defVariable) throws IllegalArgumentException, Exception {
            FileWriter fileWriter;
            CharSequence charSequence = this.evalString(defVariable);
            if (charSequence == retException) {
                return -5;
            }
            String string = charSequence.toString();
            if (!FileSystem.isAbsolutePath(string)) {
                File file = new File(this.currdir, string);
                fileWriter = new FileWriter(file);
            } else {
                fileWriter = new FileWriter(string);
            }
            this.storeValue(defVariable.defVariable, map, fileWriter, JZcmdExecuter.this.bAccessPrivate);
            return 0;
        }

        private short assignStatement(JZcmdScript.JZcmditem jZcmditem) throws IllegalArgumentException, Exception {
            return this.assignObj((JZcmdScript.AssignExpr)jZcmditem, null, true);
        }

        private short assignObj(JZcmdScript.AssignExpr assignExpr, Object object, boolean bl) throws IllegalArgumentException, Exception {
            Object object2;
            CalculatorExpr.Value value = null;
            Object object3 = object;
            int n = 0;
            Boolean bl2 = null;
            JZcmdScript.JZcmdDataAccess jZcmdDataAccess = assignExpr.variable;
            if (jZcmdDataAccess == null) {
                object2 = this.evalObject(assignExpr, false);
                n = object2 == retException ? -5 : 0;
            }
            Object object4 = object2 = assignExpr.assignObjs == null ? null : assignExpr.assignObjs.iterator();
            while (jZcmdDataAccess != null) {
                DataAccess.Dst dst = new DataAccess.Dst();
                Object object5 = this.dataAccess(jZcmdDataAccess, this.localVariables, JZcmdExecuter.this.bAccessPrivate, false, true, dst);
                if (object5 instanceof DataAccess.Variable) {
                    DataAccess.Variable variable = (DataAccess.Variable)object5;
                    char c = variable.type();
                    switch (c) {
                        case 'K': {
                            if (value != null) break;
                            value = this.evalValue(assignExpr, false);
                            break;
                        }
                        case 'Q': {
                            if (bl2 != null) break;
                            bl2 = new Boolean(this.evalCondition(assignExpr));
                            break;
                        }
                        default: {
                            if (object3 != null) break;
                            object3 = this.evalObject(assignExpr, false);
                        }
                    }
                    object5 = variable.value();
                    switch (variable.type()) {
                        case 'A': {
                            this.throwIllegalDstArgument("assign to appendable faulty", jZcmdDataAccess, assignExpr);
                            break;
                        }
                        case 'U': {
                            Object object6;
                            assert (object5 instanceof StringPartAppend);
                            StringPartAppend stringPartAppend = (StringPartAppend)object5;
                            stringPartAppend.clear();
                            Object object7 = object6 = object3 == null ? "--null--" : object3;
                            if (!(object6 instanceof CharSequence)) {
                                object6 = object6.toString();
                            }
                            stringPartAppend.append((CharSequence)object6);
                            break;
                        }
                        case 'S': {
                            if (object3 == null || object instanceof String || object instanceof StringSeq && ((StringSeq)object).isUnmated()) {
                                variable.setValue(object3);
                                break;
                            }
                            variable.setValue(object3.toString());
                            break;
                        }
                        case 'K': {
                            variable.setValue(value);
                            break;
                        }
                        case 'Q': {
                            variable.setValue(bl2);
                            break;
                        }
                        default: {
                            variable.setValue(object3);
                            break;
                        }
                    }
                } else {
                    if (object3 == null && (object3 = this.evalObject(assignExpr, false)) == retException) {
                        n = -5;
                    }
                    dst.set(object3);
                }
                if (object2 != null && object2.hasNext()) {
                    jZcmdDataAccess = (JZcmdScript.JZcmdDataAccess)object2.next();
                    continue;
                }
                jZcmdDataAccess = null;
            }
            return (short)n;
        }

        short defineExpr(Map<String, DataAccess.Variable<Object>> map, JZcmdScript.DefVariable defVariable) throws IllegalArgumentException, Exception {
            Object object;
            Object object2;
            Object object3;
            Object object4 = this.evalObject(defVariable, false);
            if (object4 == retException) {
                return -5;
            }
            switch (defVariable.elementType()) {
                case 'U': {
                    if (object4 == null) {
                        object3 = new StringPartAppend();
                        break;
                    }
                    object2 = object4 instanceof CharSequence ? (CharSequence)object4 : object4.toString();
                    object = new StringPartAppend();
                    ((StringPartAppend)object).append((CharSequence)object2);
                    object3 = object;
                    break;
                }
                case 'S': {
                    if (object4 == null || object4 instanceof String) {
                        object3 = object4;
                        break;
                    }
                    object3 = object4.toString();
                    break;
                }
                default: {
                    object3 = object4;
                }
            }
            object2 = defVariable.defVariable.datapath();
            if (object2.get(0).ident().equals("return") && !this.localVariables.containsKey("return")) {
                object = new DataAccess.Variable<IndexMultiTable<String, DataAccess.Variable<Object>>>('M', "return", JZcmdExecuter.this.new_Variables());
                this.localVariables.add("return", (DataAccess.Variable<Object>)object);
            }
            this.storeValue(defVariable.defVariable, map, object3, JZcmdExecuter.this.bAccessPrivate);
            if (this.cmdExecuter != null && ((String)(object = defVariable.defVariable.datapath().get(0).ident())).startsWith("$")) {
                this.cmdExecuter.environment().put((String)object, object3.toString());
            }
            return 0;
        }

        short appendExpr(JZcmdScript.AssignExpr assignExpr) throws IllegalArgumentException, Exception {
            Iterator<JZcmdScript.JZcmdDataAccess> iterator;
            Object object = this.evalObject(assignExpr, false);
            short s = object == retException ? (short)-5 : 0;
            JZcmdScript.JZcmdDataAccess jZcmdDataAccess = assignExpr.variable;
            Iterator<JZcmdScript.JZcmdDataAccess> iterator2 = iterator = assignExpr.assignObjs == null ? null : assignExpr.assignObjs.iterator();
            while (jZcmdDataAccess != null) {
                Object object2 = this.dataAccess(jZcmdDataAccess, this.localVariables, JZcmdExecuter.this.bAccessPrivate, false, false, null);
                if (object2 instanceof Appendable) {
                    if (!(object instanceof CharSequence)) {
                        object = object.toString();
                    }
                    ((Appendable)object2).append((CharSequence)object);
                } else if (object2 instanceof List) {
                    List list = (List)object2;
                    if (object instanceof List) {
                        for (Object e : (List)object) {
                            list.add(e);
                        }
                    } else {
                        list.add(object);
                    }
                } else {
                    this.throwIllegalDstArgument("dst should be Appendable", jZcmdDataAccess, assignExpr);
                }
                if (iterator != null && iterator.hasNext()) {
                    jZcmdDataAccess = iterator.next();
                    continue;
                }
                jZcmdDataAccess = null;
            }
            return s;
        }

        void execThrow(JZcmdScript.JZcmditem jZcmditem) throws Exception {
            CharSequence charSequence = this.evalString(jZcmditem);
            throw new JZcmdThrow(charSequence.toString());
        }

        void execThrowonerror(JZcmdScript.Onerror onerror) throws CmdErrorLevelException {
            if (this.cmdErrorlevel >= onerror.errorLevel) {
                throw new CmdErrorLevelException(this.cmdErrorlevel);
            }
        }

        public Object evalDatapathOrExpr(JZcmdScript.Argument argument) throws Exception {
            if (argument.dataAccess != null) {
                Object object = this.dataAccess(argument.dataAccess, this.localVariables, JZcmdExecuter.this.bAccessPrivate, false, false, null);
                if (object == null) {
                    return "null";
                }
                return object;
            }
            if (argument.expression != null) {
                CalculatorExpr.Value value = this.calculateExpression(argument.expression);
                if (value.isObjValue()) {
                    return value.objValue();
                }
                return value;
            }
            throw new IllegalArgumentException("JZcmd - unexpected, faulty syntax");
        }

        public CharSequence evalString(JZcmdScript.JZcmditem jZcmditem) throws Exception {
            if (jZcmditem.textArg != null) {
                return jZcmditem.textArg;
            }
            if (jZcmditem.dataAccess != null) {
                Object object = this.dataAccess(jZcmditem.dataAccess, this.localVariables, JZcmdExecuter.this.bAccessPrivate, false, false, null);
                if (object == null) {
                    return "null";
                }
                if (object instanceof CharSequence) {
                    return (CharSequence)object;
                }
                return object.toString();
            }
            if (jZcmditem.statementlist != null) {
                StringFormatter stringFormatter = new StringFormatter();
                short s = this.executeNewlevel(this.jzClass, jZcmditem.statementlist, stringFormatter, 0, -1);
                if (s == -5) {
                    return retException;
                }
                return stringFormatter.getBuffer();
            }
            if (jZcmditem.expression != null) {
                CalculatorExpr.Value value = this.calculateExpression(jZcmditem.expression);
                return value.stringValue();
            }
            return null;
        }

        Object dataAccess(JZcmdScript.JZcmdDataAccess jZcmdDataAccess, Map<String, DataAccess.Variable<Object>> map, boolean bl, boolean bl2, boolean bl3, DataAccess.Dst dst) throws Exception {
            this.calculateArguments(jZcmdDataAccess);
            return DataAccess.access(jZcmdDataAccess.datapath(), map, bl, bl2, bl3, dst);
        }

        void storeValue(DataAccess dataAccess, Map<String, DataAccess.Variable<Object>> map, Object object, boolean bl) throws Exception {
            this.calculateArguments(dataAccess);
            dataAccess.storeValue(map, object, bl);
        }

        private CalculatorExpr.Value calculateExpression(CalculatorExpr calculatorExpr) throws Exception {
            for (CalculatorExpr.Operation operation : calculatorExpr.listOperations()) {
                DataAccess dataAccess = operation.datapath();
                if (dataAccess == null) continue;
                this.calculateArguments(dataAccess);
            }
            return calculatorExpr.calcDataAccess(this.localVariables, new Object[0]);
        }

        private void calculateArguments(DataAccess dataAccess) throws Exception {
            if (this.debug_dataAccessArguments) {
                this.debug();
                this.debug_dataAccessArguments = false;
            }
            for (DataAccess.DatapathElement datapathElement : dataAccess.datapath()) {
                Object object;
                DataAccess.DatapathElement datapathElement2;
                List<JZcmdScript.JZcmditem> list = null;
                if (datapathElement instanceof JZcmdScript.JZcmdDatapathElementClass) {
                    datapathElement2 = (JZcmdScript.JZcmdDatapathElementClass)datapathElement;
                    if (((JZcmdScript.JZcmdDatapathElementClass)datapathElement2).dpathLoader != null) {
                        object = this.dataAccess(((JZcmdScript.JZcmdDatapathElementClass)datapathElement2).dpathLoader, this.localVariables, JZcmdExecuter.this.bAccessPrivate, false, false, null);
                        assert (object instanceof ClassLoader);
                        ((DataAccess.DatapathElementClass)datapathElement2).set_loader((ClassLoader)object);
                    }
                    if (((JZcmdScript.JZcmdDatapathElementClass)datapathElement2).dpathClass != null) {
                        object = this.dataAccess(((JZcmdScript.JZcmdDatapathElementClass)datapathElement2).dpathClass, this.localVariables, JZcmdExecuter.this.bAccessPrivate, false, false, null);
                        assert (object instanceof Class);
                        ((DataAccess.DatapathElementClass)datapathElement2).set_Class((Class)object);
                    }
                    list = ((JZcmdScript.JZcmdDatapathElementClass)datapathElement2).fnArgsExpr;
                }
                if (datapathElement instanceof JZcmdScript.JZcmdDatapathElement) {
                    datapathElement2 = (JZcmdScript.JZcmdDatapathElement)datapathElement;
                    if (((JZcmdScript.JZcmdDatapathElement)datapathElement2).indirectDatapath != null) {
                        object = this.dataAccess(((JZcmdScript.JZcmdDatapathElement)datapathElement2).indirectDatapath, this.localVariables, JZcmdExecuter.this.bAccessPrivate, false, false, null);
                        datapathElement.setIdent(object.toString());
                    }
                    list = ((JZcmdScript.JZcmdDatapathElement)datapathElement2).fnArgsExpr;
                }
                if (list == null) continue;
                int n = list.size();
                object = new Object[n];
                int n2 = -1;
                for (JZcmdScript.JZcmditem jZcmditem : list) {
                    Object object2 = this.evalObject(jZcmditem, false);
                    object[++n2] = object2;
                }
                datapathElement.setActualArgumentArray((Object[])object);
            }
        }

        public Object evalObject(JZcmdScript.JZcmditem jZcmditem, boolean bl) throws Exception {
            Object object;
            Object object2;
            int n = 0;
            if (jZcmditem.textArg != null) {
                object2 = jZcmditem.textArg;
            } else if (jZcmditem.dataAccess != null) {
                object2 = this.dataAccess(jZcmditem.dataAccess, this.localVariables, JZcmdExecuter.this.bAccessPrivate, false, false, null);
            } else if (jZcmditem.statementlist != null) {
                IndexMultiTable<String, DataAccess.Variable<Object>> indexMultiTable;
                object2 = jZcmditem.elementType == 'M' ? ((n = (int)super.execute(jZcmditem.statementlist, null, 0, indexMultiTable = new IndexMultiTable<String, DataAccess.Variable<Object>>(IndexMultiTable.providerString), -1)) == -5 ? retException : indexMultiTable) : ((n = (int)this.executeNewlevel(this.jzClass, jZcmditem.statementlist, (StringFormatter)(object = new StringFormatter()), jZcmditem.statementlist.indentText, -1)) == -5 ? retException : ((StringFormatter)object).toString());
            } else if (jZcmditem.expression != null) {
                object = this.calculateExpression(jZcmditem.expression);
                object2 = ((CalculatorExpr.Value)object).objValue();
            } else {
                object2 = null;
            }
            if (object2 != null && n != -5 && jZcmditem.conversion != '\u0000') {
                switch (jZcmditem.conversion) {
                    case 'E': {
                        object = object2.toString();
                        if (FileSystem.isAbsolutePath((CharSequence)object)) {
                            object2 = new File((String)object);
                            break;
                        }
                        object2 = new File(this.currdir, (String)object);
                        break;
                    }
                    case 'F': {
                        object = object2.toString();
                        object2 = new JZcmdFilepath(this, (String)object);
                        break;
                    }
                    case 'G': {
                        assert (jZcmditem.subitem instanceof JZcmdScript.AccessFilesetname);
                        object = (JZcmdScript.AccessFilesetname)jZcmditem.subitem;
                        object2 = new JZcmdAccessFileset((JZcmdScript.AccessFilesetname)object, ((JZcmdScript.AccessFilesetname)object).filesetVariableName, this);
                        break;
                    }
                    default: {
                        assert (false);
                        break;
                    }
                }
            }
            return object2;
        }

        public CalculatorExpr.Value evalValue(JZcmdScript.JZcmditem jZcmditem, boolean bl) throws Exception {
            if (jZcmditem.textArg != null) {
                return null;
            }
            if (jZcmditem.dataAccess != null) {
                Object object = this.dataAccess(jZcmditem.dataAccess, this.localVariables, JZcmdExecuter.this.bAccessPrivate, false, false, null);
                CalculatorExpr.Value value = object instanceof Float ? new CalculatorExpr.Value(((Float)object).floatValue()) : (object instanceof Double ? new CalculatorExpr.Value((Double)object) : (object instanceof Long ? new CalculatorExpr.Value((Long)object) : (object instanceof Integer ? new CalculatorExpr.Value((Integer)object) : (object instanceof Short ? new CalculatorExpr.Value(((Short)object).shortValue()) : (object instanceof Byte ? new CalculatorExpr.Value(((Byte)object).byteValue()) : (object instanceof Boolean ? new CalculatorExpr.Value((Boolean)object) : new CalculatorExpr.Value(object)))))));
                return value;
            }
            if (jZcmditem.expression != null) {
                return this.calculateExpression(jZcmditem.expression);
            }
            return null;
        }

        public boolean evalCondition(JZcmdScript.JZcmditem jZcmditem) throws Exception {
            boolean bl;
            block12: {
                if (jZcmditem.textArg != null) {
                    return true;
                }
                if (jZcmditem.dataAccess != null) {
                    try {
                        Object object = this.dataAccess(jZcmditem.dataAccess, this.localVariables, JZcmdExecuter.this.bAccessPrivate, false, false, null);
                        if (object instanceof Number) {
                            bl = ((Number)object).intValue() != 0;
                            break block12;
                        }
                        if (object instanceof Boolean) {
                            bl = (Boolean)object;
                            break block12;
                        }
                        bl = object != null;
                    }
                    catch (NoSuchElementException noSuchElementException) {
                        bl = false;
                    }
                    catch (NoSuchFieldException noSuchFieldException) {
                        bl = false;
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        bl = false;
                    }
                } else {
                    if (jZcmditem.statementlist != null) {
                        throw new IllegalArgumentException("JZcmdExecuter - unexpected, faulty syntax");
                    }
                    if (jZcmditem.expression != null) {
                        CalculatorExpr.Value value = this.calculateExpression(jZcmditem.expression);
                        bl = value.booleanValue();
                    } else {
                        throw new IllegalArgumentException("JZcmdExecuter - unexpected, faulty syntax");
                    }
                }
            }
            return bl;
        }

        JZcmdFilepath convert2FilePath(Object object) {
            JZcmdFilepath jZcmdFilepath;
            if (object instanceof JZcmdFilepath) {
                jZcmdFilepath = (JZcmdFilepath)object;
            } else {
                String string = object.toString();
                jZcmdFilepath = new JZcmdFilepath(this, new FilePath(string));
            }
            return jZcmdFilepath;
        }

        protected short exec_DefMapVariable(JZcmdScript.DefVariable defVariable, Map<String, DataAccess.Variable<Object>> map) throws Exception {
            short s = 0;
            TreeMap treeMap = this.evalObject(defVariable, false);
            if (treeMap == retException) {
                s = -5;
            } else {
                if (treeMap == null) {
                    treeMap = new TreeMap();
                }
                this.executeDefVariable(map, defVariable, 'M', treeMap, true);
            }
            return s;
        }

        protected short exec_DefClassVariable(JZcmdScript.DefClassVariable defClassVariable, Map<String, DataAccess.Variable<Object>> map) throws Exception {
            Class<?> clazz;
            short s = 0;
            CharSequence charSequence = this.evalString(defClassVariable);
            if (defClassVariable.loader != null) {
                Object object = this.dataAccess(defClassVariable.loader, this.localVariables, JZcmdExecuter.this.bAccessPrivate, false, false, null);
                if (!(object instanceof ClassLoader)) {
                    throw new IllegalArgumentException("JZcmd.exec_DefClassVariable - faulty ClassLoader");
                }
                ClassLoader classLoader = (ClassLoader)object;
                clazz = classLoader.loadClass(charSequence.toString());
            } else {
                clazz = Class.forName(charSequence.toString());
            }
            this.executeDefVariable(map, defClassVariable, 'C', clazz, false);
            return s;
        }

        protected short addClassLoader(JZcmdScript.DefClasspathVariable defClasspathVariable, Map<String, DataAccess.Variable<Object>> map) throws Exception {
            Object object;
            Object object22;
            Object object3;
            LinkedList<Object> linkedList = new LinkedList<Object>();
            for (JZcmdScript.AccessFilesetname accessFilesetname : defClasspathVariable.jarpaths) {
                Object object4;
                if (accessFilesetname.filesetVariableName != null) {
                    object3 = new JZcmdAccessFileset(accessFilesetname, accessFilesetname.filesetVariableName, this);
                    object22 = ((JZcmdAccessFileset)object3).listFilesExpanded();
                    object = object22.iterator();
                    while (object.hasNext()) {
                        object4 = (JZcmdFilepath)object.next();
                        File file = new File(((JZcmdFilepath)object4).absfile().toString());
                        if (!file.exists()) {
                            throw new IllegalArgumentException("JZcmd.addClasspath - file does not exist; " + file.getAbsolutePath());
                        }
                        linkedList.add(file);
                    }
                    continue;
                }
                object22 = this.evalString(accessFilesetname);
                object3 = new FilePath(object22.toString());
                object = new JZcmdFilepath(this, (FilePath)object3);
                object4 = new File(((JZcmdFilepath)object).absfile().toString());
                if (!((File)object4).exists()) {
                    throw new IllegalArgumentException("JZcmd.addClasspath - file does not exist; " + ((File)object4).getAbsolutePath());
                }
                linkedList.add(object4);
            }
            URL[] uRLArray = new URL[linkedList.size()];
            int n = -1;
            for (Object object22 : linkedList) {
                object = ((File)object22).toURI();
                uRLArray[++n] = ((URI)object).toURL();
            }
            object3 = this.getClass().getClassLoader();
            object22 = new URLClassLoader(uRLArray, (ClassLoader)object3);
            this.executeDefVariable(map, defClasspathVariable, 'J', object22, true);
            return 0;
        }

        protected void runThread(ExecuteLevel executeLevel, JZcmdScript.ThreadBlock threadBlock, JZcmdThread jZcmdThread) {
            try {
                executeLevel.execute(threadBlock.statementlist, JZcmdExecuter.this.textout, 0, executeLevel.localVariables, -1);
            }
            catch (Exception exception) {
                jZcmdThread.exception = exception;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finishThread(JZcmdThread jZcmdThread) {
            Object object = jZcmdThread;
            synchronized (object) {
                jZcmdThread.notifyAll();
            }
            object = JZcmdExecuter.this.threads;
            synchronized (object) {
                boolean bl = JZcmdExecuter.this.threads.remove(jZcmdThread);
                assert (bl);
                if (JZcmdExecuter.this.threads.size() == 0) {
                    JZcmdExecuter.this.threads.notify();
                }
            }
        }

        boolean isBreak() {
            return this.isBreak;
        }

        public String currdir() {
            return this.currdir.getPath().replace('\\', '/');
        }

        int debug(JZcmdScript.JZcmditem jZcmditem) {
            try {
                CharSequence charSequence = this.evalString(jZcmditem);
            }
            catch (Exception exception) {
                // empty catch block
            }
            Assert.stop();
            return 1;
        }

        public void debug_dataAccessArguments() {
            this.debug_dataAccessArguments = true;
        }

        void debug() {
            Assert.stop();
        }

        public CharSequence excStacktraceinfo() {
            CharSequence charSequence = Assert.exceptionInfo("JZcmd.execute - exception at;" + this.threadData.excStatement.toString() + ";", this.threadData.exception, 0, 20);
            return charSequence;
        }

        void throwIllegalDstArgument(CharSequence charSequence, DataAccess dataAccess, JZcmdScript.JZcmditem jZcmditem) throws IllegalArgumentException {
            StringBuilder stringBuilder = new StringBuilder(100);
            stringBuilder.append("JZcmd - ").append(charSequence).append(";").append(dataAccess);
            stringBuilder.append("; in file ").append(jZcmditem.parentList.srcFile);
            stringBuilder.append(", line ").append(jZcmditem.srcLine).append(" col ").append(jZcmditem.srcColumn);
            throw new IllegalArgumentException(stringBuilder.toString());
        }

        @Override
        public Object getAttribute(String string) {
            DataAccess.Variable<Object> variable = this.localVariables.get(string);
            if (variable == null) {
                return null;
            }
            return variable.value();
        }

        @Override
        public Object getAttribute(String string, int n) {
            switch (n) {
                case 100: {
                    return this.getAttribute(string);
                }
                case 200: {
                    return JZcmdExecuter.this.scriptLevel.getAttribute(string);
                }
            }
            throw new IllegalArgumentException("JZcmdExecuter.getAttribute - failed scope;" + n);
        }

        @Override
        public int getAttributesScope(String string) {
            return 100;
        }

        @Override
        public Bindings getBindings(int n) {
            switch (n) {
                case 100: {
                    return new JZcmdBindings(this.localVariables);
                }
                case 200: {
                    return new JZcmdBindings(JZcmdExecuter.this.scriptLevel.localVariables);
                }
            }
            throw new IllegalArgumentException("JZcmdExecuter.getBindings - failed scope;" + n);
        }

        @Override
        public Writer getErrorWriter() {
            return null;
        }

        @Override
        public Reader getReader() {
            return null;
        }

        @Override
        public List<Integer> getScopes() {
            return null;
        }

        @Override
        public Writer getWriter() {
            return null;
        }

        @Override
        public Object removeAttribute(String string, int n) {
            return null;
        }

        @Override
        public void setAttribute(String string, Object object, int n) {
        }

        @Override
        public void setBindings(Bindings bindings, int n) {
        }

        @Override
        public void setErrorWriter(Writer writer) {
        }

        @Override
        public void setReader(Reader reader) {
        }

        @Override
        public void setWriter(Writer writer) {
        }

        @Override
        public CharSequence getCurrentDir() {
            return this.currdir();
        }

        @Override
        public Object getValue(String string) throws NoSuchFieldException {
            Object object;
            DataAccess.Variable<Object> variable = this.localVariables.get(string);
            if (variable == null) {
                object = string.startsWith("$") ? System.getenv(string.substring(1)).replace('\\', '/') : null;
                if (object == null) {
                    throw new NoSuchFieldException("JZcmdFilepath.getValue() - variable not found; " + string);
                }
            } else {
                object = variable.value();
                if (object instanceof JZcmdFilepath) {
                    object = ((JZcmdFilepath)object).data;
                }
            }
            return object;
        }
    }
}

