/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.cmd;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.vishia.cmd.CmdGetFileArgs_ifc;
import org.vishia.cmd.JZcmdScript;
import org.vishia.cmd.PrepareCmd;
import org.vishia.util.DataAccess;
import org.vishia.util.StringPart;

public class CmdStore {
    public static int version = 20120609;
    private final List<CmdBlock> listCmds = new LinkedList<CmdBlock>();
    private final Map<String, CmdBlock> idxCmd = new TreeMap<String, CmdBlock>();
    private final String XXXsyntaxCmd = "Cmds::={ <cmd> }\\e. cmd::= <* :?name> : { <*\\n?cmd> \\n } .";

    public CmdBlock new_CmdBlock() {
        return new CmdBlock();
    }

    public void add_CmdBlock(CmdBlock cmdBlock) {
        this.listCmds.add(cmdBlock);
        this.idxCmd.put(cmdBlock.name, cmdBlock);
    }

    public void addSubOfZgenclass(JZcmdScript.JZcmdClass jZcmdClass, int n) {
        Object object;
        if (jZcmdClass.classes != null) {
            for (JZcmdScript.JZcmdClass object2 : jZcmdClass.classes) {
                object = new CmdBlock();
                this.listCmds.add((CmdBlock)object);
                ((CmdBlock)object).name = object2.cmpnName;
                this.addSubOfZgenclass(object2, n + 1);
            }
        }
        if (jZcmdClass.subroutines != null) {
            for (Map.Entry entry : jZcmdClass.subroutines.entrySet()) {
                object = (JZcmdScript.Subroutine)entry.getValue();
                CmdBlock cmdBlock = new CmdBlock((JZcmdScript.Subroutine)object, n);
                this.listCmds.add(cmdBlock);
                this.idxCmd.put(cmdBlock.name, cmdBlock);
            }
        }
    }

    public String readCmdCfgOld(File file) {
        String string = null;
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(file));
        }
        catch (FileNotFoundException fileNotFoundException) {
            string = "CommandSelector - cfg file not found; " + file;
        }
        if (bufferedReader != null) {
            CmdBlock cmdBlock = null;
            this.listCmds.clear();
            StringPart stringPart = new StringPart();
            StringBuilder stringBuilder = new StringBuilder(1000);
            try {
                String string2;
                while ((string2 = bufferedReader.readLine()) != null) {
                    if (string2.contains("$")) {
                        stringBuilder.setLength(0);
                        stringBuilder.append(string2.trim());
                        stringPart.assignReplaceEnv(stringBuilder);
                        string2 = stringBuilder.toString();
                    } else {
                        string2 = string2.trim();
                        stringPart.assign(string2);
                    }
                    if (string2.length() == 0) continue;
                    if (string2.startsWith("==")) {
                        int n = string2.indexOf(58);
                        int n2 = string2.indexOf("==", 2);
                        if (cmdBlock != null) {
                            this.add_CmdBlock(cmdBlock);
                        }
                        cmdBlock = this.new_CmdBlock();
                        if (n >= 0 && n < n2) {
                            cmdBlock.name = string2.substring(2, n).trim();
                            cmdBlock.title = string2.substring(n + 1, n2).trim();
                            continue;
                        }
                        cmdBlock.name = string2.substring(2, n2).trim();
                        cmdBlock.title = "";
                        continue;
                    }
                    if (string2.startsWith("@") || string2.startsWith("//") || string2.startsWith("#")) continue;
                    PrepareCmd prepareCmd = cmdBlock.new_cmd();
                    prepareCmd.set_cmd(string2.trim());
                    cmdBlock.add_cmd(prepareCmd);
                }
                if (cmdBlock != null) {
                    this.add_CmdBlock(cmdBlock);
                }
            }
            catch (IOException iOException) {
                string = "CommandStore - cfg file read error; " + file;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                string = "CommandStore - cfg file error; " + file + "; line: " + stringPart + "; msg:" + illegalArgumentException.getMessage();
            }
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return string;
    }

    public CmdBlock getCmd(String string) {
        return this.idxCmd.get(string);
    }

    public final List<CmdBlock> getListCmds() {
        return this.listCmds;
    }

    public static class CmdBlock {
        public String name;
        public String title;
        public final int level;
        public final List<PrepareCmd> listBlockCmds = new LinkedList<PrepareCmd>();
        protected final JZcmdScript.Subroutine zgenSub;
        protected List<CmdBlock> listSubCmds;

        public CmdBlock() {
            this.zgenSub = null;
            this.level = 1;
        }

        public CmdBlock(JZcmdScript.Subroutine subroutine, int n) {
            this.zgenSub = subroutine;
            this.level = n;
            this.name = subroutine.name;
        }

        public Map<String, DataAccess.Variable<Object>> getArguments(CmdGetFileArgs_ifc cmdGetFileArgs_ifc) {
            if (this.zgenSub != null) {
                cmdGetFileArgs_ifc.prepareFileSelection();
                TreeMap<String, DataAccess.Variable<Object>> treeMap = new TreeMap<String, DataAccess.Variable<Object>>();
                try {
                    for (JZcmdScript.DefVariable defVariable : this.zgenSub.formalArgs) {
                        String string = defVariable.getVariableIdent();
                        if (string.equals("file1")) {
                            DataAccess.createOrReplaceVariable(treeMap, "file1", 'O', cmdGetFileArgs_ifc.getFile1(), true);
                            continue;
                        }
                        if (string.equals("file2")) {
                            DataAccess.createOrReplaceVariable(treeMap, "file2", 'O', cmdGetFileArgs_ifc.getFile2(), true);
                            continue;
                        }
                        if (string.equals("file3")) {
                            DataAccess.createOrReplaceVariable(treeMap, "file3", 'O', cmdGetFileArgs_ifc.getFile3(), true);
                            continue;
                        }
                        if (string.equals("dir1")) {
                            DataAccess.createOrReplaceVariable(treeMap, "dir1", 'O', cmdGetFileArgs_ifc.getFile1().getParentFile(), true);
                            continue;
                        }
                        if (string.equals("dir2")) {
                            DataAccess.createOrReplaceVariable(treeMap, "dir2", 'O', cmdGetFileArgs_ifc.getFile2().getParentFile(), true);
                            continue;
                        }
                        if (!string.equals("dir3")) continue;
                        DataAccess.createOrReplaceVariable(treeMap, "dir3", 'O', cmdGetFileArgs_ifc.getFile3().getParentFile(), true);
                    }
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new IllegalArgumentException(illegalAccessException);
                }
                return treeMap;
            }
            return null;
        }

        public PrepareCmd new_cmd() {
            return new PrepareCmd();
        }

        public void add_cmd(PrepareCmd prepareCmd) {
            prepareCmd.prepareListCmdReplace();
            this.listBlockCmds.add(prepareCmd);
        }

        public final List<PrepareCmd> getCmds() {
            return this.listBlockCmds;
        }

        public String toString() {
            return this.name + this.listBlockCmds;
        }
    }
}

