/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.cmd;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.vishia.cmd.CmdExecuter;
import org.vishia.cmd.CmdGetFileArgs_ifc;
import org.vishia.cmd.CmdStore;
import org.vishia.cmd.JZcmdExecuter;
import org.vishia.cmd.JZcmdScript;
import org.vishia.cmd.PrepareCmd;
import org.vishia.mainCmd.MainCmdLoggingStream;
import org.vishia.util.DataAccess;

public class CmdQueue
implements Closeable {
    public static int version = 20120609;
    private final ConcurrentLinkedQueue<PendingCmd> pendingCmds = new ConcurrentLinkedQueue();
    private final CmdExecuter executer = new CmdExecuter();
    private final JZcmdExecuter zgenExecuter;
    private final PrintStream log;
    private boolean busy;
    private Appendable cmdOutput = System.out;
    private Appendable cmdError = System.err;

    public CmdQueue(PrintStream printStream) {
        this.log = printStream;
        MainCmdLoggingStream mainCmdLoggingStream = new MainCmdLoggingStream(printStream, 3);
        this.zgenExecuter = new JZcmdExecuter(mainCmdLoggingStream);
    }

    public void setOutput(Appendable appendable, Appendable appendable2) {
        this.cmdOutput = appendable;
        this.cmdError = appendable2;
    }

    public void initExecuter(JZcmdScript jZcmdScript, String string) throws Throwable {
        this.zgenExecuter.initialize(jZcmdScript, false, null, string);
    }

    @Deprecated
    public void setWorkingDir(File file) {
        if (!file.isDirectory()) {
            File file2 = file.getParentFile();
        } else {
            File file3 = file;
        }
    }

    public int addCmd(CmdStore.CmdBlock cmdBlock, Map<String, DataAccess.Variable<Object>> map, File file) {
        this.pendingCmds.add(new PendingCmd(cmdBlock.zgenSub, map, file));
        return this.pendingCmds.size();
    }

    public int addCmd(CmdStore.CmdBlock cmdBlock, File[] fileArray, File file) {
        for (PrepareCmd prepareCmd : cmdBlock.getCmds()) {
            this.pendingCmds.add(new PendingCmd(prepareCmd, fileArray, file));
        }
        return this.pendingCmds.size();
    }

    public int addCmd(String string, File[] fileArray, File file, char c) {
        PrepareCmd prepareCmd = new PrepareCmd(c);
        prepareCmd.set_cmd(string);
        this.pendingCmds.add(new PendingCmd(prepareCmd, fileArray, file));
        return this.pendingCmds.size();
    }

    public final void execCmds(Appendable appendable) {
        PendingCmd pendingCmd;
        boolean bl = false;
        while ((pendingCmd = this.pendingCmds.poll()) != null) {
            this.busy = true;
            bl = true;
            try {
                String[] stringArray;
                StringBuilder stringBuilder = new StringBuilder(120);
                stringBuilder.append("CmdQueue - exec; ");
                if (pendingCmd.currentDir != null) {
                    this.executer.setCurrentDir(pendingCmd.currentDir);
                    stringBuilder.append(pendingCmd.currentDir).append(">");
                }
                if (pendingCmd.jbat != null) {
                    if (appendable != null) {
                        appendable.append(pendingCmd.jbat.toString());
                    }
                    this.zgenExecuter.execSub(pendingCmd.jbat, pendingCmd.args, false, this.log, pendingCmd.currentDir);
                    continue;
                }
                for (String string : stringArray = pendingCmd.cmd.prepareCmd(pendingCmd)) {
                    stringBuilder.append(string).append(" ");
                }
                char c = pendingCmd.cmd.getKindOfExecution();
                if (">%".indexOf(c) >= 0) {
                    if (appendable != null) {
                        appendable.append(">" + stringArray[0]);
                    }
                    if (this.cmdOutput != null) {
                        if (pendingCmd.currentDir != null) {
                            this.cmdOutput.append(pendingCmd.currentDir.getCanonicalPath()).append(">");
                        } else {
                            this.cmdOutput.append("??>");
                        }
                        for (String string : stringArray) {
                            if (string == null) continue;
                            this.cmdOutput.append(string).append(" ");
                        }
                        this.cmdOutput.append("\n");
                    }
                    this.log.println(stringBuilder);
                    int n = this.executer.execute(stringArray, null, this.cmdOutput, this.cmdError);
                    if (n == 0) {
                        this.cmdOutput.append("\nJavaCmd: cmd execution successfull\n");
                        continue;
                    }
                    this.cmdOutput.append("\nJavaCmd: cmd execution errorlevel = " + n + "\n");
                    continue;
                }
                if (c == '&') {
                    this.log.println(stringBuilder);
                    if (appendable != null) {
                        appendable.append("&" + stringArray[0]);
                    }
                    try {
                        this.executer.execute(stringArray, true, null, null, null);
                    }
                    catch (Exception exception) {
                        this.log.println("\nCmdQueue - execution exception; " + exception.getMessage());
                    }
                    continue;
                }
                this.log.println("\nCmdQueue - unexpected kind of execution; " + c);
            }
            catch (Throwable throwable) {
                System.out.println("Exception " + throwable.getMessage());
            }
        }
        this.busy = false;
        if (bl && appendable != null) {
            try {
                appendable.append('\u0000');
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public boolean abortCmd() {
        this.pendingCmds.clear();
        return this.executer.abortCmd();
    }

    public boolean isBusy() {
        return this.busy;
    }

    @Override
    public void close() {
        this.executer.close();
    }

    private static class PendingCmd
    implements CmdGetFileArgs_ifc {
        public final PrepareCmd cmd;
        public final JZcmdScript.Subroutine jbat;
        final File[] files;
        final Map<String, DataAccess.Variable<Object>> args;
        File currentDir;

        public PendingCmd(PrepareCmd prepareCmd, File[] fileArray, File file) {
            this.cmd = prepareCmd;
            this.jbat = null;
            this.files = fileArray;
            this.args = null;
            this.currentDir = file;
        }

        public PendingCmd(JZcmdScript.Subroutine subroutine, Map<String, DataAccess.Variable<Object>> map, File file) {
            this.cmd = null;
            this.jbat = subroutine;
            this.files = null;
            this.args = map;
            this.currentDir = file;
        }

        @Override
        public void prepareFileSelection() {
        }

        @Override
        public File getFileSelect() {
            return this.files[0];
        }

        @Override
        public File getFile1() {
            return this.files[0];
        }

        @Override
        public File getFile2() {
            return this.files[1];
        }

        @Override
        public File getFile3() {
            return this.files[2];
        }
    }
}

