/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.byteData;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Arrays;
import org.vishia.bridgeC.IllegalArgumentExceptionJc;
import org.vishia.util.Java4C;
import org.vishia.util.StringFormatter;

public abstract class ByteDataAccessBase {
    public static final String sVersion = "2014-08-26";
    private int sizeHead;
    @Java4C.PtrVal
    protected byte[] data;
    protected int ixBegin;
    protected int ixChild;
    protected int ixChildEnd;
    protected int ixEnd;
    protected boolean bExpand;
    protected boolean bBigEndian;
    protected ByteDataAccessBase parent;
    @Java4C.SimpleRef
    private Charset charset = Charset.forName("ISO-8859-1");
    @Java4C.Exclude
    protected StringFormatter toStringformatter = null;

    protected ByteDataAccessBase(int n) {
        this.sizeHead = n;
    }

    protected ByteDataAccessBase(int n, int n2) {
        assert (n >= 0);
        assert (n2 > 0);
        this.sizeHead = n;
        this.ixBegin = 0;
        this.ixEnd = n2;
        this.ixChild = -1;
        this.ixChildEnd = n;
        this.parent = null;
    }

    @Java4C.Inline
    public final void setBigEndian(boolean bl) {
        this.bBigEndian = bl;
    }

    public final void setCharset(String string) {
        this.charset = Charset.forName(string);
    }

    @Java4C.Inline
    final void _setSizeHead(int n) {
        if (this.sizeHead < 0) {
            this.sizeHead = n;
        } else if (this.sizeHead != n) assert (false);
    }

    final void _reset(int n) {
        assert (this.sizeHead >= 0);
        this.bExpand = n <= 0;
        this.ixChild = -1;
        this.ixChildEnd = this.ixBegin + this.sizeHead;
        int n2 = this.ixEnd = this.bExpand ? this.ixBegin + this.sizeHead : this.ixBegin + n;
        if (this.ixEnd > this.data.length) {
            String string = "not enough data bytes, requested=" + this.ixEnd + ", buffer-length=" + this.data.length;
            throw new IllegalArgumentException(string);
        }
    }

    protected final long _getLong(int n, int n2) {
        int n3;
        long l;
        int n4;
        int n5;
        boolean bl;
        int n6;
        long l2 = 0L;
        if (n2 >= 0) {
            n6 = n2;
            bl = false;
        } else {
            n6 = -n2;
            bl = true;
        }
        if (this.bBigEndian) {
            n5 = this.ixBegin + n;
            n4 = 1;
        } else {
            n5 = this.ixBegin + n + n6 - 1;
            n4 = -1;
        }
        int n7 = n6;
        while (true) {
            l2 |= (long)(this.data[n5] & 0xFF);
            if (--n7 <= 0) break;
            l2 <<= 8;
            n5 += n4;
        }
        if (bl && (l2 & (l = 1L << (n3 = n6 * 8 - 1))) != 0L) {
            long l3 = -1L << n3;
            l2 |= l3;
        }
        return l2;
    }

    protected final void _setLong(int n, int n2, long l) {
        int n3;
        if (this.bBigEndian) {
            n = this.ixBegin + n + n2 - 1;
            n3 = -1;
        } else {
            n = this.ixBegin + n;
            n3 = 1;
        }
        while (true) {
            this.data[n] = (byte)l;
            if (--n2 <= 0) break;
            l >>= 8;
            n += n3;
        }
    }

    final void _expand(int n) {
        if (this.ixEnd < n) {
            this.ixEnd = n;
        }
        assert (n >= this.ixBegin + this.sizeHead);
        this.ixChildEnd = n;
        if (this.parent != null) {
            this.parent._expand(n);
        }
    }

    public final void assign(@Java4C.PtrVal byte[] byArray, int n, int n2) throws IllegalArgumentException {
        assert (n2 >= 0 && this.sizeHead >= 0);
        this.data = byArray;
        this.ixBegin = n2;
        this.parent = null;
        this._reset(n);
    }

    @Java4C.Inline
    public final void assign(@Java4C.PtrVal byte[] byArray, int n) {
        this.assign(byArray, n, 0);
    }

    @Java4C.Inline
    public final void assign(@Java4C.PtrVal byte[] byArray) {
        this.assign(byArray, byArray.length, 0);
    }

    @Java4C.Inline
    public final void assignClear(@Java4C.PtrVal byte[] byArray) {
        Arrays.fill(byArray, (byte)0);
        this.assign(byArray, -1, 0);
    }

    @Java4C.Inline
    public final void assignAt(int n, int n2, ByteDataAccessBase byteDataAccessBase) throws IllegalArgumentException {
        this.bBigEndian = byteDataAccessBase.bBigEndian;
        this.bExpand = byteDataAccessBase.bExpand;
        this.assign(byteDataAccessBase.data, byteDataAccessBase.ixBegin + n + n2, byteDataAccessBase.ixBegin + n);
        this.setBigEndian(byteDataAccessBase.bBigEndian);
    }

    @Java4C.Inline
    public final void assignAt(int n, ByteDataAccessBase byteDataAccessBase) throws IllegalArgumentException {
        this.assignAt(n, this.sizeHead, byteDataAccessBase);
    }

    @Java4C.Inline
    protected final void assignCasted_i(ByteDataAccessBase byteDataAccessBase, int n, int n2) throws IllegalArgumentException {
        this.bBigEndian = byteDataAccessBase.bBigEndian;
        this.bExpand = byteDataAccessBase.bExpand;
        this.assign(byteDataAccessBase.data, byteDataAccessBase.ixEnd, byteDataAccessBase.ixBegin + n);
    }

    @Java4C.Retinline
    @Java4C.PtrVal
    public final byte[] getData() {
        return this.data;
    }

    @Java4C.Inline
    public final void rewind() {
        this.ixChild = -1;
    }

    @Java4C.Retinline
    public final int getLengthHead() {
        return this.sizeHead;
    }

    @Java4C.Retinline
    public final int getLength() {
        return this.ixEnd - this.ixBegin;
    }

    @Java4C.Retinline
    public final int getLengthTotal() {
        return this.ixEnd;
    }

    @Java4C.Retinline
    public final int getMaxNrofBytes() {
        return this.data.length - this.ixBegin;
    }

    @Java4C.Retinline
    public final boolean getBigEndian() {
        return this.bBigEndian;
    }

    @Java4C.Inline
    public final void setLengthElement(int n) {
        this._expand(this.ixBegin + n);
    }

    @Java4C.Inline
    public final void clearHead() {
        Arrays.fill(this.data, this.ixBegin, this.ixBegin + this.sizeHead, (byte)0);
    }

    @Java4C.Inline
    public final void clearData() {
        Arrays.fill(this.data, this.ixBegin, this.ixEnd, (byte)0);
    }

    public final boolean sufficingBytesForNextChild(int n) throws IllegalArgumentException {
        int n2 = this.getMaxNrofBytesForNextChild();
        return n < 0 ? false : n2 >= n;
    }

    @Java4C.Retinline
    public final int getMaxNrofBytesForNextChild() throws IllegalArgumentException {
        if (this.ixChildEnd < this.ixChild) {
            throw new IllegalArgumentException("length of current child is undefined.");
        }
        return this.ixEnd - this.ixChildEnd;
    }

    public final void addChild(ByteDataAccessBase byteDataAccessBase, int n) throws IllegalArgumentException {
        assert (n == 0 || n >= byteDataAccessBase.sizeHead);
        assert (byteDataAccessBase.sizeHead >= 0);
        this.setIdxtoNextCurrentChild(n == 0 ? byteDataAccessBase.sizeHead : n);
        byteDataAccessBase.bBigEndian = this.bBigEndian;
        byteDataAccessBase.bExpand = this.bExpand;
        byteDataAccessBase.data = this.data;
        byteDataAccessBase.parent = this;
        byteDataAccessBase.charset = this.charset;
        byteDataAccessBase.ixBegin = this.ixChild;
        byteDataAccessBase.ixChildEnd = byteDataAccessBase.ixBegin + byteDataAccessBase.sizeHead;
        byteDataAccessBase.ixChild = -1;
        int n2 = byteDataAccessBase.ixEnd = this.bExpand ? byteDataAccessBase.ixChildEnd : this.ixEnd;
        assert (byteDataAccessBase.ixEnd <= this.data.length);
        if (this.bExpand) {
            this._expand(byteDataAccessBase.ixEnd);
        }
    }

    @Java4C.Retinline
    public final void addChild(ByteDataAccessBase byteDataAccessBase) {
        this.addChild(byteDataAccessBase, byteDataAccessBase.sizeHead);
    }

    public final void addChildEmpty(ByteDataAccessBase byteDataAccessBase) {
        this.addChild(byteDataAccessBase);
        byteDataAccessBase.clearHead();
    }

    public final void addChildEmpty(ByteDataAccessBase byteDataAccessBase, int n) {
        this.addChild(byteDataAccessBase, n);
        byteDataAccessBase.clearData();
    }

    public final void addChildAt(int n, ByteDataAccessBase byteDataAccessBase, int n2) throws IllegalArgumentException {
        int n3;
        assert (byteDataAccessBase.sizeHead >= 0);
        assert (n2 >= byteDataAccessBase.sizeHead);
        byteDataAccessBase.data = this.data;
        byteDataAccessBase.ixBegin = n3 = this.ixBegin + n;
        byteDataAccessBase.ixEnd = n3 + n2;
        byteDataAccessBase.ixChildEnd = n3 + byteDataAccessBase.sizeHead;
        byteDataAccessBase.ixChild = -1;
        byteDataAccessBase.bBigEndian = this.bBigEndian;
        byteDataAccessBase.bExpand = this.bExpand;
        byteDataAccessBase.parent = this;
        this._expand(byteDataAccessBase.ixEnd);
    }

    @Java4C.Retinline
    public final void addChildAt(int n, ByteDataAccessBase byteDataAccessBase) throws IllegalArgumentException {
        this.addChildAt(n, byteDataAccessBase, byteDataAccessBase.sizeHead);
    }

    public final void addChildInteger(int n, long l) throws IllegalArgumentException {
        assert (n > 0);
        this.setIdxtoNextCurrentChild(n);
        if (this.data.length < this.ixChild + n) {
            String string = "data length to small:" + (this.ixChild + n);
            throw new IllegalArgumentException(string);
        }
        this._setLong(this.ixChild - this.ixBegin, n, l);
    }

    public final void addChildFloat(float f) throws IllegalArgumentException {
        this.setIdxtoNextCurrentChild(4);
        if (this.data.length < this.ixChild + 4) {
            String string = "data length to small:" + (this.ixChild + 4);
            throw new IllegalArgumentException(string);
        }
        this.setFloat(this.ixChild - this.ixBegin, f);
    }

    public final void addChildString(String string, String string2, boolean bl) throws IllegalArgumentException, UnsupportedEncodingException {
        int n = string.length();
        this.setIdxtoNextCurrentChild(n);
        this._setString(this.ixChild - this.ixBegin, n, string, string2, bl);
    }

    public final void addChildString(CharSequence charSequence, String string) throws IllegalArgumentException, UnsupportedEncodingException {
        int n = charSequence.length();
        this.setIdxtoNextCurrentChild(n);
        for (int i = 0; i < n; ++i) {
            byte by;
            this.data[this.ixChild + i] = by = (byte)charSequence.charAt(i);
        }
    }

    @Java4C.Inline
    public final void addChildString(CharSequence charSequence) throws IllegalArgumentException {
        try {
            this.addChildString(charSequence, null);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
    }

    public final long getChildInteger(int n) throws IllegalArgumentException {
        int n2 = n < 0 ? -n : n;
        this.setIdxtoNextCurrentChild(n2);
        this.setIdxCurrentChildEnd(n2);
        long l = this._getLong(this.ixChild - this.ixBegin, n);
        return l;
    }

    public final float getChildFloat() throws IllegalArgumentException {
        this.setIdxtoNextCurrentChild(4);
        int n = (int)this._getLong(this.ixChild - this.ixBegin, 4);
        return Float.intBitsToFloat(n);
    }

    public final double getChildDouble() throws IllegalArgumentException {
        this.setIdxtoNextCurrentChild(8);
        long l = this._getLong(this.ixChild - this.ixBegin, 8);
        return Double.longBitsToDouble(l);
    }

    public final String getChildString(int n) throws IllegalArgumentException, UnsupportedEncodingException {
        assert (n >= 0);
        this.setIdxtoNextCurrentChild(n);
        this.setIdxCurrentChildEnd(n);
        return this.getString(this.ixChild - this.ixBegin, n);
    }

    @Java4C.Inline
    public final void removeChild() throws IllegalArgumentException {
        assert (this.ixChild >= this.sizeHead);
        this.ixChildEnd = this.ixChild;
        this.ixChild = -1;
    }

    @Java4C.Inline
    public final void removeChildren() {
        this.ixChildEnd = this.ixBegin + this.sizeHead;
        if (this.bExpand) {
            this.ixEnd = this.ixBegin + this.sizeHead;
        }
        this.ixChild = -1;
    }

    @Java4C.Inline
    public final void detach() {
        this.data = null;
        this.parent = null;
        this.ixEnd = 0;
        this.ixBegin = 0;
        this.ixChild = this.ixChildEnd = this.sizeHead;
        this.bExpand = false;
    }

    @Java4C.Retinline
    public final int getPositionInBuffer() {
        return this.ixBegin;
    }

    @Java4C.Retinline
    public final int getPositionNextChildInBuffer() {
        return this.ixChildEnd;
    }

    public final void copyDataFrom(ByteDataAccessBase byteDataAccessBase) throws IllegalArgumentException {
        int n = byteDataAccessBase.getLength();
        if (this.data.length < n) {
            throw new IndexOutOfBoundsException("copy, dst to small" + n);
        }
    }

    public final void copyData(int[] nArray) {
        int n = this.ixEnd - this.ixBegin;
        if (n / 4 > nArray.length) {
            n = 4 * nArray.length;
        }
        int n2 = 0;
        for (int i = 0; i < n; i += 4) {
            nArray[n2++] = (int)this._getLong(i, 4);
        }
    }

    @Java4C.Retinline
    public final boolean assertNotExpandable() {
        assert (this.ixChild > 0 && this.ixEnd > 0 && !this.bExpand);
        return true;
    }

    final void setIdxtoNextCurrentChild(int n) {
        assert (n >= 0);
        assert (this.ixChildEnd >= this.ixChild);
        assert (this.ixChildEnd >= 0);
        this.ixChild = this.ixChildEnd;
        this.ixChildEnd = this.ixChild + n;
        if (this.bExpand) {
            this._expand(this.ixChildEnd);
        }
        if (this.data.length < this.ixChildEnd) {
            throw new IllegalArgumentExceptionJc("ByteDataAccess: less data", this.ixChildEnd);
        }
    }

    final void setIdxtoNextCurrentChildLengthUnknown() {
        assert (this.ixChildEnd >= this.ixChild);
        assert (this.ixChildEnd >= 0);
        this.ixChild = this.ixChildEnd;
        this.ixChildEnd = -1;
    }

    protected final String getString(int n, int n2) {
        int n3 = n + this.ixBegin;
        int n4 = n3 + n2;
        assert (n4 <= this.ixEnd && n4 <= this.data.length);
        while (this.data[--n4] == 0 && n4 > n3) {
        }
        int n5 = n4 + 1 - n3;
        String string = new String(this.data, n3, n5, this.charset);
        return string;
    }

    protected final int setString(int n, int n2, String string) {
        byte[] byArray;
        if (string.length() > n2) {
            string = string.substring(0, n2);
        }
        try {
            byArray = string.getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byArray = null;
        }
        int n3 = byArray.length;
        if (n3 > n2) {
            n3 = n2;
        }
        System.arraycopy(byArray, 0, this.data, this.ixBegin + n, n3);
        return n3;
    }

    protected final void _setString(int n, int n2, String string, String string2, boolean bl) throws UnsupportedEncodingException {
        byte[] byArray;
        int n3;
        int n4 = n + this.ixBegin;
        int n5 = n4 + n2;
        if (string2 == null) {
            string2 = "ISO-8859-1";
        }
        if ((n3 = (byArray = string.getBytes(string2)).length) > n2) {
            n3 = n2;
        }
        for (int i = 0; i < n3; ++i) {
            int n6 = byArray[i];
            if (bl && n6 < 32) {
                n6 = 63;
            }
            this.data[n4++] = n6;
        }
        while (n4 < n5) {
            this.data[n4++] = 0;
        }
    }

    @Java4C.Retinline
    protected final float getFloat(int n) {
        int n2 = this.getInt32(n);
        float f = Float.intBitsToFloat(n2);
        return f;
    }

    @Java4C.Retinline
    protected final double getDouble(int n) {
        long l = this._getLong(n, 8);
        return Double.longBitsToDouble(l);
    }

    @Java4C.Retinline
    protected final long getInt64(int n) {
        int n2;
        int n3;
        if (this.bBigEndian) {
            n3 = this.getInt32(n);
            n2 = this.getInt32(n + 4);
        } else {
            n3 = this.getInt32(n + 4);
            n2 = this.getInt32(n);
        }
        long l = n2 << 32;
        return l |= (long)(n3 & 0xFFFFFFFF);
    }

    protected final int getInt32(int n) {
        int n2 = this.bBigEndian ? this.data[this.ixBegin + n] << 24 | this.data[this.ixBegin + n + 1] << 16 & 0xFF0000 | this.data[this.ixBegin + n + 2] << 8 & 0xFF00 | this.data[this.ixBegin + n + 3] & 0xFF : this.data[this.ixBegin + n + 3] << 24 | this.data[this.ixBegin + n + 2] << 16 & 0xFF0000 | this.data[this.ixBegin + n + 1] << 8 & 0xFF00 | this.data[this.ixBegin + n] & 0xFF;
        return n2;
    }

    @Java4C.Retinline
    protected final int getUint32(int n) {
        return this.getInt32(n);
    }

    protected final int getUint16(int n) {
        int n2 = this.bBigEndian ? this.data[this.ixBegin + n] << 8 & 0xFF00 | this.data[this.ixBegin + n + 1] & 0xFF : this.data[this.ixBegin + n + 1] << 8 & 0xFF00 | this.data[this.ixBegin + n] & 0xFF;
        return n2;
    }

    protected final short getInt16(int n) {
        int n2 = this.bBigEndian ? this.data[this.ixBegin + n] << 8 & 0xFF00 | this.data[this.ixBegin + n + 1] & 0xFF : this.data[this.ixBegin + n + 1] << 8 & 0xFF00 | this.data[this.ixBegin + n] & 0xFF;
        return (short)n2;
    }

    protected final char getChar(int n) {
        char c = (char)this.data[this.ixBegin + n];
        return c;
    }

    protected final byte getInt8(int n) {
        byte by = this.data[this.ixBegin + n];
        return by;
    }

    protected final int getUint8(int n) {
        int n2 = this.data[this.ixBegin + n] & 0xFF;
        return n2;
    }

    protected final int getUint32(int n, int n2, int n3) {
        if (n2 >= n3 || n2 < 0) {
            throw new IndexOutOfBoundsException("getUint16:" + n2);
        }
        return this.getUint32(n + 4 * n2);
    }

    protected final int getInt32(int n, int n2, int n3) {
        if (n2 >= n3 || n2 < 0) {
            throw new IndexOutOfBoundsException("getInt32:" + n2);
        }
        return this.getInt32(n + 4 * n2);
    }

    protected final int getInt16(int n, int n2, int n3) {
        if (n2 >= n3 || n2 < 0) {
            throw new IndexOutOfBoundsException("getInt16:" + n2);
        }
        return this.getInt16(n + 2 * n2);
    }

    protected final int getInt8(int n, int n2, int n3) {
        if (n2 >= n3 || n2 < 0) {
            throw new IndexOutOfBoundsException("getInt8:" + n2);
        }
        return this.getInt8(n + n2);
    }

    protected final int getUint16(int n, int n2, int n3) {
        if (n2 >= n3 || n2 < 0) {
            throw new IndexOutOfBoundsException("getUint16:" + n2);
        }
        return this.getUint16(n + 2 * n2);
    }

    protected final int getUint8(int n, int n2, int n3) {
        if (n2 >= n3 || n2 < 0) {
            throw new IndexOutOfBoundsException("getUint8:" + n2);
        }
        return this.getInt8(n + n2);
    }

    protected final float getFloat(int n, int n2, int n3) {
        if (n2 >= n3 || n2 < 0) {
            throw new IndexOutOfBoundsException("getFloat:" + n2);
        }
        return this.getFloat(n + 4 * n2);
    }

    @Java4C.Inline
    protected final void setFloat(int n, float f) {
        int n2 = Float.floatToRawIntBits(f);
        this._setLong(n, 4, n2);
    }

    @Java4C.Inline
    protected final void setDouble(int n, double d) {
        long l = Double.doubleToRawLongBits(d);
        this._setLong(n, 8, l);
    }

    protected final void setInt32(int n, int n2) {
        if (this.bBigEndian) {
            this.data[this.ixBegin + n] = (byte)(n2 >> 24 & 0xFF);
            this.data[this.ixBegin + n + 1] = (byte)(n2 >> 16 & 0xFF);
            this.data[this.ixBegin + n + 2] = (byte)(n2 >> 8 & 0xFF);
            this.data[this.ixBegin + n + 3] = (byte)(n2 & 0xFF);
        } else {
            this.data[this.ixBegin + n + 3] = (byte)(n2 >> 24 & 0xFF);
            this.data[this.ixBegin + n + 2] = (byte)(n2 >> 16 & 0xFF);
            this.data[this.ixBegin + n + 1] = (byte)(n2 >> 8 & 0xFF);
            this.data[this.ixBegin + n] = (byte)(n2 & 0xFF);
        }
    }

    @Java4C.Inline
    protected final void setInt8(int n, int n2) {
        this.data[this.ixBegin + n] = (byte)(n2 & 0xFF);
    }

    @Java4C.Inline
    protected final void setUint8(int n, int n2) {
        this.setInt8(n, n2);
    }

    protected final void setUint32(int n, long l) {
        if (this.bBigEndian) {
            this.data[this.ixBegin + n] = (byte)(l >> 24 & 0xFFL);
            this.data[this.ixBegin + n + 1] = (byte)(l >> 16 & 0xFFL);
            this.data[this.ixBegin + n + 2] = (byte)(l >> 8 & 0xFFL);
            this.data[this.ixBegin + n + 3] = (byte)(l & 0xFFL);
        } else {
            this.data[this.ixBegin + n + 3] = (byte)(l >> 24 & 0xFFL);
            this.data[this.ixBegin + n + 2] = (byte)(l >> 16 & 0xFFL);
            this.data[this.ixBegin + n + 1] = (byte)(l >> 8 & 0xFFL);
            this.data[this.ixBegin + n] = (byte)(l & 0xFFL);
        }
    }

    protected final void setInt16(int n, int n2) {
        if (this.bBigEndian) {
            this.data[this.ixBegin + n] = (byte)(n2 >> 8 & 0xFF);
            this.data[this.ixBegin + n + 1] = (byte)(n2 & 0xFF);
        } else {
            this.data[this.ixBegin + n + 1] = (byte)(n2 >> 8 & 0xFF);
            this.data[this.ixBegin + n] = (byte)(n2 & 0xFF);
        }
    }

    @Java4C.Inline
    protected final void setUint16(int n, int n2) {
        this.setInt16(n, n2);
    }

    private final void throwexc(String string, int n) {
        String string2 = string + n;
        throw new IndexOutOfBoundsException(string2);
    }

    @Java4C.Inline
    protected final void setUint32(int n, int n2, int n3, int n4) {
        if (n2 >= n3 || n2 < 0) {
            this.throwexc("setUint32:", n2);
        }
        this.setUint32(n + 4 * n2, n4);
    }

    @Java4C.Inline
    protected final void setInt32(int n, int n2, int n3, int n4) {
        if (n2 >= n3 || n2 < 0) {
            this.throwexc("setInt32:", n2);
        }
        this.setInt32(n + 4 * n2, n4);
    }

    @Java4C.Inline
    protected final void setInt16(int n, int n2, int n3, int n4) {
        if (n2 >= n3 || n2 < 0) {
            throw new IndexOutOfBoundsException("getInt16:" + n2);
        }
        this.setInt16(n + 2 * n2, n4);
    }

    @Java4C.Inline
    protected final void setInt8(int n, int n2, int n3, int n4) {
        if (n2 >= n3 || n2 < 0) {
            throw new IndexOutOfBoundsException("getInt16:" + n2);
        }
        this.setInt8(n + n2, n4);
    }

    @Java4C.Inline
    protected final void setUint16(int n, int n2, int n3, int n4) {
        if (n2 >= n3 || n2 < 0) {
            throw new IndexOutOfBoundsException("getInt16:" + n2);
        }
        this.setUint16(n + 2 * n2, n4);
    }

    @Java4C.Inline
    protected final void setUint8(int n, int n2, int n3, int n4) {
        if (n2 >= n3 || n2 < 0) {
            throw new IndexOutOfBoundsException("getInt16:" + n2);
        }
        this.setUint8(n + n2, n4);
    }

    @Java4C.Inline
    protected final void setFloat(int n, int n2, int n3, float f) {
        if (n2 >= n3 || n2 < 0) {
            throw new IndexOutOfBoundsException("getInt16:" + n2);
        }
        this.setFloat(n + 4 * n2, f);
    }

    protected final void correctCurrentChildEnd(int n) {
        if (this.ixEnd < n) {
            this.ixEnd = n;
        }
        if (this.ixChildEnd < n) {
            this.ixChildEnd = n;
        }
        if (this.parent != null) {
            this.parent.correctCurrentChildEnd(n);
        }
    }

    protected final void setIdxCurrentChildEnd(int n) throws IllegalArgumentException {
        if (this.data.length < this.ixChild + n) {
            String string = "data length to small:" + (this.ixChild + n);
            throw new IllegalArgumentException(string);
        }
        this._expand(this.ixChild + n);
    }

    @Java4C.Exclude
    public String toString() {
        if (this.data == null) {
            return "no data";
        }
        if (this.toStringformatter == null) {
            this.toStringformatter = new StringFormatter();
        } else {
            this.toStringformatter.reset();
        }
        int n = this.getLengthHead();
        this.toStringformatter.addint(this.ixBegin, "33331").add("..").addint(this.ixBegin + n, "333331").add("..").addint(this.ixEnd, "333331").add(":");
        if (n > 16) {
            n = 16;
        }
        if (n < 0) {
            n = 4;
        }
        if (this.ixBegin + n > this.data.length) {
            n = this.data.length - this.ixBegin;
        }
        this.toStringformatter.addHexLine(this.data, this.ixBegin, n, this.bBigEndian ? (short)36 : 4);
        this.toStringformatter.add(" child ").addint(this.ixChild, "-3331").add("..").addint(this.ixChildEnd, "-33331").add(":");
        if (this.ixChild >= this.ixBegin) {
            n = this.ixChildEnd - this.ixChild;
            if (n > 16) {
                n = 16;
            }
            if (n < 0) {
                n = 4;
            }
            if (this.ixChild + n > this.data.length) {
                n = this.data.length - this.ixBegin;
            }
            this.toStringformatter.addHexLine(this.data, this.ixChild, n, this.bBigEndian ? (short)36 : 4);
        }
        String string = this.toStringformatter.toString();
        return string;
    }
}

