/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.reflect;

import java.lang.reflect.Field;
import java.util.Map;
import java.util.TreeMap;
import org.vishia.bridgeC.MemSegmJc;
import org.vishia.reflect.FieldJc;

public final class ClassJc {
    public static final int version = 20120409;
    private static final Map<String, ClassJc> allClasses = new TreeMap<String, ClassJc>();
    public static final int REFLECTION_void = 1;
    public static final int REFLECTION_int64 = 2;
    public static final int REFLECTION_uint64 = 3;
    public static final int REFLECTION_int32 = 4;
    public static final int REFLECTION_uint32 = 5;
    public static final int REFLECTION_int16 = 6;
    public static final int REFLECTION_uint16 = 7;
    public static final int REFLECTION_int8 = 8;
    public static final int REFLECTION_uint8 = 9;
    @Deprecated
    public static final int REFLECTION_int = 10;
    @Deprecated
    public static final int REFLECTION_uint = 11;
    public static final int REFLECTION_float = 12;
    public static final int REFLECTION_double = 13;
    public static final int REFLECTION_char8 = 14;
    public static final int REFLECTION_char16 = 15;
    public static final int REFLECTION_String = 16;
    public static final int REFLECTION_boolean = 22;
    public static final int REFLECTION_bitfield = 23;
    public static final int[] nrofBytesScalarTypes = new int[]{0, 0, 8, 8, 4, 4, 2, 2, 1, 1, 4, 4, 4, 8, 1, 2, 8, 0, 0, 0, 0, 0, 1, 4};
    private final Class<?> clazz;
    private ClassJc superClass;
    private FieldJc superField;
    private boolean bSuperClassChecked;
    private Map<String, FieldJc> indexNameFields;
    private FieldJc[] allFields;
    private final int modifier;
    private final String name;

    private ClassJc(Class<?> clazz) {
        this.clazz = clazz;
        this.modifier = clazz.getModifiers();
        this.name = clazz.getName();
        allClasses.put(this.name, this);
    }

    void fillAllFields() {
        if (this.indexNameFields == null) {
            Field[] fieldArray = this.clazz.getDeclaredFields();
            this.indexNameFields = new TreeMap<String, FieldJc>();
            Class<?> clazz = this.clazz.getSuperclass();
            this.allFields = new FieldJc[fieldArray.length];
            int n = -1;
            for (Field field : fieldArray) {
                String string = field.getName();
                FieldJc fieldJc = new FieldJc(field);
                this.indexNameFields.put(string, fieldJc);
                this.allFields[++n] = fieldJc;
            }
        }
    }

    private ClassJc(String string, int n) {
        this.name = string;
        this.modifier = n;
        this.clazz = null;
        allClasses.put(string, this);
    }

    public static ClassJc getClass(Object object) {
        Class<?> clazz = object.getClass();
        String string = clazz.getName();
        ClassJc classJc = allClasses.get(string);
        if (classJc == null) {
            MemSegmJc memSegmJc = new MemSegmJc(object, 0);
            classJc = new ClassJc(clazz);
        }
        return classJc;
    }

    public static ClassJc fromClass(Class<?> clazz) {
        String string = clazz.getName();
        ClassJc classJc = allClasses.get(string);
        if (classJc == null) {
            classJc = new ClassJc(clazz);
            allClasses.put(string, classJc);
        }
        return classJc;
    }

    public static ClassJc forName(String string) {
        ClassJc classJc = allClasses.get(string);
        if (classJc == null) {
            // empty if block
        }
        return classJc;
    }

    public static ClassJc primitive(String string) {
        ClassJc classJc = allClasses.get(string);
        if (classJc == null) {
            classJc = new ClassJc(string, 983040);
            allClasses.put(string, classJc);
        }
        return classJc;
    }

    public String getName() {
        return this.name;
    }

    public FieldJc[] getDeclaredFields() {
        this.fillAllFields();
        return this.allFields;
    }

    public FieldJc getDeclaredField(String string) throws NoSuchFieldException {
        this.fillAllFields();
        FieldJc fieldJc = this.indexNameFields.get(string);
        if (fieldJc == null) {
            throw new NoSuchFieldException(string);
        }
        return fieldJc;
    }

    public boolean isPrimitive() {
        return (this.modifier & 0xF0000) != 0 || this.clazz != null && this.clazz.isPrimitive();
    }

    public Class<?> getClazz() {
        return this.clazz;
    }

    public ClassJc getEnclosingClass() {
        return null;
    }

    public ClassJc getSuperClass() {
        if (!this.bSuperClassChecked) {
            Class<?> clazz = this.clazz.getSuperclass();
            if (clazz != Object.class) {
                this.superClass = ClassJc.fromClass(clazz);
                this.superField = new FieldJc(this.superClass, "super");
            }
            this.bSuperClassChecked = true;
        }
        return this.superClass;
    }

    public FieldJc getSuperField() {
        this.getSuperClass();
        return this.superField;
    }
}

