/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.gral.widget;

import java.util.ArrayList;
import java.util.List;
import org.vishia.gral.base.GralMenu;
import org.vishia.gral.base.GralMng;
import org.vishia.gral.base.GralWidgImpl_ifc;
import org.vishia.gral.base.GralWidget;
import org.vishia.gral.ifc.GralColor;
import org.vishia.gral.ifc.GralUserAction;
import org.vishia.gral.ifc.GralWidget_ifc;
import org.vishia.util.KeyCode;

public class GralHorizontalSelector<UserData>
extends GralWidget {
    public static final int version = 20130618;
    protected List<Item<UserData>> items = new ArrayList<Item<UserData>>();
    protected Item<UserData> actItem = null;
    protected int ixActItem = 0;
    protected int ixDstItem = 0;
    protected int ixLeftItem = 0;
    protected int minSize;
    public GralColor colorText;
    public GralColor colorSelect;
    public GralColor colorBack;
    public GralColor colorLine;
    GralUserAction actionRemoveTab = new GralUserAction("actionRemoveTab"){

        @Override
        public boolean exec(int n, GralWidget_ifc gralWidget_ifc, Object ... objectArray) {
            if (KeyCode.isControlFunctionMouseUpOrMenu((int)n)) {
                GralHorizontalSelector.this.removeTab();
            }
            return true;
        }
    };

    public GralHorizontalSelector(String string, GralUserAction gralUserAction) {
        super(string, 'n');
        this.colorText = GralColor.getColor("bk");
        this.colorSelect = GralColor.getColor("rd");
        this.colorBack = GralColor.getColor("wh");
        this.colorLine = GralColor.getColor("bk");
        this.setActionChange(gralUserAction);
    }

    public void addItem(String string, int n, UserData UserData) {
        Item item = new Item();
        item.text = string;
        item.xSize = 0;
        item.data = UserData;
        int n2 = n < 0 || n > this.items.size() ? this.items.size() : n;
        this.items.add(n2, item);
        this.ixActItem = this.ixDstItem = n2;
        this.actItem = item;
    }

    public boolean setActItem(String string) {
        int n = 0;
        for (Item<UserData> item : this.items) {
            if (item.text.equals(string)) {
                this.actItem = item;
                this.ixActItem = n;
                this.ixDstItem = n;
                return true;
            }
            ++n;
        }
        return false;
    }

    public void removeItem(String string) {
        for (Item<UserData> item : this.items) {
            if (!item.text.equals(string)) continue;
            this.items.remove(item);
        }
    }

    protected void setDstToActItem() {
        if (this.ixDstItem >= 0) {
            this.ixActItem = this.ixDstItem;
            this.actItem = this.items.get(this.ixActItem);
            if (this.actionChanging != null) {
                this.actionChanging.exec(720993, this, this.actItem.data);
            }
        }
    }

    protected void removeTab() {
        boolean bl = this.ixDstItem == this.ixActItem;
        Item<UserData> item = this.items.remove(this.ixDstItem);
        if (this.actionChanging != null) {
            this.actionChanging.exec(721016, this, item.data);
        }
        if (this.ixDstItem < this.ixActItem) {
            --this.ixActItem;
        }
        if (bl) {
            if (this.ixActItem >= this.items.size()) {
                this.ixDstItem = this.ixActItem - 1;
            }
            this.setDstToActItem();
        } else {
            this.ixDstItem = this.ixActItem;
        }
        this.repaint(100, 300);
    }

    public static abstract class GraphicImplAccess<UserData>
    extends GralWidget.ImplAccess
    implements GralWidgImpl_ifc {
        protected final GralHorizontalSelector<UserData> outer;

        protected GraphicImplAccess(GralHorizontalSelector<UserData> gralHorizontalSelector, GralMng gralMng) {
            super(gralHorizontalSelector, gralMng);
            this.outer = gralHorizontalSelector;
        }

        protected List<Item<UserData>> items() {
            return this.outer.items;
        }

        protected Item<?> actItem() {
            return this.outer.actItem;
        }

        protected Item<?> tab(int n) {
            return this.outer.items.get(n);
        }

        protected int nrItem() {
            return this.outer.ixDstItem;
        }

        protected int nrofTabs() {
            return this.outer.items.size();
        }

        protected void calcLeftTab(int n, int n2) {
            int n3 = 0;
            int n4 = this.outer.ixDstItem;
            if (this.outer.items.size() > 0) {
                this.outer.ixLeftItem = 0;
                while (this.outer.ixLeftItem == 0 && n4 >= 0) {
                    Item item = this.outer.items.get(n4);
                    if (item.xSize == 0) {
                        // empty if block
                    }
                    if (n2 + n3 + item.xSize + n2 + 4 > n) {
                        this.outer.ixLeftItem = n4 + 1;
                        continue;
                    }
                    n3 += item.xSize;
                    --n4;
                }
            } else {
                this.outer.ixLeftItem = -1;
            }
        }

        protected void findTab(int n) {
            int n2 = this.outer.ixLeftItem;
            int n3 = n2 == 0 ? 2 : 22;
            boolean bl = false;
            int n4 = this.outer.items.size();
            do {
                Item<?> item = this.tab(n2);
                if (n3 + item.xSize > n) {
                    bl = true;
                    continue;
                }
                n3 += item.xSize;
                ++n2;
            } while (n2 < n4 && !bl);
            if (bl) {
                this.outer.ixDstItem = n2;
            }
        }

        protected void setDstToActItem() {
            this.outer.setDstToActItem();
        }

        protected void clearDstItem() {
            this.outer.ixDstItem = this.outer.ixActItem;
        }

        protected void removeDstItem() {
            this.outer.items.remove(this.outer.ixDstItem);
            if (this.outer.ixDstItem < this.outer.ixActItem) {
                --this.outer.ixActItem;
            }
            this.clearDstItem();
        }

        protected void execAfterCreationImplWidget() {
            GralMenu gralMenu = this.outer.getContextMenu();
            gralMenu.addMenuItemGthread("&Close tab", this.outer.actionRemoveTab);
        }

        protected int nrLeftTab() {
            return this.outer.ixLeftItem;
        }
    }

    public static class Item<UserData> {
        public String text;
        public int xSize;
        protected UserData data;
        protected boolean removeIfNotUsed;
    }
}

