/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.gral.widget;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.vishia.event.EventSource;
import org.vishia.fileRemote.FileAccessZip;
import org.vishia.fileRemote.FileRemote;
import org.vishia.fileRemote.FileRemoteCallback;
import org.vishia.gral.base.GralButton;
import org.vishia.gral.base.GralMenu;
import org.vishia.gral.base.GralPanelContent;
import org.vishia.gral.base.GralPos;
import org.vishia.gral.base.GralTable;
import org.vishia.gral.base.GralTextField;
import org.vishia.gral.base.GralValueBar;
import org.vishia.gral.base.GralWidget;
import org.vishia.gral.ifc.GralColor;
import org.vishia.gral.ifc.GralMngBuild_ifc;
import org.vishia.gral.ifc.GralTableLine_ifc;
import org.vishia.gral.ifc.GralTextField_ifc;
import org.vishia.gral.ifc.GralUserAction;
import org.vishia.gral.ifc.GralWidget_ifc;
import org.vishia.gral.ifc.GralWindow_ifc;
import org.vishia.gral.widget.GralInfoBox;
import org.vishia.gral.widget.GralSelectList;
import org.vishia.util.FileSystem;
import org.vishia.util.IndexMultiTable;
import org.vishia.util.KeyCode;
import org.vishia.util.MarkMask_ifc;
import org.vishia.util.Removeable;
import org.vishia.util.SortedTreeWalkerCallback;

public class GralFileSelector
implements Removeable {
    public static final String sVersion = "2014-12-27";
    protected WindowConfirmSearch windSearch;
    private final GralUserAction actionOnFileSelection = new GralUserAction(){

        @Override
        public boolean userActionGui(int n, GralWidget gralWidget, Object ... objectArray) {
            GralTableLine_ifc gralTableLine_ifc;
            if (n == 720979 && (gralTableLine_ifc = (GralTableLine_ifc)objectArray[0]) != null) {
                FileRemote fileRemote = (FileRemote)gralTableLine_ifc.getUserData();
                String string = gralTableLine_ifc.getCellText(1);
                if (fileRemote.exists()) {
                    if (string.equals("..")) {
                        GralFileSelector.this.currentFile = fileRemote;
                        GralFileSelector.this.currentDir = fileRemote;
                    } else {
                        GralFileSelector.this.currentDir = fileRemote.getParentFile();
                        GralFileSelector.this.currentFile = fileRemote;
                        String string2 = fileRemote.getParent();
                        GralFileSelector.this.indexSelection.put(string2, fileRemote);
                    }
                    if (GralFileSelector.this.actionOnFileSelected != null) {
                        GralFileSelector.this.actionOnFileSelected.exec(0, GralFileSelector.this.selectList.wdgdTable, gralTableLine_ifc, fileRemote);
                    }
                    if (gralTableLine_ifc.getCellText(0).startsWith("?")) {
                        GralFileSelector.this.completeLine(gralTableLine_ifc, fileRemote, System.currentTimeMillis());
                    }
                }
            }
            return true;
        }
    };
    private final MarkMask_ifc actionOnMarkLine = new MarkMask_ifc(){

        public int getMark() {
            return 0;
        }

        public int setNonMarked(int n, Object object) {
            assert (object instanceof FileRemote);
            FileRemote fileRemote = (FileRemote)object;
            fileRemote.resetMarked(n);
            return n;
        }

        public int setMarked(int n, Object object) {
            assert (object instanceof FileRemote);
            FileRemote fileRemote = (FileRemote)object;
            fileRemote.setMarked(n);
            return n;
        }
    };
    public static final int zColumns = 4;
    public static final int kColDesignation = 0;
    public static final int kColFilename = 1;
    public static final int kColLength = 2;
    public static final int kColDate = 3;
    public static final char kSortName = 'n';
    public static final char kSortNameNonCase = 'N';
    public static final char kSortExtension = 'x';
    public static final char kSortExtensionNonCase = 'X';
    public static final char kSortDateNewest = 'd';
    public static final char kSortDateOldest = 'o';
    public static final char kSortSizeLargest = 'l';
    public static final char kSortSizeSmallest = 's';
    public static MenuTexts contextMenuTexts = new MenuTexts();
    private char sortOrder = (char)110;
    private char sortOrderLast = (char)48;
    protected char showTime = (char)109;
    protected FileSelectList selectList;
    GralColor colorBack;
    GralColor colorBackPending;
    private final IndexMultiTable<String, GralTableLine_ifc<FileRemote>> idxLines = new IndexMultiTable(IndexMultiTable.providerString);
    protected final GralTable<?> favorList;
    private final Map<String, FileRemote> indexSelection = new TreeMap<String, FileRemote>();
    protected long timeFillinInvoked;
    protected long timeFilesRefreshed;
    protected long timeFillinFinished;
    protected int durationRefresh;
    protected int durationFillin;
    protected int refreshCount;
    boolean donotCheckRefresh = true;
    protected GralTextField widgdPathDir;
    String sDatePrefixNewer = "";
    SimpleDateFormat dateFormatNewer = new SimpleDateFormat("?yy-MM-dd HH:mm:ss");
    String sDatePrefixToday = "";
    SimpleDateFormat dateFormatToday = new SimpleDateFormat("@ HH:mm:ss");
    String sDatePrefixYear = "";
    SimpleDateFormat dateFormatYear = new SimpleDateFormat("MMM-dd HH:mm:ss");
    String sDatePrefixOlder = "";
    SimpleDateFormat dateFormatOlder = new SimpleDateFormat("yy-MM-dd HH:mm:ss");
    protected FileRemote currentDir;
    protected FileRemote currentFile;
    String sCurrentDir;
    FileRemote originDir;
    protected GralUserAction actionOnFileSelected;
    private GralUserAction actionOnEnterFile;
    private GralUserAction actionOnEnterDirectory;
    private GralUserAction actionOnEnterPathNewFile;
    GralUserAction actionSetFileAttribs;
    private GralInfoBox questionWindow;
    private final EventSource evSrc = new EventSource("GralFileSelector"){};
    boolean fillinPending;
    public FileRemoteCallback callbackChildren1 = new FileRemoteCallback(){

        public void start(FileRemote fileRemote) {
        }

        public SortedTreeWalkerCallback.Result offerParentNode(FileRemote fileRemote) {
            return SortedTreeWalkerCallback.Result.cont;
        }

        public SortedTreeWalkerCallback.Result finishedParentNode(FileRemote fileRemote, SortedTreeWalkerCallback.Counters counters) {
            return SortedTreeWalkerCallback.Result.cont;
        }

        public SortedTreeWalkerCallback.Result offerLeafNode(FileRemote fileRemote) {
            GralFileSelector.this.showFile(fileRemote);
            return SortedTreeWalkerCallback.Result.cont;
        }

        public void finished(FileRemote fileRemote, SortedTreeWalkerCallback.Counters counters) {
            GralFileSelector.this.finishShowFileTable();
        }

        public boolean shouldAborted() {
            return false;
        }
    };
    GralUserAction actionSetPath = new GralUserAction(){

        @Override
        public boolean userActionGui(int n, GralWidget gralWidget, Object ... objectArray) {
            String string;
            int n2;
            if (n == 917517 && (n2 = (string = gralWidget.getValue()).indexOf(42)) < 0) {
                FileRemote fileRemote = GralFileSelector.this.originDir.itsCluster.getDir((CharSequence)string);
                if (fileRemote.isDirectory()) {
                    GralFileSelector.this.fillIn(fileRemote, false);
                } else if (fileRemote.isFile()) {
                    FileRemote fileRemote2 = fileRemote.getParentFile();
                    String string2 = FileSystem.getCanonicalPath((File)fileRemote2);
                    String string3 = fileRemote.getName();
                    GralFileSelector.this.indexSelection.put(string2, fileRemote);
                    GralFileSelector.this.fillIn(fileRemote2, false);
                } else {
                    FileRemote fileRemote3 = fileRemote.getParentFile();
                    if (fileRemote3 != null && fileRemote3.exists()) {
                        if (GralFileSelector.this.actionOnEnterPathNewFile != null) {
                            GralFileSelector.this.actionOnEnterPathNewFile.userActionGui(917517, (GralWidget)GralFileSelector.this.widgdPathDir, fileRemote);
                        } else {
                            String string4 = "Do you want to create file\n" + fileRemote.getName() + "\n  in directory\n" + fileRemote3.getPath();
                            GralFileSelector.this.questionWindow.setText(string4);
                            GralFileSelector.this.questionWindow.setActionOk(GralFileSelector.this.confirmCreate);
                            GralFileSelector.this.questionWindow.setWindowVisible(true);
                        }
                    } else {
                        GralFileSelector.this.questionWindow.setText("unknown path");
                        GralFileSelector.this.questionWindow.setActionOk(null);
                        GralFileSelector.this.questionWindow.setWindowVisible(true);
                    }
                }
            }
            GralFileSelector.this.stop();
            return false;
        }
    };
    GralUserAction actionSortFilePerNameCase = new GralUserAction("actionSortFilePerNameCase"){

        @Override
        public boolean exec(int n, GralWidget_ifc gralWidget_ifc, Object ... objectArray) {
            GralFileSelector.this.setSortOrderFiles('n');
            return true;
        }
    };
    GralUserAction actionSortFilePerNameNonCase = new GralUserAction("actionSortFilePerNameNonCase"){

        @Override
        public boolean exec(int n, GralWidget_ifc gralWidget_ifc, Object ... objectArray) {
            GralFileSelector.this.setSortOrderFiles('N');
            return true;
        }
    };
    GralUserAction actionSortFilePerExtensionCase = new GralUserAction("actionSortFilePerExtensionCase"){

        @Override
        public boolean exec(int n, GralWidget_ifc gralWidget_ifc, Object ... objectArray) {
            GralFileSelector.this.setSortOrderFiles('x');
            return true;
        }
    };
    GralUserAction actionSortFilePerExtensionNonCase = new GralUserAction("actionSortFilePerExtensionNonCase"){

        @Override
        public boolean exec(int n, GralWidget_ifc gralWidget_ifc, Object ... objectArray) {
            GralFileSelector.this.setSortOrderFiles('X');
            return true;
        }
    };
    GralUserAction actionSortFilePerTimestamp = new GralUserAction("actionSortFilePerTimestamp"){

        @Override
        public boolean exec(int n, GralWidget_ifc gralWidget_ifc, Object ... objectArray) {
            GralFileSelector.this.setSortOrderFiles('d');
            return true;
        }
    };
    GralUserAction actionSortFilePerTimestampOldestFirst = new GralUserAction("actionSortFilePerTimestampOldestFirst"){

        @Override
        public boolean exec(int n, GralWidget_ifc gralWidget_ifc, Object ... objectArray) {
            GralFileSelector.this.setSortOrderFiles('o');
            return true;
        }
    };
    GralUserAction actionShowLastModifiedTime = new GralUserAction("actionSortFilePerTimestamp"){

        @Override
        public boolean exec(int n, GralWidget_ifc gralWidget_ifc, Object ... objectArray) {
            GralFileSelector.this.showTime = (char)109;
            return true;
        }
    };
    GralUserAction actionShowLastAccessTime = new GralUserAction("actionSortFilePerTimestamp"){

        @Override
        public boolean exec(int n, GralWidget_ifc gralWidget_ifc, Object ... objectArray) {
            GralFileSelector.this.showTime = (char)97;
            return true;
        }
    };
    GralUserAction actionShowCreationTime = new GralUserAction("actionSortFilePerTimestamp"){

        @Override
        public boolean exec(int n, GralWidget_ifc gralWidget_ifc, Object ... objectArray) {
            GralFileSelector.this.showTime = (char)99;
            return true;
        }
    };
    GralUserAction actionSortFilePerLenghLargestFirst = new GralUserAction("actionSortFilePerLenghLargestFirst"){

        @Override
        public boolean exec(int n, GralWidget_ifc gralWidget_ifc, Object ... objectArray) {
            GralFileSelector.this.setSortOrderFiles('l');
            return true;
        }
    };
    GralUserAction actionSortFilesPerLenghSmallestFirst = new GralUserAction("actionSortFilesPerLenghSmallestFirst"){

        @Override
        public boolean exec(int n, GralWidget_ifc gralWidget_ifc, Object ... objectArray) {
            GralFileSelector.this.setSortOrderFiles('s');
            return true;
        }
    };
    GralUserAction actionDeselectDirtree = new GralUserAction("actionDeselectDirtree"){

        @Override
        public boolean exec(int n, GralWidget_ifc gralWidget_ifc, Object ... objectArray) {
            if (GralFileSelector.this.currentFile != null) {
                Thread thread = new Thread("actionDeselectDirtree"){

                    @Override
                    public void run() {
                        GralFileSelector.this.currentFile.resetMarkedRecurs(-1, null);
                        GralFileSelector.this.currentFile.setDirShouldRefresh();
                    }
                };
                thread.start();
            }
            return true;
        }
    };
    GralUserAction actionRefreshFileTable = new GralUserAction(){

        @Override
        public boolean userActionGui(int n, GralWidget gralWidget, Object ... objectArray) {
            if (KeyCode.isControlFunctionMouseUpOrMenu((int)n)) {
                GralFileSelector.this.fillInCurrentDir();
                return true;
            }
            return false;
        }
    };
    GralUserAction actionSwitchoffCheckRefresh = new GralUserAction("actionSwitchoffCheckRefresh"){

        @Override
        public boolean userActionGui(int n, GralWidget gralWidget, Object ... objectArray) {
            if (KeyCode.isControlFunctionMouseUpOrMenu((int)n)) {
                GralFileSelector.this.donotCheckRefresh = true;
                return true;
            }
            return false;
        }
    };
    GralUserAction actionSwitchonCheckRefresh = new GralUserAction("actionSwitchoffCheckRefresh"){

        @Override
        public boolean userActionGui(int n, GralWidget gralWidget, Object ... objectArray) {
            if (KeyCode.isControlFunctionMouseUpOrMenu((int)n)) {
                GralFileSelector.this.donotCheckRefresh = false;
                return true;
            }
            return false;
        }
    };
    GralUserAction confirmCreate = new GralUserAction(){

        @Override
        public boolean userActionGui(int n, GralWidget gralWidget, Object ... objectArray) {
            return true;
        }
    };
    GralUserAction actionFavorButton = new GralUserAction("actionFavorButton"){

        @Override
        public boolean exec(int n, GralWidget_ifc gralWidget_ifc, Object ... objectArray) {
            if (KeyCode.isControlFunctionMouseUpOrMenu((int)n)) {
                if (GralFileSelector.this.selectList.wdgdTable.isVisible()) {
                    GralFileSelector.this.selectList.wdgdTable.setVisible(false);
                    GralFileSelector.this.favorList.setVisible(true);
                } else {
                    GralFileSelector.this.selectList.wdgdTable.setVisible(true);
                    GralFileSelector.this.favorList.setVisible(false);
                }
                return true;
            }
            return false;
        }
    };

    public GralFileSelector(String string, int n, int[] nArray, char c) {
        this.favorList = new GralTable(null, new int[]{15, 0});
        this.selectList = new FileSelectList(this, string, n, nArray, c);
        this.colorBack = GralColor.getColor("wh");
        this.colorBackPending = GralColor.getColor("pma");
    }

    public void setNameWidget(String string) {
        this.selectList.wdgdTable.name = string;
    }

    public void setDateFormat(String string) {
        this.dateFormatOlder = new SimpleDateFormat(string);
    }

    public void setToPanel(GralMngBuild_ifc gralMngBuild_ifc) {
        GralPos gralPos = gralMngBuild_ifc.getPositionInPanel();
        GralPanelContent gralPanelContent = gralPos.panel;
        String string = gralPanelContent.getName();
        gralMngBuild_ifc.setPosition(gralPos, 32768.0f, 16386.0f, 32768.0f, 32762.0f, 1, 'r');
        this.widgdPathDir = gralMngBuild_ifc.addTextField(null, true, null, null);
        this.widgdPathDir.setActionChange(this.actionSetPath);
        this.widgdPathDir.setBackColor(gralMngBuild_ifc.getColor("pye"), 0xEEFFFF);
        GralMenu gralMenu = this.widgdPathDir.getContextMenu();
        gralMenu.addMenuItemGthread("x", "refresh [cR]", this.actionRefreshFileTable);
        gralMngBuild_ifc.setPosition(32768.0f, 32768.0f, 57342.5f, 16389.5f, 1, 'd');
        gralMngBuild_ifc.addButton(null, this.actionFavorButton, "favor");
        gralMngBuild_ifc.setPosition(gralPos, 32770.0f, 32768.0f, 32768.0f, 32768.0f, 1, 'd');
        this.selectList.setToPanel(gralMngBuild_ifc);
        this.selectList.wdgdTable.setVisible(true);
        this.selectList.wdgdTable.addContextMenuEntryGthread(1, null, GralFileSelector.contextMenuTexts.refresh, this.actionRefreshFileTable);
        this.selectList.wdgdTable.addContextMenuEntryGthread(1, null, GralFileSelector.contextMenuTexts.refreshCyclicOff, this.actionSwitchoffCheckRefresh);
        this.selectList.wdgdTable.addContextMenuEntryGthread(1, null, GralFileSelector.contextMenuTexts.refreshCyclicOn, this.actionSwitchonCheckRefresh);
        this.selectList.wdgdTable.addContextMenuEntryGthread(1, "sort", GralFileSelector.contextMenuTexts.sortNameCase, this.actionSortFilePerNameCase);
        this.selectList.wdgdTable.addContextMenuEntryGthread(1, "sort", GralFileSelector.contextMenuTexts.sortNameNonCase, this.actionSortFilePerNameNonCase);
        this.selectList.wdgdTable.addContextMenuEntryGthread(1, "sort", GralFileSelector.contextMenuTexts.sortExtCase, this.actionSortFilePerExtensionCase);
        this.selectList.wdgdTable.addContextMenuEntryGthread(1, "sort", GralFileSelector.contextMenuTexts.sortExtNonCase, this.actionSortFilePerExtensionNonCase);
        this.selectList.wdgdTable.addContextMenuEntryGthread(1, "sort", GralFileSelector.contextMenuTexts.sortDateNewest, this.actionSortFilePerTimestamp);
        this.selectList.wdgdTable.addContextMenuEntryGthread(1, "sort", GralFileSelector.contextMenuTexts.sortOldest, this.actionSortFilePerTimestampOldestFirst);
        this.selectList.wdgdTable.addContextMenuEntryGthread(1, "sort", GralFileSelector.contextMenuTexts.showLastModifiedTime, this.actionShowLastModifiedTime);
        this.selectList.wdgdTable.addContextMenuEntryGthread(1, "sort", GralFileSelector.contextMenuTexts.showLastAccessTime, this.actionShowLastAccessTime);
        this.selectList.wdgdTable.addContextMenuEntryGthread(1, "sort", GralFileSelector.contextMenuTexts.showCreationTime, this.actionShowCreationTime);
        this.selectList.wdgdTable.addContextMenuEntryGthread(1, "sort", GralFileSelector.contextMenuTexts.sizeLarge, this.actionSortFilePerLenghLargestFirst);
        this.selectList.wdgdTable.addContextMenuEntryGthread(1, "sort", GralFileSelector.contextMenuTexts.sortSizeSmall, this.actionSortFilesPerLenghSmallestFirst);
        this.selectList.wdgdTable.addContextMenuEntryGthread(1, "sort", GralFileSelector.contextMenuTexts.deselectRecursFiles, this.actionDeselectDirtree);
        this.widgdPathDir.setContentInfo(this);
        this.selectList.wdgdTable.setContentInfo(this);
        this.selectList.wdgdTable.specifyActionOnLineSelected(this.actionOnFileSelection);
        this.selectList.wdgdTable.specifyActionOnLineMarked(this.actionOnMarkLine);
        gralMngBuild_ifc.setPosition(gralPos, 32770.0f, 32768.0f, 32768.0f, 0.0f, 1, 'd');
        this.favorList.setToPanel(gralMngBuild_ifc);
        this.favorList.insertLine((String)null, 0, new String[]{"test", "path"}, (Object)null);
        this.favorList.setVisible(false);
        gralMngBuild_ifc.setPosition(5.0f, 0.0f, 10.0f, 16424.0f, 1, 'd');
        this.questionWindow = GralInfoBox.createTextInfoBox(gralMngBuild_ifc, "questionInfoBox", "question");
        gralMngBuild_ifc.selectPanel(string);
    }

    public static WindowConfirmSearch createWindowConfirmSearchGthread(GralMngBuild_ifc gralMngBuild_ifc) {
        WindowConfirmSearch windowConfirmSearch = new WindowConfirmSearch();
        gralMngBuild_ifc.selectPanel("primaryWindow");
        gralMngBuild_ifc.setPosition(-24.0f, 0.0f, -67.0f, 0.0f, 1, 'r');
        windowConfirmSearch.windConfirmSearch = gralMngBuild_ifc.createWindow("windConfirmSearch", "search in file tree", 0x40000000);
        gralMngBuild_ifc.setPosition(4.0f, 16380.5f, 1.0f, -1.0f, 0, 'd', 0.5f);
        windowConfirmSearch.widgPath = gralMngBuild_ifc.addTextField("path", false, "path", "t");
        windowConfirmSearch.widgMask = gralMngBuild_ifc.addTextField("mask", true, "search name/mask:", "t");
        windowConfirmSearch.widgText = gralMngBuild_ifc.addTextField("containsText", true, "contains text:", "t");
        gralMngBuild_ifc.setPosition(-5.0f, 16383.0f, 1.0f, -1.0f, 0, 'r', 2.0f);
        windowConfirmSearch.widgProgression = gralMngBuild_ifc.addValueBar(null, null);
        gralMngBuild_ifc.setPosition(-1.0f, 16381.0f, 1.0f, 16392.0f, 0, 'r', 2.0f);
        gralMngBuild_ifc.addButton(null, windowConfirmSearch.actionFileSearch, "esc", null, "esc");
        windowConfirmSearch.widgSubdirs = gralMngBuild_ifc.addSwitchButton(null, null, "subdirs", null, "subdirs", "wh", "gn");
        windowConfirmSearch.widgSearch = gralMngBuild_ifc.addButton(null, windowConfirmSearch.actionFileSearch, "search", null, "search");
        windowConfirmSearch.widgSearch.setPrimaryWidgetOfPanel();
        return windowConfirmSearch;
    }

    public void specifyActionOnFileSelected(GralUserAction gralUserAction) {
        this.actionOnFileSelected = gralUserAction;
    }

    public String getCurrentDirPath() {
        return this.sCurrentDir;
    }

    public void setOriginDir(FileRemote fileRemote) {
        this.originDir = fileRemote;
    }

    public void setSortOrder(char c) {
        this.sortOrder = c;
    }

    public GralUserAction setActionOnEnterFile(GralUserAction gralUserAction) {
        GralUserAction gralUserAction2 = this.actionOnEnterFile;
        this.actionOnEnterFile = gralUserAction;
        return gralUserAction2;
    }

    public GralUserAction setActionOnEnterDirectory(GralUserAction gralUserAction) {
        GralUserAction gralUserAction2 = this.actionOnEnterDirectory;
        this.actionOnEnterDirectory = gralUserAction;
        return gralUserAction2;
    }

    public GralUserAction setActionOnEnterPathNewFile(GralUserAction gralUserAction) {
        GralUserAction gralUserAction2 = this.actionOnEnterPathNewFile;
        this.actionOnEnterPathNewFile = gralUserAction;
        return gralUserAction2;
    }

    public GralUserAction setActionSetFileLineAttrib(GralUserAction gralUserAction) {
        GralUserAction gralUserAction2 = this.actionSetFileAttribs;
        this.actionSetFileAttribs = gralUserAction;
        return gralUserAction2;
    }

    public void fillInOriginDir() {
        this.fillIn(this.originDir, false);
    }

    public void fillInCurrentDir() {
        if (this.currentDir != null && !this.fillinPending) {
            this.fillIn(this.currentDir, false);
        }
    }

    public void forcefillIn(FileRemote fileRemote, boolean bl) {
        this.fillinPending = false;
        this.fillIn(fileRemote, bl);
    }

    public void fillIn(FileRemote fileRemote, boolean bl) {
        boolean bl2;
        Object object;
        FileRemote fileRemote2;
        FileRemote fileRemote3;
        long l;
        this.timeFillinInvoked = l = System.currentTimeMillis();
        if (!fileRemote.isDirectory()) {
            fileRemote3 = fileRemote.getParentFile();
            fileRemote2 = fileRemote;
            String string = FileSystem.getCanonicalPath((File)fileRemote3);
            object = fileRemote.getName();
            this.indexSelection.put(string, fileRemote);
        } else {
            fileRemote3 = fileRemote;
            fileRemote2 = null;
        }
        if (this.originDir == null) {
            this.originDir = fileRemote3;
        }
        fileRemote.internalAccess().setRefreshed();
        boolean bl3 = bl2 = fileRemote3 == this.currentDir;
        if (!bl2 || !this.fillinPending) {
            Object object2;
            this.fillinPending = true;
            if (!bl2) {
                this.currentDir = fileRemote3;
                this.sCurrentDir = fileRemote3.getAbsolutePath();
            }
            System.out.println("FcmdFileCard - start fillin; " + this.sCurrentDir + (bl2 ? "; same" : "; new"));
            if (bl2) {
                object = ERefresh.refreshAll;
            } else {
                this.currentFile = null;
                object = ERefresh.refreshChildren;
            }
            if (!bl2 || this.sortOrder != this.sortOrderLast) {
                this.selectList.wdgdTable.clearTable();
                this.idxLines.clear();
                if (fileRemote3.getParentFile() != null) {
                    object2 = this.selectList.wdgdTable.insertLine("..", 0, (String[])null, fileRemote3);
                    object2.setCellText("<", 0);
                    object2.setCellText("..", 1);
                    object2.setCellText("", 2);
                    object2.setCellText("", 3);
                    object2.setBackColor(this.colorBack, -1);
                    this.idxLines.put((Comparable)((Object)".."), object2);
                }
            } else {
                for (Object object3 : this.selectList.wdgdTable.iterLines()) {
                    ((GralTable.TableLineData)object3).setBackColor(this.colorBackPending, -1);
                }
            }
            this.widgdPathDir.setText(this.sCurrentDir, -1);
            this.sortOrderLast = this.sortOrder;
            if (bl) {
                object2 = fileRemote3.children();
                if (object2 != null) {
                    for (Map.Entry entry : object2.entrySet()) {
                        FileRemote fileRemote4 = (FileRemote)entry.getValue();
                        this.showFile(fileRemote4);
                    }
                }
                this.finishShowFileTable();
            } else {
                fileRemote3.refreshPropertiesAndChildren(this.callbackChildren1, false);
            }
        }
    }

    void showFile(FileRemote fileRemote) {
        String string = this.buildKey(fileRemote, true, null);
        boolean[] blArray = new boolean[1];
        GralTableLine_ifc gralTableLine_ifc = (GralTableLine_ifc)this.idxLines.search((Comparable)((Object)string), false, blArray);
        if (!blArray[0]) {
            String string2 = fileRemote.getName();
            gralTableLine_ifc = gralTableLine_ifc == null ? this.selectList.wdgdTable.insertLine(string2, 0, (String[])null, fileRemote) : gralTableLine_ifc.addNextLine(string2, null, fileRemote);
            gralTableLine_ifc.setCellText(fileRemote.getName(), 1);
            this.idxLines.add((Comparable)((Object)string), (Object)gralTableLine_ifc);
        }
        this.completeLine(gralTableLine_ifc, fileRemote, System.currentTimeMillis());
        gralTableLine_ifc.setBackColor(this.colorBack, -1);
    }

    void finishShowFileTable() {
        Object object;
        Object object2;
        System.out.println("FcmdFileCard - finish fillin; " + this.sCurrentDir);
        Iterator iterator = this.idxLines.entrySet().iterator();
        while (iterator.hasNext()) {
            object2 = (Map.Entry)iterator.next();
            object = (GralTableLine_ifc)object2.getValue();
            if (object.getKey().equals("..")) {
                object.setBackColor(this.colorBack, -1);
                continue;
            }
            if (object.getBackColor(-1) != this.colorBackPending) continue;
            this.selectList.wdgdTable.deleteLine(object);
            iterator.remove();
        }
        this.selectList.wdgdTable.setBackColor(this.colorBack, -2);
        if (this.currentFile == null) {
            this.currentFile = this.indexSelection.get(this.sCurrentDir);
        }
        if (this.currentFile != null) {
            object = this.buildKey(this.currentFile, true, null);
            object2 = (GralTableLine_ifc)this.idxLines.search((Comparable)object);
        } else {
            object2 = null;
        }
        if (object2 != null) {
            this.selectList.wdgdTable.setCurrentLine(object2, -3, 1);
            this.currentFile = (FileRemote)object2.getUserData();
        }
        this.selectList.wdgdTable.repaint(100, 200);
        this.fillinPending = false;
    }

    private void completeLine(GralTableLine_ifc<FileRemote> gralTableLine_ifc, FileRemote fileRemote, long l) {
        long l2;
        String string;
        int n;
        int n2 = n = fileRemote.mark == null ? 0 : fileRemote.mark.getMark();
        String string2 = fileRemote.isSymbolicLink() ? (fileRemote.isDirectory() ? ">" : "s") : (fileRemote.isDirectory() ? "/" : "");
        if (n != 0) {
            if ((n & 0x20000000) != 0) {
                string = "#";
            } else if ((n & 0x10000000) != 0) {
                string = "*";
            } else if ((n & 0x1000000) != 0) {
                string = "+";
            } else if ((n & 0xC000000) != 0) {
                switch (n & 0xC000000) {
                    case 0x4000000: {
                        string = " ";
                        break;
                    }
                    case 0x8000000: {
                        string = "#";
                        break;
                    }
                    default: {
                        string = " ";
                        break;
                    }
                }
            } else {
                string = " ";
            }
        } else {
            string = " ";
        }
        gralTableLine_ifc.setCellText(string2 + string, 0);
        switch (this.showTime) {
            case 'm': {
                l2 = fileRemote.lastModified();
                break;
            }
            case 'c': {
                l2 = fileRemote.creationTime();
                break;
            }
            case 'a': {
                l2 = fileRemote.lastAccessTime();
                break;
            }
            default: {
                l2 = -1L;
            }
        }
        long l3 = l - l2;
        Date date = new Date(l2);
        String string3 = l3 < -36000000L ? this.sDatePrefixNewer + this.dateFormatNewer.format(date) : (l3 < 64800000L ? this.sDatePrefixToday + this.dateFormatToday.format(date) : (l3 < 27648000000L ? this.sDatePrefixYear + this.dateFormatYear.format(date) : this.sDatePrefixOlder + this.dateFormatOlder.format(date)));
        gralTableLine_ifc.setCellText(string3, 3);
        long l4 = fileRemote.length();
        String string4 = l4 < 1024L ? "" + l4 : (l4 < 10000L ? String.format("%1.1f k", Float.valueOf((float)l4 / 1024.0f)) : (l4 < 1000000L ? String.format("%3.0f k", Float.valueOf((float)l4 / 1024.0f)) : (l4 < 10000000L ? String.format("%1.1f M", Float.valueOf((float)l4 / 1048576.0f)) : (l4 < 1000000000L ? String.format("%3.0f M", Float.valueOf((float)l4 / 1048576.0f)) : (l4 < 10000000000L ? String.format("%1.1f G", Float.valueOf((float)l4 / 1048576.0f)) : String.format("%2.0f G", Float.valueOf((float)l4 / 1048576.0f)))))));
        gralTableLine_ifc.setCellText(string4, 2);
        gralTableLine_ifc.setContentIdent(l2);
    }

    protected String buildKey(FileRemote fileRemote, boolean bl, String[] stringArray) {
        String string;
        String string2;
        if (!fileRemote.isTested()) {
            bl = false;
        }
        switch (this.sortOrder) {
            case 'n': {
                String string3 = fileRemote.getName();
                if (fileRemote.isDirectory()) {
                    string3 = string3 + "/";
                }
                string = string2 = (fileRemote.isDirectory() ? "D" : "F") + string3;
                break;
            }
            case 'N': {
                String string4 = fileRemote.getName().toLowerCase();
                if (fileRemote.isDirectory()) {
                    string4 = string4 + "/";
                }
                string = string2 = (fileRemote.isDirectory() ? "D" : "F") + string4;
                break;
            }
            case 'x': {
                String string5 = fileRemote.getName();
                int n = string5.lastIndexOf(46);
                String string6 = string5.substring(n + 1);
                if (fileRemote.isDirectory()) {
                    string5 = string5 + "/";
                }
                string = string2 = (fileRemote.isDirectory() ? "D" : "F") + string6 + string5;
                break;
            }
            case 'X': {
                String string7 = fileRemote.getName().toLowerCase();
                int n = string7.lastIndexOf(46);
                String string8 = string7.substring(n + 1);
                if (fileRemote.isDirectory()) {
                    string7 = string7 + "/";
                }
                string = string2 = (fileRemote.isDirectory() ? "D" : "F") + string8 + string7;
                break;
            }
            case 'd': {
                String string9 = fileRemote.getName().toLowerCase();
                if (bl) {
                    long l = -fileRemote.lastModified();
                    String string10 = String.format("%016X", new Long(l));
                    string2 = (fileRemote.isDirectory() ? "D" : "F") + string10 + string9;
                } else {
                    string2 = "";
                }
                string = (fileRemote.isDirectory() ? "D" : "F") + string9;
                break;
            }
            case 'o': {
                String string11 = fileRemote.getName().toLowerCase();
                if (bl) {
                    long l = fileRemote.lastModified();
                    String string12 = String.format("%016X", new Long(l));
                    string2 = (fileRemote.isDirectory() ? "D" : "F") + string12 + string11;
                } else {
                    string2 = "";
                }
                string = (fileRemote.isDirectory() ? "D" : "F") + string11;
                break;
            }
            case 'l': {
                String string13 = fileRemote.getName().toLowerCase();
                if (bl) {
                    long l = Long.MAX_VALUE - fileRemote.length();
                    String string14 = String.format("%016d", new Long(l));
                    string2 = (fileRemote.isDirectory() ? "D" : "F") + string14 + string13;
                } else {
                    string2 = "";
                }
                string = (fileRemote.isDirectory() ? "D" : "F") + string13;
                break;
            }
            case 's': {
                String string15 = fileRemote.getName().toLowerCase();
                if (bl) {
                    long l = fileRemote.length();
                    String string16 = String.format("%016d", new Long(l));
                    string2 = (fileRemote.isDirectory() ? "D" : "F") + string16 + string15;
                } else {
                    string2 = "";
                }
                string = (fileRemote.isDirectory() ? "D" : "F") + string15;
                break;
            }
            default: {
                string = string2 = fileRemote.getName();
            }
        }
        if (stringArray != null) {
            stringArray[0] = string;
        }
        return string2;
    }

    public void checkRefresh(long l) {
        if (this.currentDir != null && (!this.donotCheckRefresh && !this.currentDir.isTested(l - 5000L) || this.currentDir.shouldRefresh())) {
            this.fillIn(this.currentDir, false);
        }
    }

    public File XXXgetSelectedFile() {
        if (this.selectList.wdgdTable == null) {
            this.stop();
            return null;
        }
        GralTable.TableLineData tableLineData = this.selectList.wdgdTable.getCurrentLine();
        if (tableLineData != null) {
            File file = (File)tableLineData.getUserData();
            return file;
        }
        return null;
    }

    public List<FileRemote> getSelectedFiles(boolean bl, int n) {
        if (this.selectList.wdgdTable == null) {
            this.stop();
            return null;
        }
        if (this.currentFile == null) {
            return null;
        }
        if (this.currentFile.isMarked(1)) {
            LinkedList<FileRemote> linkedList = new LinkedList<FileRemote>();
            for (GralTableLine_ifc gralTableLine_ifc : this.selectList.wdgdTable.getMarkedLines(n)) {
                FileRemote fileRemote = (FileRemote)gralTableLine_ifc.getUserData();
                if (!bl && fileRemote.isDirectory()) continue;
                linkedList.add(fileRemote);
            }
            return linkedList;
        }
        if (bl || !this.currentFile.isDirectory()) {
            LinkedList<FileRemote> linkedList = new LinkedList<FileRemote>();
            linkedList.add(this.currentFile);
            return linkedList;
        }
        return null;
    }

    public boolean selectFile(String string) {
        return this.selectList.wdgdTable.setCurrentLine(string);
    }

    public FileRemote currentFile() {
        return this.currentFile;
    }

    public FileRemote currentDir() {
        return this.currentDir;
    }

    public FileRemote getCurrentDir() {
        return this.currentDir;
    }

    public void setFocus() {
        this.selectList.wdgdTable.setFocus();
    }

    void stop() {
    }

    public boolean remove() {
        this.selectList.remove();
        this.widgdPathDir.remove();
        this.indexSelection.clear();
        this.currentDir = null;
        return true;
    }

    public boolean actionUserKey(int n, Object object, GralTableLine_ifc<FileRemote> gralTableLine_ifc) {
        return false;
    }

    public void setSortOrderFiles(char c) {
        this.setSortOrder(c);
        this.fillInCurrentDir();
    }

    public static class MenuTexts {
        public String refresh = "&Refresh [F5]";
        public String sortNameCase = "&Sort/&Name case sensit";
        public String sortNameNonCase = "&Sort/&Name non-case";
        public String sortExtCase = "&Sort/e&Xt case sensit";
        public String sortExtNonCase = "&Sort/e&Xt non-case";
        public String sortOldest = "&Sort/date &Oldest";
        public String sortDateNewest = "&Sort/&Date newest";
        public String sizeLarge = "&Sort/size &Largest";
        public String sortSizeSmall = "&Sort/size &Smallest";
        public String deselectRecursFiles = "actionDeselectDirtree";
        public String refreshCyclicOff = "Cyclic refresh/o&ff";
        public String refreshCyclicOn = "Cyclic refresh/&on";
        public String showLastAccessTime = "show date last &Access";
        public String showLastModifiedTime = "show date last &Modified";
        public String showCreationTime = "show date &Creation";
    }

    private static enum ERefresh {
        doNothing,
        refreshAll,
        refreshChildren;

    }

    protected class FileSelectList
    extends GralSelectList<FileRemote> {
        final GralFileSelector outer;

        FileSelectList(GralFileSelector gralFileSelector2, String string, int n, int[] nArray, char c) {
            super(string, n, nArray, c);
            this.outer = gralFileSelector2;
            super.setLeftRightKeys(201982037, 655428);
        }

        @Override
        public boolean actionOk(Object object, GralTableLine_ifc gralTableLine_ifc) {
            String string;
            boolean bl = true;
            File file = (File)object;
            String string2 = gralTableLine_ifc.getCellText(1);
            if (string2.equals("..")) {
                this.actionLeft(object, gralTableLine_ifc);
            } else if (file != null && file.isDirectory()) {
                this.actionRight(object, gralTableLine_ifc);
            } else if (file != null && ((string = file.getName()).endsWith(".zip") || string.endsWith(".jar"))) {
                this.actionRightZip(object, gralTableLine_ifc);
            } else if (GralFileSelector.this.actionOnEnterFile != null) {
                GralFileSelector.this.actionOnEnterFile.userActionGui(917517, (GralWidget)GralFileSelector.this.widgdPathDir, file);
            } else {
                bl = false;
            }
            return bl;
        }

        private String getParentDir(File file) {
            int n = file.getParent().length();
            int n2 = file.getParent().lastIndexOf(47, n - 2);
            if (n2 >= 0) {
                String string = file.getParent().substring(0, n2 + 1);
                return string;
            }
            return null;
        }

        @Override
        public void actionLeft(Object object, GralTableLine_ifc gralTableLine_ifc) {
            if (GralFileSelector.this.currentDir != null) {
                String string = GralFileSelector.this.currentDir.getParent();
                String string2 = GralFileSelector.this.currentDir.getName();
                FileRemote fileRemote = GralFileSelector.this.currentDir.getParentFile();
                if (fileRemote != null) {
                    GralFileSelector.this.indexSelection.put(string, GralFileSelector.this.currentDir);
                    GralFileSelector.this.fillIn(fileRemote, false);
                }
            }
        }

        @Override
        public void actionRight(Object object, GralTableLine_ifc gralTableLine_ifc) {
            FileRemote fileRemote = (FileRemote)object;
            if (fileRemote.isDirectory()) {
                GralFileSelector.this.fillIn(fileRemote, false);
            }
        }

        public void actionRightZip(Object object, GralTableLine_ifc gralTableLine_ifc) {
            FileRemote fileRemote = (FileRemote)object;
            FileRemote fileRemote2 = FileAccessZip.examineZipFile((FileRemote)fileRemote);
            GralFileSelector.this.fillIn(fileRemote2, false);
        }

        @Override
        public boolean actionUserKey(int n, Object object, GralTableLine_ifc gralTableLine_ifc) {
            boolean bl = true;
            bl = this.outer.actionUserKey(n, object, gralTableLine_ifc);
            return bl;
        }
    }

    public static class WindowConfirmSearch {
        GralWindow_ifc windConfirmSearch;
        GralTextField_ifc widgPath;
        GralTextField_ifc widgMask;
        GralTextField_ifc widgText;
        GralValueBar widgProgression;
        GralButton widgEsc;
        GralButton widgSubdirs;
        GralButton widgSearch;
        GralFileSelector fileSelector;
        Appendable searchOutput;
        GralUserAction actionFileSearch = new GralUserAction(){

            @Override
            public boolean userActionGui(int n, GralWidget gralWidget, Object ... objectArray) {
                if (gralWidget.sCmd.equals("search") && n == 720981) {
                    boolean bl = WindowConfirmSearch.this.widgSubdirs.isOn();
                    String string = (bl ? "**/" : "") + WindowConfirmSearch.this.widgMask.getText();
                    String string2 = WindowConfirmSearch.this.widgText.getText();
                    LinkedList linkedList = new LinkedList();
                    try {
                        FileSystem.addFileToList((File)WindowConfirmSearch.this.fileSelector.currentDir, (String)string, linkedList);
                        if (string2.length() > 0) {
                            FileSystem.searchInFiles(linkedList, (String)string2, (Appendable)WindowConfirmSearch.this.searchOutput);
                        } else {
                            try {
                                for (File file : linkedList) {
                                    WindowConfirmSearch.this.searchOutput.append("<File=").append(file.getPath()).append(">\n");
                                }
                                WindowConfirmSearch.this.searchOutput.append("<done: search in files>\n");
                            }
                            catch (IOException iOException) {}
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return true;
            }
        };

        protected WindowConfirmSearch() {
        }

        public void confirmSearchInFiles(GralFileSelector gralFileSelector, Appendable appendable) {
            this.fileSelector = gralFileSelector;
            this.searchOutput = appendable;
            this.widgPath.setText(gralFileSelector.sCurrentDir);
            this.windConfirmSearch.setWindowVisible(true);
        }
    }
}

