/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.gral.swt;

import java.util.LinkedList;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.vishia.gral.ifc.GralColor;
import org.vishia.gral.ifc.GralRectangle;
import org.vishia.gral.swt.SwtMng;
import org.vishia.gral.swt.SwtPanel;

public class SwtWidgetHelper {
    public static final int version = 537989401;
    private static SwtMng mngs;
    public final SwtMng mng;
    public Control widgetSwt;

    public SwtWidgetHelper(Control control, SwtMng swtMng) {
        if (mngs != null) {
            assert (mngs == swtMng);
        } else {
            mngs = swtMng;
        }
        this.widgetSwt = control;
        this.mng = swtMng;
    }

    public static GralColor getColor(Color color) {
        int n = color.getBlue() << 16 + color.getGreen() << 8 + color.getRed();
        return GralColor.getColor(n);
    }

    public static Color getColor(GralColor gralColor) {
        return SwtWidgetHelper.mngs.propertiesGuiSwt.colorSwt(gralColor);
    }

    public static GralColor setBackgroundColor(GralColor gralColor, Control control) {
        Color color = SwtWidgetHelper.getColor(gralColor);
        Color color2 = control.getBackground();
        control.setBackground(color);
        return SwtWidgetHelper.getColor(color2);
    }

    public static GralColor setForegroundColor(GralColor gralColor, Control control) {
        Color color = (Color)gralColor.colorGuimpl;
        Color color2 = control.getForeground();
        control.setForeground(color);
        return SwtWidgetHelper.getColor(color2);
    }

    public static boolean setFocusOfTabSwt(Control control) {
        LinkedList<Control> linkedList = new LinkedList<Control>();
        Control control2 = control;
        while (control2 != null && (control2 = control2.getParent()) != null) {
            linkedList.add(control2);
        }
        for (Control control3 : linkedList) {
            SwtPanel swtPanel;
            Object object = control3.getData();
            if (object != null && object instanceof SwtPanel) {
                swtPanel = (SwtPanel)object;
                TabItem tabItem = swtPanel.itsTabSwt;
                if (tabItem != null) {
                    tabItem.getParent().setSelection(tabItem);
                }
            }
            if (!(control3 instanceof TabFolder)) continue;
            swtPanel = (TabFolder)control3;
            swtPanel.setFocus();
        }
        if (control == null) {
            return false;
        }
        control.forceFocus();
        return control.setFocus();
    }

    public void swtUpdateRedraw() {
        this.widgetSwt.update();
        this.widgetSwt.redraw();
    }

    public boolean setFocusGThread() {
        return this.widgetSwt.setFocus();
    }

    public void removeWidgetImplementation() {
        if (this.widgetSwt != null) {
            this.widgetSwt.dispose();
            this.widgetSwt = null;
        }
    }

    public void setBoundsPixel(int n, int n2, int n3, int n4) {
        this.widgetSwt.setBounds(n, n2, n3, n4);
    }

    public GralRectangle getPixelPositionSize() {
        int n;
        int n2;
        Rectangle rectangle;
        int n3 = 0;
        int n4 = 0;
        Rectangle rectangle2 = this.widgetSwt.getBounds();
        Composite composite = this.widgetSwt instanceof Composite ? (Composite)this.widgetSwt : this.widgetSwt.getParent();
        while (!(composite instanceof Shell)) {
            rectangle = composite.getBounds();
            n3 += rectangle.x;
            n4 += rectangle.y;
            composite = composite.getParent();
        }
        assert (composite instanceof Shell);
        Rectangle rectangle3 = composite.getClientArea();
        rectangle = composite.getBounds();
        int n5 = (rectangle.width - rectangle3.width) / 2;
        n3 += rectangle2.x + n5;
        n4 += rectangle2.y + (rectangle.height - rectangle3.height) - n5;
        if (composite == this.widgetSwt) {
            n2 = rectangle3.width;
            n = rectangle3.height;
        } else {
            n2 = rectangle2.width;
            n = rectangle2.height;
        }
        GralRectangle gralRectangle = new GralRectangle(n3, n4, n2, n);
        return gralRectangle;
    }

    @Deprecated
    public static GralRectangle getPixelPositionSize(Control control) {
        int n;
        int n2;
        Rectangle rectangle;
        int n3 = 0;
        int n4 = 0;
        Rectangle rectangle2 = control.getBounds();
        Composite composite = control instanceof Composite ? (Composite)control : control.getParent();
        while (!(composite instanceof Shell)) {
            rectangle = composite.getBounds();
            n3 += rectangle.x;
            n4 += rectangle.y;
            composite = composite.getParent();
        }
        assert (composite instanceof Shell);
        Rectangle rectangle3 = composite.getClientArea();
        rectangle = composite.getBounds();
        int n5 = (rectangle.width - rectangle3.width) / 2;
        n3 += rectangle2.x + n5;
        n4 += rectangle2.y + (rectangle.height - rectangle3.height) - n5;
        if (composite == control) {
            n2 = rectangle3.width;
            n = rectangle3.height;
        } else {
            n2 = rectangle2.width;
            n = rectangle2.height;
        }
        GralRectangle gralRectangle = new GralRectangle(n3, n4, n2, n);
        return gralRectangle;
    }
}

