/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.gral.swt;

import java.util.Map;
import java.util.TreeMap;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.RGB;
import org.vishia.gral.base.GralGridProperties;
import org.vishia.gral.ifc.GralColor;
import org.vishia.gral.ifc.GralFont;

public class SwtProperties
extends GralGridProperties {
    private final Device guiDevice;
    public final Font smallPromptFont;
    public final Font stdInputFont;
    public final Font stdButtonFont;
    Map<Integer, Color> colorsSwt = new TreeMap<Integer, Color>();
    private final Color colorBlack;
    public final Color colorGrid;
    public final Color colorGridStrong;
    public Color colorBackground;

    public SwtProperties(Device device, char c) {
        super(c);
        this.guiDevice = device;
        this.colorBlack = new Color(this.guiDevice, 0, 0, 0);
        this.colorGrid = this.colorSwt(0xE0E0E0);
        this.colorGridStrong = this.colorSwt(0xC0C0C0);
        this.colorBackground = this.colorSwt(this.colorBackground_);
        this.smallPromptFont = new Font(device, "Arial", smallPromptFontSize[this.size], 0);
        this.stdInputFont = new Font(device, "Arial", stdInputFontSize[this.size], 0);
        this.stdButtonFont = new Font(device, "Arial", stdButtonFontSize[this.size], 0);
    }

    public Color colorSwt(GralColor gralColor) {
        if (gralColor.colorGuimpl == null) {
            int n = gralColor.getColorValue();
            gralColor.colorGuimpl = this.colorSwt(n);
        } else if (!(gralColor.colorGuimpl instanceof Color)) {
            throw new IllegalArgumentException("unauthorized color setting");
        }
        return (Color)gralColor.colorGuimpl;
    }

    public Color colorSwt(int n) {
        Color color;
        if (n >= 0 && n < 0x1000000) {
            color = this.colorsSwt.get(n);
            if (color == null) {
                color = new Color(this.guiDevice, n >> 16 & 0xFF, n >> 8 & 0xFF, n & 0xFF);
                this.colorsSwt.put(n, color);
            }
        } else {
            color = this.colorBlack;
        }
        return color;
    }

    public Color color(String string) {
        int n = this.getColorValue(string);
        return this.colorSwt(n);
    }

    public Color colorBackgroundSwt() {
        return this.colorSwt(this.colorBackground_);
    }

    public static GralColor createColorGui(Color color) {
        RGB rGB = color.getRGB();
        GralColor gralColor = new GralColor(rGB.red, rGB.green, rGB.blue);
        return gralColor;
    }

    public Font getSwtFont(float f) {
        return this.fontSwt(super.getTextFont(f));
    }

    public Font fontSwt(GralFont gralFont) {
        if (gralFont.fontImpl == null) {
            int n = 0;
            switch (gralFont.style) {
                case 'b': {
                    n |= 1;
                    break;
                }
                case 'B': {
                    n |= 1;
                    break;
                }
                case 'i': {
                    n |= 2;
                    break;
                }
                case 'I': {
                    n |= 3;
                    break;
                }
                default: {
                    n = 0;
                }
            }
            String string = gralFont.fontName.equals("monospacedSansSerif") ? "Courier" : (gralFont.fontName.equals("MonospacedSmall") ? "Courier" : (gralFont.fontName.equals("monospacedSerif") ? "Courier" : (gralFont.fontName.equals("sansSerif") ? "Arial" : (gralFont.fontName.equals("serif") ? "Serif" : gralFont.fontName))));
            gralFont.fontImpl = new Font(this.guiDevice, string, gralFont.size, n);
        } else if (!(gralFont.fontImpl instanceof Font)) {
            throw new IllegalArgumentException("unauthorized font setting");
        }
        return (Font)gralFont.fontImpl;
    }

    Font getTextFontSwt(float f, char c, char c2) {
        return this.fontSwt(this.getTextFont(f, c, c2));
    }
}

