/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.gral.swt;

import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.vishia.gral.base.GralLed;
import org.vishia.gral.base.GralWidget;
import org.vishia.gral.ifc.GralColor;
import org.vishia.gral.ifc.GralRectangle;
import org.vishia.gral.swt.SwtMng;
import org.vishia.gral.swt.SwtWidgetHelper;

public class SwtLed
extends GralLed.GraphicImplAccess {
    private SwtLedImpl widgSwt;
    private final SwtWidgetHelper wdgh;
    Color borderColor;
    Color innerColor;
    final SwtMng mng;
    boolean round;

    SwtLed(String string, SwtMng swtMng) {
        this(new GralLed(string), swtMng);
    }

    SwtLed(GralLed gralLed, SwtMng swtMng) {
        GralLed gralLed2 = gralLed;
        gralLed2.getClass();
        super(gralLed, swtMng.mng);
        this.mng = swtMng;
        switch (114) {
            case 114: {
                this.round = true;
                break;
            }
            case 113: {
                this.round = false;
                break;
            }
            default: {
                throw new IllegalArgumentException("param size must be r or q");
            }
        }
        Composite composite = swtMng.getCurrentPanel();
        this.widgSwt = new SwtLedImpl(composite);
        this.wdgh = new SwtWidgetHelper((Control)this.widgSwt, swtMng);
        this.widgSwt.setBackground(swtMng.propertiesGuiSwt.colorBackground);
        this.widgSwt.addFocusListener(swtMng.focusListener);
        this.widgSwt.setForeground(swtMng.propertiesGuiSwt.colorSwt(65280));
        swtMng.setBounds_((Control)this.widgSwt);
        this.widgSwt.setData(this);
        this.widgSwt.addMouseListener(swtMng.mouseClickForInfo);
    }

    private void setColors() {
        int n = 0;
        GralWidget.DynamicData dynamicData = this.dyda();
        if (dynamicData.backColor != null && ((dynamicData.whatIsChanged.get() & 2) != 0 || this.innerColor == null)) {
            this.innerColor = this.mng.getColorImpl(dynamicData.backColor);
            n |= 2;
        }
        if (dynamicData.lineColor != null) {
            if ((dynamicData.whatIsChanged.get() & 0x10) != 0 || this.borderColor == null) {
                this.borderColor = this.mng.getColorImpl(dynamicData.lineColor);
                n |= 0x10;
            }
        } else {
            this.borderColor = this.innerColor;
        }
        if (n != 0) {
            dynamicData.setChanged(n);
        }
    }

    @Override
    public GralRectangle getPixelPositionSize() {
        return this.wdgh.getPixelPositionSize();
    }

    @Override
    public void removeWidgetImplementation() {
        if (this.widgSwt != null) {
            this.widgSwt.dispose();
            this.widgSwt = null;
        }
    }

    @Override
    public boolean setFocusGThread() {
        return this.widgSwt.setFocus();
    }

    @Override
    public void repaintGthread() {
        this.widgSwt.redraw();
    }

    @Override
    public Object getWidgetImplementation() {
        return this.widgSwt;
    }

    public GralColor XXXsetBackgroundColor(GralColor gralColor) {
        return SwtWidgetHelper.setBackgroundColor(gralColor, (Control)this.widgSwt);
    }

    @Override
    public void setBoundsPixel(int n, int n2, int n3, int n4) {
    }

    public GralColor XXXsetForegroundColor(GralColor gralColor) {
        return null;
    }

    private class SwtLedImpl
    extends Canvas {
        PaintListener paintListener;

        public SwtLedImpl(Composite composite) {
            super(composite, 0);
            this.paintListener = new PaintListener(){

                public void paintControl(PaintEvent paintEvent) {
                    GC gC = paintEvent.gc;
                    SwtLed.this.setColors();
                    gC.setBackground(SwtLed.this.borderColor);
                    gC.fillOval(2, 2, paintEvent.width - 3, paintEvent.height - 3);
                    gC.setBackground(SwtLed.this.innerColor);
                    int n = (paintEvent.width + 1) / 2;
                    int n2 = (paintEvent.height + 1) / 2;
                    int n3 = (paintEvent.width - n) / 2 + 1;
                    int n4 = (paintEvent.height - n2) / 2 + 1;
                    gC.fillOval(n3, n4, n, n2);
                }
            };
            this.addPaintListener(this.paintListener);
        }

        void XXXsetBorderColor(int n) {
            SwtLed.this.borderColor = SwtLed.this.mng.propertiesGuiSwt.colorSwt(n);
            this.redraw();
        }

        void XXXsetInnerColor(int n) {
            SwtLed.this.innerColor = SwtLed.this.mng.propertiesGuiSwt.colorSwt(n);
            this.redraw();
        }

        void XXXsetColor(int n) {
            SwtLed.this.borderColor = SwtLed.this.innerColor = SwtLed.this.mng.propertiesGuiSwt.colorSwt(n);
            this.redraw();
        }

        void XXXsetColor(String string) {
            SwtLed.this.borderColor = SwtLed.this.innerColor = SwtLed.this.mng.propertiesGuiSwt.color(string);
            this.redraw();
        }

        void XXXsetColor(int n, int n2) {
            SwtLed.this.borderColor = SwtLed.this.mng.propertiesGuiSwt.colorSwt(n);
            SwtLed.this.innerColor = SwtLed.this.mng.propertiesGuiSwt.colorSwt(n2);
            this.redraw();
        }
    }
}

