/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.gral.swt;

import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;
import org.vishia.gral.base.GralMng;
import org.vishia.gral.base.GralMouseWidgetAction_ifc;
import org.vishia.gral.base.GralWidget;
import org.vishia.gral.ifc.GralRectangle;
import org.vishia.gral.ifc.GralUserAction;
import org.vishia.gral.swt.SwtGralKey;
import org.vishia.util.Assert;

public class SwtGralMouseListener {
    public static final int version = 20120309;

    public static class MouseListenerGralAction
    extends MouseListenerNoAction
    implements MouseListener {
        private int xMousePress;
        private int yMousePress;
        protected boolean isPressed;
        protected final GralMouseWidgetAction_ifc mouseWidgetAction;
        protected final int mUser;
        protected MouseMoveListener mouseMoveListener = new MouseMoveListener(){

            public void mouseMove(MouseEvent mouseEvent) {
                if (mouseEvent.widget instanceof Control) {
                    Control control = (Control)mouseEvent.widget;
                    Point point = control.getSize();
                    if (MouseListenerGralAction.this.mouseWidgetAction != null && !MouseListenerGralAction.this.mouseWidgetAction.mouseMoved(mouseEvent.x, mouseEvent.y, point.x, point.y)) {
                        MouseListenerGralAction.this.isPressed = false;
                        control.removeMouseMoveListener(MouseListenerGralAction.this.mouseMoveListener);
                    }
                }
            }
        };

        public MouseListenerGralAction(GralMouseWidgetAction_ifc gralMouseWidgetAction_ifc, int n) {
            this.mouseWidgetAction = gralMouseWidgetAction_ifc;
            this.mUser = n;
        }

        @Override
        public void mouseDoubleClick(MouseEvent mouseEvent) {
            this.xMousePress = mouseEvent.x;
            this.yMousePress = mouseEvent.y;
            Control control = (Control)mouseEvent.widget;
            GralWidget gralWidget = GralWidget.ImplAccess.gralWidgetFromImplData(control.getData());
            try {
                Object object;
                int n = SwtGralKey.convertMouseKey(mouseEvent.button, SwtGralKey.MouseAction.doubleClick, mouseEvent.stateMask);
                Control control2 = (Control)mouseEvent.widget;
                if (this.mouseWidgetAction != null) {
                    object = control2.getSize();
                    this.mouseWidgetAction.mouse1Double(n, this.xMousePress, this.yMousePress, ((Point)object).x, ((Point)object).y, gralWidget);
                }
                if ((this.mUser & 0x100) != 0) {
                    GralUserAction gralUserAction = object = gralWidget == null ? null : gralWidget.getActionChange();
                    if (object != null) {
                        ((GralUserAction)object).exec(n, gralWidget, new Integer(mouseEvent.x), new Integer(mouseEvent.y));
                    }
                }
            }
            catch (Exception exception) {
                System.err.printf("SwtGralMouseListener - any exception while mouse double; %s\n", exception.getMessage());
            }
        }

        @Override
        public void mouseDown(MouseEvent mouseEvent) {
            super.mouseDown(mouseEvent);
            this.isPressed = true;
            this.xMousePress = mouseEvent.x;
            this.yMousePress = mouseEvent.y;
            Control control = (Control)mouseEvent.widget;
            control.addMouseMoveListener(this.mouseMoveListener);
            GralWidget gralWidget = GralWidget.ImplAccess.gralWidgetFromImplData(control.getData());
            try {
                Object object;
                int n = SwtGralKey.convertMouseKey(mouseEvent.button, SwtGralKey.MouseAction.down, mouseEvent.stateMask);
                int n2 = 0;
                if (this.mouseWidgetAction != null) {
                    object = control.getSize();
                    switch (mouseEvent.button) {
                        case 1: {
                            n2 = 1;
                            this.mouseWidgetAction.mouse1Down(n, this.xMousePress, this.yMousePress, ((Point)object).x, ((Point)object).y, gralWidget);
                            break;
                        }
                        case 2: {
                            n2 = 1;
                            this.mouseWidgetAction.mouse2Down(n, this.xMousePress, this.yMousePress, ((Point)object).x, ((Point)object).y, gralWidget);
                        }
                    }
                }
                if ((this.mUser & n2) != 0) {
                    GralUserAction gralUserAction = object = gralWidget == null ? null : gralWidget.getActionChange();
                    if (object != null) {
                        ((GralUserAction)object).exec(n, gralWidget, new Integer(mouseEvent.x), new Integer(mouseEvent.y));
                    }
                }
            }
            catch (Exception exception) {
                System.err.printf("SwtGralMouseListener - any exception while mouse down; %s\n", exception.getMessage());
            }
        }

        @Override
        public void mouseUp(MouseEvent mouseEvent) {
            super.mouseUp(mouseEvent);
            if (this.isPressed) {
                Control control = (Control)mouseEvent.widget;
                control.removeMouseMoveListener(this.mouseMoveListener);
                this.isPressed = false;
                Point point = control.getSize();
                GralWidget gralWidget = GralWidget.ImplAccess.gralWidgetFromImplData(control.getData());
                try {
                    boolean bl = mouseEvent.x < 0 || mouseEvent.x > point.x || mouseEvent.y < 0 || mouseEvent.y > point.y;
                    SwtGralKey.MouseAction mouseAction = bl ? SwtGralKey.MouseAction.upMovedOutside : SwtGralKey.MouseAction.up;
                    int n = SwtGralKey.convertMouseKey(mouseEvent.button, mouseAction, mouseEvent.stateMask);
                    int n2 = 0;
                    if (this.mouseWidgetAction != null) {
                        switch (mouseEvent.button) {
                            case 1: {
                                n2 = 16;
                                this.mouseWidgetAction.mouse1Up(n, mouseEvent.x, mouseEvent.y, point.x, point.y, gralWidget);
                                break;
                            }
                            case 2: {
                                n2 = 32;
                                this.mouseWidgetAction.mouse2Up(n, mouseEvent.x, mouseEvent.y, point.x, point.y, gralWidget);
                            }
                        }
                    }
                    if ((this.mUser & n2) != 0) {
                        GralUserAction gralUserAction;
                        GralUserAction gralUserAction2 = gralUserAction = gralWidget == null ? null : gralWidget.getActionChange();
                        if (gralUserAction != null) {
                            gralUserAction.exec(n, gralWidget, new Object[0]);
                        }
                    }
                }
                catch (Exception exception) {
                    CharSequence charSequence = Assert.exceptionInfo((CharSequence)"SwtGralMouseListener - any exception while mouse down;", (Throwable)exception, (int)0, (int)20);
                    System.err.printf(charSequence.toString(), new Object[0]);
                }
            }
        }
    }

    public static class MouseListenerNoAction
    implements MouseListener {
        int xDown;
        int yDown;
        private final MouseMoveListener mouseMoveListenerDesignMode = new MouseMoveListener(){

            public void mouseMove(MouseEvent mouseEvent) {
            }
        };

        public void mouseDoubleClick(MouseEvent mouseEvent) {
            Widget widget = mouseEvent.widget;
            Object object = widget.getData();
            GralWidget gralWidget = GralWidget.ImplAccess.gralWidgetFromImplData(object);
            if (gralWidget != null) {
                GralMng gralMng = gralWidget.gralMng();
                try {
                    String string = gralWidget.toString();
                    gralMng.log.sendMsg(0, "Info widget: %s", new Object[]{string});
                }
                catch (Exception exception) {
                    gralMng.writeLog(0, exception);
                }
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void mouseDown(MouseEvent mouseEvent) {
            Widget widget = mouseEvent.widget;
            Object object = widget.getData();
            GralWidget gralWidget = GralWidget.ImplAccess.gralWidgetFromImplData(object);
            if (gralWidget == null) return;
            GralMng gralMng = gralWidget.gralMng();
            try {
                String string = gralWidget.getDataPath();
                if (string == null || !string.equals("widgetInfo")) {
                    gralMng.setLastClickedWidget(gralWidget);
                }
                if (!gralMng.bDesignMode) return;
                GralRectangle gralRectangle = new GralRectangle(mouseEvent.x, mouseEvent.y, 0, 0);
                if (mouseEvent.button == 1) {
                    this.xDown = mouseEvent.x;
                    this.yDown = mouseEvent.y;
                    gralMng.pressedLeftMouseDownForDesign(gralWidget, gralRectangle);
                    return;
                }
                if (mouseEvent.button != 3) return;
            }
            catch (Exception exception) {
                gralMng.writeLog(0, exception);
            }
        }

        public void mouseUp(MouseEvent mouseEvent) {
            Widget widget = mouseEvent.widget;
            Object object = widget.getData();
            GralWidget gralWidget = GralWidget.ImplAccess.gralWidgetFromImplData(object);
            if (gralWidget != null) {
                GralMng gralMng = gralWidget.gralMng();
                try {
                    int n = mouseEvent.x - this.xDown;
                    int n2 = mouseEvent.y - this.yDown;
                    if (gralMng.bDesignMode && mouseEvent.button == 1) {
                        if ((mouseEvent.stateMask & 0x10000) != 0) {
                            boolean bl = (mouseEvent.stateMask & 0x40000) != 0;
                            GralRectangle gralRectangle = new GralRectangle(mouseEvent.x, mouseEvent.y, 0, 0);
                            gralMng.releaseLeftMouseForDesign(gralWidget, gralRectangle, bl);
                        } else {
                            gralMng.markWidgetForDesign(gralWidget);
                        }
                    }
                }
                catch (Exception exception) {
                    gralMng.writeLog(0, exception);
                }
            }
        }
    }
}

