/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.gral.swt;

import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.Control;
import org.vishia.gral.base.GetGralWidget_ifc;
import org.vishia.gral.base.GralWidget;
import org.vishia.gral.ifc.GralUserAction;

public class SwtDropListener
implements DropTargetListener {
    private FileTransfer fileTransfer;
    private TextTransfer textTransfer;

    SwtDropListener(int n, Control control) {
        DropTarget dropTarget = new DropTarget(control, 1);
        dropTarget.addDropListener((DropTargetListener)this);
        switch (n) {
            case 852038: {
                this.fileTransfer = FileTransfer.getInstance();
                Transfer[] transferArray = new Transfer[]{this.fileTransfer};
                dropTarget.setTransfer(transferArray);
                break;
            }
            case 852052: {
                this.textTransfer = TextTransfer.getInstance();
                Transfer[] transferArray = new Transfer[]{this.textTransfer};
                dropTarget.setTransfer(transferArray);
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown droptype: " + Integer.toHexString(n));
            }
        }
    }

    public void dragEnter(DropTargetEvent dropTargetEvent) {
        TransferData transferData = dropTargetEvent.currentDataType;
        dropTargetEvent.detail = this.fileTransfer != null && this.fileTransfer.isSupportedType(transferData) ? 1 : (this.textTransfer != null && this.textTransfer.isSupportedType(transferData) ? 1 : 0);
    }

    public void dragLeave(DropTargetEvent dropTargetEvent) {
        this.stop();
    }

    public void dragOperationChanged(DropTargetEvent dropTargetEvent) {
        this.stop();
    }

    public void dragOver(DropTargetEvent dropTargetEvent) {
        this.stop();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void drop(DropTargetEvent dropTargetEvent) {
        DropTarget dropTarget = (DropTarget)dropTargetEvent.getSource();
        Control control = dropTarget.getControl();
        Object object = control.getData();
        if (object == null || !(object instanceof GetGralWidget_ifc)) throw new IllegalArgumentException("GralWidget as getData() of swt.Control expected.");
        GralWidget gralWidget = ((GetGralWidget_ifc)object).getGralWidget();
        GralUserAction gralUserAction = gralWidget.getActionDrop();
        if (gralUserAction == null) throw new IllegalArgumentException("no action found for drop.");
        TransferData transferData = dropTargetEvent.currentDataType;
        if (this.fileTransfer != null && this.fileTransfer.isSupportedType(transferData)) {
            Object object2 = this.fileTransfer.nativeToJava(transferData);
            String[] stringArray = (String[])object2;
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = stringArray[i].replace('\\', '/');
            }
            gralUserAction.userActionGui(852038, gralWidget, (Object[])stringArray);
            return;
        } else {
            if (this.textTransfer == null || !this.textTransfer.isSupportedType(transferData)) return;
            Object object3 = this.textTransfer.nativeToJava(transferData);
            gralUserAction.userActionGui(852052, gralWidget, object3);
        }
    }

    public void dropAccept(DropTargetEvent dropTargetEvent) {
        this.stop();
    }

    void stop() {
    }
}

