/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.gral.swt;

import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.Control;
import org.vishia.gral.base.GralWidget;
import org.vishia.gral.ifc.GralUserAction;

public class SwtDragListener
extends DragSourceAdapter {
    private final FileTransfer fileTransfer;
    private final TextTransfer textTransfer;

    SwtDragListener(int n, Control control) {
        DragSource dragSource = new DragSource(control, 1);
        dragSource.addDragListener((DragSourceListener)this);
        switch (n) {
            case 852070: {
                this.fileTransfer = FileTransfer.getInstance();
                this.textTransfer = TextTransfer.getInstance();
                Transfer[] transferArray = new Transfer[]{this.fileTransfer, this.textTransfer};
                dragSource.setTransfer(transferArray);
                break;
            }
            case 852084: {
                this.fileTransfer = FileTransfer.getInstance();
                this.textTransfer = TextTransfer.getInstance();
                Transfer[] transferArray = new Transfer[]{this.textTransfer};
                dragSource.setTransfer(transferArray);
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown dragtype: " + Integer.toHexString(n));
            }
        }
    }

    public void dragFinished(DragSourceEvent dragSourceEvent) {
        this.stop();
        System.out.println("drag finished\n");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void dragSetData(DragSourceEvent dragSourceEvent) {
        DragSource dragSource = (DragSource)dragSourceEvent.getSource();
        Control control = dragSource.getControl();
        GralWidget gralWidget = GralWidget.ImplAccess.gralWidgetFromImplData(control.getData());
        if (gralWidget == null) throw new IllegalArgumentException("GralWidget as getData() of swt.Control expected.");
        GralUserAction gralUserAction = gralWidget.getActionDrag();
        if (gralUserAction == null) throw new IllegalArgumentException("no action found for drop.");
        String[][] stringArrayArray = new String[1][];
        boolean bl = gralUserAction.userActionGui(852070, gralWidget, new Object[]{stringArrayArray});
        if (bl && stringArrayArray[0] != null) {
            String[] stringArray = stringArrayArray[0];
            TransferData transferData = dragSourceEvent.dataType;
            if (this.textTransfer.isSupportedType(transferData)) {
                dragSourceEvent.data = stringArray[0];
                dragSourceEvent.doit = true;
                return;
            } else if (this.fileTransfer.isSupportedType(transferData)) {
                stringArray[0] = stringArray[0].replace('/', '\\');
                dragSourceEvent.data = stringArray;
                dragSourceEvent.doit = true;
                return;
            } else {
                dragSourceEvent.doit = false;
            }
            return;
        } else {
            dragSourceEvent.doit = false;
        }
    }

    public void dragStart(DragSourceEvent dragSourceEvent) {
        this.stop();
        dragSourceEvent.doit = true;
    }

    void stop() {
    }
}

