/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.gral.swt;

import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.vishia.gral.base.GralCurveView;
import org.vishia.gral.base.GralPos;
import org.vishia.gral.ifc.GralColor;
import org.vishia.gral.ifc.GralRectangle;
import org.vishia.gral.swt.SwtGralMouseListener;
import org.vishia.gral.swt.SwtMng;
import org.vishia.gral.swt.SwtProperties;
import org.vishia.util.Assert;
import org.vishia.util.Debugutil;

public class SwtCurveView
extends GralCurveView {
    public static final int version = 20120317;
    private final CurveView curveSwt;
    private final Image cursorStore1;
    private final Image cursorStore2;
    protected Color gridColor;
    protected Color gridColorStrong;
    protected final Color colorCursor;
    protected final Color colorBack;
    TestHelp testHelp = new TestHelp();
    SwtGralMouseListener.MouseListenerGralAction mouseListenerCurve = new SwtGralMouseListener.MouseListenerGralAction(this.mouseAction, 0);

    public SwtCurveView(String string, GralPos gralPos, SwtMng swtMng, int n, GralCurveView.CommonCurve commonCurve) {
        super(string, swtMng.mng, n, commonCurve);
        GralRectangle gralRectangle = swtMng.calcWidgetPosAndSize(gralPos, 800, 600);
        Composite composite = (Composite)gralPos.panel.getWidgetImplementation();
        this.curveSwt = new CurveView(composite, gralRectangle.dx, gralRectangle.dy, n);
        this.curveSwt.setSize(gralRectangle.dx, gralRectangle.dy);
        this.curveSwt.setBounds(gralRectangle.x, gralRectangle.y, gralRectangle.dx, gralRectangle.dy);
        this.curveSwt.setGridVertical(10, 5);
        this.curveSwt.setGridHorizontal(50.0f, 5);
        this.cursorStore1 = new Image((Device)composite.getDisplay(), 1, 2000);
        this.cursorStore2 = new Image((Device)composite.getDisplay(), 1, 2000);
        this.gridColor = new Color((Device)this.curveSwt.getDisplay(), 192, 255, 255);
        this.gridColorStrong = new Color((Device)this.curveSwt.getDisplay(), 128, 255, 255);
        this.colorCursor = new Color((Device)this.curveSwt.getDisplay(), 64, 64, 64);
        this.colorBack = new Color((Device)this.curveSwt.getDisplay(), 255, 255, 255);
        super.initMenuContext();
    }

    @Override
    public void repaintGthread() {
        this.curveSwt.redraw();
    }

    @Override
    public Object getWidgetImplementation() {
        return this.curveSwt;
    }

    @Override
    public void removeWidgetImplementation() {
    }

    private void drawTrack(GC gC, Point point, GralCurveView.Track track, int n, int n2) {
        Color color;
        int n3;
        int n4;
        int n5 = 0;
        int n6 = n4 = point.x - 1;
        int n7 = this.ixDataShown[n5];
        int n8 = this.nrofPixel4data[n5];
        int n9 = n7;
        int n10 = n9 >> this.shIxiData & this.mIxiData;
        float f = (float)point.y / -10.0f / track.yScale;
        float f2 = (1.0f - (float)track.y0Line / 100.0f) * (float)point.y;
        float f3 = track.values[n10];
        int n11 = this.timeValues[n10];
        int n12 = n3 = (int)((f3 - track.yOffset) * f + f2);
        Color color2 = color = track.lineColor != null ? (Color)this.itsMng.impl.getColorImpl(track.lineColor) : ((SwtProperties)this.itsMng.propertiesGui).colorBackground;
        if (n == 0) {
            // empty if block
        }
        while (n5 < n2) {
            int n13 = this.ixDataShown[n5 += n8 + 1];
            n6 -= n8 + 1;
            if (n9 == n13) continue;
            int n14 = Integer.MAX_VALUE;
            int n15 = Integer.MIN_VALUE;
            int n16 = 0;
            int n17 = 0;
            do {
                int n18;
                n10 = (n9 -= this.adIxData) >> this.shIxiData & this.mIxiData;
                if (n5 >= n2) {
                    n18 = track.ypixLast;
                } else {
                    f3 = track.values[n10];
                    int n19 = this.timeValues[n10];
                    int n20 = n11 - n19;
                    n18 = (int)((f3 - track.yOffset) * f + f2);
                }
                n17 += n18;
                if (n9 != n13) {
                    if (n14 > n18) {
                        n14 = n18;
                    }
                    if (n15 < n18) {
                        n15 = n18;
                    }
                }
                ++n16;
            } while (n9 != n13);
            gC.setForeground(color);
            gC.setLineWidth(track.lineWidth);
            if (n16 > 1) {
                gC.drawLine(n6, n14, n6, n15);
                n17 /= n16;
            }
            gC.drawLine(n4, n12, n6, n17);
            if (n == 0) {
                // empty if block
            }
            n4 = n6;
            n12 = n17;
            n8 = this.nrofPixel4data[n5];
            n7 = n13;
        }
        track.ypixLast = n3;
    }

    private int drawShiftAreaToLeft(GC gC, Point point, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7;
        ++this.testHelp.ctRedrawBecauseNewData;
        if (n5 > 0 && n5 < point.x) {
            this.timeCaryOverNewValue = (int)((float)n6 - (float)n5 * this.timeorg.timePerPixel);
            this.xViewLastF -= (float)n5;
            if (n != 0) {
                this.stop();
            }
            n7 = n + n2 - n5;
            if (this.xpCursor1 >= 0) {
                gC.drawImage(this.cursorStore1, point.x - this.xpCursor1, 0);
            }
            if (this.xpCursor2 >= 0) {
                gC.drawImage(this.cursorStore2, point.x - this.xpCursor2, 0);
            }
            gC.copyArea(n + n5, n3, n2 - n5, n4 - 5, n, n3, false);
            this.timeorg.pixelWrittenAfterStrongDiv += n5;
            ++this.testHelp.ctRedrawPart;
        } else if (n5 >= point.x) {
            n5 = point.x;
            n7 = 0;
            ++this.testHelp.ctRedrawAllShift;
            this.xViewLastF = 0.0f;
        } else {
            n5 = 0;
            n7 = point.x;
        }
        return n7;
    }

    private void drawRightOrAll(GC gC, Point point, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, boolean bl) {
        int n9;
        gC.setBackground(this.colorBack);
        gC.fillRectangle(n8, n3, n6, n4);
        float f = (float)n4 / this.gridDistanceX;
        int n10 = this.gridStrongPeriodX;
        int n11 = this.prepareIndicesDataForDrawing(n5, n6, n7, bl);
        gC.setForeground(this.gridColor);
        gC.setLineWidth(1);
        gC.setLineStyle(3);
        for (n10 = 1; n10 <= 9; ++n10) {
            n9 = (int)((float)point.y / 10.0f * (float)n10);
            gC.drawLine(point.x - n6, n9, point.x, n9);
        }
        n10 = -1;
        while ((n9 = this.timeorg.xPixelTimeDivFine[++n10]) >= 0) {
            gC.drawLine(point.x - n9, 0, point.x - n9, point.y);
        }
        gC.setForeground(this.gridColorStrong);
        gC.setLineWidth(1);
        n10 = -1;
        while ((n9 = this.timeorg.xPixelTimeDiv[++n10]) >= 0) {
            gC.drawLine(point.x - n9, 0, point.x - n9, point.y);
            if (n9 <= 30) continue;
            gC.setForeground((Color)this.itsMng.impl.getColorImpl(GralColor.getColor("bk")));
            gC.drawText(this.timeorg.sTimeAbsDiv[n10], point.x - 6 - n9, point.y - 25);
            gC.setForeground(this.gridColorStrong);
            this.timeorg.pixelWrittenAfterStrongDiv = Integer.MIN_VALUE;
        }
        gC.setLineStyle(1);
        int n12 = 0;
        for (GralCurveView.Track track : this.listTracks) {
            this.drawTrack(gC, point, track, n12, n11);
            ++n12;
        }
        this.ixDataDraw = n5;
        if (this.timeorg.pixelWrittenAfterStrongDiv > 30) {
            gC.drawText(this.timeorg.sTimeAbsDiv[0], point.x - 6 - this.timeorg.pixelWrittenAfterStrongDiv, point.y - 25);
            this.timeorg.pixelWrittenAfterStrongDiv = Integer.MIN_VALUE;
        }
        if (this.xpCursor1New >= 0) {
            this.xpCursor1 = this.xpCursor1New;
            this.xpCursor1New = -1;
        }
        if (this.xpCursor2New >= 0) {
            this.xpCursor2 = this.xpCursor2New;
            this.xpCursor2New = -1;
        }
        if (this.xpCursor1 >= 0) {
            int n13 = point.x - this.xpCursor1;
            gC.copyArea(this.cursorStore1, n13, 0);
            gC.setForeground(this.colorCursor);
            gC.setLineWidth(1);
            gC.drawLine(n13, 0, n13, point.y);
        }
        if (this.xpCursor2 >= 0) {
            int n14 = point.x - this.xpCursor2;
            gC.copyArea(this.cursorStore2, n14, 0);
            gC.setForeground(this.colorCursor);
            gC.setLineWidth(1);
            gC.drawLine(n14, 0, n14, point.y);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drawBackground(GC gC, Point point, int n, int n2, int n3, int n4) {
        try {
            int n5;
            int n6;
            int n7;
            boolean bl;
            boolean bl2;
            SwtCurveView swtCurveView = this;
            synchronized (swtCurveView) {
                boolean bl3 = this.redrawBecauseNewData;
                bl2 = this.bRedrawAll;
                if (!bl3) {
                    Debugutil.stop();
                }
                this.bRedrawAll = false;
                this.redrawBecauseNewData = false;
            }
            int n8 = this.ixDataShowRight;
            this.pixelOrg.xPixelCurve = point.x;
            this.pixelOrg.yPixelCurve = point.y;
            GralCurveView.TimeOrganisation timeOrganisation = this.timeorg;
            timeOrganisation.timePerPixel = (float)timeOrganisation.timeSpread / (float)(point.x + 1);
            timeOrganisation.pixel7time = (float)(point.x + 1) / (float)timeOrganisation.timeSpread;
            int n9 = -1;
            this.testHelp.xView = n;
            this.testHelp.yView = n2;
            this.testHelp.dxView = n3;
            this.testHelp.dyView = n4;
            if (!(this.common.bFreeze || this.bPaintAllCmd || bl2)) {
                int n10;
                bl = false;
                if (n8 != this.ixDataDraw) {
                    this.testStopWr = true;
                    this.stop();
                }
                if ((n9 = (int)(timeOrganisation.pixel7time * (float)(n7 = (n6 = this.timeValues[n8 >> this.shIxiData & this.mIxiData]) - (n10 = this.timeValues[this.ixDataDraw >> this.shIxiData & this.mIxiData]) + this.timeCaryOverNewValue) + 0.0f)) > point.x) {
                    n9 = point.x;
                }
                n5 = this.drawShiftAreaToLeft(gC, point, n, n3, n2, n4, n9, n7);
            } else {
                bl = true;
                timeOrganisation.calc();
                n9 = point.x;
                this.timeCaryOverNewValue = 0;
                n7 = (int)(timeOrganisation.timePerPixel * (float)n9);
                n5 = 0;
                this.bPaintAllCmd = false;
                ++this.testHelp.ctRedrawAll;
                this.xViewLastF = 0.0f;
                this.nrofDataShift.set(0);
            }
            this.newSamples = 0;
            if (n9 > 0) {
                try {
                    Thread.sleep(2L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.drawRightOrAll(gC, point, n, n3, n2, n4, n8, n9, n7, n5, bl);
            } else {
                ++this.nrofValuesLessViewPart;
            }
            if (this.nrofValues > 0) {
                int n11 = this.ixDataWr - this.ixDataDraw >> this.shIxiData & this.mIxiData;
                n6 = this.ixDataWr - this.ixDataShown[point.x] >> this.shIxiData & this.mIxiData;
                float f = (float)n11 / (float)this.maxNrofXValues;
                float f2 = (float)n6 / (float)this.maxNrofXValues;
                int n12 = point.x - (int)((float)point.x * f);
                int n13 = point.x - (int)((float)point.x * f2);
                gC.setLineWidth(5);
                gC.setForeground((Color)this.itsMng.impl.getColorImpl(GralColor.getColor("ye")));
                gC.drawLine(0, point.y - 3, n13, point.y - 3);
                gC.drawLine(n12, point.y - 3, point.x, point.y - 3);
                gC.setForeground((Color)this.itsMng.impl.getColorImpl(GralColor.getColor("dgr")));
                gC.drawLine(n13, point.y - 3, n12, point.y - 3);
            }
        }
        catch (Exception exception) {
            CharSequence charSequence = Assert.exceptionInfo((CharSequence)"SwtCurveView.draw - exception", (Throwable)exception, (int)0, (int)20, (boolean)true);
            System.err.append(charSequence);
        }
        this.focusChanged = false;
        this.testStopWr = false;
    }

    void stop() {
    }

    private static class TestHelp {
        int ctRedrawAll;
        int ctRedrawAllShift;
        int ctRedrawPart;
        int ctRedrawBecauseNewData;
        int xView;
        int yView;
        int dxView;
        int dyView;

        private TestHelp() {
        }
    }

    private class CurveView
    extends Canvas {
        PaintListener paintListener;
        FocusListener focusListener;

        public CurveView(Composite composite, int n, int n2, int n3) {
            super(composite, 262160);
            this.paintListener = new PaintListener(){

                public void paintControl(PaintEvent paintEvent) {
                    GC gC = paintEvent.gc;
                    CurveView.this.drawBackground(paintEvent.gc, paintEvent.x, paintEvent.y, paintEvent.width, paintEvent.height);
                }
            };
            this.focusListener = new FocusListener(){

                public void focusGained(FocusEvent focusEvent) {
                    SwtCurveView.this.focusChanged = true;
                }

                public void focusLost(FocusEvent focusEvent) {
                    SwtCurveView.this.focusChanged = true;
                }
            };
            this.setData("Control", (Object)this);
            this.setSize(n, n2);
            Color color = new Color((Device)this.getDisplay(), 255, 0, 0);
            this.addPaintListener(this.paintListener);
            this.addFocusListener(this.focusListener);
            this.addMouseListener(SwtCurveView.this.mouseListenerCurve);
        }

        public void setGridVertical(int n, int n2) {
            SwtCurveView.this.gridDistanceY = n;
            SwtCurveView.this.gridStrongPeriodY = n2;
            SwtCurveView.this.gridDistanceStrongY = n * n2;
        }

        public void setGridHorizontal(float f, int n) {
            SwtCurveView.this.gridDistanceX = f;
            SwtCurveView.this.gridStrongPeriodX = n;
        }

        public void redrawData() {
            SwtCurveView.this.redrawBecauseNewData = true;
            this.redraw();
        }

        public void drawBackground(GC gC, int n, int n2, int n3, int n4) {
            SwtCurveView.this.drawBackground(gC, this.getSize(), n, n2, n3, n4);
        }
    }
}

