/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.gral.swt;

import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.vishia.gral.base.GralMng;
import org.vishia.gral.base.GralPanelContent;
import org.vishia.gral.ifc.GralCanvasStorage;
import org.vishia.gral.ifc.GralPoint;
import org.vishia.gral.ifc.GralRectangle;
import org.vishia.gral.swt.SwtMng;
import org.vishia.gral.swt.SwtPanel;

public class SwtCanvasStorePanel
extends SwtPanel {
    protected SwtCanvas swtCanvas;
    private static final long serialVersionUID = 6448419343757106982L;
    protected Color currColor;

    public SwtCanvasStorePanel(GralPanelContent gralPanelContent, Composite composite, int n, Color color, GralMng gralMng) {
        super(gralPanelContent, null);
        this.gralPanel().canvas = new GralCanvasStorage();
        this.swtCanvas = new SwtCanvas(this, composite, n);
        this.panelComposite = this.swtCanvas;
        this.swtCanvas.addControlListener(this.resizeItemListener);
        this.swtCanvas.setData(this);
        this.swtCanvas.setLayout(null);
        this.currColor = this.swtCanvas.getForeground();
        this.swtCanvas.addPaintListener(this.swtCanvas.paintListener);
        this.swtCanvas.setBackground(color);
    }

    protected SwtCanvasStorePanel(GralPanelContent gralPanelContent) {
        super(gralPanelContent, null);
        this.gralPanel().canvas = new GralCanvasStorage();
    }

    public void xxxsetForeground(Color color) {
        this.currColor = color;
    }

    public Control getWidgetImplementation() {
        return this.swtCanvas;
    }

    @Override
    public boolean setFocusGThread() {
        if (!super.setFocusGThread()) {
            return this.swtCanvas.setFocus();
        }
        return true;
    }

    void stop() {
    }

    public static class SwtPolyLine {
        int[] points;
        int nrofPoints;
        Color color;

        SwtPolyLine(GralCanvasStorage.PolyLine polyLine, SwtMng swtMng) {
            int n;
            int n2;
            this.nrofPoints = polyLine.points.size();
            this.points = new int[2 * this.nrofPoints];
            GralRectangle gralRectangle = polyLine.pos.calcWidgetPosAndSize(swtMng.mng.propertiesGui, 0, 0, 800, 600);
            int n3 = -1;
            if (polyLine.bPointsAreGralPosUnits) {
                n2 = swtMng.mng.propertiesGui.xPixelUnit();
                n = swtMng.mng.propertiesGui.xPixelUnit();
            } else {
                n2 = gralRectangle.dx;
                n = gralRectangle.dy;
            }
            for (GralPoint gralPoint : polyLine.points) {
                int n4 = gralRectangle.x + (int)(gralPoint.x * (float)n2 + 0.5f);
                int n5 = gralRectangle.y - (int)(gralPoint.y * (float)n2 + 0.5f);
                this.points[++n3] = n4;
                this.points[++n3] = n5;
            }
            this.color = swtMng.getColorImpl(polyLine.color);
        }
    }

    protected static class SwtCanvas
    extends Canvas {
        private final SwtCanvasStorePanel storeMng;
        protected PaintListener paintListener = new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                GC gC = paintEvent.gc;
                SwtCanvas.this.drawBackground(paintEvent.gc, paintEvent.x, paintEvent.y, paintEvent.width, paintEvent.height);
            }
        };

        SwtCanvas(SwtCanvasStorePanel swtCanvasStorePanel, Composite composite, int n) {
            super(composite, n);
            this.storeMng = swtCanvasStorePanel;
        }

        public void drawBackground(GC gC, int n, int n2, int n3, int n4) {
            if (this.storeMng.gralPanel().canvas == null) {
                this.stop();
            } else {
                block5: for (GralCanvasStorage.PaintOrder paintOrder : this.storeMng.gralPanel().canvas.paintOrders) {
                    switch (paintOrder.paintWhat) {
                        case 238: {
                            gC.setForeground(((SwtMng)this.storeMng.gralPanel().gralMng().impl).getColorImpl(paintOrder.color));
                            gC.drawLine(paintOrder.x1, paintOrder.y1, paintOrder.x2, paintOrder.y2);
                            continue block5;
                        }
                        case 430: {
                            GralCanvasStorage.PaintOrder paintOrder2 = (GralCanvasStorage.PaintOrderImage)paintOrder;
                            Object object = (Image)((GralCanvasStorage.PaintOrderImage)paintOrder2).image.getImage();
                            gC.drawImage(object, 0, 0, ((GralCanvasStorage.PaintOrderImage)paintOrder2).dxImage, ((GralCanvasStorage.PaintOrderImage)paintOrder2).dyImage, paintOrder.x1, paintOrder.y1, paintOrder.x2, paintOrder.y2);
                            continue block5;
                        }
                        case 121: {
                            Object object;
                            GralCanvasStorage.PaintOrder paintOrder2 = (GralCanvasStorage.PolyLine)paintOrder;
                            Object object2 = paintOrder2.getImplData();
                            if (object2 == null) {
                                object = new SwtPolyLine((GralCanvasStorage.PolyLine)paintOrder2, (SwtMng)this.storeMng.gralPanel().gralMng().impl);
                                paintOrder2.setImplData(object);
                            } else {
                                object = (SwtPolyLine)object2;
                            }
                            gC.drawPolyline(object.points);
                            continue block5;
                        }
                    }
                    throw new IllegalArgumentException("unknown order");
                }
            }
        }

        void stop() {
        }
    }
}

