/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.gral.ifc;

import java.util.Map;
import java.util.TreeMap;

public class GralColor {
    public static final int version = 20120907;
    public final int red;
    public final int green;
    public final int blue;
    public final String name;
    public Object colorGuimpl;
    private static GralColorContainer container = new GralColorContainer();

    public GralColor(int n, int n2, int n3) {
        this.red = n;
        this.green = n2;
        this.blue = n3;
        int n4 = n << 16 & 0xFF0000 | n2 << 8 & 0xFF00 | n3 & 0xFF;
        this.name = String.format("0x%06X", new Integer(n4));
    }

    public GralColor(int n) {
        this.red = n >> 16 & 0xFF;
        this.green = n >> 8 & 0xFF;
        this.blue = n >> 0 & 0xFF;
        this.name = String.format("0x%06X", new Integer(n));
    }

    public GralColor(String string, int n) {
        this.red = n >> 16 & 0xFF;
        this.green = n >> 8 & 0xFF;
        this.blue = n >> 0 & 0xFF;
        this.name = string;
    }

    public int getColorValue() {
        return (this.red & 0xFF) << 16 | (this.green & 0xFF) << 8 | this.blue & 0xFF;
    }

    public String getColorName() {
        return this.name;
    }

    public static GralColor getColor(String string) {
        GralColor gralColor;
        if (string.startsWith("0x")) {
            try {
                int n = Integer.parseInt(string.substring(2).trim(), 16);
                gralColor = GralColor.getColor(n);
            }
            catch (NumberFormatException numberFormatException) {
                gralColor = GralColor.container.colorsByName.get("ma");
            }
        } else {
            gralColor = GralColor.container.colorsByName.get(string);
            if (gralColor == null) {
                gralColor = GralColor.container.colorsByName.get("ma");
            }
        }
        return gralColor;
    }

    public static GralColor getStdColor(int n, int n2) {
        return GralColor.container.stdColors[n][n2];
    }

    public static GralColor getColor(int n) {
        GralColor gralColor = GralColor.container.colorsByValue.get(new Integer(n));
        if (gralColor == null) {
            gralColor = new GralColor(n);
            GralColor.container.colorsByValue.put(new Integer(n), gralColor);
        }
        return gralColor;
    }

    public String toString() {
        int n = this.red << 16 & 0xFF0000 | this.green << 8 & 0xFF00 | this.blue & 0xFF;
        if (this.name != null) {
            return this.name;
        }
        return String.format("0x%06X", new Integer(n));
    }

    private static class GralColorContainer {
        Map<String, GralColor> colorsByName = new TreeMap<String, GralColor>();
        Map<Integer, GralColor> colorsByValue = new TreeMap<Integer, GralColor>();
        public GralColor[][] stdColors = new GralColor[6][19];

        GralColorContainer() {
            this.addColor("white", 0xFFFFFF);
            this.addColor("gray", 0x808080);
            this.addColor("black", 0);
            this.addColor("red", 0xFF0000);
            this.addColor("lime", 65280);
            this.addColor("green", 57344);
            this.addColor("blue", 255);
            this.addColor("yellow", 0xFFFF00);
            this.addColor("magenta", 0xFF00FF);
            this.addColor("cyan", 65535);
            this.addColor("brown", 0x600020);
            this.addColor("amber", 0xFFE000);
            this.addColor("orange", 0xFFA000);
            this.addColor("violet", 0x6000FF);
            this.addColor("mauve", 0xD0D0FF);
            this.addColor("pink", 0xFF0080);
            this.addColor("red-purple", 0xFF0060);
            this.addColor("purple", 0x800080);
            this.addColor("ye", 0xFFFF00);
            this.addColor("ygn", 10145074);
            this.addColor("lm", 65280);
            this.addColor("gn", 57344);
            this.addColor("g2", 57376);
            this.addColor("cy", 65535);
            this.addColor("wh", 0xFFFFFF);
            this.addColor("gr", 0xA0A0A0);
            this.addColor("bk", 0);
            this.addColor("ma", 0xFF00FF);
            this.addColor("ma2", 0xFF00C0);
            this.addColor("ma3", 0xFF0080);
            this.addColor("ma4", 0xFF0040);
            this.addColor("rpu", 0xFF0040);
            this.addColor("pu", 0x800080);
            this.addColor("rd", 0xFF2020);
            this.addColor("or", 0xFFA000);
            this.addColor("cc", 13789470);
            this.addColor("am", 0xFFE000);
            this.addColor("sye", 0xC0C000);
            this.addColor("ol", 0x808000);
            this.addColor("od", 7048739);
            this.addColor("fgn", 0x228B22);
            this.addColor("sgn", 3050327);
            this.addColor("sg2", 49184);
            this.addColor("scy", 49344);
            this.addColor("tl", 32896);
            this.addColor("bl", 255);
            this.addColor("ubl", 128);
            this.addColor("vi", 0x6000FF);
            this.addColor("bn", 0x600020);
            this.addColor("mv", 0xD0D0FF);
            this.addColor("pk", 0xFF0080);
            this.addColor("lgr", 0xD0D0D0);
            this.addColor("lrd", 0xFF8080);
            this.addColor("lgn", 0x80FF80);
            this.addColor("lbl", 0xA0A0FF);
            this.addColor("lye", 0xFFFF80);
            this.addColor("lam", 0xFFF080);
            this.addColor("lor", 16752736);
            this.addColor("lma", 0xFF80FF);
            this.addColor("lmv", 0xE0E0FF);
            this.addColor("lcy", 65535);
            this.addColor("lbk", 0x404040);
            this.addColor("pgr", 0xF0F0F0);
            this.addColor("prd", 0xFFE0E0);
            this.addColor("pgn", 0xE0FFE0);
            this.addColor("pbl", 0xE0E0FF);
            this.addColor("pye", 0xFFFFC0);
            this.addColor("pam", 0xFFF0C0);
            this.addColor("por", 16760960);
            this.addColor("pmv", 0xFFF0FF);
            this.addColor("pma", 0xFFA0FF);
            this.addColor("pcy", 0xA0FFFF);
            this.addColor("dgr", 0x606060);
            this.addColor("drd", 0x800000);
            this.addColor("dor", 16747520);
            this.addColor("dbn", 0x400010);
            this.addColor("dol", 5597999);
            this.addColor("dgn", 32768);
            this.addColor("dbl", 128);
            this.addColor("dye", 0x606000);
            this.addColor("dma", 0x600060);
            this.addColor("dcy", 24672);
            int n = 0;
            this.addColor(n, 0, "pMa1", 0xFFC0FF);
            this.addColor(n, 1, "pMa2", 16761056);
            this.addColor(n, 2, "pRd1", 0xFFD0D0);
            this.addColor(n, 3, "pRd2", 16769216);
            this.addColor(n, 4, "pRd3", 0xFFF0C0);
            this.addColor(n, 5, "pYe1", 0xFFFFD0);
            this.addColor(n, 6, "pYe2", 14745536);
            this.addColor(n, 7, "pYe3", 14745536);
            this.addColor(n, 8, "pYe4", 14745536);
            this.addColor(n, 9, "pGn1", 0xD0FFD0);
            this.addColor(n, 10, "pGn2", 0xC0FFF0);
            this.addColor(n, 11, "pGn3", 12648416);
            this.addColor(n, 12, "pGn4", 0xC0FFF0);
            this.addColor(n, 13, "pCy1", 0xC0FFFF);
            this.addColor(n, 14, "pCy2", 0xD0F0FF);
            this.addColor(n, 15, "pCy3", 12640511);
            this.addColor(n, 16, "pBl1", 0xD0D0FF);
            this.addColor(n, 17, "pBl2", 14729471);
            this.addColor(n, 18, "pBl3", 0xF0C0FF);
            this.addColor(++n, 0, "lMa1", 0xFF80FF);
            this.addColor(n, 1, "lMa2", 16744648);
            this.addColor(n, 2, "lRd1", 0xFFB8B8);
            this.addColor(n, 3, "lRd2", 16763040);
            this.addColor(n, 4, "lRd3", 16769168);
            this.addColor(n, 5, "lYe1", 0xFFFF80);
            this.addColor(n, 6, "lYe2", 14745472);
            this.addColor(n, 7, "lYe3", 12648320);
            this.addColor(n, 8, "lYe4", 10551168);
            this.addColor(n, 9, "lGn1", 0x70FF70);
            this.addColor(n, 10, "lGn2", 8454048);
            this.addColor(n, 11, "lGn3", 8454080);
            this.addColor(n, 12, "lGn4", 8454112);
            this.addColor(n, 13, "lCy1", 0x80FFFF);
            this.addColor(n, 14, "lCy2", 10021119);
            this.addColor(n, 15, "lCy3", 11587839);
            this.addColor(n, 16, "lBl1", 0xC0C0FF);
            this.addColor(n, 17, "lBl2", 13676799);
            this.addColor(n, 18, "lBl3", 14721279);
            this.addColor(++n, 0, "Ma1", 0xFF00FF);
            this.addColor(n, 1, "Ma2", 16728208);
            this.addColor(n, 2, "Rd1", 0xFF7070);
            this.addColor(n, 3, "Rd2", 16748608);
            this.addColor(n, 4, "Am", 0xFFE000);
            this.addColor(n, 5, "Ye1", 0xFFFF00);
            this.addColor(n, 6, "Ye2", 0xC0FF00);
            this.addColor(n, 7, "Ye3", 0x80FF00);
            this.addColor(n, 8, "Ye4", 0x40FF00);
            this.addColor(n, 9, "Gn1", 65280);
            this.addColor(n, 10, "Gn2", 65344);
            this.addColor(n, 11, "Gn3", 65408);
            this.addColor(n, 12, "Gn4", 65472);
            this.addColor(n, 13, "Cy1", 65535);
            this.addColor(n, 14, "Cy2", 3199231);
            this.addColor(n, 15, "Cy3", 6332671);
            this.addColor(n, 16, "Bl1", 0x8080FF);
            this.addColor(n, 17, "Bl2", 10510591);
            this.addColor(n, 18, "Bl3", 12599551);
            this.addColor(++n, 0, "gMa1", 0xD080D0);
            this.addColor(n, 1, "gMa2", 13664456);
            this.addColor(n, 2, "gRd1", 13678776);
            this.addColor(n, 3, "gRd2", 13682848);
            this.addColor(n, 4, "gRd3", 13688976);
            this.addColor(n, 5, "gYe1", 0xD0D080);
            this.addColor(n, 6, "gYe2", 14733440);
            this.addColor(n, 7, "gYe3", 12636288);
            this.addColor(n, 8, "gYe4", 10539136);
            this.addColor(n, 9, "gGn1", 0x70D070);
            this.addColor(n, 10, "gGn2", 8442016);
            this.addColor(n, 11, "gGn3", 8442048);
            this.addColor(n, 12, "gGn4", 8442080);
            this.addColor(n, 13, "gCy1", 0x80D0D0);
            this.addColor(n, 14, "gCy2", 10021072);
            this.addColor(n, 15, "gCy3", 0xB0D0D0);
            this.addColor(n, 16, "gBl1", 0xC0C0D0);
            this.addColor(n, 17, "gBl2", 0xD0B0D0);
            this.addColor(n, 18, "gBl3", 14721232);
            this.addColor(++n, 0, "sMa1", 0xD000D0);
            this.addColor(n, 1, "sMa2", 14688384);
            this.addColor(n, 2, "sRd1", 0xFF0000);
            this.addColor(n, 3, "sRd2", 0xFFC000);
            this.addColor(n, 4, "sRd3", 0xFF8000);
            this.addColor(n, 5, "sYe1", 0xE8E800);
            this.addColor(n, 6, "sYe2", 0xC0C000);
            this.addColor(n, 7, "sYe3", 0x80B000);
            this.addColor(n, 8, "sYe4", 0x40B000);
            this.addColor(n, 9, "sGn1", 49152);
            this.addColor(n, 10, "sGn2", 45120);
            this.addColor(n, 11, "sGn3", 45184);
            this.addColor(n, 12, "sGn4", 45248);
            this.addColor(n, 13, "sCy1", 53456);
            this.addColor(n, 14, "sCy2", 32976);
            this.addColor(n, 15, "sCy3", 0x3030FF);
            this.addColor(n, 16, "sBl1", 255);
            this.addColor(n, 17, "sBl2", 8401151);
            this.addColor(n, 18, "sBl3", 0xC000FF);
            this.addColor(++n, 0, "dMa1", 0x800080);
            this.addColor(n, 1, "dMa2", 0x800000);
            this.addColor(n, 2, "dRd1", 0xC00000);
            this.addColor(n, 3, "dRd2", 0x808000);
            this.addColor(n, 4, "dRd3", 0x800000);
            this.addColor(n, 5, "dYe1", 0xC0C000);
            this.addColor(n, 6, "dYe2", 0x606000);
            this.addColor(n, 7, "dYe3", 0x405000);
            this.addColor(n, 8, "dYe4", 131072);
            this.addColor(n, 9, "dGn1", 32768);
            this.addColor(n, 10, "dGn2", 16384);
            this.addColor(n, 11, "dGn3", 22592);
            this.addColor(n, 12, "dGn4", 22624);
            this.addColor(n, 13, "dCy1", 26728);
            this.addColor(n, 14, "dCy2", 16488);
            this.addColor(n, 15, "dCy3", 1513344);
            this.addColor(n, 16, "dBl1", 192);
            this.addColor(n, 17, "dBl2", 0x2000A0);
            this.addColor(n, 18, "dBl3", 0x200080);
        }

        private void addColor(int n, int n2, String string, int n3) {
            GralColor gralColor;
            this.stdColors[n][n2] = gralColor = new GralColor(string, n3);
            this.colorsByName.put(string, gralColor);
            this.colorsByValue.put(new Integer(n3), gralColor);
        }

        private void addColor(String string, int n) {
            GralColor gralColor = new GralColor(string, n);
            this.colorsByName.put(string, gralColor);
            this.colorsByValue.put(new Integer(n), gralColor);
        }
    }
}

