/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.gral.cfg;

import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import org.vishia.gral.cfg.GralCfgData;
import org.vishia.gral.cfg.GralCfgElement;
import org.vishia.gral.cfg.GralCfgPosition;
import org.vishia.msgDispatch.LogMessage;

public class GralCfgWriter {
    public static final String version = "2015-01-27";
    final LogMessage log;
    Writer writer;

    public GralCfgWriter(LogMessage logMessage) {
        this.log = logMessage;
    }

    public String saveCfg(Writer writer, GralCfgData gralCfgData) {
        this.writer = writer;
        String string = null;
        try {
            this.writer.append("size(500,120); ");
            this.writeDataReplace(gralCfgData);
            GralCfgElement gralCfgElement = gralCfgData.firstElement;
            while (gralCfgElement != null) {
                this.writeElement(writer, gralCfgElement);
                gralCfgElement = gralCfgElement.next;
            }
            writer.append("\n");
        }
        catch (IOException iOException) {
            this.log.sendMsg(-1, "exception writing config", new Object[0]);
        }
        return string;
    }

    void writeDataReplace(GralCfgData gralCfgData) throws IOException {
        this.writer.append("\n");
        if (gralCfgData != null) {
            for (Map.Entry<String, String> entry : gralCfgData.dataReplace.entrySet()) {
                this.writer.append("DataReplace: ").append(entry.getKey()).append(" = ").append(entry.getValue()).append(";\n");
            }
        }
        this.writer.append("\n");
    }

    void writeElement(Writer writer, GralCfgElement gralCfgElement) throws IOException {
        if (gralCfgElement.widgetType instanceof GralCfgData.GuiCfgImage) {
            writer.append("\n\n//================================================================================\n");
        }
        this.writePosition(writer, gralCfgElement.positionInput);
        if (gralCfgElement.widgetType instanceof GralCfgData.GuiCfgShowField) {
            this.writeShowField((GralCfgData.GuiCfgShowField)gralCfgElement.widgetType);
        } else if (gralCfgElement.widgetType instanceof GralCfgData.GuiCfgText) {
            this.writeText((GralCfgData.GuiCfgText)gralCfgElement.widgetType);
        } else if (gralCfgElement.widgetType instanceof GralCfgData.GuiCfgLed) {
            this.writeLed((GralCfgData.GuiCfgLed)gralCfgElement.widgetType);
        } else if (gralCfgElement.widgetType instanceof GralCfgData.GuiCfgImage) {
            this.writeImage((GralCfgData.GuiCfgImage)gralCfgElement.widgetType);
        } else if (gralCfgElement.widgetType instanceof GralCfgData.GuiCfgInputFile) {
            this.writeInputFile((GralCfgData.GuiCfgInputFile)gralCfgElement.widgetType);
        } else if (gralCfgElement.widgetType instanceof GralCfgData.GuiCfgButton) {
            this.writeButton((GralCfgData.GuiCfgButton)gralCfgElement.widgetType);
        } else if (gralCfgElement.widgetType.whatIs == 'T') {
            this.writer.append("InputTextline(");
            this.writeParam(gralCfgElement.widgetType);
            this.writer.append(");\n");
        } else if (gralCfgElement.widgetType.whatIs == 't') {
            this.writer.append("InputBox(");
            this.writeParam(gralCfgElement.widgetType);
            this.writer.append(");\n");
        } else {
            this.writeUnknown(gralCfgElement.widgetType);
        }
    }

    void writePosition(Writer writer, GralCfgPosition gralCfgPosition) throws IOException {
        if (gralCfgPosition.yPos >= 0 || gralCfgPosition.xPos >= 0 || gralCfgPosition.ySizeDown != 0 || gralCfgPosition.xWidth != 0) {
            writer.append("\n@");
            if (gralCfgPosition.panel != null) {
                writer.append(gralCfgPosition.panel).append(", ");
            }
            if (gralCfgPosition.yPosRelative) {
                writer.append("&");
            }
            if (gralCfgPosition.yPos >= 0) {
                writer.append(Integer.toString(gralCfgPosition.yPos));
            }
            if (gralCfgPosition.yPosFrac != 0) {
                writer.append(".").append(Integer.toString(gralCfgPosition.yPosFrac));
            }
            if (gralCfgPosition.ySizeDown > 0) {
                writer.append("+").append(gralCfgPosition.ySizeDown == Integer.MAX_VALUE ? "*" : Integer.toString(gralCfgPosition.ySizeDown));
            } else if (gralCfgPosition.ySizeDown < 0) {
                writer.append(Integer.toString(gralCfgPosition.ySizeDown));
            }
            if (gralCfgPosition.ySizeFrac != 0) {
                writer.append(".").append(Integer.toString(gralCfgPosition.ySizeFrac));
            }
            if (gralCfgPosition.yIncr_) {
                writer.append("++");
            }
            writer.append(",");
            if (gralCfgPosition.xPosRelative) {
                writer.append("&");
            }
            if (gralCfgPosition.xPos >= 0) {
                writer.append(Integer.toString(gralCfgPosition.xPos));
            }
            if (gralCfgPosition.xPosFrac != 0) {
                writer.append(".").append(Integer.toString(gralCfgPosition.xPosFrac));
            }
            if (gralCfgPosition.xWidth > 0) {
                writer.append("+").append(gralCfgPosition.xWidth == Integer.MAX_VALUE ? "*" : Integer.toString(gralCfgPosition.xWidth));
            } else if (gralCfgPosition.xWidth < 0) {
                writer.append(Integer.toString(gralCfgPosition.xWidth));
            }
            if (gralCfgPosition.xSizeFrac != 0) {
                writer.append(".").append(Integer.toString(gralCfgPosition.xSizeFrac));
            }
            if (gralCfgPosition.xIncr_) {
                writer.append("++");
            }
            writer.append(": ");
        }
    }

    void writeShowField(GralCfgData.GuiCfgShowField guiCfgShowField) throws IOException {
        if (guiCfgShowField.editable) {
            this.writer.append("InputTextline(");
        } else {
            this.writer.append("Show(");
        }
        this.writeParam(guiCfgShowField);
        this.writer.append("); ");
    }

    void writeLed(GralCfgData.GuiCfgLed guiCfgLed) throws IOException {
        this.writer.append("Led(");
        this.writeParam(guiCfgLed);
        this.writer.append("); ");
    }

    void writeImage(GralCfgData.GuiCfgImage guiCfgImage) throws IOException {
        this.writer.append("Imagefile(file=\"");
        this.writer.append(guiCfgImage.file_).append("\"");
        this.writeParam(guiCfgImage, ",");
        this.writer.append(");\n");
    }

    void writeInputFile(GralCfgData.GuiCfgInputFile guiCfgInputFile) throws IOException {
        this.writer.append("InputFile(");
        this.writeParam(guiCfgInputFile);
        this.writer.append(");\n");
    }

    void writeButton(GralCfgData.GuiCfgButton guiCfgButton) throws IOException {
        this.writer.append("Button(");
        this.writeParam(guiCfgButton);
        this.writer.append(");\n");
    }

    void writeText(GralCfgData.GuiCfgText guiCfgText) throws IOException {
        this.writer.append("Text(");
        this.writeParam(guiCfgText);
        this.writer.append("); ");
    }

    void writeUnknown(GralCfgData.WidgetTypeBase widgetTypeBase) throws IOException {
        this.writer.append("Unknown(");
        this.writeParam(widgetTypeBase);
        this.writer.append("); ");
    }

    private void writeParam(GralCfgData.WidgetTypeBase widgetTypeBase) throws IOException {
        this.writeParam(widgetTypeBase, "");
    }

    private void writeParam(GralCfgData.WidgetTypeBase widgetTypeBase, String string) throws IOException {
        if (widgetTypeBase.prompt != null && widgetTypeBase.promptPosition != null && widgetTypeBase.promptPosition.length() >= 1) {
            this.writer.append("%").append(widgetTypeBase.promptPosition).append(":\"").append(widgetTypeBase.prompt).append("\"");
            string = ", ";
        }
        if (widgetTypeBase.text != null) {
            this.writer.append(string).append("\"").append(widgetTypeBase.text).append("\"");
            string = ", ";
        }
        if (widgetTypeBase.name != null) {
            this.writer.append(string).append("name=").append(widgetTypeBase.name);
            string = ", ";
        }
        if (widgetTypeBase.cmd != null) {
            this.writer.append(string).append("cmd=\"").append(widgetTypeBase.cmd).append("\"");
            string = ", ";
        }
        if (widgetTypeBase.showMethod != null) {
            this.writer.append(string).append("show=\"").append(widgetTypeBase.showMethod).append("\"");
            string = ", ";
        }
        if (widgetTypeBase.format != null) {
            this.writer.append(string).append("format=\"").append(widgetTypeBase.format).append("\"");
            string = ", ";
        }
        if (widgetTypeBase.type != null) {
            this.writer.append(string).append("type=").append(widgetTypeBase.type);
            string = ", ";
        }
        if (widgetTypeBase.data != null) {
            this.writer.append(string).append("data=\"").append(widgetTypeBase.data).append("\"");
            string = ", ";
        }
        if (widgetTypeBase.userAction != null) {
            this.writer.append(string).append("action=").append(widgetTypeBase.userAction);
            string = ", ";
        }
        if (widgetTypeBase.dragFiles != null) {
            this.writer.append(string).append("dragFiles=\"").append(widgetTypeBase.dragFiles).append("\"");
            string = ", ";
        }
        if (widgetTypeBase.dragText != null) {
            this.writer.append(string).append("dragText=\"").append(widgetTypeBase.dragText).append("\"");
            string = ", ";
        }
        if (widgetTypeBase.dropFiles != null) {
            this.writer.append(string).append("dropFiles=\"").append(widgetTypeBase.dropFiles).append("\"");
            string = ", ";
        }
        if (widgetTypeBase.dropText != null) {
            this.writer.append(string).append("dropText=\"").append(widgetTypeBase.dropText).append("\"");
            string = ", ";
        }
        if (widgetTypeBase.color0 != null) {
            this.writer.append(string).append("color=").append(widgetTypeBase.color0.color);
            if (widgetTypeBase.color1 != null) {
                this.writer.append("/").append(widgetTypeBase.color1.color);
            }
            string = ", ";
        }
    }
}

