/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.gral.cfg;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.vishia.gral.base.GralCurveView;
import org.vishia.gral.base.GralWidget;
import org.vishia.gral.cfg.GralCfgData;
import org.vishia.gral.cfg.GralCfgElement;
import org.vishia.gral.cfg.GralCfgPanel;
import org.vishia.gral.ifc.GralColor;
import org.vishia.gral.ifc.GralMngBuild_ifc;
import org.vishia.gral.ifc.GralPoint;
import org.vishia.gral.ifc.GralUserAction;
import org.vishia.msgDispatch.LogMessage;
import org.vishia.util.CalculatorExpr;
import org.vishia.util.FileSystem;

public class GralCfgBuilder {
    public static final int version = 20120303;
    private final GralCfgData cfgData;
    private final GralMngBuild_ifc gralMng;
    private final File currentDir;
    private final Map<String, String> indexAlias = new TreeMap<String, String>();

    public GralCfgBuilder(GralCfgData gralCfgData, GralMngBuild_ifc gralMngBuild_ifc, File file) {
        this.cfgData = gralCfgData;
        this.gralMng = gralMngBuild_ifc;
        this.currentDir = file;
        String string = FileSystem.getCanonicalPath((File)file);
        this.indexAlias.put("cfg", string);
    }

    public GralCfgElement XXXnewCfgElement(GralCfgElement gralCfgElement) {
        GralCfgElement gralCfgElement2 = gralCfgElement.clone();
        gralCfgElement2.next = gralCfgElement.next;
        gralCfgElement2.previous = gralCfgElement;
        gralCfgElement.next = gralCfgElement2;
        return gralCfgElement2;
    }

    public String buildGui(LogMessage logMessage, int n) {
        String string = null;
        this.gralMng.addDataReplace(this.cfgData.dataReplace);
        Set<Map.Entry<String, GralCfgPanel>> set = this.cfgData.getPanels();
        for (Map.Entry<String, GralCfgPanel> entry : set) {
            GralCfgPanel gralCfgPanel = entry.getValue();
            String string2 = this.buildPanel(gralCfgPanel);
            if (string2 != null) {
                if (logMessage != null) {
                    logMessage.sendMsg(n, "GralCfgBuilder - cfg error; %s", new Object[]{string2});
                }
                if (string == null) {
                    string = string2;
                    continue;
                }
                string = string + "\n" + string2;
                continue;
            }
            this.stop();
        }
        return string;
    }

    public String buildPanel(GralCfgPanel gralCfgPanel) {
        String string = null;
        this.gralMng.selectPanel(gralCfgPanel.name);
        for (GralCfgElement gralCfgElement : gralCfgPanel.listElements) {
            String string2 = this.buildWidget(gralCfgElement);
            if (string2 == null) continue;
            if (string == null) {
                string = string2;
                continue;
            }
            string = string + "\n" + string2;
        }
        return string;
    }

    public String buildWidget(GralCfgElement gralCfgElement) {
        GralUserAction gralUserAction;
        String string;
        Object object2;
        String string2 = null;
        gralCfgElement.setPos(this.gralMng);
        if (gralCfgElement.widgetType.type != null) {
            object2 = this.cfgData.idxTypes.get(gralCfgElement.widgetType.type);
            if (object2 == null) {
                throw new IllegalArgumentException("GralCfgBuilder.buildWidget - unknown type; " + gralCfgElement.widgetType.type + "; in " + gralCfgElement.content);
            }
            gralCfgElement.widgetType.setFromType((GralCfgData.WidgetTypeBase)object2);
        }
        object2 = null;
        String string3 = gralCfgElement.widgetType.name;
        if (string3 != null && string3.equals("msgOfDay")) {
            this.stop();
        }
        if (string3 == null && gralCfgElement.widgetType.text != null) {
            string3 = gralCfgElement.widgetType.text;
        }
        if (string3 == null && gralCfgElement.widgetType.prompt != null) {
            string3 = this.cfgData.actPanel.name + "/" + gralCfgElement.widgetType.prompt;
        }
        if ((string = gralCfgElement.widgetType.data) == null && gralCfgElement.widgetType.text != null) {
            string = gralCfgElement.widgetType.text;
        }
        if (gralCfgElement.widgetType.userAction != null) {
            gralUserAction = this.gralMng.getRegisteredUserAction(gralCfgElement.widgetType.userAction);
            if (gralUserAction == null) {
                string2 = "GuiCfgBuilder - user action not found: " + gralCfgElement.widgetType.userAction;
            }
        } else {
            gralUserAction = null;
        }
        if (gralCfgElement.widgetType instanceof GralCfgData.GuiCfgButton) {
            GralCfgData.GuiCfgButton guiCfgButton = (GralCfgData.GuiCfgButton)gralCfgElement.widgetType;
            object2 = guiCfgButton.bSwitch ? this.gralMng.addSwitchButton(gralCfgElement.widgetType.name, gralUserAction, gralCfgElement.widgetType.cmd, gralCfgElement.widgetType.data, gralCfgElement.widgetType.text, gralCfgElement.widgetType.color0.color, gralCfgElement.widgetType.color1.color) : this.gralMng.addButton(gralCfgElement.widgetType.name, gralUserAction, gralCfgElement.widgetType.cmd, gralCfgElement.widgetType.data, gralCfgElement.widgetType.text);
        } else if (gralCfgElement.widgetType instanceof GralCfgData.GuiCfgText) {
            GralCfgData.GuiCfgText guiCfgText = (GralCfgData.GuiCfgText)gralCfgElement.widgetType;
            int n = guiCfgText.color0 != null ? this.gralMng.getColorValue(guiCfgText.color0.color) : 0;
            gralCfgElement.widgetType.color0 = null;
            object2 = this.gralMng.addText(gralCfgElement.widgetType.text, guiCfgText.size.charAt(0), n);
        } else if (gralCfgElement.widgetType instanceof GralCfgData.GuiCfgLed) {
            GralCfgData.GuiCfgLed guiCfgLed = (GralCfgData.GuiCfgLed)gralCfgElement.widgetType;
            object2 = this.gralMng.addLed(string3, string);
        } else if (gralCfgElement.widgetType instanceof GralCfgData.GuiCfgImage) {
            GralCfgData.GuiCfgImage guiCfgImage = (GralCfgData.GuiCfgImage)gralCfgElement.widgetType;
            File file = new File(this.currentDir, guiCfgImage.file_);
            if (file.exists()) {
                try {
                    FileInputStream fileInputStream = new FileInputStream(file);
                    this.gralMng.addImage(string3, fileInputStream, 10, 20, "?cmd");
                    ((InputStream)fileInputStream).close();
                }
                catch (IOException iOException) {}
            }
        } else if (gralCfgElement.widgetType instanceof GralCfgData.GuiCfgShowField) {
            object2 = this.gralMng.addTextField(string3, gralCfgElement.widgetType.editable, gralCfgElement.widgetType.prompt, gralCfgElement.widgetType.promptPosition);
            ((GralWidget)object2).setDataPath(string);
        } else if (gralCfgElement.widgetType instanceof GralCfgData.GuiCfgInputFile) {
            GralCfgData.GuiCfgInputFile guiCfgInputFile = (GralCfgData.GuiCfgInputFile)gralCfgElement.widgetType;
            String string4 = guiCfgInputFile.data != null ? this.replaceAlias(guiCfgInputFile.data) : "";
            object2 = this.gralMng.addFileSelectField(string3, null, string4, null, "t");
            ((GralWidget)object2).setDataPath(string);
        } else if (gralCfgElement.widgetType instanceof GralCfgData.GuiCfgTable) {
            GralCfgData.GuiCfgTable guiCfgTable = (GralCfgData.GuiCfgTable)gralCfgElement.widgetType;
            List<Integer> list = guiCfgTable.getColumnWidths();
            int n = list.size();
            int[] object3 = new int[n];
            int n2 = -1;
            for (Integer n3 : list) {
                object3[++n2] = n3;
            }
            object2 = this.gralMng.addTable(string3, guiCfgTable.height, object3);
            ((GralWidget)object2).setDataPath(string);
        } else if (gralCfgElement.widgetType instanceof GralCfgData.GuiCfgCurveview) {
            GralCfgData.GuiCfgCurveview guiCfgCurveview = (GralCfgData.GuiCfgCurveview)gralCfgElement.widgetType;
            int n = guiCfgCurveview.lines.size();
            GralCurveView gralCurveView = this.gralMng.addCurveViewY(string3, guiCfgCurveview.nrofPoints, null);
            gralCurveView.activate(guiCfgCurveview.activate);
            for (GralCfgData.GuiCfgCurveLine guiCfgCurveLine : guiCfgCurveview.lines) {
                String string4 = guiCfgCurveLine.data;
                GralColor gralColor = guiCfgCurveLine.color0 != null ? GralColor.getColor(guiCfgCurveLine.color0.color) : GralColor.getColor(guiCfgCurveLine.colorValue);
                gralCurveView.initTrack(guiCfgCurveLine.name, string4, gralColor, 0, guiCfgCurveLine.nullLine, guiCfgCurveLine.scale, guiCfgCurveLine.offset);
            }
            object2 = gralCurveView;
        } else {
            switch (gralCfgElement.widgetType.whatIs) {
                case 'T': {
                    object2 = this.gralMng.addTextField(string3, true, gralCfgElement.widgetType.prompt, gralCfgElement.widgetType.promptPosition);
                    ((GralWidget)object2).setDataPath(string);
                    break;
                }
                case 't': {
                    char c = gralCfgElement.widgetType.promptPosition == null ? (char)'.' : (char)gralCfgElement.widgetType.promptPosition.charAt(0);
                    object2 = this.gralMng.addTextBox(string3, true, gralCfgElement.widgetType.prompt, c);
                    ((GralWidget)object2).setDataPath(string);
                    break;
                }
                case 'U': {
                    object2 = this.gralMng.addValueBar(string3, string);
                    break;
                }
                case 'I': {
                    GralCfgData.GuiCfgLine guiCfgLine = (GralCfgData.GuiCfgLine)gralCfgElement.widgetType;
                    LinkedList<GralPoint> linkedList = new LinkedList<GralPoint>();
                    for (GralCfgData.GuiCfgCoord guiCfgCoord : guiCfgLine.coords) {
                        linkedList.add(new GralPoint(guiCfgCoord.x, guiCfgCoord.y));
                    }
                    this.gralMng.addLine(GralColor.getColor(guiCfgLine.color0.color), linkedList);
                    break;
                }
                default: {
                    object2 = null;
                }
            }
        }
        if (object2 != null) {
            String string6;
            String string7 = gralCfgElement.widgetType.showMethod;
            if (string7 != null) {
                String[] stringArray = CalculatorExpr.splitFnNameAndParams((String)string7);
                GralUserAction gralUserAction2 = this.gralMng.getRegisteredUserAction(stringArray[0]);
                if (gralUserAction2 == null) {
                    string2 = "GuiCfgBuilder - show method not found: " + stringArray[0];
                } else {
                    String[] stringArray2 = stringArray[1] == null ? null : CalculatorExpr.splitFnParams((String)stringArray[1]);
                    ((GralWidget)object2).setActionShow(gralUserAction2, stringArray2);
                }
            }
            ((GralWidget)object2).sCmd = gralCfgElement.widgetType.cmd;
            if (gralUserAction != null) {
                ((GralWidget)object2).setActionChange(gralUserAction);
            }
            if ((string6 = gralCfgElement.widgetType.format) != null) {
                ((GralWidget)object2).setFormat(string6);
            }
            if (gralCfgElement.widgetType.help != null) {
                ((GralWidget)object2).setHtmlHelp(gralCfgElement.widgetType.help);
            }
            if (gralCfgElement.widgetType.color0 != null) {
                ((GralWidget)object2).setBackColor(GralColor.getColor(gralCfgElement.widgetType.color0.color), 0);
            }
            if (gralCfgElement.widgetType.color1 != null) {
                ((GralWidget)object2).setLineColor(GralColor.getColor(gralCfgElement.widgetType.color1.color), 0);
            }
            if (gralCfgElement.widgetType.dropFiles != null) {
                GralUserAction gralUserAction3 = this.gralMng.getRegisteredUserAction(gralCfgElement.widgetType.dropFiles);
                if (gralUserAction3 == null) {
                    string2 = "GuiCfgBuilder - action for drop not found: " + gralCfgElement.widgetType.dropFiles;
                } else {
                    ((GralWidget)object2).setDropEnable(gralUserAction3, 852038);
                }
            }
            if (gralCfgElement.widgetType.dragFiles != null) {
                GralUserAction gralUserAction4 = this.gralMng.getRegisteredUserAction(gralCfgElement.widgetType.dragFiles);
                if (gralUserAction4 == null) {
                    string2 = "GuiCfgBuilder - action for drag not found: " + gralCfgElement.widgetType.dragFiles;
                } else {
                    ((GralWidget)object2).setDragEnable(gralUserAction4, 852070);
                }
            }
            if (gralCfgElement.widgetType.dragText != null) {
                GralUserAction gralUserAction5 = this.gralMng.getRegisteredUserAction(gralCfgElement.widgetType.dragText);
                if (gralUserAction5 == null) {
                    string2 = "GuiCfgBuilder - action for drag not found: " + gralCfgElement.widgetType.dragText;
                } else {
                    ((GralWidget)object2).setDragEnable(gralUserAction5, 852084);
                }
            }
            ((GralWidget)object2).setCfgElement(gralCfgElement);
        }
        return string2;
    }

    public void updatePanel(String string) {
    }

    String replaceAlias(String string) {
        int n = string.indexOf("<*");
        if (n < 0) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(string);
        do {
            int n2;
            String string2;
            String string3;
            if ((string3 = this.indexAlias.get(string2 = string.substring(n + 2, n2 = stringBuilder.indexOf(">", n + 2)))) == null) {
                string3 = "??" + string2 + "??";
            }
            stringBuilder.replace(n, n2 + 1, string3);
        } while ((n = stringBuilder.indexOf("<*", n)) >= 0);
        return stringBuilder.toString();
    }

    void stop() {
    }
}

