/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.gral.base;

import java.util.IllegalFormatException;
import java.util.Map;
import org.vishia.gral.base.GralGraphicThread;
import org.vishia.gral.base.GralKeyListener;
import org.vishia.gral.base.GralMng;
import org.vishia.gral.base.GralWidgImpl_ifc;
import org.vishia.gral.base.GralWidget;
import org.vishia.gral.ifc.GralColor;
import org.vishia.gral.ifc.GralFont;
import org.vishia.gral.ifc.GralTextFieldUser_ifc;
import org.vishia.gral.ifc.GralTextField_ifc;
import org.vishia.gral.ifc.GralWidget_ifc;
import org.vishia.util.CalculatorExpr;
import org.vishia.util.DataAccess;
import org.vishia.util.StringFunctions;

public class GralTextField
extends GralWidget
implements GralTextField_ifc {
    public static final int version = 20130313;
    protected int caretPos;
    protected String sPrompt;
    protected String sPromptStylePosition;
    private CalculatorExpr calculator;
    private String sFormat2;
    protected GralTextFieldUser_ifc user;
    protected final GralGraphicThread windowMng;
    final boolean bPassword;
    protected GralKeyListener gralKeyListener;

    public GralTextField(String string, Type ... typeArray) {
        super(string, 't');
        this.gralKeyListener = new GralKeyListener(this.itsMng){

            @Override
            public boolean specialKeysOfWidgetType(int n, GralWidget_ifc gralWidget_ifc, Object object) {
                return false;
            }
        };
        boolean bl = false;
        if (typeArray != null) {
            block4: for (int i = 0; i < typeArray.length; ++i) {
                switch (typeArray[i]) {
                    case password: {
                        bl = true;
                        continue block4;
                    }
                    case editable: {
                        this.setEditable(true);
                    }
                }
            }
        }
        this.bPassword = bl;
        this.windowMng = null;
        this.setBackColor(GralColor.getColor("wh"), 0);
        this.setTextColor(GralColor.getColor("bk"));
    }

    @Deprecated
    public GralTextField(String string, char c, GralMng gralMng) {
        super(string, c, gralMng);
        this.gralKeyListener = new /* invalid duplicate definition of identical inner class */;
        this.bPassword = false;
        this.setBackColor(GralColor.getColor("wh"), 0);
        this.setTextColor(GralColor.getColor("bk"));
        this.windowMng = gralMng.gralDevice;
    }

    public void setPrompt(String string) {
        this.sPrompt = string;
        if (this._wdgImpl != null) {
            this.dyda.setChanged(256);
            this.repaint();
        } else {
            this.sPromptStylePosition = "t";
        }
    }

    public void setPrompt(String string, String string2) {
        this.sPrompt = string;
        this.sPromptStylePosition = string2;
        if (this._wdgImpl != null) {
            throw new IllegalStateException("setPrompt(prompt, style) can only applied on creation, use setPrompt(text) to change the prompt.");
        }
    }

    public void setUser(GralTextFieldUser_ifc gralTextFieldUser_ifc) {
        this.user = gralTextFieldUser_ifc;
    }

    @Override
    public void setFormat(String string) {
        super.setFormat(string);
        this.calculator = null;
        this.sFormat2 = null;
    }

    @Override
    public void setValue(float f) {
        String string;
        String string2;
        float f2;
        if (this.calculator != null) {
            try {
                CalculatorExpr.Value value = this.calculator.calcDataAccess(null, new Object[]{Float.valueOf(f)});
                f2 = (float)value.doubleValue();
            }
            catch (Exception exception) {
                f2 = 7777778.0f;
            }
            string2 = this.sFormat2;
        } else if (this.sFormat != null) {
            if (this.sFormat.startsWith("!")) {
                int n = this.sFormat.indexOf(33, 1);
                if (n >= 0) {
                    String string3 = this.sFormat.substring(1, n);
                    this.sFormat2 = string2 = this.sFormat.substring(n + 1);
                    if (this.calculator == null) {
                        this.calculator = new CalculatorExpr();
                        String string4 = this.calculator.setExpr(string3);
                        if (string4 != null) {
                            this.calculator = null;
                        }
                    }
                    f2 = this.calculator != null ? this.calculator.calc(f) : f;
                } else {
                    string2 = this.sFormat;
                    f2 = f;
                }
            } else if (this.sFormat.startsWith("int16AngleDegree")) {
                this.calculator = new CalculatorAngle16();
                this.sFormat2 = "%3.3f";
                string2 = "%3.3f";
                f2 = this.calculator.calc(f);
            } else if (this.sFormat.startsWith("int32AngleDegree")) {
                this.calculator = new CalculatorAngle32();
                this.sFormat2 = "%3.3f";
                string2 = "%3.3f";
                f2 = this.calculator.calc(f);
            } else {
                string2 = this.sFormat;
                f2 = f;
            }
        } else {
            string2 = null;
            f2 = f;
        }
        if (string2 != null && this.sFormat.length() > 0) {
            try {
                string = String.format(string2, new Float(f2));
            }
            catch (IllegalFormatException illegalFormatException) {
                string = null;
            }
            if (string == null) {
                try {
                    string = String.format(this.sFormat, new Integer((int)f2));
                }
                catch (IllegalFormatException illegalFormatException) {
                    string = "?format";
                }
            }
        } else {
            float f3 = Math.abs(f2);
            string = f2 == 0.0f ? "0.0" : (f3 < 1.0E-7f ? (f2 < 0.0f ? "-0.0000001" : "0.0000001") : (f3 < 1.0f ? String.format("%1.7f", new Float(f2)) : (f3 < 1000.0f ? String.format("%3.4f", new Float(f2)) : (f3 < 1000000.0f ? String.format("%3.3f k", new Float(f2 / 1000.0f)) : (f3 < 1.0E9f ? String.format("%3.3f M", new Float(f2 / 1000000.0f)) : (f3 >= 1.0E9f ? String.format("%3.3g", new Float(f2)) : Float.toString(f2)))))));
        }
        this.setText(string);
    }

    public void setValue(double d) {
        String string;
        String string2;
        double d2;
        if (this.calculator != null) {
            d2 = this.calculator.calc(d);
            string2 = this.sFormat2;
        } else if (this.sFormat != null) {
            if (this.sFormat.startsWith("!")) {
                int n = this.sFormat.indexOf(33, 1);
                if (n >= 0) {
                    String string3 = this.sFormat.substring(1, n);
                    this.sFormat2 = string2 = this.sFormat.substring(n + 1);
                    if (this.calculator == null) {
                        this.calculator = new CalculatorExpr();
                        String string4 = this.calculator.setExpr(string3);
                        if (string4 != null) {
                            this.calculator = null;
                        }
                    }
                    d2 = this.calculator != null ? this.calculator.calc(d) : d;
                } else {
                    string2 = this.sFormat;
                    d2 = d;
                }
            } else {
                string2 = this.sFormat;
                d2 = d;
            }
        } else {
            string2 = null;
            d2 = d;
        }
        if (string2 != null && this.sFormat.length() > 0) {
            try {
                string = String.format(string2, new Double(d2));
            }
            catch (IllegalFormatException illegalFormatException) {
                string = null;
            }
            if (string == null) {
                try {
                    string = String.format(this.sFormat, new Integer((int)d2));
                }
                catch (IllegalFormatException illegalFormatException) {
                    string = "?format";
                }
            }
        } else {
            double d3 = Math.abs(d2);
            string = d2 == 0.0 ? "0.0" : (d3 < (double)1.0E-7f ? (d2 < 0.0 ? "-0.0000001" : "0.0000001") : (d3 < 1.0 ? String.format("%1.12f", new Double(d2)) : (d3 < 1000.0 ? String.format("%3.9f", new Double(d2)) : (d3 < 1000000.0 ? String.format("%3.8f k", new Double(d2 / 1000.0)) : (d3 < 1.0E9 ? String.format("%3.8f M", new Double(d2 / 1000000.0)) : (d3 >= 1.0E9 ? String.format("%3.8g", new Double(d2)) : Double.toString(d2)))))));
        }
        this.setText(string);
    }

    @Override
    public void setValue(Object[] objectArray) {
        if (objectArray != null && objectArray.length == 1 && objectArray[0] instanceof Double) {
            double d = (Double)objectArray[0];
            this.setValue(d);
        } else {
            this.setText("?" + objectArray);
        }
    }

    @Override
    public void setText(CharSequence charSequence) {
        this.setText(charSequence, 0);
    }

    @Override
    public void setText(CharSequence charSequence, int n) {
        this.bShouldInitialize = false;
        if (this.dyda.displayedText == null || !this.dyda.bTouchedField && !StringFunctions.equals((CharSequence)this.dyda.displayedText, (CharSequence)charSequence) || n != this.caretPos) {
            this.dyda.displayedText = charSequence.toString();
            this.caretPos = n;
            this.dyda.setChanged(1);
            this.repaint();
        }
    }

    @Override
    public String getValue() {
        return this.dyda.displayedText;
    }

    @Override
    public int getCursorPos() {
        return this.caretPos;
    }

    @Override
    public int setCursorPos(int n) {
        int n2 = this.caretPos;
        if (n != this.caretPos) {
            this.caretPos = n;
            this.dyda.setChanged(512);
            this.repaint(this.repaintDelay, this.repaintDelayMax);
        }
        return n2;
    }

    @Override
    public void setTextStyle(GralColor gralColor, GralFont gralFont) {
        this.dyda.textFont = gralFont;
        this.dyda.textColor = gralColor;
        this.dyda.setChanged(4);
        if (this._wdgImpl != null) {
            this.repaint();
        }
    }

    public final String getPromptLabelImpl() {
        return this.sPrompt;
    }

    public abstract class GraphicImplAccess
    extends GralWidget.ImplAccess
    implements GralWidgImpl_ifc {
        public static final int chgPrompt = 256;
        public static final int chgCursor = 512;

        protected GraphicImplAccess(GralWidget gralWidget, GralMng gralMng) {
            super(gralWidget, gralMng);
        }

        protected String prompt() {
            return GralTextField.this.sPrompt;
        }

        protected String promptStylePosition() {
            return GralTextField.this.sPromptStylePosition;
        }

        protected int caretPos() {
            return GralTextField.this.caretPos;
        }

        protected void caretPos(int n) {
            GralTextField.this.caretPos = n;
        }

        protected GralTextFieldUser_ifc user() {
            return GralTextField.this.user;
        }

        protected boolean isPasswordField() {
            return GralTextField.this.bPassword;
        }
    }

    private static class CalculatorAngle32
    extends CalculatorExpr {
        CalculatorAngle32() {
        }

        public float calc(float f) {
            return f * 8.381903E-8f;
        }

        public CalculatorExpr.Value calcDataAccess(Map<String, DataAccess.Variable<Object>> map, Object ... objectArray) throws Exception {
            Float f = (Float)objectArray[0];
            CalculatorExpr.Value value = new CalculatorExpr.Value(this.calc(f.floatValue()));
            return value;
        }
    }

    private static class CalculatorAngle16
    extends CalculatorExpr {
        CalculatorAngle16() {
        }

        public float calc(float f) {
            return f * 0.005493164f;
        }

        public CalculatorExpr.Value calcDataAccess(Map<String, DataAccess.Variable<Object>> map, Object ... objectArray) throws Exception {
            Float f = (Float)objectArray[0];
            CalculatorExpr.Value value = new CalculatorExpr.Value(this.calc(f.floatValue()));
            return value;
        }
    }

    public static enum Type {
        password,
        editable;

    }
}

