/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.gral.base;

import java.lang.reflect.Array;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.vishia.byteData.VariableContainer_ifc;
import org.vishia.gral.base.GralGraphicTimeOrder;
import org.vishia.gral.base.GralMenu;
import org.vishia.gral.base.GralMng;
import org.vishia.gral.base.GralWidgImpl_ifc;
import org.vishia.gral.base.GralWidget;
import org.vishia.gral.ifc.GralColor;
import org.vishia.gral.ifc.GralMngBuild_ifc;
import org.vishia.gral.ifc.GralRectangle;
import org.vishia.gral.ifc.GralTableLine_ifc;
import org.vishia.gral.ifc.GralTable_ifc;
import org.vishia.gral.ifc.GralUserAction;
import org.vishia.util.Assert;
import org.vishia.util.IterableIterator;
import org.vishia.util.KeyCode;
import org.vishia.util.MarkMask_ifc;
import org.vishia.util.Removeable;
import org.vishia.util.SelectMask;
import org.vishia.util.TreeNodeBase;
import org.vishia.util.TreeNode_ifc;

public final class GralTable<UserData>
extends GralWidget
implements GralTable_ifc<UserData> {
    protected static final int version = 538120710;
    protected int keyMarkUp = 1342832757;
    protected int keyMarkDn = 1342832740;
    protected int keyOpenChild = 655474;
    protected int keyCloseChild = 655468;
    protected String keySeparator = "/";
    GralUserAction actionOnLineSelected;
    GralUserAction actionOnRefreshChildren;
    protected int[] columnWidthsGral;
    protected boolean[] bColumnEditable;
    protected GralMenu[] menuColumns;
    GraphicImplAccess gi;
    protected int lineSelectedixCell;
    protected int colSelectedixCellC;
    protected int lineSelectedNewixCell;
    protected TableLineData[] linesForCell;
    protected TableLineData lineSelected;
    protected TableLineData lineSelectedNew;
    protected int zLine;
    protected int zColumn;
    protected int zLineVisible;
    protected int zLineVisibleMax;
    protected final StringBuilder searchChars = new StringBuilder(20);
    TreeNodeBase<TableLineData, UserData, GralTableLine_ifc<UserData>> rootLine;
    protected boolean bPrepareVisibleArea;
    protected int XXXdLineForCells;
    protected long timeLastRedraw;
    protected boolean keyDone = true;
    private int lastKey;
    private int keyRepetition;
    protected GralColor colorBackSelect;
    protected GralColor colorBackMarked;
    protected GralColor colorBackSelectMarked;
    protected GralColor colorBackSomeMarked;
    protected GralColor colorBackSelectSomeMarked;
    protected GralColor colorBackSelectNew;
    protected GralColor colorBackSelectNewMarked;
    protected GralColor colorTextSelect;
    protected GralColor colorTextMarked;
    protected GralColor colorSelectCharsBack;
    protected GralColor colorSelectChars;
    protected MarkMask_ifc actionMarkOnLine;
    protected final GralGraphicTimeOrder keyActionDone = new GralGraphicTimeOrder("GralTableKeyDone"){

        public void executeOrder() {
            GralTable.this.gi.bFocused = true;
            GralTable.this.repaintGthread();
            GralTable.this.keyDone = true;
        }
    };

    public GralTable(String string, int[] nArray) {
        super(string, 'L');
        this.columnWidthsGral = nArray;
        this.zColumn = nArray.length;
        this.bColumnEditable = new boolean[this.zColumn];
        this.rootLine = new TreeNodeBase("", null);
        this.linesForCell = (TableLineData[])Array.newInstance(TableLineData.class, 50);
        this.zLineVisibleMax = this.linesForCell.length;
        this.setColors();
    }

    public int nrofLinesVisibleMax() {
        return this.zLineVisibleMax;
    }

    public void specifyActionOnLineSelected(GralUserAction gralUserAction) {
        this.actionOnLineSelected = gralUserAction;
    }

    public void specifyActionOnLineMarked(MarkMask_ifc markMask_ifc) {
        this.actionMarkOnLine = markMask_ifc;
    }

    public void specifyActionOnRefreshChildren(GralUserAction gralUserAction) {
        this.actionOnRefreshChildren = gralUserAction;
    }

    public void specifyKeysMarkUpDn(int n, int n2) {
        this.keyMarkUp = n;
        this.keyMarkDn = n2;
    }

    public void addContextMenuEntryGthread(int n, String string, String string2, GralUserAction gralUserAction) {
        GralMenu gralMenu = this.getContextMenuColumn(n);
        GralWidget gralWidget = null;
        gralMenu.addMenuItemGthread(gralWidget, string, string2, gralUserAction);
    }

    public GralMenu getContextMenuColumn(int n) {
        if (this.menuColumns == null) {
            this.menuColumns = new GralMenu[this.zColumn];
        }
        if (this.menuColumns[n] == null) {
            this.menuColumns[n] = this.gi.createColumnMenu(n);
        }
        return this.menuColumns[n];
    }

    public GralMenu getContextMenuColumnCells(int n, String string, String string2, GralUserAction gralUserAction) {
        return null;
    }

    public void setColumnWidth(int n, int[] nArray) {
        this.columnWidthsGral = nArray;
    }

    public void setColumnEditable(int n, boolean bl) {
        this.bColumnEditable[n] = bl;
        if (this._wdgImpl != null) {
            this.dyda.setChanged(0x100000);
            this.repaint(this.repaintDelay, this.repaintDelayMax);
        }
    }

    @Override
    public boolean setCurrentLine(String string) {
        GralTableLine_ifc gralTableLine_ifc = (GralTableLine_ifc)this.rootLine.getNode(string, this.keySeparator);
        if (gralTableLine_ifc == null) {
            return false;
        }
        this.setCurrentLine(gralTableLine_ifc, this.lineSelectedixCell, -1);
        return true;
    }

    void setColors() {
        this.colorBackSelect = GralColor.getColor("lam");
        this.colorBackSelectNew = GralColor.getColor("lbl");
        this.colorBackMarked = GralColor.getColor("prd");
        this.colorBackSelectMarked = GralColor.getColor("lrd");
        this.colorBackSomeMarked = GralColor.getColor("pma");
        this.colorBackSelectSomeMarked = GralColor.getColor("lor");
        this.colorBackSelectNewMarked = GralColor.getColor("lpu");
        this.dyda.backColor = GralColor.getColor("wh");
        this.dyda.backColorNoFocus = GralColor.getColor("pgr");
        this.dyda.textColor = GralColor.getColor("bk");
        this.colorSelectCharsBack = GralColor.getColor("lgr");
        this.colorSelectChars = GralColor.getColor("wh");
    }

    @Override
    public void setFocus(int n, int n2) {
        if (this.gi != null) {
            this.gi.cells[this.lineSelectedixCell][this.colSelectedixCellC].bSetFocus = true;
            super.setFocus(n, n2);
        }
    }

    @Override
    public void setCurrentLine(GralTableLine_ifc<UserData> gralTableLine_ifc, int n, int n2) {
        assert (n > -this.zLineVisible && n < this.zLineVisible);
        assert (n2 < this.gi.cells[0].length);
        this.lineSelected = (TableLineData)gralTableLine_ifc;
        this.actionOnLineSelected(720979, this.lineSelected);
        if (n < 0) {
            this.lineSelectedixCell = this.zLineVisible + n;
            if (this.lineSelectedixCell < 0) {
                this.lineSelectedixCell = 0;
            }
        } else {
            this.lineSelectedixCell = n;
            if (this.lineSelectedixCell >= this.zLineVisible) {
                this.lineSelectedixCell = this.zLineVisible - 1;
            }
        }
        if (n2 >= 0) {
            this.colSelectedixCellC = n2;
        }
        this.bPrepareVisibleArea = true;
        this.repaint(50, 200);
    }

    public void setColorBackSelectedLine(GralColor gralColor) {
        this.colorBackSelect = gralColor;
        this.repaint(100, 0);
    }

    public TableLineData getCurrentLine() {
        return this.lineSelected;
    }

    public TableLineData getLineMousePressed() {
        return this.lineSelectedNew;
    }

    @Override
    public GralTableLine_ifc<UserData> getLine(String string) {
        return (GralTableLine_ifc)this.rootLine.getNode(string, this.keySeparator);
    }

    public TableLineData insertLine(String string, int n, String[] stringArray, UserData UserData) {
        TableLineData tableLineData = new TableLineData(string, UserData);
        if (n > this.zLine || n < 0) {
            n = this.zLine;
        }
        if (n == 0) {
            this.rootLine.addNodeFirst((TreeNodeBase)tableLineData);
        }
        if (this.lineSelected == null) {
            this.lineSelected = tableLineData;
            this.actionOnLineSelected(721011, this.lineSelected);
        }
        ++this.zLine;
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length && i < tableLineData.cellTexts.length; ++i) {
                tableLineData.cellTexts[i] = stringArray[i];
            }
        }
        this.bPrepareVisibleArea = true;
        this.repaint(100, 0);
        return tableLineData;
    }

    public TableLineData addLine(String string, String[] stringArray, UserData UserData) {
        TableLineData tableLineData = new TableLineData(string, UserData);
        if (this.lineSelected == null) {
            this.lineSelected = tableLineData;
            this.actionOnLineSelected(721011, this.lineSelected);
        }
        ++this.zLine;
        this.rootLine.addNode((TreeNodeBase)tableLineData);
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length && i < tableLineData.cellTexts.length; ++i) {
                tableLineData.cellTexts[i] = stringArray[i];
            }
        }
        this.bPrepareVisibleArea = true;
        this.repaint(100, 0);
        return tableLineData;
    }

    @Override
    public void deleteLine(GralTableLine_ifc<UserData> gralTableLine_ifc) {
        --this.zLine;
        TableLineData tableLineData = (TableLineData)gralTableLine_ifc;
        this.bPrepareVisibleArea = true;
        if (this.lineSelected == gralTableLine_ifc) {
            TableLineData tableLineData2 = this.prevLine(tableLineData);
            this.lineSelected = tableLineData2 == null ? this.nextLine(tableLineData) : tableLineData2;
        }
        gralTableLine_ifc.detach();
        this.repaint(200, 200);
    }

    public IterableIterator<TableLineData> iterLines() {
        return this.rootLine.iterator();
    }

    @Override
    public int size() {
        return this.zLine;
    }

    @Override
    public void clearTable() {
        this.colSelectedixCellC = 0;
        this.zLine = 0;
        this.lineSelected = null;
        this.actionOnLineSelected(721016, this.lineSelected);
        this.searchChars.setLength(0);
        for (int i = 0; i < this.linesForCell.length; ++i) {
            this.linesForCell[i] = null;
        }
        this.rootLine.removeChildren();
        this.bPrepareVisibleArea = true;
        this.bPrepareVisibleArea = true;
        this.repaint(200, 200);
    }

    @Override
    public List<GralTableLine_ifc<UserData>> getMarkedLines(int n) {
        LinkedList<GralTableLine_ifc<UserData>> linkedList = new LinkedList<GralTableLine_ifc<UserData>>();
        for (TableLineData tableLineData : this.rootLine.iterator()) {
            if (tableLineData.data instanceof MarkMask_ifc) {
                if ((((MarkMask_ifc)tableLineData.data).getMark() & n) == 0) continue;
                linkedList.add(tableLineData);
                continue;
            }
            if ((tableLineData.getMark() & n) == 0) continue;
            linkedList.add(tableLineData);
        }
        return linkedList;
    }

    @Override
    public TreeNode_ifc<?, UserData> getAllLines() {
        return this.rootLine;
    }

    @Override
    public List<UserData> getListContent() {
        LinkedList linkedList = new LinkedList();
        for (TableLineData tableLineData : this.rootLine.iterator()) {
            linkedList.add(tableLineData.getUserData());
        }
        return linkedList;
    }

    @Override
    public GralTableLine_ifc<UserData> getFirstMarkedLine(int n) {
        for (TableLineData tableLineData : this.rootLine.iterator()) {
            if ((tableLineData.getMark() & n) == 0) continue;
            return tableLineData;
        }
        return null;
    }

    protected void fillVisibleArea() {
        TableLineData tableLineData = this.lineSelected;
        int n = this.lineSelectedixCell;
        while (n > 0 && tableLineData != null) {
            if ((tableLineData = this.prevLine(tableLineData)) == null) continue;
            this.linesForCell[--n] = tableLineData;
        }
        int n2 = this.lineSelectedixCell - n;
        if (n > 0) {
            System.arraycopy(this.linesForCell, n, this.linesForCell, 0, n2);
            this.lineSelectedixCell = n2;
        }
        this.fillVisibleAreaBehind(this.lineSelected, n2);
    }

    protected void fillVisibleAreaBehind(TableLineData tableLineData, int n) {
        int n2;
        TableLineData tableLineData2 = tableLineData;
        for (n2 = n; tableLineData2 != null && n2 < this.zLineVisible; ++n2) {
            this.linesForCell[n2] = tableLineData2;
            tableLineData2 = this.nextLine(tableLineData2);
        }
        while (n2 < this.zLineVisible) {
            this.linesForCell[n2++] = null;
        }
    }

    protected int shiftVisibleArea(int n) {
        int n2;
        block4: {
            block3: {
                n2 = n;
                if (n <= 0) break block3;
                TableLineData tableLineData = this.linesForCell[this.zLineVisible - 1];
                while (tableLineData != null && n2 > 0) {
                    if ((tableLineData = this.nextLine(tableLineData)) == null) continue;
                    System.arraycopy(this.linesForCell, 1, this.linesForCell, 0, this.zLineVisible - 1);
                    this.linesForCell[this.zLineVisible - 1] = tableLineData;
                    --n2;
                }
                break block4;
            }
            if (n >= 0) break block4;
            TableLineData tableLineData = this.linesForCell[0];
            if (tableLineData == null) {
                tableLineData = (TableLineData)this.rootLine.firstChild();
            }
            while (tableLineData != null && n2 < 0) {
                if ((tableLineData = this.prevLine(tableLineData)) == null) continue;
                System.arraycopy(this.linesForCell, 0, this.linesForCell, 1, this.zLineVisible - 1);
                this.linesForCell[0] = tableLineData;
                ++n2;
            }
        }
        return n - n2;
    }

    TableLineData nextLine(TableLineData tableLineData) {
        TableLineData tableLineData2 = tableLineData;
        TableLineData tableLineData3 = null;
        if (tableLineData2.showChildren) {
            tableLineData3 = (TableLineData)tableLineData2.firstChild();
        }
        if (tableLineData3 == null) {
            tableLineData3 = (TableLineData)tableLineData2.nextSibling();
        }
        while (tableLineData3 == null && tableLineData2.parent() != null && !tableLineData2.parentEquals((TreeNode_ifc)this.rootLine)) {
            tableLineData3 = (TableLineData)tableLineData2.parent();
            if (tableLineData3 == null) continue;
            tableLineData3 = (TableLineData)tableLineData3.nextSibling();
        }
        return tableLineData3;
    }

    TableLineData prevLine(TableLineData tableLineData) {
        TableLineData tableLineData2 = tableLineData;
        TableLineData tableLineData3 = tableLineData;
        tableLineData2 = (TableLineData)tableLineData3.prevSibling();
        if (tableLineData2 == null) {
            tableLineData3 = !tableLineData3.parentEquals((TreeNode_ifc)this.rootLine) ? (TableLineData)tableLineData3.parent() : null;
        } else {
            while (tableLineData2 != null && tableLineData2.showChildren) {
                tableLineData2 = (TableLineData)tableLineData2.lastChild();
            }
            tableLineData3 = tableLineData2;
        }
        return tableLineData3;
    }

    protected void mouseDown(int n, CellData cellData) {
        this.lineSelectedNew = this.linesForCell[cellData.ixCellLine];
        this.repaint(0, 0);
    }

    protected void mouseUp(int n, CellData cellData) {
        if (n == 720981) {
            this.lineSelected = this.lineSelectedNew;
            this.lineSelectedNew = null;
            this.lineSelectedixCell = cellData.ixCellLine;
            this.colSelectedixCellC = cellData.ixCellColumn;
            this.actionOnLineSelected(720979, this.lineSelected);
            this.repaint();
        }
    }

    protected void mouseDouble(int n, CellData cellData) {
        this.processKeys(720963);
    }

    protected boolean searchContent(boolean bl) {
        String string = this.searchChars.toString();
        boolean bl2 = true;
        boolean bl3 = false;
        TableLineData tableLineData = this.lineSelected;
        do {
            TableLineData tableLineData2;
            if ((tableLineData2 = bl && tableLineData != null ? this.prevLine(tableLineData) : (!bl && tableLineData != null ? this.nextLine(tableLineData) : null)) == null) {
                bl2 = false;
                this.lineSelected = tableLineData;
                bl3 = string.length() > 0;
                continue;
            }
            tableLineData = tableLineData2;
            String string2 = tableLineData.getCellText(this.colSelectedixCellC).toLowerCase();
            if (string.length() > 0 && this.searchChars.charAt(0) == '*') {
                bl2 = false;
                continue;
            }
            if (string.length() == 0) {
                bl3 = false;
                bl2 = false;
                continue;
            }
            if (!string2.startsWith(string)) {
                bl3 = false;
                continue;
            }
            bl3 = true;
            this.lineSelected = tableLineData;
            this.bPrepareVisibleArea = true;
            bl2 = false;
        } while (bl2);
        return bl3;
    }

    protected void checkAndUpdateText(String string, CellData cellData) {
        TableLineData tableLineData = this.linesForCell[cellData.ixCellLine];
        if (tableLineData != null && !string.equals(tableLineData.cellTexts[cellData.ixCellColumn])) {
            tableLineData.cellTexts[cellData.ixCellColumn] = string;
            tableLineData.bChanged = true;
        }
    }

    protected boolean processKeys(int n) {
        boolean bl = true;
        long l = System.currentTimeMillis();
        this.lineSelectedNew = null;
        this.keyRepetition = this.lastKey == n ? ++this.keyRepetition : 1;
        long l2 = l - this.timeLastRedraw;
        if (this.keyDone || n == 720963 || l2 > -11110L) {
            GralUserAction gralUserAction;
            this.keyDone = false;
            switch (n) {
                case 655445: {
                    if (this.lineSelectedixCell > 2) {
                        this.lineSelectedixCell = 2;
                    } else {
                        int n2 = this.shiftVisibleArea(-this.zLineVisible);
                        this.lineSelectedixCell -= this.zLineVisible + n2;
                        if (this.lineSelectedixCell < 0) {
                            this.lineSelectedixCell = 0;
                        }
                    }
                    this.lineSelected = this.linesForCell[this.lineSelectedixCell];
                    this.gi.cells[this.lineSelectedixCell][this.colSelectedixCellC].bSetFocus = true;
                    this.actionOnLineSelected(720979, this.lineSelected);
                    this.keyActionDone.activate();
                    break;
                }
                case 655477: 
                case 721012: {
                    if (!this.searchContent(true)) {
                        if (this.lineSelectedixCell > 2) {
                            --this.lineSelectedixCell;
                        } else {
                            int n3 = this.shiftVisibleArea(-1);
                            this.lineSelectedixCell -= 1 + n3;
                            if (this.lineSelectedixCell < 0) {
                                this.lineSelectedixCell = 0;
                            }
                        }
                        this.lineSelected = this.linesForCell[this.lineSelectedixCell];
                    }
                    this.gi.cells[this.lineSelectedixCell][this.colSelectedixCellC].bSetFocus = true;
                    this.actionOnLineSelected(720979, this.lineSelected);
                    this.keyActionDone.activate();
                    break;
                }
                case 655428: {
                    if (this.lineSelectedixCell < this.zLineVisible - 3) {
                        this.lineSelectedixCell = this.zLineVisible - 3;
                    } else {
                        int n4 = this.shiftVisibleArea(this.zLineVisible);
                        this.lineSelectedixCell += this.zLineVisible - n4;
                        if (this.lineSelectedixCell >= this.zLineVisible) {
                            this.lineSelectedixCell = this.zLineVisible - 1;
                        }
                    }
                    while ((this.lineSelected = this.linesForCell[this.lineSelectedixCell]) == null && this.lineSelectedixCell > 0) {
                        --this.lineSelectedixCell;
                    }
                    this.gi.cells[this.lineSelectedixCell][this.colSelectedixCellC].bSetFocus = true;
                    this.actionOnLineSelected(720979, this.lineSelected);
                    this.keyActionDone.activate();
                    break;
                }
                default: {
                    if (n == 655460 || n == this.keyMarkDn || n == 720997) {
                        if (n == this.keyMarkDn && this.lineSelected != null) {
                            TableLineData tableLineData = this.lineSelected;
                            if ((tableLineData.getMark() & 1) != 0) {
                                tableLineData.setNonMarked(1, tableLineData.getUserData());
                            } else {
                                tableLineData.setMarked(1, tableLineData.getUserData());
                            }
                        }
                        if (!this.searchContent(false)) {
                            if (this.lineSelectedixCell < this.zLineVisible - 3) {
                                ++this.lineSelectedixCell;
                            } else {
                                int n5 = this.shiftVisibleArea(1);
                                this.lineSelectedixCell += 1 - n5;
                                if (this.lineSelectedixCell >= this.zLineVisible) {
                                    this.lineSelectedixCell = this.zLineVisible - 1;
                                }
                            }
                            while ((this.lineSelected = this.linesForCell[this.lineSelectedixCell]) == null && this.lineSelectedixCell > 0) {
                                --this.lineSelectedixCell;
                            }
                        }
                        this.gi.cells[this.lineSelectedixCell][this.colSelectedixCellC].bSetFocus = true;
                        this.actionOnLineSelected(720979, this.lineSelected);
                        this.keyActionDone.activate();
                        break;
                    }
                    if (KeyCode.isTextKey((int)n) && !this.bColumnEditable[this.colSelectedixCellC]) {
                        this.searchChars.appendCodePoint(n);
                        this.searchContent(false);
                        this.repaint();
                        break;
                    }
                    if (n == 917531) {
                        this.searchChars.setLength(0);
                        this.repaint();
                        break;
                    }
                    if (n == 917512 && this.searchChars.length() > 0) {
                        this.searchChars.setLength(this.searchChars.length() - 1);
                        this.repaint();
                        break;
                    }
                    if (n == this.keyOpenChild) {
                        if (this.lineSelected.lineCanHaveChildren) {
                            this.actionOnRefreshChildren(this.lineSelected);
                        }
                        if (!this.lineSelected.hasChildren()) break;
                        this.lineSelected.showChildren = true;
                        this.fillVisibleAreaBehind(this.lineSelected, this.lineSelectedixCell);
                        this.repaint();
                        break;
                    }
                    if (n == this.keyCloseChild) {
                        if (!this.lineSelected.showChildren) break;
                        this.lineSelected.showChildren = false;
                        this.fillVisibleAreaBehind(this.lineSelected, this.lineSelectedixCell);
                        this.repaint();
                        break;
                    }
                    bl = false;
                }
            }
            if (!bl && n == this.keyMarkDn && this.lineSelected != null) {
                TableLineData tableLineData = this.lineSelected;
                if ((tableLineData.getMark() & 1) != 0) {
                    tableLineData.setNonMarked(1, tableLineData.getUserData());
                } else {
                    tableLineData.setMarked(1, tableLineData.getUserData());
                }
                this.keyActionDone.activate();
                bl = true;
            }
            if (!bl && this.lineSelected != null && this.actionChanging != null) {
                bl = this.actionChanging.exec(n, this, this.lineSelected);
            }
            if (!bl && this.itsMng.userMainKeyAction() != null) {
                bl = this.itsMng.userMainKeyAction().exec(n, this.getCurrentLine(), new Object[0]);
            }
            if (!bl && (gralUserAction = this.itsMng.getRegisteredUserAction("KeyAction")) != null && !gralUserAction.exec(n, this, new Object[0])) {
                bl = gralUserAction.exec(n, this, new Integer(n));
            }
            this.keyRepetition = 0;
        }
        this.lastKey = n;
        return bl;
    }

    private void actionOnLineSelected(int n, GralTableLine_ifc<?> gralTableLine_ifc) {
        this.itsMng.setLastClickedWidget(this.lineSelected);
        if (this.actionOnLineSelected != null) {
            this.actionOnLineSelected.exec(n, this, gralTableLine_ifc);
        }
    }

    protected void actionOnRefreshChildren(GralTableLine_ifc<?> gralTableLine_ifc) {
        if (this.actionOnRefreshChildren != null) {
            this.actionOnRefreshChildren.exec(720979, this, gralTableLine_ifc);
        }
    }

    public static class CellData {
        public final int ixCellLine;
        public final int ixCellColumn;
        public GralColor colorBack;
        public GralColor colorText;
        public boolean bSetFocus;
        public int treeDepth;

        public CellData(int n, int n2) {
            this.ixCellLine = n;
            this.ixCellColumn = n2;
        }
    }

    public final class TableLineData
    extends TreeNodeBase<TableLineData, UserData, GralTableLine_ifc<UserData>>
    implements MarkMask_ifc,
    GralTableLine_ifc<UserData> {
        SelectMask markMask;
        boolean lineCanHaveChildren;
        boolean showChildren;
        public AtomicInteger ctRepaintLine;
        private int treeDepth;
        public String[] cellTexts;
        private String sDataPath;
        protected boolean bChanged;
        public GralColor colorForground;
        public GralColor colorBackground;

        TableLineData(String string, UserData UserData) {
            super(string, UserData);
            this.ctRepaintLine = new AtomicInteger();
            this.cellTexts = new String[GralTable.this.zColumn];
        }

        @Override
        public GralTableLine_ifc<UserData> addNextLine(String string, String[] stringArray, UserData UserData) {
            GralTable gralTable = GralTable.this;
            gralTable.getClass();
            TableLineData tableLineData = gralTable.new TableLineData(string, UserData);
            super.addSiblingNext((TreeNodeBase)tableLineData);
            tableLineData.treeDepth = this.treeDepth;
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length && i < tableLineData.cellTexts.length; ++i) {
                    tableLineData.cellTexts[i] = stringArray[i];
                }
            }
            GralTable.this.bPrepareVisibleArea = true;
            return tableLineData;
        }

        public GralTableLine_ifc<UserData> addPrevLine(String string, String[] stringArray, UserData UserData) {
            GralTable gralTable = GralTable.this;
            gralTable.getClass();
            TableLineData tableLineData = gralTable.new TableLineData(string, UserData);
            super.addSiblingPrev((TreeNodeBase)tableLineData);
            tableLineData.treeDepth = this.treeDepth;
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length && i < tableLineData.cellTexts.length; ++i) {
                    tableLineData.cellTexts[i] = stringArray[i];
                }
            }
            GralTable.this.bPrepareVisibleArea = true;
            return tableLineData;
        }

        @Override
        public GralTableLine_ifc<UserData> addChildLine(String string, String[] stringArray, UserData UserData) {
            this.lineCanHaveChildren = true;
            GralTable gralTable = GralTable.this;
            gralTable.getClass();
            TableLineData tableLineData = gralTable.new TableLineData(string, UserData);
            super.addNode((TreeNodeBase)tableLineData);
            tableLineData.treeDepth = this.treeDepth + 1;
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length && i < tableLineData.cellTexts.length; ++i) {
                    tableLineData.cellTexts[i] = stringArray[i];
                }
            }
            GralTable.this.bPrepareVisibleArea = true;
            if (this.key != null) {
                // empty if block
            }
            if (this.showChildren) {
                this.repaint(100, 0);
            }
            return tableLineData;
        }

        @Override
        public void setEditable(boolean bl) {
            throw new IllegalArgumentException("a table line can't be set edit able");
        }

        @Override
        public boolean isEditable() {
            return GralTable.this.bEditable;
        }

        @Override
        public boolean isNotEditableOrShouldInitialize() {
            return GralTable.this.isNotEditableOrShouldInitialize();
        }

        @Override
        public boolean isChanged(boolean bl) {
            boolean bl2 = this.bChanged;
            if (bl) {
                this.bChanged = false;
            }
            return bl2;
        }

        public TableLineData parentNode() {
            return (TableLineData)super.getParent();
        }

        @Override
        public String getName() {
            return GralTable.this.name;
        }

        @Override
        public String getCellText(int n) {
            String string = this.cellTexts[n];
            return string == null ? "" : string;
        }

        @Override
        public String[] getCellTexts() {
            return this.cellTexts;
        }

        public int treeDepth() {
            return this.treeDepth;
        }

        @Override
        public String setCellText(String string, int n) {
            String string2 = this.cellTexts[n];
            this.cellTexts[n] = string;
            GralTable.this.repaint();
            return string2;
        }

        @Override
        public UserData getUserData() {
            return this.data;
        }

        @Override
        public long setContentIdent(long l) {
            long l2 = GralTable.this.dateUser;
            GralTable.this.dateUser = l;
            return l2;
        }

        @Override
        public long getContentIdent() {
            return GralTable.this.dateUser;
        }

        @Override
        public int getSelectedColumn() {
            return GralTable.this.colSelectedixCellC;
        }

        @Override
        public boolean setVisible(boolean bl) {
            return false;
        }

        @Override
        public void setFocus() {
            GralTable.this.setFocus();
        }

        @Override
        public void setFocus(int n, int n2) {
            GralTable.this.setFocus(n, n2);
        }

        @Override
        public boolean isInFocus() {
            return GralTable.this.isInFocus();
        }

        @Override
        public boolean isVisible() {
            return GralTable.this.isVisible();
        }

        @Override
        public GralColor setBackgroundColor(GralColor gralColor) {
            GralColor gralColor2 = this.colorBackground;
            this.colorBackground = gralColor;
            this.repaint(50, 50);
            return gralColor2;
        }

        @Override
        public GralColor setForegroundColor(GralColor gralColor) {
            GralColor gralColor2 = this.colorForground;
            this.colorForground = gralColor;
            this.repaint(50, 50);
            return gralColor2;
        }

        @Override
        public void setBackColor(GralColor gralColor, int n) {
            if (gralColor.getColorName().equals("pma")) {
                Assert.stop();
            }
            this.colorBackground = gralColor;
            this.repaint(50, 50);
        }

        @Override
        public GralColor getBackColor(int n) {
            return this.colorBackground;
        }

        @Override
        public void setLineColor(GralColor gralColor, int n) {
            this.colorForground = gralColor;
            this.repaint(50, 50);
        }

        @Override
        public void setTextColor(GralColor gralColor) {
            this.colorForground = gralColor;
            this.repaint(50, 50);
        }

        @Override
        public void setText(CharSequence charSequence) {
            throw new IllegalArgumentException("GralTable-TableLineData - setText is not implemented;");
        }

        @Override
        public void repaint() {
            this.ctRepaintLine.addAndGet(1);
            GralTable.this.repaint();
        }

        @Override
        public void repaint(int n, int n2) {
            this.ctRepaintLine.addAndGet(1);
            GralTable.this.repaint(n, n2);
        }

        @Override
        public void setBoundsPixel(int n, int n2, int n3, int n4) {
        }

        @Override
        public void refreshFromVariable(VariableContainer_ifc variableContainer_ifc) {
            GralTable.this.refreshFromVariable(variableContainer_ifc);
        }

        @Override
        public void refreshFromVariable(VariableContainer_ifc variableContainer_ifc, long l, GralColor gralColor, GralColor gralColor2) {
            GralTable.this.refreshFromVariable(variableContainer_ifc, l, gralColor, gralColor2);
        }

        @Override
        public void setDataPath(String string) {
            this.sDataPath = string;
        }

        @Override
        public String getDataPath() {
            return this.sDataPath;
        }

        @Override
        public GralUserAction getActionChange() {
            return GralTable.this.getActionChange();
        }

        public boolean remove() {
            return GralTable.this.gi.remove();
        }

        @Override
        public void setHtmlHelp(String string) {
            GralTable.this.setHtmlHelp(string);
        }

        @Override
        public Object getContentInfo() {
            return this.data;
        }

        public int getMark() {
            if (this.data instanceof MarkMask_ifc) {
                return ((MarkMask_ifc)this.data).getMark();
            }
            if (this.markMask == null) {
                return 0;
            }
            return this.markMask.getMark();
        }

        public int setNonMarked(int n, Object object) {
            if (GralTable.this.actionMarkOnLine != null && object != null) {
                GralTable.this.actionMarkOnLine.setNonMarked(n, object);
            }
            if (object instanceof MarkMask_ifc) {
                ((MarkMask_ifc)object).setNonMarked(n, object);
            }
            if (this.markMask == null) {
                return 0;
            }
            return this.markMask.setNonMarked(n, object);
        }

        public int setMarked(int n, Object object) {
            if (GralTable.this.actionMarkOnLine != null && object != null) {
                GralTable.this.actionMarkOnLine.setMarked(n, object);
            }
            if (object instanceof MarkMask_ifc) {
                ((MarkMask_ifc)object).setMarked(n, object);
            }
            if (this.markMask == null) {
                this.markMask = new SelectMask();
            }
            return this.markMask.setMarked(n, object);
        }

        @Override
        public GralMng gralMng() {
            return GralTable.this.gralMng();
        }

        @Override
        public void setToPanel(GralMngBuild_ifc gralMngBuild_ifc) {
            throw new IllegalArgumentException("GralTableLine.setToPanel - is illegal; Use GralTable.setToPanel(...)");
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < this.cellTexts.length; ++i) {
                stringBuilder.append(this.cellTexts[i]).append('|');
            }
            return stringBuilder.toString();
        }
    }

    public abstract class GraphicImplAccess
    extends GralWidget.ImplAccess
    implements GralWidgImpl_ifc,
    Removeable {
        public static final int chgEditableColumn = 0x100000;
        private final LinePresentation linePresentation;
        protected final GralTable<UserData> outer;
        protected CellData[][] cells;
        protected boolean bRedrawPending;
        protected int linePixel;
        protected final int[] xpixelCell;
        protected int[] columnPixel;
        protected final int xPixelUnit;
        protected int nrofColumnTreeShift;
        protected boolean bFocused;
        protected boolean bFocusLost;
        protected boolean XXXhasFocus;
        protected long mousetime;
        protected long redrawtime;
        protected long mousect;
        protected long redrawct;
        private boolean mouseDoubleClick;

        protected GraphicImplAccess(GralTable<UserData> gralTable2, GralMng gralMng) {
            int n;
            int n2;
            super(gralTable2, gralMng);
            this.linePresentation = new LinePresentation();
            this.xPixelUnit = gralMng.propertiesGui.xPixelUnit();
            this.outer = gralTable2;
            gralTable2.gi = this;
            int n3 = gralTable2.itsMng.propertiesGui().xPixelUnit();
            this.columnPixel = new int[gralTable2.columnWidthsGral.length + 1];
            this.columnPixel[0] = n2 = 0;
            for (n = 0; n < gralTable2.columnWidthsGral.length; ++n) {
                this.columnPixel[n + 1] = n2 += gralTable2.columnWidthsGral[n] * n3;
            }
            this.xpixelCell = new int[gralTable2.columnWidthsGral.length + 1];
            n = gralTable2.itsMng.propertiesGui().yPixelUnit();
            this.linePixel = 2 * n;
        }

        protected GralMng itsMng() {
            return this.outer.itsMng;
        }

        protected boolean bColumnEditable(int n) {
            return GralTable.this.bColumnEditable[n];
        }

        protected void checkAndUpdateText(String string, CellData cellData) {
            GralTable.this.checkAndUpdateText(string, cellData);
        }

        protected int ixColumn() {
            return this.outer.colSelectedixCellC;
        }

        protected int[] columnWidthsGral() {
            return this.outer.columnWidthsGral;
        }

        protected int zColumn() {
            return this.outer.zColumn;
        }

        protected GralColor colorSelectCharsBack() {
            return this.outer.colorSelectCharsBack;
        }

        protected GralColor colorSelectChars() {
            return this.outer.colorSelectChars;
        }

        protected GralColor colorBackTable() {
            return this.outer.dyda.backColor;
        }

        protected StringBuilder searchChars() {
            return this.outer.searchChars;
        }

        protected boolean processKeys(int n) {
            return this.outer.processKeys(n);
        }

        protected void setFocusCellMousePressed() {
        }

        protected void setCellText(CellData cellData, String string) {
            TableLineData tableLineData = GralTable.this.linesForCell[cellData.ixCellLine];
            if (tableLineData != null) {
                tableLineData.setCellText(string, cellData.ixCellColumn);
            }
        }

        protected void updateGraphicCellContent() {
            long l = System.currentTimeMillis();
            this.bRedrawPending = true;
            Assert.check((boolean)this.outer.itsMng.currThreadIsGraphic());
            if (this.outer.bPrepareVisibleArea) {
                this.outer.fillVisibleArea();
                this.outer.bPrepareVisibleArea = false;
            }
            int n = -1;
            while (++n < this.outer.zLineVisible) {
                TableLineData tableLineData = this.outer.linesForCell[n];
                this.setLinePresentation(tableLineData);
                this.drawCellContent(n, this.cells[n], tableLineData, this.linePresentation);
            }
            if (++n < this.outer.zLineVisibleMax) {
                this.drawCellContent(n, this.cells[n], null, this.linePresentation);
            }
            this.outer.timeLastRedraw = System.currentTimeMillis();
        }

        private void setLinePresentation(TableLineData tableLineData) {
            boolean bl;
            boolean bl2 = tableLineData != null && (tableLineData.getMark() & 1) != 0;
            boolean bl3 = bl = tableLineData != null && (tableLineData.getMark() & 2) != 0;
            this.linePresentation.colorBack = tableLineData == this.outer.lineSelected ? (bl2 ? this.outer.colorBackSelectMarked : (bl ? this.outer.colorBackSelectSomeMarked : this.outer.colorBackSelect)) : (tableLineData == this.outer.lineSelectedNew ? (bl2 ? this.outer.colorBackSelectNewMarked : this.outer.colorBackSelectNew) : (bl2 ? this.outer.colorBackMarked : (bl ? this.outer.colorBackSomeMarked : (!this.bFocused ? GralTable.this.dyda.backColorNoFocus : (tableLineData != null && tableLineData.colorBackground != null ? tableLineData.colorBackground : this.outer.dyda.backColor)))));
            this.linePresentation.colorText = tableLineData != null && tableLineData.colorForground != null ? tableLineData.colorForground : this.outer.dyda.textColor;
        }

        protected void resizeTable(GralRectangle gralRectangle) {
            int n;
            int n2;
            int n3;
            int n4 = this.itsMng().propertiesGui().xPixelUnit();
            int n5 = this.itsMng().propertiesGui().yPixelUnit();
            this.outer.zLineVisible = gralRectangle.dy / n5 / 2;
            if (this.outer.zLineVisible > this.outer.zLineVisibleMax) {
                this.outer.zLineVisible = this.outer.zLineVisibleMax;
            }
            this.xpixelCell[0] = n3 = 0;
            for (n2 = 0; n2 < this.columnWidthsGral().length && (n = this.columnWidthsGral()[n2]) > 0; ++n2) {
                this.xpixelCell[n2 + 1] = n3 += n * n4;
            }
            this.nrofColumnTreeShift = n2 + 1;
            System.out.println("GralTable - resizeTable; nrofColumnTreeShift =" + this.nrofColumnTreeShift);
            this.xpixelCell[this.columnWidthsGral().length] = n3 = gralRectangle.dx;
            for (n2 = this.columnWidthsGral().length - 1; n2 >= 0 && (n = this.columnWidthsGral()[n2]) < 0; --n2) {
                this.xpixelCell[n2] = n3 += n * n4;
            }
            this.setBoundsCells(0);
        }

        protected abstract void setBoundsCells(int var1);

        public boolean remove() {
            this.outer.rootLine.removeChildren();
            return true;
        }

        protected boolean redrawTableWithFocusedCell(CellData cellData) {
            TableLineData tableLineData;
            if (GralTable.this.bPrepareVisibleArea) {
                GralTable.this.fillVisibleArea();
                GralTable.this.bPrepareVisibleArea = false;
            }
            if ((tableLineData = this.outer.linesForCell[cellData.ixCellLine]) != null) {
                this.outer.lineSelectedNewixCell = cellData.ixCellLine;
                GralTable.this.lineSelectedNew = tableLineData;
                this.outer.colSelectedixCellC = cellData.ixCellColumn;
                this.bFocused = true;
                return true;
            }
            return false;
        }

        public void focusGainedTable() {
            if (this.bFocusLost) {
                this.bFocusLost = false;
            } else {
                this.bFocused = true;
                if (!this.bRedrawPending) {
                    GralTable.this.itsMng.gralFocusListener.focusGainedGral(GralTable.this);
                    System.out.println("GralTable - debugInfo; focusGained " + GralTable.this.toString());
                    GralTable.this.repaint(50, 100);
                }
            }
        }

        protected void focusLostTable() {
            this.bFocusLost = true;
            GralTable.this.repaint(50, 100);
        }

        protected void mouseDownGral(int n, CellData cellData) {
            this.mousetime = System.currentTimeMillis();
            this.outer.mouseDown(n, cellData);
        }

        protected void mouseUpGral(int n, CellData cellData) {
            if (this.mouseDoubleClick) {
                this.mouseDoubleClick = false;
            } else {
                this.outer.mouseUp(n, cellData);
            }
        }

        protected void mouseDoubleGral(int n, CellData cellData) {
            this.mousetime = System.currentTimeMillis();
            this.mouseDoubleClick = true;
            this.outer.mouseDouble(n, cellData);
        }

        protected abstract void drawCellContent(int var1, CellData[] var2, TableLineData var3, LinePresentation var4);

        protected abstract CellData drawCellInvisible(int var1, int var2);

        protected abstract int getVisibleLinesTableImpl();

        protected abstract GralMenu createColumnMenu(int var1);
    }

    public static final class LinePresentation {
        public GralColor colorBack;
        public GralColor colorText;
    }
}

