/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.gral.base;

import org.vishia.bridgeC.IllegalArgumentExceptionJc;
import org.vishia.gral.ifc.GralColor;
import org.vishia.gral.ifc.GralFont;

public class GralGridProperties {
    public static final int version = 538051331;
    protected static final int[] smallPromptFontSize = new int[]{5, 5, 6, 6, 7, 8};
    protected static final int[] stdInputFontSize = new int[]{8, 9, 11, 12, 14, 18};
    protected static final int[] stdButtonFontSize = new int[]{10, 11, 12, 14, 16, 20};
    protected static final int[][] stdTextFontSize = new int[][]{{5, 5, 7, 7, 8, 9}, {6, 6, 8, 9, 9, 10}, {6, 7, 9, 9, 10, 12}, {7, 8, 10, 10, 12, 14}, {7, 9, 11, 12, 14, 18}, {8, 10, 11, 12, 14, 18}, {9, 10, 11, 12, 14, 18}, {9, 11, 11, 12, 14, 18}, {10, 11, 11, 12, 14, 18}, {10, 11, 11, 12, 14, 18}};
    protected static final int[] yPixelUnit_ = new int[]{6, 7, 9, 11, 14, 18};
    protected static final int[] xPixelUnit_ = new int[]{6, 7, 9, 11, 14, 18};
    protected static final int[][] xPixelFrac = new int[][]{{0, 1, 1, 2, 2, 3, 4, 4, 5, 5}, {0, 1, 1, 2, 3, 3, 4, 5, 6, 6}, {0, 1, 2, 3, 4, 5, 6, 6, 7, 8}, {0, 2, 3, 4, 5, 6, 7, 8, 9, 10}, {0, 2, 3, 4, 5, 7, 8, 9, 10, 12}, {0, 3, 4, 6, 7, 9, 11, 12, 14, 15}};
    protected static final int[][] yPixelFrac = xPixelFrac;
    protected final int xPixelUnit;
    public GralColor colorBackground_;
    public final GralFont[] textFont = new GralFont[10];
    public final GralFont[] fontMonospacedSansSerif = new GralFont[10];
    protected final int size;

    public GralGridProperties(char c) {
        int n = c - 65;
        if (n < 0 || n >= stdInputFontSize.length) {
            throw new IllegalArgumentException("parameter size should be 1.." + stdInputFontSize.length);
        }
        this.size = n;
        this.xPixelUnit = xPixelUnit_[n];
        this.colorBackground_ = this.color(0xEEEEEE);
        this.textFont[0] = new GralFont("Arial", stdTextFontSize[0][n], 'n');
        this.textFont[1] = new GralFont("Arial", stdTextFontSize[1][n], 'n');
        this.textFont[2] = new GralFont("Arial", stdTextFontSize[2][n], 'n');
        this.textFont[3] = new GralFont("Arial", stdTextFontSize[3][n], 'n');
        this.textFont[4] = new GralFont("Arial", stdTextFontSize[4][n], 'n');
        this.textFont[5] = new GralFont("Arial", stdTextFontSize[5][n], 'n');
        this.textFont[6] = new GralFont("Arial", stdTextFontSize[6][n], 'n');
        this.textFont[7] = new GralFont("Arial", stdTextFontSize[7][n], 'n');
        this.textFont[8] = new GralFont("Arial", stdTextFontSize[8][n], 'n');
        this.textFont[9] = new GralFont("Arial", stdTextFontSize[9][n], 'n');
        String string = "monospacedSansSerif";
        this.fontMonospacedSansSerif[0] = new GralFont(string, stdTextFontSize[0][n], 'n');
        this.fontMonospacedSansSerif[1] = new GralFont(string, stdTextFontSize[1][n], 'n');
        this.fontMonospacedSansSerif[2] = new GralFont(string, stdTextFontSize[2][n], 'n');
        this.fontMonospacedSansSerif[3] = new GralFont(string, stdTextFontSize[3][n], 'n');
        this.fontMonospacedSansSerif[4] = new GralFont(string, stdTextFontSize[4][n], 'n');
        this.fontMonospacedSansSerif[5] = new GralFont(string, stdTextFontSize[5][n], 'n');
        this.fontMonospacedSansSerif[6] = new GralFont(string, stdTextFontSize[6][n], 'n');
        this.fontMonospacedSansSerif[7] = new GralFont(string, stdTextFontSize[7][n], 'n');
        this.fontMonospacedSansSerif[8] = new GralFont(string, stdTextFontSize[8][n], 'n');
        this.fontMonospacedSansSerif[9] = new GralFont(string, stdTextFontSize[9][n], 'n');
    }

    public int getColorValue(String string) {
        GralColor gralColor = GralColor.getColor(string);
        if (gralColor == null) {
            return 0x606060;
        }
        return gralColor.getColorValue();
    }

    public GralFont getTextFont(float f) {
        if (f <= 1.2f) {
            return this.textFont[0];
        }
        if (f <= 1.4f) {
            return this.textFont[1];
        }
        if (f <= 1.6f) {
            return this.textFont[2];
        }
        if (f <= 1.8f) {
            return this.textFont[3];
        }
        if (f <= 2.0f) {
            return this.textFont[4];
        }
        if (f <= 2.4f) {
            return this.textFont[5];
        }
        if (f <= 2.8f) {
            return this.textFont[6];
        }
        if (f <= 3.1f) {
            return this.textFont[7];
        }
        if (f <= 3.9f) {
            return this.textFont[8];
        }
        return this.textFont[9];
    }

    public GralFont getTextFont(float f, char c, char c2) {
        GralFont gralFont;
        int n = f <= 1.2f ? 0 : (f <= 1.4f ? 1 : (f <= 1.6f ? 2 : (f <= 1.8f ? 3 : (f <= 2.0f ? 4 : (f <= 2.4f ? 5 : (f <= 2.8f ? 6 : (f <= 3.1f ? 7 : (f <= 3.9f ? 8 : 9))))))));
        switch (c) {
            case 'm': {
                gralFont = this.fontMonospacedSansSerif[n];
                break;
            }
            default: {
                gralFont = this.textFont[n];
            }
        }
        return gralFont;
    }

    public GralColor color(int n) {
        if (n < 0 || n >= 0x1000000) {
            throw new IllegalArgumentExceptionJc("color value fault", n);
        }
        GralColor gralColor = GralColor.getColor(n);
        return gralColor;
    }

    public int yPixelUnit() {
        return yPixelUnit_[this.size];
    }

    public int yPixelFrac(int n) {
        return yPixelFrac[this.size][n];
    }

    public int xPixelUnit() {
        return xPixelUnit_[this.size];
    }

    public int xPixelFrac(int n) {
        return xPixelFrac[this.size][n];
    }
}

