/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.gral.base;

import java.util.EventObject;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.vishia.event.EventTimerThread;
import org.vishia.gral.base.GralGraphicTimeOrder;
import org.vishia.gral.base.GralMng;
import org.vishia.util.Assert;
import org.vishia.util.MinMaxTime;

public class GralGraphicThread
implements Runnable {
    public static final String version = "2015-01-17";
    protected long graphicThreadId;
    protected boolean isWakedUpOnly;
    protected boolean bStarted = false;
    protected boolean bExit = false;
    protected MinMaxTime checkTimes = new MinMaxTime();
    private final ConcurrentLinkedQueue<GralGraphicTimeOrder> queueOrdersToExecute = new ConcurrentLinkedQueue();
    EventTimerThread orderList = new EventTimerThread("GraphicOrderTimeMng");
    private ImplAccess impl;

    void storeEvent(EventObject eventObject) {
        if (!(eventObject instanceof GralGraphicTimeOrder)) {
            throw new IllegalArgumentException("can only store events of type GralDispatchCallbackWorker");
        }
        this.queueOrdersToExecute.add((GralGraphicTimeOrder)((Object)eventObject));
        this.impl.wakeup();
    }

    public EventTimerThread orderList() {
        return this.orderList;
    }

    public void addDispatchOrder(GralGraphicTimeOrder gralGraphicTimeOrder) {
        gralGraphicTimeOrder.activate();
    }

    public void addEvent(EventObject eventObject) {
        assert (eventObject instanceof GralGraphicTimeOrder);
        this.queueOrdersToExecute.add((GralGraphicTimeOrder)((Object)eventObject));
        this.impl.wakeup();
    }

    public long getThreadIdGui() {
        return this.graphicThreadId;
    }

    public void wakeup() {
        this.impl.wakeup();
    }

    public boolean isStarted() {
        return this.bStarted;
    }

    public boolean isRunning() {
        return this.bStarted && !this.bExit;
    }

    public boolean isTerminated() {
        return this.bStarted && this.bExit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.impl.initGraphic();
        long l = Thread.currentThread().getId();
        GralGraphicThread gralGraphicThread = this;
        synchronized (gralGraphicThread) {
            this.graphicThreadId = l;
            this.bStarted = true;
            this.orderList.start();
            this.notify();
        }
        this.checkTimes.init();
        this.checkTimes.adjust();
        this.checkTimes.cyclTime();
        while (!this.bExit) {
            GralGraphicTimeOrder gralGraphicTimeOrder;
            boolean bl;
            do {
                try {
                    bl = this.impl.dispatchOsEvents();
                }
                catch (Throwable throwable) {
                    System.out.println(throwable.getMessage());
                    throwable.printStackTrace(System.out);
                    bl = true;
                }
            } while (bl);
            this.checkTimes.calcTime();
            this.isWakedUpOnly = false;
            if (this.bExit) continue;
            if (this.isWakedUpOnly) {
                Assert.stop();
            }
            this.checkTimes.cyclTime();
            boolean bl2 = true;
            while ((gralGraphicTimeOrder = this.queueOrdersToExecute.poll()) != null) {
                gralGraphicTimeOrder.stateOfEvent = (char)114;
                try {
                    gralGraphicTimeOrder.doExecute();
                }
                catch (Throwable throwable) {
                    CharSequence charSequence = Assert.exceptionInfo((CharSequence)"GralGraphicThread - unexpected Exception; ", (Throwable)throwable, (int)0, (int)99);
                    System.err.append(charSequence);
                }
                gralGraphicTimeOrder.relinquish();
                bl2 = false;
            }
            if (!bl2) continue;
            this.impl.graphicThreadSleep();
        }
        this.orderList.close();
    }

    public static abstract class ImplAccess {
        protected final GralGraphicThread gralGraphicThread;
        protected char sizeCharProperties;
        protected final Thread threadGuiDispatch;

        protected ImplAccess(char c) {
            this.gralGraphicThread = GralMng.get().gralDevice;
            this.gralGraphicThread.impl = this;
            this.sizeCharProperties = c;
            this.threadGuiDispatch = new Thread((Runnable)this.gralGraphicThread, "graphic");
        }

        public GralGraphicThread gralGraphicThread() {
            return this.gralGraphicThread;
        }

        protected abstract void initGraphic();

        protected abstract boolean dispatchOsEvents();

        protected abstract void graphicThreadSleep();

        public abstract void wakeup();

        protected void setClosed(boolean bl) {
            this.gralGraphicThread.bExit = bl;
        }
    }
}

