/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.gral.base;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.vishia.byteData.VariableAccess_ifc;
import org.vishia.byteData.VariableContainer_ifc;
import org.vishia.curves.WriteCurve_ifc;
import org.vishia.gral.base.GralMenu;
import org.vishia.gral.base.GralMng;
import org.vishia.gral.base.GralMouseWidgetAction_ifc;
import org.vishia.gral.base.GralWidget;
import org.vishia.gral.ifc.GralColor;
import org.vishia.gral.ifc.GralCurveViewTrack_ifc;
import org.vishia.gral.ifc.GralCurveView_ifc;
import org.vishia.gral.ifc.GralSetValue_ifc;
import org.vishia.gral.ifc.GralUserAction;
import org.vishia.gral.ifc.GralWidget_ifc;
import org.vishia.mainCmd.MainCmdLogging_ifc;
import org.vishia.mainCmd.ReportWrapperLog;
import org.vishia.util.Assert;
import org.vishia.util.KeyCode;
import org.vishia.util.Timeshort;
import org.vishia.zbnf.ZbnfJavaOutput;
import org.vishia.zbnf.ZbnfParser;

public abstract class GralCurveView
extends GralWidget
implements GralCurveView_ifc {
    public static final int version = 20130327;
    final ZbnfSetCurve zbnfSetCurve = new ZbnfSetCurve();
    protected TimeOrganisation timeorg = new TimeOrganisation();
    protected final DataOrganisation dataOrg = new DataOrganisation();
    protected SaveOrganisation saveOrg = new SaveOrganisation();
    protected final PixelOrganisation pixelOrg = new PixelOrganisation();
    protected final GralCurveViewMouseAction mouseAction = new GralCurveViewMouseAction();
    protected final List<Track> listTracks = new ArrayList<Track>();
    protected final CommonCurve common;
    protected Track trackSelected;
    protected final List<GralSetValue_ifc> listTrackSet = new LinkedList<GralSetValue_ifc>();
    protected final int[] timeValues;
    protected final int[] ixDataShown = new int[2000];
    protected final int[] nrofPixel4data = new int[2000];
    protected final int[] lastPositionX = new int[2];
    protected final int maxNrofXValues;
    protected final int adIxData;
    protected final int shIxiData;
    protected final int mIxiData;
    protected final int mIxData;
    protected int XXXnrofValuesShow;
    protected int timeCaryOverNewValue;
    protected int nrofValues = 0;
    protected int ixDataWr;
    protected boolean testStopWr;
    protected int ixDataDraw = 0;
    protected boolean bActive;
    protected int nrofValuesLessViewPart;
    protected int ixDataShowRight = 0;
    protected int xpCursor1 = -1;
    protected int xpCursor2 = -1;
    protected int xpCursor1New = -1;
    protected int xpCursor2New = -1;
    protected boolean bMouseDownCursor1;
    protected boolean bMouseDownCursor2;
    protected static final int cmdSetCursor = -2;
    protected int ixDataCursor1;
    protected int ixDataCursor2;
    protected int nrofValuesForGrid;
    protected int gridDistanceY;
    protected float gridDistanceX;
    protected int gridStrongPeriodX;
    protected int gridStrongPeriodY;
    protected int gridDistanceStrongY;
    protected GralColor gridColorGral;
    protected GralColor gridColorGralStrong;
    protected GralColor colorBackGral;
    protected boolean focusChanged = false;
    protected boolean bPaintAllCmd = false;
    private boolean bNewGetVariables = true;
    protected int newSamples;
    protected float xViewLastF = 0.0f;
    protected AtomicInteger nrofDataShift = new AtomicInteger(0);
    protected float nrofDataShiftFracPart = 0.0f;
    protected boolean redrawBecauseNewData;
    protected boolean bRedrawAll;
    private int ctLastSelected;
    private GralUserAction actionMoveCursor;
    private GralUserAction actionSelectTrack;
    public GralUserAction actionZoomBetweenCursors = new GralUserAction("actionZoomBetweenCursors"){

        @Override
        public boolean exec(int n, GralWidget_ifc gralWidget_ifc, Object ... objectArray) {
            if (KeyCode.isControlFunctionMouseUpOrMenu((int)n)) {
                GralCurveView.this.zoomBetweenCursors();
            }
            return true;
        }
    };
    public GralUserAction actionZoomOut = new GralUserAction("actionZoomOut"){

        @Override
        public boolean exec(int n, GralWidget_ifc gralWidget_ifc, Object ... objectArray) {
            if (KeyCode.isControlFunctionMouseUpOrMenu((int)n)) {
                GralCurveView.this.cursorUnzoom();
            }
            return true;
        }
    };
    public GralUserAction actionGo = new GralUserAction("actionGo"){

        @Override
        public boolean exec(int n, GralWidget_ifc gralWidget_ifc, Object ... objectArray) {
            if (KeyCode.isControlFunctionMouseUpOrMenu((int)n)) {
                GralCurveView.this.ixDataShowRight = GralCurveView.this.ixDataWr;
                GralCurveView.this.common.bFreeze = false;
            }
            return true;
        }
    };
    public GralUserAction actionPaintAll = new GralUserAction("actionPaintAll"){

        @Override
        public boolean exec(int n, GralWidget_ifc gralWidget_ifc, Object ... objectArray) {
            if (KeyCode.isControlFunctionMouseUpOrMenu((int)n)) {
                GralCurveView.this.setPaintAllCmd();
            }
            return true;
        }
    };

    public GralCurveView(String string, GralMng gralMng, int n, CommonCurve commonCurve) {
        super(string, 'c', gralMng);
        this.common = commonCurve == null ? new CommonCurve() : commonCurve;
        int n2 = 1;
        int n3 = 32;
        while (n2 < n) {
            n2 <<= 1;
            --n3;
        }
        this.shIxiData = n3;
        this.maxNrofXValues = n2;
        this.adIxData = 0x40000000 / (this.maxNrofXValues >> 2);
        this.mIxData = ~(this.adIxData - 1);
        this.mIxiData = this.maxNrofXValues - 1;
        this.ixDataWr = -this.adIxData;
        this.pixelOrg.xPixelCurve = 0;
        this.pixelOrg.yPixelCurve = 0;
        this.timeValues = new int[this.maxNrofXValues];
        for (int i = 0; i < this.maxNrofXValues; ++i) {
            this.timeValues[i] = i;
        }
        this.saveOrg.nrofValuesAutoSave = (int)((double)this.maxNrofXValues * 0.75);
        this.timeorg.calc();
        gralMng.registerWidget(this);
    }

    protected void initMenuContext() {
        GralMenu gralMenu = this.getContextMenu();
        gralMenu.addMenuItemGthread("refresh", this.actionPaintAll);
        gralMenu.addMenuItemGthread("go", this.actionGo);
        gralMenu.addMenuItemGthread("zoomBetweenCursor", "zoom between Cursors", this.actionZoomBetweenCursors);
        gralMenu.addMenuItemGthread("zoomOut", "zoom out", this.actionZoomOut);
    }

    public CommonCurve getCommonData() {
        return this.common;
    }

    public void setActionMoveCursor(GralUserAction gralUserAction) {
        this.actionMoveCursor = gralUserAction;
    }

    public void setActionTrackSelected(GralUserAction gralUserAction) {
        this.actionSelectTrack = gralUserAction;
    }

    public GralCurveViewTrack_ifc initTrack(String string, String string2, GralColor gralColor, int n, int n2, float f, float f2) {
        Track track = new Track(this, string, this.listTracks.size());
        track.values = new float[this.maxNrofXValues];
        this.listTracks.add(track);
        this.listTrackSet.add(track);
        track.sDataPath = string2;
        track.variable = null;
        track.y0Line = n2;
        track.yOffset = f2;
        track.yScale = f;
        track.lineColor = gralColor;
        this.bNewGetVariables = true;
        return track;
    }

    public void setTimePerPixel(int n) {
        this.timeorg.timePerPixel = n;
    }

    public void setTimeSpread(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("GralCurveView.setTimeSpread - value should >0");
        }
        this.timeorg.timeSpread = n;
    }

    public void setTrackScale(int n, float f, float f2, int n2) {
        Track track = this.listTracks.get(n);
        track.setTrackScale(f, f2, n2);
    }

    public String getTimeVariable() {
        return this.common.timeDatapath;
    }

    public List<GralSetValue_ifc> getTracks() {
        return this.listTrackSet;
    }

    public List<? extends GralCurveViewTrack_ifc> getTrackInfo() {
        return this.listTracks;
    }

    public Track getTrackSelected() {
        return this.trackSelected;
    }

    public boolean shouldAutosave() {
        return this.saveOrg.ctValuesAutoSave >= this.saveOrg.nrofValuesAutoSave;
    }

    public long timeRight() {
        int n = this.ixDataShown[0];
        int n2 = this.timeValues[n >> this.shIxiData & this.mIxiData];
        return this.timeorg.absTime.absTimeshort(n2);
    }

    @Override
    public void setTimePoint(long l, int n, float f) {
        this.timeorg.absTime.setTimePoint(l, n, f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSample(float[] fArray, int n) {
        if (this.testStopWr) {
            return;
        }
        if (++this.saveOrg.ctValuesAutoSave > this.saveOrg.nrofValuesAutoSave) {
            this.saveOrg.ctValuesAutoSave = this.saveOrg.nrofValuesAutoSave;
        }
        this.ixDataWr += this.adIxData;
        if (this.ixDataWr == -this.adIxData) {
            this.dataOrg.bWrappedInBuffer = true;
        }
        if (!this.common.bFreeze) {
            this.ixDataShowRight = this.ixDataWr;
        }
        ++this.newSamples;
        ++this.nrofValuesForGrid;
        if (this.nrofValuesForGrid > this.maxNrofXValues + this.gridDistanceStrongY) {
            this.nrofValuesForGrid -= this.gridDistanceStrongY;
        }
        int n2 = -1;
        int n3 = this.ixDataWr >> this.shIxiData & this.mIxiData;
        for (GralSetValue_ifc gralSetValue_ifc : this.listTracks) {
            if (n2 < fArray.length - 1) {
                float f;
                gralSetValue_ifc.values[n3] = f = fArray[++n2];
                if (gralSetValue_ifc.min > f) {
                    gralSetValue_ifc.min = f;
                }
                if (!(gralSetValue_ifc.max < f)) continue;
                gralSetValue_ifc.max = f;
                continue;
            }
            gralSetValue_ifc.values[n3] = 0.0f;
        }
        int n4 = this.timeValues[n3];
        this.timeValues[n3] = n;
        this.timeorg.lastShortTimeDateInCurve = n;
        if (this.nrofValues < this.maxNrofXValues) {
            if (this.nrofValues == 0) {
                this.timeorg.firstShortTimeDateInCurve = n;
            }
            ++this.nrofValues;
        } else {
            this.timeorg.firstShortTimeDateInCurve = n4;
            this.nrofDataShift.incrementAndGet();
        }
        if (!this.common.bFreeze) {
            GralSetValue_ifc gralSetValue_ifc;
            gralSetValue_ifc = this;
            synchronized (gralSetValue_ifc) {
                this.redrawBecauseNewData = true;
            }
            super.repaint(50, 100);
        }
    }

    @Override
    public void refreshFromVariable(VariableContainer_ifc variableContainer_ifc) {
        if (this.bActive) {
            long l;
            float[] fArray = new float[this.listTracks.size()];
            int n = -1;
            boolean bl = false;
            for (Track track : this.listTracks) {
                float f;
                String string;
                if (track.variable == null && this.bNewGetVariables && (string = track.getDataPath()) != null) {
                    if (string.startsWith("-")) {
                        int n2 = string.indexOf(45, 1) + 1;
                        string = string.substring(n2);
                    }
                    String string2 = string.trim();
                    if (!string.startsWith("#")) {
                        String string3 = this.itsMng.replaceDataPathPrefix(string2);
                        track.variable = variableContainer_ifc.getVariable(string3);
                        if (track.variable == null) {
                            System.err.printf("GralCurveView - variable not found; %s in curveview: %s\n", string3, this.name);
                        }
                    }
                }
                if (track.variable != null) {
                    if (track.variable.isRefreshed()) {
                        bl = true;
                    }
                    if (track.getDataPath().startsWith("CCS:")) {
                        this.stop();
                    }
                    f = track.variable.getFloat();
                    track.variable.requestValue(System.currentTimeMillis());
                } else {
                    f = 0.0f;
                }
                fArray[++n] = f;
            }
            this.bNewGetVariables = false;
            if (this.common.timeDatapath != null && this.common.timeVariable == null) {
                String string = this.itsMng.replaceDataPathPrefix(this.common.timeDatapath);
                this.common.timeVariable = variableContainer_ifc.getVariable(string);
            }
            if (this.common.timeVariable != null) {
                l = this.common.timeVariable.getLong();
                this.common.timeVariable.requestValue(System.currentTimeMillis());
            } else {
                l = System.currentTimeMillis();
            }
            if (bl) {
                int n3 = (int)l;
                this.setTimePoint(l, n3, 1.0f);
                this.setSample(fArray, n3);
            }
        }
    }

    protected int prepareIndicesDataForDrawing(int n, int n2, int n3, boolean bl) {
        int n4;
        System.arraycopy(this.ixDataShown, 0, this.ixDataShown, n2, this.ixDataShown.length - n2);
        this.dataOrg.zPixelDataShown = bl ? 0 : (this.dataOrg.zPixelDataShown + n2 >= this.pixelOrg.xPixelCurve ? this.pixelOrg.xPixelCurve : (this.dataOrg.zPixelDataShown += n2));
        this.ixDataShown[0] = n;
        int n5 = n;
        int n6 = n;
        int n7 = n5 >> this.shIxiData & this.mIxiData;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = this.timeValues[n7];
        if (n2 > 100) {
            this.timeorg.timeLeftShowing = n11 - (int)((float)(n2 + 1) * this.timeorg.timePerPixel);
        }
        long l = this.timeorg.absTime.absTimeshort(n11);
        int n12 = (int)(l % (long)this.timeorg.millisecPerDiv);
        int n13 = n12 % this.timeorg.millisecPerFineDiv;
        float f = (float)n12 * this.timeorg.pixel7time / this.timeorg.absTime.millisec7short();
        int n14 = -1;
        int n15 = -1;
        for (float f2 = (float)n13 * this.timeorg.pixel7time / this.timeorg.absTime.millisec7short(); f2 < (float)n2; f2 += this.timeorg.pixelPerTimeFineDiv) {
            if (Math.abs(f - f2) < 3.0f) {
                String string;
                n4 = (int)((double)f + 1.5);
                this.timeorg.xPixelTimeDiv[++n14] = n4;
                this.timeorg.timeAbsOnLastStrongDiv = l - (long)n12;
                if (this.timeorg.millisecPerFineDiv <= 100) {
                    float f3 = (float)(this.timeorg.timeAbsOnLastStrongDiv % 60000L) / 1000.0f;
                    this.timeorg.sTimeAbsDiv[n14] = String.format("% 2.3f", Float.valueOf(f3));
                } else if (this.timeorg.millisecPerFineDiv < 1000) {
                    long l2 = this.timeorg.timeAbsOnLastStrongDiv / 1000L % 60L;
                    this.timeorg.sTimeAbsDiv[n14] = "" + l2;
                } else if (this.timeorg.millisecPerFineDiv < 10000) {
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm:ss");
                    this.timeorg.sTimeAbsDiv[n14] = string = simpleDateFormat.format(new Date(this.timeorg.timeAbsOnLastStrongDiv));
                } else {
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm");
                    this.timeorg.sTimeAbsDiv[n14] = string = simpleDateFormat.format(new Date(this.timeorg.timeAbsOnLastStrongDiv));
                }
                this.timeorg.pixelWrittenAfterStrongDiv = n4;
                f += this.timeorg.pixelPerTimeDiv;
                n12 += this.timeorg.millisecPerDiv;
                continue;
            }
            n4 = (int)(f2 + 1.5f);
            this.timeorg.xPixelTimeDivFine[++n15] = n4;
        }
        this.timeorg.timeLeftShowing = n11;
        this.timeorg.xPixelTimeDiv[++n14] = -1;
        this.timeorg.xPixelTimeDivFine[++n15] = -1;
        n4 = n11;
        int n16 = n11;
        int n17 = 0;
        while (n9 < n2 && n17 <= 0 && n10 >= 0) {
            do {
                if ((n5 -= this.adIxData) == -this.adIxData && !this.dataOrg.bWrappedInBuffer) {
                    n17 = 1;
                    continue;
                }
                n7 = n5 >> this.shIxiData & this.mIxiData;
                n16 = this.timeValues[n7];
                n17 = n16 - n4;
                if (n17 >= 0) continue;
                int n18 = n11 - n16;
                int n19 = (int)((float)n18 * this.timeorg.pixel7time + 0.5f);
                if (n19 > n2) {
                    n19 = n2;
                }
                n10 += n19 - n9;
                n9 = n19;
                if (this.xpCursor1New == -2 && n5 == this.ixDataCursor1) {
                    this.xpCursor1New = n9;
                }
                if (this.xpCursor2New != -2 || n5 != this.ixDataCursor2) continue;
                this.xpCursor2New = n9;
            } while (n9 == n8 && n17 < 0);
            while (n8 < n9) {
                this.ixDataShown[n8] = n6;
                this.nrofPixel4data[n8] = --n10;
                ++n8;
            }
            if (this.dataOrg.zPixelDataShown < n8) {
                this.dataOrg.zPixelDataShown = n8;
            }
            n6 = n5;
        }
        if (n9 < n2) {
            // empty if block
        }
        return n9;
    }

    @Override
    public GralColor setBackgroundColor(GralColor gralColor) {
        return null;
    }

    @Override
    public GralColor setForegroundColor(GralColor gralColor) {
        return null;
    }

    @Override
    public void setBoundsPixel(int n, int n2, int n3, int n4) {
    }

    @Override
    public boolean setFocusGThread() {
        return false;
    }

    @Override
    public void activate(boolean bl) {
        this.bActive = bl;
    }

    @Override
    public boolean isActiv() {
        return this.bActive;
    }

    @Override
    public boolean isFreezed() {
        return this.common.bFreeze;
    }

    @Override
    public boolean applySettings(String string) {
        boolean bl;
        try {
            ReportWrapperLog reportWrapperLog = new ReportWrapperLog(this.itsMng.log());
            ZbnfParser zbnfParser = new ZbnfParser((MainCmdLogging_ifc)reportWrapperLog);
            zbnfParser.setSyntax("curveSettings::= [ timeVariable = <* ;?timeDatapath> ; ] { <Track> } \\e.Track::= track <*:?name> : { datapath = <* ,;?datapath> | color = <* ,;?color> | scale = <#f?scale> | offset = <#f?offset> | 0-line-percent = <#?nullLine> ? , } ; .");
            bl = zbnfParser.parse(string);
            if (!bl) {
                reportWrapperLog.writeError(zbnfParser.getSyntaxErrorReport());
            } else {
                this.common.timeDatapath = null;
                this.listTracks.clear();
                this.listTrackSet.clear();
                ZbnfJavaOutput zbnfJavaOutput = new ZbnfJavaOutput((MainCmdLogging_ifc)reportWrapperLog);
                zbnfJavaOutput.setContent(this.zbnfSetCurve.getClass(), (Object)this.zbnfSetCurve, zbnfParser.getFirstParseResult());
                this.bNewGetVariables = true;
            }
        }
        catch (Exception exception) {
            System.err.println("GralCurveView.writeSettings() - unexpected IOException;" + exception.getMessage());
            bl = false;
        }
        return bl;
    }

    @Override
    public void writeSettings(Appendable appendable) {
        for (Track track : this.listTracks) {
            if (track.sDataPath == null) continue;
            try {
                appendable.append("track ").append(track.name).append(":");
                appendable.append(" datapath=").append(track.sDataPath);
                appendable.append(", color=").append(track.lineColor.toString());
                appendable.append(", scale=").append(Float.toString(track.yScale));
                appendable.append(", offset=").append(Float.toString(track.yOffset));
                appendable.append(", 0-line-percent=").append(Integer.toString(track.y0Line));
                appendable.append(";\n");
            }
            catch (IOException iOException) {
                System.err.println("GralCurveView.writeSettings() - unexpected IOException;" + iOException.getMessage());
            }
        }
    }

    public CharSequence timeInitSaveViewArea() {
        this.dataOrg.ixDataStartSave = this.ixDataShown[this.dataOrg.zPixelDataShown - 1];
        int n = this.timeValues[this.dataOrg.ixDataStartSave >> this.shIxiData & this.mIxiData];
        this.dataOrg.ixDataEndSave = this.ixDataShown[0];
        if (!this.common.bFreeze) {
            this.dataOrg.ixDataEndAutoSave = this.dataOrg.ixDataEndSave;
            this.saveOrg.ctValuesAutoSave = 0;
        }
        return this.buildDate(this.dataOrg.ixDataStartSave, this.dataOrg.ixDataEndSave);
    }

    @Override
    public CharSequence timeInitAutoSave() {
        this.dataOrg.ixDataStartAutoSave = this.dataOrg.ixDataEndAutoSave;
        this.dataOrg.ixDataEndAutoSave = this.ixDataWr;
        this.saveOrg.ctValuesAutoSave = 0;
        return this.buildDate(this.dataOrg.ixDataStartAutoSave, this.dataOrg.ixDataEndAutoSave);
    }

    private CharSequence buildDate(int n, int n2) {
        int n3 = this.timeValues[n >> this.shIxiData & this.mIxiData];
        int n4 = this.timeValues[n2 >> this.shIxiData & this.mIxiData];
        long l = this.timeorg.absTime.absTimeshort(n3);
        long l2 = this.timeorg.absTime.absTimeshort(n4);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss");
        SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("_HH-mm-ss");
        String string = simpleDateFormat.format(new Date(l)) + "_to" + simpleDateFormat2.format(new Date(l2));
        return string;
    }

    public void readCurve(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        byte[] byArray = new byte[256];
        int n = ((InputStream)fileInputStream).read(byArray);
        ((InputStream)fileInputStream).close();
        String string = new String(byArray, 0, n);
        if (string.startsWith("csv-headline.curve;")) {
            this.readCurveCsvHeadline(file);
        } else if (string.startsWith("CurveView-CSV version 150120")) {
            this.readCurveCsvHeadline(file);
        }
    }

    private void readCurveCsvHeadline(File file) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        String string = bufferedReader.readLine();
        this.setTimePoint(System.currentTimeMillis(), 0, 0.156f);
        string = bufferedReader.readLine();
        this.listTracks.clear();
        this.listTrackSet.clear();
        int n = -1;
        String[] stringArray = string.split(";");
        String[] stringArray2 = new String[]{"bk", "rd", "gn", "bl", "or", "gr", "gr", "gr", "gr"};
        int n2 = 0;
        for (String n4 : stringArray) {
            String[] stringArray3 = n4.trim();
            GralColor gralColor = GralColor.getColor(stringArray2[n2]);
            this.initTrack((String)stringArray3, (String)stringArray3, gralColor, 1, 50, 1.0f, 0.0f);
            ++n2;
        }
        this.ixDataWr = -this.adIxData;
        float[] fArray = new float[this.listTracks.size()];
        int n3 = 0;
        while ((string = bufferedReader.readLine()) != null) {
            String[] stringArray4 = string.split(";");
            int n4 = -1;
            for (String string2 : stringArray4) {
                float f;
                String string3 = string2.trim();
                string3 = string3.replace(',', '.');
                try {
                    f = Float.valueOf(string3).floatValue();
                }
                catch (NumberFormatException numberFormatException) {
                    f = 0.1f;
                }
                fArray[++n4] = f;
            }
            this.setSample(fArray, ++n3);
        }
    }

    @Override
    public void writeCurve(WriteCurve_ifc writeCurve_ifc, GralCurveView_ifc.ModeWrite modeWrite) {
        int n;
        int n2;
        switch (modeWrite) {
            case currentView: {
                n2 = this.dataOrg.ixDataEndSave;
                n = this.dataOrg.ixDataStartSave;
                break;
            }
            case autoSave: {
                n2 = this.dataOrg.ixDataEndAutoSave;
                n = this.dataOrg.ixDataStartAutoSave;
                break;
            }
            default: {
                n2 = 0;
                n = 0;
            }
        }
        this.writeCurve(writeCurve_ifc, n, n2);
    }

    private void writeCurve(WriteCurve_ifc writeCurve_ifc, int n, int n2) {
        boolean bl = true;
        try {
            writeCurve_ifc.writeCurveTimestamp(new Timeshort(this.timeorg.absTime));
            if (!bl) {
                writeCurve_ifc.writeCurveError("absolute time error");
            } else {
                int n3 = -1;
                int n4 = this.listTracks.size();
                for (Track track : this.listTracks) {
                    String string = track.name;
                    String string2 = track.getDataPath();
                    GralColor gralColor = track.getLineColor();
                    String string3 = gralColor.getColorName();
                    writeCurve_ifc.setTrackInfo(n4, ++n3, string2, string, string3, track.getScale7div(), track.getOffset(), track.getLinePercent());
                }
                Object object = new float[this.listTracks.size()];
                int n5 = n >> this.shIxiData & this.mIxiData;
                int n6 = this.timeValues[n5];
                writeCurve_ifc.writeCurveStart(n6);
                int n7 = this.nrofValues - 1;
                for (int i = n; i != n2 && --n7 >= 0; i += this.adIxData) {
                    n5 = i >> this.shIxiData & this.mIxiData;
                    n3 = -1;
                    for (Track track : this.listTracks) {
                        object[++n3] = track.values[n5];
                    }
                    int n8 = this.timeValues[n5];
                    if (n8 - n6 < 0) {
                        writeCurve_ifc.writeCurveStart(n8);
                    }
                    writeCurve_ifc.writeCurveRecord(n8, (float[])object);
                    n6 = n8;
                }
                writeCurve_ifc.writeCurveFinish();
            }
        }
        catch (IOException iOException) {
            System.err.println(Assert.exceptionInfo((CharSequence)"GralCurveView- exception", (Throwable)iOException, (int)0, (int)4));
        }
    }

    @Override
    public void repaint(int n, int n2) {
        System.out.println("GralCurveView.Info - repaint all Trigger;");
        this.bPaintAllCmd = true;
        this.bNewGetVariables = true;
        super.repaint(n, n2);
    }

    protected void setPaintAllCmd() {
        System.out.println("GralCurveView.Info - paintallTrigger;");
        this.bPaintAllCmd = true;
        this.bNewGetVariables = true;
    }

    protected int getIxDataFromPixelRight(int n) {
        int n2 = this.ixDataShown[n];
        int n3 = n2 >> this.shIxiData & this.mIxiData;
        return n3;
    }

    protected boolean selectTrack(int n, int n2, int n3, int n4) {
        int n5 = this.getIxDataFromPixelRight(n3 - n);
        int n6 = 10;
        int n7 = 0;
        Track track = null;
        ++this.ctLastSelected;
        for (Track track2 : this.listTracks) {
            float f = track2.values[n5];
            float f2 = (float)n4 / -10.0f / track2.yScale;
            float f3 = (1.0f - (float)track2.y0Line / 100.0f) * (float)n4;
            int n8 = (int)((f - track2.yOffset) * f2 + f3);
            int n9 = Math.abs(n8 - n2);
            int n10 = this.ctLastSelected - track2.identLastSelect;
            if (n9 >= n6 || n10 <= n7) continue;
            track = track2;
            n7 = n10;
        }
        if (track != null) {
            track.identLastSelect = this.ctLastSelected;
            this.trackSelected = track;
            if (this.actionSelectTrack != null) {
                this.actionSelectTrack.exec(0, this, this.trackSelected);
            }
        }
        return track != null;
    }

    protected void setCursors(int n) {
        int n2 = this.pixelOrg.xPixelCurve - n;
        if (this.xpCursor1 < 0) {
            this.xpCursor1New = n2;
            this.bMouseDownCursor1 = true;
            this.bMouseDownCursor2 = false;
        } else if (this.xpCursor2 < 0) {
            this.xpCursor2New = n2;
            this.bMouseDownCursor2 = true;
            this.bMouseDownCursor1 = false;
        } else {
            int n3;
            int n4;
            int n5 = this.xpCursor1New >= 0 ? this.xpCursor1New : this.xpCursor1;
            int n6 = n4 = this.xpCursor2New >= 0 ? this.xpCursor2New : this.xpCursor2;
            if (n5 < n4) {
                n3 = n5;
                this.xpCursor1New = n4;
                this.xpCursor2New = n3;
            }
            if (n2 > (n3 = (n5 + n4) / 2)) {
                this.xpCursor1New = n2;
                this.bMouseDownCursor1 = true;
                this.bMouseDownCursor2 = false;
            } else {
                this.xpCursor2New = n2;
                this.bMouseDownCursor2 = true;
                this.bMouseDownCursor1 = false;
            }
        }
        this.bRedrawAll = true;
        this.repaint(0, 0);
        if (this.actionMoveCursor != null) {
            this.actionMoveCursor.exec(0, this, new Object[0]);
        }
    }

    protected void moveCursor(int n) {
        int n2 = this.pixelOrg.xPixelCurve - n;
        if (this.bMouseDownCursor1) {
            this.xpCursor1New = n2;
            this.repaint(50, 100);
        } else if (this.bMouseDownCursor2) {
            this.xpCursor2New = n2;
            this.repaint(50, 100);
        }
        if (this.actionMoveCursor != null) {
            this.actionMoveCursor.exec(0, this, new Object[0]);
        }
    }

    protected void zoomToPresent() {
        if (this.xpCursor1 >= 0) {
            this.ixDataCursor1 = this.ixDataShown[this.xpCursor1];
        }
        if (this.xpCursor2 >= 0) {
            this.ixDataCursor2 = this.ixDataShown[this.xpCursor2];
        }
        this.xpCursor2New = -2;
        this.xpCursor1New = -2;
        this.timeorg.timeSpread = this.timeorg.timeSpread > 100 ? (this.timeorg.timeSpread /= 2) : 100;
        this.bPaintAllCmd = true;
        this.repaint(100, 200);
    }

    protected void zoomToPast() {
        int n = this.timeorg.lastShortTimeDateInCurve - this.timeorg.firstShortTimeDateInCurve;
        if (this.xpCursor1 >= 0) {
            this.ixDataCursor1 = this.ixDataShown[this.xpCursor1];
        }
        if (this.xpCursor2 >= 0) {
            this.ixDataCursor2 = this.ixDataShown[this.xpCursor2];
        }
        this.xpCursor2New = -2;
        this.xpCursor1New = -2;
        this.timeorg.timeSpread = this.timeorg.timeSpread < 0x3FFFFFFF ? (this.timeorg.timeSpread *= 2) : Integer.MAX_VALUE;
        this.bPaintAllCmd = true;
        this.repaint(100, 200);
    }

    protected void zoomBetweenCursors() {
        this.ixDataCursor1 = this.ixDataShown[this.xpCursor1];
        this.ixDataCursor2 = this.ixDataShown[this.xpCursor2];
        this.ixDataShowRight = this.ixDataCursor2 + ((this.ixDataCursor2 - this.ixDataCursor1) / 10 & this.mIxData);
        int n = this.ixDataShown[this.xpCursor2] >> this.shIxiData & this.mIxiData;
        int n2 = this.timeValues[n];
        int n3 = this.ixDataShown[this.xpCursor1] >> this.shIxiData & this.mIxiData;
        int n4 = this.timeValues[n3];
        if (n2 - n4 > 0) {
            this.timeorg.timeSpread = (n2 - n4) * 10 / 8;
            assert (this.timeorg.timeSpread > 0);
        } else {
            this.stop();
        }
        this.xpCursor2New = -2;
        this.xpCursor1New = -2;
        this.repaint(100, 200);
    }

    protected void cursorUnzoom() {
        int n = (this.xpCursor1 + this.xpCursor2) / 2;
        int n2 = this.ixDataShown[n];
        this.ixDataShowRight = n2 + (this.ixDataShowRight - n2) * 5;
        if (this.ixDataShowRight - this.ixDataWr > 0) {
            this.ixDataShowRight = this.ixDataWr;
        }
        this.timeorg.timeSpread = this.timeorg.timeSpread < 0x19999997 ? (this.timeorg.timeSpread *= 5) : Integer.MAX_VALUE;
        Assert.check((this.timeorg.timeSpread > 0 ? 1 : 0) != 0);
        this.xpCursor2New = -2;
        this.xpCursor1New = -2;
        this.repaint(100, 200);
    }

    protected void viewToPresentOrGoIrRefresh() {
        if (this.common.bFreeze) {
            int n = this.ixDataShowRight - this.ixDataShown[this.pixelOrg.xPixelCurve * 5 / 8];
            if (this.ixDataShowRight - this.ixDataWr < 0 && this.ixDataShowRight - this.ixDataWr + n >= 0) {
                this.ixDataShowRight = this.ixDataWr;
                this.common.bFreeze = false;
            } else {
                this.ixDataShowRight += n;
            }
            this.repaint(100, 200);
        } else {
            this.setPaintAllCmd();
        }
    }

    protected void stopAndViewToPast() {
        if (!this.common.bFreeze) {
            this.common.bFreeze = true;
        } else {
            int n = this.ixDataShowRight - this.ixDataShown[this.pixelOrg.xPixelCurve * 5 / 10];
            this.ixDataShowRight -= n;
            if (this.ixDataShowRight - this.ixDataWr < 0 && this.ixDataWr - this.ixDataShowRight < n) {
                this.ixDataShowRight = this.ixDataWr + n;
            }
        }
        this.repaint(100, 200);
    }

    protected void mouseSelectCursur(int n, int n2) {
    }

    protected class GralCurveViewMouseAction
    implements GralMouseWidgetAction_ifc {
        protected GralCurveViewMouseAction() {
        }

        @Override
        public void mouse1Down(int n, int n2, int n3, int n4, int n5, GralWidget gralWidget) {
            if (n2 < n4 / 20 && n3 > n5 * 95 / 100) {
                System.out.println("GralCurveView-Mousedown left bottom");
                GralCurveView.this.stopAndViewToPast();
            } else if (n2 > n4 * 95 / 100 && n3 > n5 * 95 / 100) {
                GralCurveView.this.viewToPresentOrGoIrRefresh();
            } else if (n2 < n4 / 20 && n3 < n5 / 20) {
                System.out.println("GralCurveView-Mousedown left top");
                GralCurveView.this.zoomToPast();
            } else if (n2 > n4 * 95 / 100 && n3 < n5 / 20) {
                GralCurveView.this.zoomToPresent();
            } else if (!GralCurveView.this.selectTrack(n2, n3, n4, n5)) {
                GralCurveView.this.setCursors(n2);
            }
        }

        @Override
        public void mouse1Up(int n, int n2, int n3, int n4, int n5, GralWidget gralWidget) {
            GralCurveView.this.bMouseDownCursor2 = false;
            GralCurveView.this.bMouseDownCursor1 = false;
        }

        @Override
        public void mouse2Down(int n, int n2, int n3, int n4, int n5, GralWidget gralWidget) {
        }

        @Override
        public void mouse2Up(int n, int n2, int n3, int n4, int n5, GralWidget gralWidget) {
        }

        @Override
        public void mouse1Double(int n, int n2, int n3, int n4, int n5, GralWidget gralWidget) {
        }

        @Override
        public boolean mouseMoved(int n, int n2, int n3, int n4) {
            GralCurveView.this.moveCursor(n);
            return true;
        }
    }

    protected static class PixelOrganisation {
        public int xPixelCurve;
        public int yPixelCurve;

        protected PixelOrganisation() {
        }
    }

    protected static class SaveOrganisation {
        public int nrofValuesAutoSave;
        public int ctValuesAutoSave;

        protected SaveOrganisation() {
        }
    }

    protected static class DataOrganisation {
        public int ixDataStartAutoSave;
        public int ixDataEndAutoSave;
        public int ixDataStartSave;
        public int ixDataEndSave;
        protected int zPixelDataShown;
        boolean bWrappedInBuffer;

        protected DataOrganisation() {
        }
    }

    protected static class TimeOrganisation {
        Timeshort absTime = new Timeshort();
        private volatile int ctTimeSet;
        public int lastShortTimeDateInCurve;
        public int firstShortTimeDateInCurve;
        public int nrofPixelForTimestep;
        float pixelPerTimeDiv;
        float pixelPerTimeFineDiv;
        int millisecPerDiv = 100;
        int millisecPerFineDiv = 10;
        public float timePerPixel = 1.0f;
        public float pixel7time = 1.0f;
        public int timeSpread = 50000;
        public int timeLeftShowing;
        public long timeAbsOnLastStrongDiv;
        public int pixelWrittenAfterStrongDiv;
        public final int[] xPixelTimeDiv = new int[50];
        public final int[] xPixelTimeDivFine = new int[200];
        public final String[] sTimeAbsDiv = new String[50];
        int[] millisecPerFineDivVariants = new int[]{1, 2, 5, 10, 20, 50, 100, 200, 500, 1000, 2000, 5000, 10000, 20000, 60000, 120000, 600000, 1200000, 3600000, 18000000};
        int[] millisecPerDivVariants = new int[]{5, 10, 20, 50, 100, 200, 500, 1000, 2000, 5000, 10000, 20000, 60000, 120000, 300000, 600000, 3600000, 0x6DDD00, 18000000, 72000000};

        protected TimeOrganisation() {
        }

        public void calc() {
            int n = (int)(12.0f * this.timePerPixel * this.absTime.absTime_Millisec7short);
            boolean bl = false;
            for (int i = 0; i < this.millisecPerDivVariants.length; ++i) {
                if (this.millisecPerFineDivVariants[i] < n) continue;
                this.millisecPerDiv = this.millisecPerDivVariants[i];
                this.millisecPerFineDiv = this.millisecPerFineDivVariants[i];
                bl = true;
                break;
            }
            if (bl) {
                this.pixelPerTimeDiv = (float)this.millisecPerDiv / (this.timePerPixel * this.absTime.absTime_Millisec7short);
                this.pixelPerTimeFineDiv = (float)this.millisecPerFineDiv / (this.timePerPixel * this.absTime.absTime_Millisec7short);
            } else {
                this.pixelPerTimeDiv = 150.0f;
                this.pixelPerTimeFineDiv = 30.0f;
            }
        }
    }

    protected static class Track
    implements GralCurveViewTrack_ifc,
    GralSetValue_ifc {
        public final String name;
        public final int ixList;
        private final GralCurveView outer;
        public String sDataPath;
        public VariableAccess_ifc variable;
        private Object oContent;
        private int dataIx;
        public float YYYactValue;
        public float min;
        public float max;
        public float yScale;
        public float yOffset;
        public int y0Line;
        public GralColor lineColor;
        public int lineWidth = 1;
        public float[] values;
        protected final int[] XXXlastValueY = new int[2];
        int identLastSelect;
        public int ypixLast;

        public Track(GralCurveView gralCurveView, String string, int n) {
            this.outer = gralCurveView;
            this.name = string;
            this.ixList = n;
        }

        @Override
        public int getIxTrack() {
            return this.ixList;
        }

        @Override
        public void setContentInfo(Object object) {
            this.oContent = object;
        }

        @Override
        public Object getContentInfo() {
            return this.oContent;
        }

        @Override
        public void setDataPath(String string) {
            this.sDataPath = string;
            this.variable = null;
            this.outer.bNewGetVariables = true;
        }

        @Override
        public String getDataPath() {
            return this.sDataPath;
        }

        @Override
        public int getDataIx() {
            return this.dataIx;
        }

        @Override
        public void setDataIx(int n) {
            this.dataIx = n;
        }

        @Override
        public void setValue(float f) {
            this.YYYactValue = f;
        }

        @Override
        public void setValue(Object[] objectArray) {
        }

        @Override
        public void setMinMax(float f, float f2) {
            this.min = f;
            this.max = f2;
        }

        @Override
        public int getLinePercent() {
            return this.y0Line;
        }

        @Override
        public float getOffset() {
            return this.yOffset;
        }

        @Override
        public float getScale7div() {
            return this.yScale;
        }

        @Override
        public GralColor getLineColor() {
            return this.lineColor;
        }

        @Override
        public void setTrackScale(float f, float f2, int n) {
            this.yScale = f;
            this.yOffset = f2;
            this.y0Line = n;
        }

        @Override
        public float getValueCursorLeft() {
            return this.getValueCursor(this.outer.xpCursor1);
        }

        @Override
        public float getValueCursorRight() {
            return this.getValueCursor(this.outer.xpCursor2);
        }

        private float getValueCursor(int n) {
            float f;
            if (n >= 0 && n < this.outer.ixDataShown.length) {
                try {
                    int n2 = this.outer.getIxDataFromPixelRight(n);
                    f = this.values[n2];
                }
                catch (Exception exception) {
                    f = 77777.7f;
                }
            } else {
                f = 777777.7f;
            }
            return f;
        }

        @Override
        public float getValueLast() {
            return 0.0f;
        }

        @Override
        public float getValueMin() {
            return 0.0f;
        }

        @Override
        public float getValueMax() {
            return 0.0f;
        }

        @Override
        public void setLineProperties(GralColor gralColor, int n, int n2) {
            this.lineColor = gralColor;
            this.lineWidth = n;
        }

        @Override
        public void setText(CharSequence charSequence) {
            System.err.println("GralCurveView - setText not supported; Widget = " + this.name + "; text=" + charSequence);
        }

        public String toString() {
            return "Track: " + this.name + "(" + this.sDataPath + "," + (this.variable != null ? this.variable.toString() : "variable = null") + ")";
        }
    }

    public class ZbnfSetCurve {
        public ZbnfSetTrack new_Track() {
            return new ZbnfSetTrack();
        }

        public void add_Track(ZbnfSetTrack zbnfSetTrack) {
            GralCurveView.this.initTrack(zbnfSetTrack.name, zbnfSetTrack.datapath, zbnfSetTrack.color_, zbnfSetTrack.style_, zbnfSetTrack.nullLine, zbnfSetTrack.scale, zbnfSetTrack.offset);
        }

        public void set_timeDatapath(String string) {
            GralCurveView.this.common.timeDatapath = string;
        }
    }

    public static class ZbnfSetTrack {
        public String name;
        public String datapath;
        GralColor color_;
        int style_ = 0;
        public int nullLine;
        public float scale;
        public float offset;

        public void set_color(String string) {
            this.color_ = GralColor.getColor(string.trim());
        }
    }

    public class CommonCurve {
        public boolean bFreeze = false;
        public VariableAccess_ifc timeVariable;
        public String timeDatapath;
    }
}

