/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.gral.base;

import org.vishia.gral.base.GralMng;
import org.vishia.gral.base.GralMouseWidgetAction_ifc;
import org.vishia.gral.base.GralWidgImpl_ifc;
import org.vishia.gral.base.GralWidget;
import org.vishia.gral.ifc.GralColor;
import org.vishia.gral.ifc.GralImageBase;
import org.vishia.gral.ifc.GralUserAction;

public class GralButton
extends GralWidget {
    public static final int version = 538051331;
    protected boolean pressed;
    protected State switchState;
    protected String sButtonTextOff;
    protected String sButtonTextOn;
    protected String sButtonTextDisabled;
    protected GralImageBase imageOff;
    protected GralImageBase imageOn;
    protected GralImageBase imageDisabled;
    protected GralColor colorBackOn;
    protected GralColor colorBackDisabled = GralColor.getColor("gr");
    protected GralColor colorLineOff = GralColor.getColor("bk");
    protected GralColor colorLineOn = GralColor.getColor("bk");
    protected GralColor colorLineDisabled = GralColor.getColor("lgr");
    protected boolean isPressed;
    protected boolean shouldSwitched;
    protected boolean bThreeStateSwitch;

    public GralButton(String string) {
        super(string, 'B');
    }

    public GralButton(String string, String string2, GralUserAction gralUserAction) {
        super(string, 'B');
        this.setText(string2);
        this.setActionChange(gralUserAction);
    }

    public void setSwitchMode(String string, String string2) {
        this.sButtonTextOn = string2;
        this.sButtonTextOff = string;
        this.shouldSwitched = true;
        this.bThreeStateSwitch = false;
    }

    public void setSwitchMode(String string, String string2, String string3) {
        this.sButtonTextOn = string2;
        this.sButtonTextOff = string;
        this.sButtonTextDisabled = string3;
        this.shouldSwitched = true;
        this.bThreeStateSwitch = true;
    }

    public void setSwitchMode(GralColor gralColor, GralColor gralColor2) {
        this.colorBackOn = gralColor2;
        this.dyda.backColor = gralColor;
        this.bThreeStateSwitch = false;
        this.shouldSwitched = true;
    }

    public void setSwitchMode(GralColor gralColor, GralColor gralColor2, GralColor gralColor3) {
        this.colorBackOn = gralColor2;
        this.dyda.backColor = gralColor;
        this.colorBackDisabled = gralColor3;
        this.bThreeStateSwitch = true;
        this.shouldSwitched = true;
    }

    public void setSwitchMode(GralImageBase gralImageBase, GralImageBase gralImageBase2) {
        this.imageOn = gralImageBase2;
        this.imageOff = gralImageBase;
        this.bThreeStateSwitch = false;
        this.shouldSwitched = true;
    }

    public void setSwitchMode(GralImageBase gralImageBase, GralImageBase gralImageBase2, GralImageBase gralImageBase3) {
        this.imageOn = gralImageBase2;
        this.imageOff = gralImageBase;
        this.imageDisabled = gralImageBase3;
        this.bThreeStateSwitch = true;
        this.shouldSwitched = true;
    }

    @Override
    public void setBackColor(GralColor gralColor, int n) {
        boolean bl;
        GralColor[] gralColorArray = new GralColor[1];
        switch (n) {
            case 0: {
                boolean bl2 = bl = !gralColor.equals(this.dyda.backColor);
                if (!bl) break;
                this.dyda.backColor = gralColor;
                break;
            }
            case 1: {
                boolean bl3 = bl = !gralColor.equals(this.colorBackOn);
                if (!bl) break;
                this.colorBackOn = gralColor;
                break;
            }
            case -1: 
            case 2: {
                boolean bl4 = bl = !gralColor.equals(this.colorBackDisabled);
                if (!bl) break;
                this.colorBackDisabled = gralColor;
                break;
            }
            default: {
                throw new IllegalArgumentException("fault ix, allowed -1, 0, 1, 2, ix=" + n);
            }
        }
        if (bl) {
            this.dyda.setChanged(2);
            this.repaint();
        }
    }

    public void setDisableColorText(GralColor gralColor, String string) {
        this.colorBackDisabled = gralColor;
        this.sButtonTextDisabled = string;
    }

    public void setText(String string) {
        this.sButtonTextOff = string;
        this.sButtonTextDisabled = string;
        this.sButtonTextOff = string;
        if (this.sButtonTextDisabled == null) {
            this.sButtonTextDisabled = string;
        }
        if (this.sButtonTextOn == null) {
            this.sButtonTextOn = string;
        }
        this.repaint(100, 100);
    }

    protected void setActivated(boolean bl) {
        this.isPressed = bl;
        this.repaint(100, 100);
    }

    @Override
    public void setValue(int n, int n2, Object object, Object object2) {
        if (object instanceof Integer) {
            int n3 = (Integer)object;
            if (this.shouldSwitched) {
                switch (n3) {
                    case 0: {
                        this.switchState = State.Off;
                        break;
                    }
                    case 1: {
                        this.switchState = State.On;
                        break;
                    }
                    default: {
                        this.switchState = State.Disabled;
                    }
                }
            }
        }
    }

    public void XXXsetDisabled(boolean bl) {
        this.switchState = bl ? State.Disabled : State.On;
        this.repaint(100, 100);
    }

    public boolean isDisabled() {
        return this.switchState == State.Disabled;
    }

    public boolean isOn() {
        return this.switchState == State.On;
    }

    public void setState(Object object) {
        if (object instanceof GralColor) {
            if (this.switchState == State.On) {
                this.colorBackOn = (GralColor)object;
            } else {
                this.dyda.backColor = (GralColor)object;
            }
        } else {
            int n;
            String string = object instanceof String ? (String)object : null;
            int n2 = n = object instanceof Integer ? (Integer)object : -1;
            if (string != null && (string.equals("1") || string.equals("true") || string.equals("on")) || string == null && n != 0) {
                this.switchState = State.On;
            } else if (string != null && (string.equals("0") || string.equals("false") || string.equals("off")) || n == 0) {
                this.switchState = State.Off;
            }
        }
        this.repaint(100, 100);
    }

    public void setState(State state) {
        this.switchState = state;
        this.repaint(100, 100);
    }

    public State getState() {
        return this.switchState;
    }

    public abstract class GraphicImplAccess
    extends GralWidget.ImplAccess
    implements GralWidgImpl_ifc {
        protected final GralMouseWidgetAction_ifc mouseWidgetAction;
        protected String sButtonText;
        protected GralColor colorgback;
        protected GralColor colorgline;

        protected GraphicImplAccess(GralWidget gralWidget, GralMng gralMng) {
            super(gralWidget, gralMng);
            this.mouseWidgetAction = new MouseActionButton();
        }

        protected boolean isPressed() {
            return GralButton.this.isPressed;
        }

        protected void prepareWidget() {
            int n;
            int n2 = 0;
            int n3 = 0;
            int n4 = -1;
            do {
                n = this.dyda().whatIsChanged.get() & ~n3;
                if (++n2 > 10000) {
                    throw new RuntimeException("atomic failed");
                }
                if ((n & 0x10000) != 0 && this.dyda().visibleInfo != null) {
                    n3 |= 0x10000;
                    if (this.dyda().visibleInfo instanceof Integer) {
                        n4 = (Integer)this.dyda().visibleInfo;
                    }
                }
                if ((n & 0x80000) == 0) continue;
                n3 |= 0x80000;
                n4 = 0;
            } while (!this.dyda().whatIsChanged.compareAndSet(n, 0));
            switch (n4) {
                case 0: {
                    GralButton.this.switchState = State.Off;
                    break;
                }
                case 1: {
                    GralButton.this.switchState = State.On;
                    break;
                }
                case 2: {
                    GralButton.this.switchState = State.Disabled;
                    break;
                }
            }
        }

        protected void paint1() {
            if (GralButton.this.switchState == State.On) {
                this.sButtonText = GralButton.this.sButtonTextOn != null ? GralButton.this.sButtonTextOn : GralButton.this.sButtonTextOff;
                this.colorgback = GralButton.this.colorBackOn != null ? GralButton.this.colorBackOn : this.dyda().backColor;
                this.colorgline = GralButton.this.colorLineOn != null ? GralButton.this.colorLineOn : GralButton.this.colorLineOff;
            } else if (GralButton.this.switchState == State.Disabled) {
                this.sButtonText = GralButton.this.sButtonTextDisabled;
                this.colorgback = GralButton.this.colorBackDisabled;
                this.colorgline = GralButton.this.colorLineDisabled;
            } else {
                this.sButtonText = GralButton.this.sButtonTextOff;
                this.colorgback = this.dyda().backColor;
                this.colorgline = GralButton.this.colorLineOff;
            }
        }
    }

    class MouseActionButton
    implements GralMouseWidgetAction_ifc {
        MouseActionButton() {
        }

        @Override
        public boolean mouseMoved(int n, int n2, int n3, int n4) {
            if (n < 0 || n > n3 || n2 < 0 || n2 > n4) {
                GralButton.this.setActivated(false);
                return false;
            }
            return true;
        }

        @Override
        public void mouse1Down(int n, int n2, int n3, int n4, int n5, GralWidget gralWidget) {
            GralButton.this.setActivated(true);
            if (gralWidget.actionChanging != null) {
                gralWidget.actionChanging.exec(n, gralWidget, new Integer(n2), new Integer(n3));
            }
        }

        @Override
        public void mouse1Up(int n, int n2, int n3, int n4, int n5, GralWidget gralWidget) {
            GralButton.this.setActivated(false);
            if (GralButton.this.shouldSwitched) {
                GralButton.this.switchState = GralButton.this.switchState == State.On ? State.Off : (GralButton.this.bThreeStateSwitch && GralButton.this.switchState == State.Off ? State.Disabled : State.On);
            }
            if (gralWidget.actionChanging != null) {
                gralWidget.actionChanging.exec(n, gralWidget, new Integer(n2), new Integer(n3));
            }
            gralWidget.repaint(100, 200);
        }

        @Override
        public void mouse2Down(int n, int n2, int n3, int n4, int n5, GralWidget gralWidget) {
            if (gralWidget.actionChanging != null) {
                gralWidget.actionChanging.exec(n, gralWidget, new Integer(n2), new Integer(n3));
            }
        }

        @Override
        public void mouse2Up(int n, int n2, int n3, int n4, int n5, GralWidget gralWidget) {
            if (gralWidget.actionChanging != null) {
                gralWidget.actionChanging.exec(n, gralWidget, new Integer(n2), new Integer(n3));
            }
        }

        @Override
        public void mouse1Double(int n, int n2, int n3, int n4, int n5, GralWidget gralWidget) {
            if (gralWidget.actionChanging != null) {
                gralWidget.actionChanging.exec(n, gralWidget, new Integer(n2), new Integer(n3));
            }
        }
    }

    public static enum State {
        On,
        Off,
        Disabled;

    }
}

