/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.gral.area9;

import java.io.File;
import java.io.IOException;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.vishia.gral.area9.GralArea9_ifc;
import org.vishia.gral.base.GralGraphicTimeOrder;
import org.vishia.gral.base.GralMenu;
import org.vishia.gral.base.GralMng;
import org.vishia.gral.base.GralPanelContent;
import org.vishia.gral.base.GralTextBox;
import org.vishia.gral.base.GralWidget;
import org.vishia.gral.base.GralWindow;
import org.vishia.gral.ifc.GralFileDialog_ifc;
import org.vishia.gral.ifc.GralRectangle;
import org.vishia.gral.ifc.GralTextBox_ifc;
import org.vishia.gral.ifc.GralUserAction;
import org.vishia.gral.ifc.GralWindow_ifc;
import org.vishia.gral.widget.GralInfoBox;
import org.vishia.mainCmd.MainCmd;
import org.vishia.mainCmd.MainCmd_ifc;

public class GralArea9Window
implements GralArea9_ifc {
    public static final int version = 538051331;
    public final MainCmd mainCmd;
    protected final GralWindow window;
    protected String outputArea;
    protected GralPanelContent outputPanel;
    public GralTextBox outputBox;
    public GralInfoBox infoHelp;
    public GralInfoBox infoAbout;
    public GralInfoBox infoBox;
    public GralInfoBox infoLog;
    protected File currentDirectory = null;
    protected GralUserAction actionFile;
    protected boolean bSetStandardMenus;
    protected Queue<String> outputTexts = new ConcurrentLinkedQueue<String>();
    protected GralPanelContent[][] componentFrameArea = new GralPanelContent[3][3];
    protected byte[] xpFrameArea = new byte[4];
    protected byte[] ypFrameArea = new byte[4];
    protected byte[][][] dxyFrameArea = new byte[3][3][2];
    private final short[] xMinGralSize = new short[3];
    private final short[] yMinGralSize = new short[3];
    private final short[] xMaxGralSize = new short[3];
    private final short[] yMaxGralSize = new short[3];
    private final int[] xPixArea = new int[4];
    private final int[] yPixArea = new int[4];
    protected float pixelPerXpercent = 1.0f;
    protected float pixelPerYpercent = 1.0f;
    protected final StringBuffer XXXsbWriteInfo = new StringBuffer(1000);
    protected GralTextBox_ifc textAreaOutput = null;
    private String sHelpBase;
    GralGraphicTimeOrder initGraphic = new GralGraphicTimeOrder("GralArea9Window.initGraphic"){

        public void executeOrder() {
            GralArea9Window.this.window.setResizeAction(GralArea9Window.this.resizeAction);
            GralArea9Window.this.setFrameAreaBorders(30, 70, 30, 70);
            if (GralArea9Window.this.bSetStandardMenus) {
                // empty if block
            }
            GralArea9Window.this.window.gralMng().setPosition(-40.0f, 0.0f, 10.0f, 0.0f, 0, 'd');
            GralArea9Window.this.infoBox = GralArea9Window.this.window.gralMng().createTextInfoBox("infoBox", "Info");
            GralArea9Window.this.window.gralMng().selectPanel("primaryWindow");
            GralArea9Window.this.window.gralMng().setPosition(0.0f, 40.0f, 10.0f, 0.0f, 0, '.');
            GralArea9Window.this.infoHelp = GralInfoBox.createHtmlInfoBox(null, "Help", "Help", true);
            try {
                for (String string : GralArea9Window.this.mainCmd.listHelpInfo) {
                    GralArea9Window.this.infoHelp.append(string).append("\n");
                }
            }
            catch (Exception exception) {
                GralArea9Window.this.window.gralMng().writeLog(0, exception);
            }
            GralArea9Window.this.window.gralMng().selectPanel("primaryWindow");
            GralArea9Window.this.window.gralMng().setPosition(0.0f, 20.0f, 15.0f, 16434.0f, 0, '.');
            GralArea9Window.this.infoAbout = GralArea9Window.this.window.gralMng().createTextInfoBox("About", "About");
            try {
                for (String string : GralArea9Window.this.mainCmd.listAboutInfo) {
                    GralArea9Window.this.infoAbout.append(string).append("\n");
                }
            }
            catch (Exception exception) {
                GralArea9Window.this.window.gralMng().writeLog(0, exception);
            }
            if (GralArea9Window.this.outputArea != null) {
                GralArea9Window.this.outputPanel = GralArea9Window.this.addOutputFrameArea(GralArea9Window.this.outputArea);
                GralArea9Window.this.window.gralMng().registerPanel(GralArea9Window.this.outputPanel);
            }
        }
    };
    private final GralGraphicTimeOrder writeOutputTextDirectly = new GralGraphicTimeOrder("GralArea9Window.writeOutputTextDirectly"){

        public void executeOrder() {
            String string;
            while ((string = GralArea9Window.this.outputTexts.poll()) != null) {
                GralArea9Window.this.writeDirectly(string, (short)3);
            }
        }
    };
    private final GralUserAction mouseAction = new GralUserAction("mouseAction"){
        int captureAreaDivider;

        @Override
        public boolean userActionGui(int n, GralWidget gralWidget, Object ... objectArray) {
            GralRectangle gralRectangle = (GralRectangle)objectArray[0];
            byte by = GralArea9Window.this.ypFrameArea[1];
            byte by2 = GralArea9Window.this.ypFrameArea[2];
            byte by3 = GralArea9Window.this.xpFrameArea[1];
            byte by4 = GralArea9Window.this.xpFrameArea[2];
            if (gralRectangle.x < 20) {
                int n2 = (int)((float)by * GralArea9Window.this.pixelPerYpercent);
                int n3 = (int)((float)by * GralArea9Window.this.pixelPerYpercent);
                if (gralRectangle.y > n2 - 20 && gralRectangle.y < n2 + 20) {
                    this.captureAreaDivider = 1;
                }
            }
            return true;
        }
    };
    private final GralUserAction resizeAction = new GralUserAction("resizeAction"){

        @Override
        public boolean userActionGui(int n, GralWidget gralWidget, Object ... objectArray) {
            GralArea9Window.this.validateFrameAreas();
            return true;
        }
    };
    private final GralUserAction actionHelp = new GralUserAction("actionHelp"){

        @Override
        public boolean userActionGui(int n, GralWidget gralWidget, Object ... objectArray) {
            GralArea9Window.this.infoHelp.activate();
            GralArea9Window.this.infoHelp.setWindowVisible(true);
            return true;
        }
    };
    private final GralUserAction actionAbout = new GralUserAction("actionAbout"){

        @Override
        public boolean userActionGui(int n, GralWidget gralWidget, Object ... objectArray) {
            try {
                for (String string : GralArea9Window.this.mainCmd.listAboutInfo) {
                }
            }
            catch (Exception exception) {
                GralArea9Window.this.window.gralMng().writeLog(0, exception);
            }
            GralArea9Window.this.infoAbout.setWindowVisible(true);
            return true;
        }
    };

    public void XXXsetOutputArea(String string) {
        this.outputArea = string;
    }

    public GralArea9Window(MainCmd mainCmd, GralWindow gralWindow) {
        this.mainCmd = mainCmd;
        this.window = gralWindow;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.xMinGralSize[i] = 4;
                this.yMinGralSize[j] = 4;
                this.xMaxGralSize[i] = Short.MAX_VALUE;
                this.yMaxGralSize[j] = Short.MAX_VALUE;
            }
        }
    }

    @Override
    public void initGraphic(String string) {
        this.outputArea = string;
        this.window.gralMng().gralDevice.addDispatchOrder(this.initGraphic);
        this.initGraphic.awaitExecution(1, 0);
        this.window.gralMng().gralDevice.addDispatchOrder(this.writeOutputTextDirectly);
    }

    @Override
    public MainCmd_ifc getMainCmd() {
        return this.mainCmd;
    }

    @Override
    public GralWindow_ifc mainWindow() {
        return this.window;
    }

    @Override
    public GralPanelContent getOutputPanel() {
        return this.outputPanel;
    }

    @Override
    public GralTextBox getOutputBox() {
        return this.outputBox;
    }

    @Override
    public void setFrameAreaBorders(int n, int n2, int n3, int n4) {
        this.xpFrameArea[0] = 0;
        this.xpFrameArea[1] = (byte)n;
        this.xpFrameArea[2] = (byte)n2;
        this.xpFrameArea[3] = 100;
        this.ypFrameArea[0] = 0;
        this.ypFrameArea[1] = (byte)n3;
        this.ypFrameArea[2] = (byte)n4;
        this.ypFrameArea[3] = 100;
        this.validateFrameAreas();
    }

    @Override
    public void addFrameArea(String string, GralPanelContent gralPanelContent) throws IndexOutOfBoundsException {
        GralRectangle gralRectangle = this.convertArea(string);
        this.addFrameArea(gralRectangle.x, gralRectangle.y, gralRectangle.dx, gralRectangle.dy, gralPanelContent);
    }

    @Override
    public final void addFrameArea(int n, int n2, int n3, int n4, GralPanelContent gralPanelContent) throws IndexOutOfBoundsException {
        int n5;
        int n6;
        if (n < 1 || n > this.componentFrameArea[0].length || n3 < 1 || n + n3 - 2 > this.componentFrameArea[0].length || n2 < 1 || n2 > this.componentFrameArea.length || n4 < 1 || n2 + n4 - 1 > this.componentFrameArea.length) {
            throw new IndexOutOfBoundsException("failed argument");
        }
        for (n6 = n - 1; n6 <= n + n3 - 2; ++n6) {
            for (n5 = n2 - 1; n5 <= n2 + n4 - 2; ++n5) {
                if (this.dxyFrameArea[n5][n6][0] == 0) continue;
                throw new IndexOutOfBoundsException("area occupied already");
            }
        }
        for (n6 = n - 1; n6 <= n + n3 - 2; ++n6) {
            for (n5 = n2 - 1; n5 <= n2 + n4 - 2; ++n5) {
                this.dxyFrameArea[n5][n6][0] = -1;
            }
        }
        this.dxyFrameArea[n2 - 1][n - 1][0] = (byte)n3;
        this.dxyFrameArea[n2 - 1][n - 1][1] = (byte)n4;
        this.componentFrameArea[n2 - 1][n - 1] = gralPanelContent;
        this.validateFrameAreas();
    }

    @Override
    public void setMinMaxSizeArea(String string, int n, int n2, int n3, int n4) throws IndexOutOfBoundsException {
        GralRectangle gralRectangle = this.convertArea(string);
        this.yMinGralSize[gralRectangle.y - 1] = (short)n;
        this.yMaxGralSize[gralRectangle.y - 1] = (short)(n2 <= 0 ? Short.MAX_VALUE : (short)n2);
        this.xMinGralSize[gralRectangle.x - 1] = (short)n3;
        this.xMaxGralSize[gralRectangle.x - 1] = (short)(n4 <= 0 ? Short.MAX_VALUE : (short)n4);
        this.validateFrameAreas();
    }

    protected void validateFrameAreas() {
        GralRectangle gralRectangle = this.window.getPixelPositionSize();
        int n = gralRectangle.dx;
        int n2 = gralRectangle.dy;
        this.pixelPerXpercent = (float)n / 100.0f;
        this.pixelPerYpercent = (float)n2 / 100.0f;
        int n3 = this.window.gralMng().propertiesGui().xPixelUnit();
        int n4 = this.window.gralMng().propertiesGui().yPixelUnit();
        this.pixelPerXpercent = (float)n / 100.0f;
        this.pixelPerYpercent = (float)n2 / 100.0f;
        this.calcPixSize(this.xPixArea, this.xpFrameArea, this.xMinGralSize, this.xMaxGralSize, n3, n, this.pixelPerXpercent);
        this.calcPixSize(this.yPixArea, this.ypFrameArea, this.yMinGralSize, this.yMaxGralSize, n4, n2, this.pixelPerYpercent);
        for (int i = 0; i <= 2; ++i) {
            for (int j = 0; j <= 2; ++j) {
                GralPanelContent gralPanelContent = this.componentFrameArea[j][i];
                if (gralPanelContent == null) continue;
                int n5 = this.xPixArea[i];
                byte by = this.dxyFrameArea[j][i][0];
                int n6 = this.xPixArea[i + by];
                int n7 = n6 - n5;
                int n8 = this.yPixArea[j];
                byte by2 = this.dxyFrameArea[j][i][1];
                int n9 = this.yPixArea[j + by2];
                int n10 = n9 - n8;
                GralPanelContent gralPanelContent2 = this.componentFrameArea[j][i];
                gralPanelContent2.setBoundsPixel(n5, n8, n7, n10);
                gralPanelContent2.repaint();
            }
        }
    }

    private void calcPixSize(int[] nArray, byte[] byArray, short[] sArray, short[] sArray2, int n, int n2, float f) {
        block11: {
            block9: {
                int n3;
                int n4;
                block10: {
                    int n5 = sArray[0] + sArray[1] + sArray[2];
                    nArray[0] = 0;
                    if (n2 < n * n5) break block9;
                    n4 = 0;
                    for (n3 = 1; n3 < 4; ++n3) {
                        int n6 = (int)((float)byArray[n3] * f);
                        if (n6 - n4 > sArray2[n3 - 1] * n) {
                            n6 = n4 + sArray2[n3 - 1] * n;
                        } else if (n6 - n4 < sArray[n3 - 1] * n) {
                            n6 = n4 + sArray[n3 - 1] * n;
                        }
                        nArray[n3] = n4 = n6;
                    }
                    if (nArray[3] >= n2) break block10;
                    nArray[3] = n4 = n2;
                    for (n3 = 2; n3 >= 0; --n3) {
                        if (n4 - nArray[n3] > sArray2[n3] * n) {
                            nArray[n3] = n4 - sArray2[n3] * n;
                        }
                        n4 = nArray[n3];
                    }
                    break block11;
                }
                if (nArray[3] <= n2) break block11;
                nArray[3] = n4 = n2;
                for (n3 = 2; n3 >= 0; --n3) {
                    if (n4 - nArray[n3] < sArray[n3] * n) {
                        nArray[n3] = n4 - sArray[n3] * n;
                    }
                    n4 = nArray[n3];
                }
                break block11;
            }
            for (int i = 0; i < 3; ++i) {
                nArray[i] = (int)((float)byArray[i] * f);
            }
        }
    }

    private void setBoundsForFrameArea(int n, int n2) {
        GralRectangle gralRectangle = this.window.getPixelPositionSize();
        int n3 = gralRectangle.dx - 6;
        int n4 = gralRectangle.dy - 53;
        this.pixelPerXpercent = (float)n3 / 100.0f;
        this.pixelPerYpercent = (float)n4 / 100.0f;
        byte by = this.xpFrameArea[n];
        byte by2 = this.ypFrameArea[n2];
        byte by3 = this.dxyFrameArea[n2][n][0];
        byte by4 = this.dxyFrameArea[n2][n][1];
        byte by5 = this.xpFrameArea[n + by3];
        byte by6 = this.ypFrameArea[n2 + by4];
        int n5 = (int)((float)by * this.pixelPerXpercent);
        int n6 = (int)((float)by2 * this.pixelPerYpercent);
        int n7 = (int)((float)(by5 - by) * this.pixelPerXpercent);
        int n8 = (int)((float)(by6 - by2) * this.pixelPerYpercent);
        int n9 = this.window.gralMng().propertiesGui().xPixelUnit();
        int n10 = this.window.gralMng().propertiesGui().yPixelUnit();
        int n11 = n9 * this.xMaxGralSize[n];
        int n12 = n9 * this.xMinGralSize[n];
        int n13 = n9 * this.yMaxGralSize[n2];
        int n14 = n9 * this.yMinGralSize[n2];
        GralPanelContent gralPanelContent = this.componentFrameArea[n2][n];
        gralPanelContent.setBoundsPixel(n5, n6, n7, n8);
        gralPanelContent.repaint();
    }

    protected GralRectangle convertArea(String string) {
        int n;
        int n2;
        int n3;
        int n4 = "ABC".indexOf(string.charAt(0));
        if (n4 < 0) {
            n4 = "ABC".indexOf(string.charAt(1));
        }
        if ((n3 = "123".indexOf(string.charAt(0))) < 0) {
            n3 = "123".indexOf(string.charAt(1));
        }
        if (string.length() >= 2) {
            n2 = "ABC".indexOf(string.charAt(2));
            if (n2 < 0) {
                n2 = "ABC".indexOf(string.charAt(3));
            }
            if ((n = "123".indexOf(string.charAt(2))) < 0) {
                n = "123".indexOf(string.charAt(3));
            }
        } else {
            n2 = n4;
            n = n3;
        }
        GralRectangle gralRectangle = new GralRectangle(n4 + 1, n3 + 1, n2 - n4 + 1, n - n3 + 1);
        return gralRectangle;
    }

    public final void setStandardMenus(File file, GralUserAction gralUserAction) {
        this.currentDirectory = file;
        this.actionFile = gralUserAction;
        this.bSetStandardMenus = true;
    }

    @Override
    public final void setStandardMenusGThread(File file, GralUserAction gralUserAction) {
        this.currentDirectory = file;
        this.actionFile = gralUserAction;
        this.window.addMenuBarItemGThread("menuFileOpen", "&File/&Open", new GralActionFileOpen());
        this.window.addMenuBarItemGThread("menuFileSave", "&File/&Save", gralUserAction);
        this.window.repaint();
    }

    @Override
    @Deprecated
    public void addMenuBarArea9ItemGThread(String string, String string2, GralUserAction gralUserAction) {
        this.window.addMenuBarItemGThread(string, string2, gralUserAction);
    }

    @Override
    public GralMenu getMenuBar() {
        return this.window.getMenuBar();
    }

    @Override
    public void setFullScreen(boolean bl) {
        this.window.setFullScreen(bl);
    }

    protected GralPanelContent addOutputFrameArea(String string) {
        GralRectangle gralRectangle = this.convertArea(string);
        this.window.gralMng().selectPanel("primaryWindow");
        GralPanelContent gralPanelContent = this.window.gralMng().createCompositeBox("outputArea");
        this.window.gralMng().setPosition(0.0f, 0.0f, 0.0f, 0.0f, 0, 'b');
        this.outputBox = this.window.gralMng().addTextBox("output", true, null, '.');
        try {
            this.outputBox.append("output...\n");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.addFrameArea(gralRectangle.x, gralRectangle.y, gralRectangle.dx, gralRectangle.dy, gralPanelContent);
        return gralPanelContent;
    }

    protected void writeDirectly(String string, short s) {
        if (this.textAreaOutput != null) {
            if (Thread.currentThread().getId() == this.window.gralMng().gralDevice.getThreadIdGui()) {
                try {
                    if ((s & 2) != 0) {
                        this.textAreaOutput.append("\n");
                    }
                    this.textAreaOutput.append(string);
                    int n = this.textAreaOutput.getNrofLines();
                    this.textAreaOutput.viewTrail();
                    this.textAreaOutput.repaint(100, 500);
                }
                catch (IOException iOException) {
                    this.getGralMng().writeLog(0, iOException);
                }
            } else {
                this.outputTexts.add(string);
                this.window.gralMng().gralDevice.wakeup();
            }
        } else {
            this.mainCmd.writeDirectly(string, s);
        }
    }

    @Override
    public void setHelpBase(String string) {
        this.sHelpBase = string;
    }

    @Override
    public void setHelpUrl(String string) {
        String string2 = string.startsWith("+") ? this.sHelpBase + string.substring(1) : string;
        if (this.infoHelp != null) {
            this.infoHelp.setUrl(string2);
        }
    }

    @Override
    public GralMng getGralMng() {
        return this.window.gralMng();
    }

    @Override
    public GralUserAction getActionAbout() {
        return this.actionAbout;
    }

    @Override
    public GralUserAction getActionHelp() {
        return this.actionHelp;
    }

    protected class GralActionFileOpen
    extends GralUserAction {
        private final GralFileDialog_ifc fileDialog;

        public GralActionFileOpen() {
            super("GralActionFileOpen");
            this.fileDialog = GralArea9Window.this.window.gralMng().createFileDialog();
            this.fileDialog.open("FileDialog", 0);
        }

        @Override
        public boolean userActionGui(int n, GralWidget gralWidget, Object ... objectArray) {
            this.fileDialog.show("d:/vishia", "", "*.*", "select");
            return true;
        }
    }
}

