/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.communication;

import org.vishia.byteData.ByteDataAccessBase;
import org.vishia.util.Java4C;

public final class InspcDataExchangeAccess {
    public static final int version = 20120409;
    public static final int maxNrOfChars = 200;
    public static final int kReferenceAddr = 223;
    public static final int kTypeNoValue = 222;
    public static final int kInvalidIndex = 221;
    public static final int kScalarTypes = 224;

    @Java4C.ExtendsOnlyMethods
    public static final class InspcSetValueData
    extends Inspcitem {
        public static final int sizeofElement = 32;

        public InspcSetValueData() {
            super(32);
            this.setBigEndian(true);
        }

        @Java4C.Inline
        public final void setAddress(int n) {
            this._setLong(8, 4, n);
        }

        @Java4C.Inline
        public final void setPosition(int n) {
            this._setLong(12, 4, n);
        }

        public final void setBool(int n) {
            InspcSetValue inspcSetValue = new InspcSetValue();
            this.addChildAt(16, inspcSetValue);
            inspcSetValue.setBool((byte)n);
        }

        public final void setShort(int n) {
            InspcSetValue inspcSetValue = new InspcSetValue();
            this.addChildAt(16, inspcSetValue);
            inspcSetValue.setShort((short)n);
        }

        public final void setByte(int n) {
            InspcSetValue inspcSetValue = new InspcSetValue();
            this.addChildAt(16, inspcSetValue);
            inspcSetValue.setByte((byte)n);
        }

        public final void setInt(int n) {
            InspcSetValue inspcSetValue = new InspcSetValue();
            this.addChildAt(16, inspcSetValue);
            inspcSetValue.setInt(n);
        }

        public final void setFloat(float f) {
            InspcSetValue inspcSetValue = new InspcSetValue();
            this.addChildAt(16, inspcSetValue);
            inspcSetValue.setFloat(f);
        }

        public final void setFloatIntImage(int n) {
            InspcSetValue inspcSetValue = new InspcSetValue();
            this.addChildAt(16, inspcSetValue);
            inspcSetValue.setFloatIntImage(n);
        }

        public final void setDouble(double d) {
            InspcSetValue inspcSetValue = new InspcSetValue();
            this.addChildAt(16, inspcSetValue);
            inspcSetValue.setDouble(d);
        }

        public final void setLong(long l) {
            InspcSetValue inspcSetValue = new InspcSetValue();
            this.addChildAt(16, inspcSetValue);
            inspcSetValue.setLong(l);
        }

        @Java4C.Inline
        public final void setHead(int n) {
            super.setInfoHead(32, 80, n);
        }
    }

    @Java4C.ExtendsOnlyMethods
    public static final class InspcSetValue
    extends ByteDataAccessBase {
        public static final int sizeofElement = 16;
        private static final int kType = 7;

        public InspcSetValue() {
            super(16);
            this.setBigEndian(true);
        }

        @Java4C.Inline
        public final long getPwd() {
            return this._getLong(0, 6);
        }

        @Java4C.Inline
        public final void setPwd(int n) {
            this._setLong(0, 6, n);
        }

        @Java4C.Inline
        public final byte getType() {
            return (byte)this._getLong(7, 1);
        }

        @Java4C.Inline
        public final byte getByte() {
            return (byte)this._getLong(15, -1);
        }

        @Java4C.Inline
        public final short getShort() {
            return (short)this._getLong(14, -2);
        }

        @Java4C.Inline
        public final int getInt() {
            return (int)this._getLong(12, -4);
        }

        @Java4C.Inline
        public final long getLong() {
            return this._getLong(8, -8);
        }

        @Java4C.Inline
        public final float getFloat() {
            return this.getFloat(8);
        }

        @Java4C.Inline
        public final double getDouble() {
            return this.getDouble(8);
        }

        @Java4C.Inline
        public final void setBool(int n) {
            this.clearData();
            this._setLong(7, 1, 246L);
            this._setLong(15, 1, n);
        }

        @Java4C.Inline
        public final void setByte(int n) {
            this.clearData();
            this._setLong(7, 1, 232L);
            this._setLong(15, 1, n);
        }

        @Java4C.Inline
        public final void setShort(int n) {
            this.clearData();
            this._setLong(7, 1, 230L);
            this._setLong(14, 2, n);
        }

        @Java4C.Inline
        public final void setInt(int n) {
            this.clearData();
            this._setLong(7, 1, 228L);
            this._setLong(12, 4, n);
        }

        @Java4C.Inline
        public final void setLong(long l) {
            this.clearData();
            this._setLong(7, 1, 226L);
            this._setLong(8, 8, l);
        }

        @Java4C.Inline
        public final void setFloat(float f) {
            this.clearData();
            this._setLong(7, 1, 236L);
            this.setFloat(12, f);
        }

        @Java4C.Inline
        public final void setFloatIntImage(int n) {
            this.clearData();
            this._setLong(7, 1, 236L);
            this._setLong(12, 4, n);
        }

        @Java4C.Inline
        public final void setDouble(double d) {
            this.clearData();
            this._setLong(7, 1, 237L);
            this.setDouble(8, d);
        }
    }

    public static class Inspcitem
    extends ByteDataAccessBase {
        private static final int kbyteOrder = 4;
        public static final int sizeofHead = 8;
        public static final int kGetFields = 16;
        public static final int kAnswerFieldMethod = 20;
        public static final int kRegisterRepeat = 35;
        public static final int kAnswerRegisterRepeat = 291;
        public static final int kFailedRegisterRepeat = 292;
        public static final int kGetValueByIndex = 37;
        public static final int kAnswerValueByIndex = 293;
        public static final int kAnswerValue = 38;
        public static final int kFailedValue = 39;
        public static final int kGetValueByPath = 48;
        public static final int kGetAddressByPath = 50;
        public static final int kSetValueByPath = 53;
        public static final int kSetStringByPath = 54;
        public static final int kGetMsg = 64;
        public static final int kAnswerMsg = 320;
        public static final int kRemoveMsg = 65;
        public static final int kAnswerRemoveMsgOk = 321;
        public static final int kAnswerRemoveMsgNok = 577;
        public static final int kSetvaluedata = 80;
        public static final int kAnswervaluedata = 336;
        public static final int kFailedPath = 254;
        public static final int kNoRessource = 253;
        public static final int kFailedCommand = 255;

        public Inspcitem(int n) {
            super(8, n);
        }

        public Inspcitem() {
            super(8);
        }

        public final void setInfoHead(int n, int n2, int n3) {
            this.setInt16(0, n);
            this.setInt16(2, n2);
            this.setInt32(4, n3);
            int n4 = n >= 8 ? n : 8;
            this.setLengthElement(n4);
        }

        @Java4C.Inline
        public final void setLength(int n) {
            this.setInt16(0, n);
            this.setLengthElement(n);
        }

        @Java4C.Inline
        public final void setCmd(int n) {
            this.setInt16(2, n);
        }

        @Java4C.Inline
        public final int getCmd() {
            return this.getInt16(2);
        }

        @Java4C.Inline
        public final int getLenInfo() {
            return this.getInt16(0);
        }

        @Java4C.Inline
        public final int getOrder() {
            return this.getInt32(4);
        }
    }

    public static final class InspcDatagram
    extends ByteDataAccessBase {
        private static final int knrofBytes = 0;
        private static final int knEntrant = 2;
        private static final int kencryption = 4;
        private static final int kseqnr = 8;
        private static final int kanswerNr = 12;
        private static final int kspare13 = 13;
        private static final int kspare14 = 14;
        public static final int sizeofHead = 16;

        public InspcDatagram(@Java4C.PtrVal byte[] byArray) {
            super(16);
            this.assign(byArray, -1, 0);
            super.setBigEndian(true);
        }

        public InspcDatagram() {
            super(16);
            this.setBigEndian(true);
        }

        @Java4C.Inline
        public final void assignDatagram(@Java4C.PtrVal byte[] byArray, int n) {
            super.assign(byArray, n, 0);
        }

        @Java4C.Inline
        public final void setLengthDatagram(int n) {
            this.setInt16(0, n);
        }

        @Java4C.Inline
        public final int getLengthDatagram() {
            return this.getInt16(0);
        }

        public final void setHeadRequest(int n, int n2, int n3) {
            this.setInt16(0, 16);
            this.setInt16(2, n);
            this.setInt32(8, n2);
            this.setInt8(12, 0);
            this.setInt8(13, 0);
            this.setInt16(14, 0);
            this.setInt32(4, n3);
        }

        public final void setHeadAnswer(int n, int n2, int n3) {
            this.setInt16(0, 16);
            this.setInt16(2, n);
            this.setInt32(8, n2);
            this.setInt8(12, 1);
            this.setInt8(13, 0);
            this.setInt16(14, 0);
            this.setInt32(4, n3);
        }

        @Java4C.Inline
        public final void setEntrant(int n) {
            this.setInt16(2, n);
        }

        @Java4C.Inline
        public final int getEntrant() {
            return this.getInt16(2);
        }

        @Java4C.Inline
        public final int getEncryption() {
            return this.getInt32(4);
        }

        @Java4C.Inline
        public final void setSeqnr(int n) {
            this.setInt32(8, n);
        }

        @Java4C.Inline
        public final int getSeqnr() {
            return this.getInt32(8);
        }

        public final void markAnswerNrLast() {
            int n = this.getInt8(12);
            this.setInt8(12, n |= 0x80);
        }

        public final void incrAnswerNr() {
            int n = this.getInt8(12);
            n = (n & 0x7F) + 1;
            assert ((n & 0x80) == 0);
            this.setInt8(12, n);
        }

        @Java4C.Inline
        public final int getAnswerNr() {
            return this.getInt8(12) & 0x7F;
        }

        @Java4C.Inline
        public final boolean lastAnswer() {
            return (this.getInt8(12) & 0x80) == 128;
        }
    }
}

