/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.commander;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import org.vishia.commander.Fcmd;
import org.vishia.fileRemote.FileRemote;
import org.vishia.gral.base.GralButton;
import org.vishia.gral.base.GralTextBox;
import org.vishia.gral.base.GralTextField;
import org.vishia.gral.base.GralWidget;
import org.vishia.gral.base.GralWindow;
import org.vishia.gral.ifc.GralColor;
import org.vishia.gral.ifc.GralTextFieldUser_ifc;
import org.vishia.gral.ifc.GralUserAction;
import org.vishia.gral.ifc.GralWidget_ifc;
import org.vishia.gral.ifc.GralWindow_ifc;
import org.vishia.util.KeyCode;
import org.vishia.util.StringFormatter;

public class FcmdView {
    protected final Fcmd main;
    private GralWindow_ifc windView;
    private GralTextBox widgContent;
    private GralTextField widgFindText;
    private GralTextField widgShowInfo;
    private GralButton btnFind;
    private GralButton btnWholeword;
    private GralButton btnCase;
    private GralButton btnQuickview;
    boolean bVisible;
    boolean bEditable;
    int nrQuickview;
    private GralTextBox widgQuickView;
    FileRemote file;
    private final ByteBuffer tmpReadTransmissionBuffer = ByteBuffer.allocate(1200);
    private int zContent;
    private final byte[] uContent = new byte[10000000];
    private Charset encodingContent;
    private char format = (char)116;
    private int cursorPos;
    private static Charset ascii7 = Charset.forName("US-ASCII");
    private static Charset utf8 = Charset.forName("UTF8");
    private static Charset iso8859_1 = Charset.forName("ISO-8859-1");
    private static byte[] endl_0a = new byte[]{10};
    private static byte[] endl_0d0a = new byte[]{13, 10};
    private final StringFormatter formatterHex = new StringFormatter(120);
    GralUserAction actionQuickView = new GralUserAction("quick view"){

        @Override
        public boolean exec(int n, GralWidget_ifc gralWidget_ifc, Object ... objectArray) {
            if (KeyCode.isControlFunctionMouseUpOrMenu((int)n)) {
                FcmdView.this.openQuickView(null);
                return true;
            }
            return false;
        }
    };
    GralUserAction actionFind = new GralUserAction("actionFind"){

        @Override
        public boolean userActionGui(int n, GralWidget gralWidget, Object ... objectArray) {
            if (KeyCode.isControlFunctionMouseUpOrMenu((int)n)) {
                int n2;
                String string;
                String string2 = FcmdView.this.widgContent.getText();
                int n3 = string2.indexOf(string = FcmdView.this.widgFindText.getText(), (n2 = FcmdView.this.widgContent.getCursorPos()) + 1);
                if (n3 > 0) {
                    FcmdView.this.widgContent.setCursorPos(n3);
                }
                return true;
            }
            return false;
        }
    };
    GralUserAction actionOpenView = new GralUserAction("actionOpenView"){

        @Override
        public boolean userActionGui(int n, GralWidget gralWidget, Object ... objectArray) {
            if (KeyCode.isControlFunctionMouseUpOrMenu((int)n)) {
                FcmdView.this.btnQuickview.setState(GralButton.State.On);
                FcmdView.this.view(null);
                return true;
            }
            return false;
        }
    };
    GralUserAction actionSetTextViewUTF8 = new GralUserAction("actionSetTextViewUTF8"){

        @Override
        public boolean userActionGui(int n, GralWidget gralWidget, Object ... objectArray) {
            if (n != 720964) {
                try {
                    FcmdView.this.format = '?';
                    FcmdView.this.presentContentText(utf8);
                    FcmdView.this.format = 'u';
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    System.err.println("FcmdView.actionSetTextViewUTF8 - UnsupportedEncodingException; unexpected");
                }
                return true;
            }
            return false;
        }
    };
    GralUserAction actionSetHexView = new GralUserAction("actionSetHexView"){

        @Override
        public boolean userActionGui(int n, GralWidget gralWidget, Object ... objectArray) {
            if (KeyCode.isControlFunctionMouseUpOrMenu((int)n)) {
                try {
                    FcmdView.this.syncContentFromWidg();
                    FcmdView.this.format = '?';
                    FcmdView.this.presentContentHex();
                    FcmdView.this.format = 'h';
                }
                catch (Exception exception) {
                    System.err.println("FcmdView.actionSetHexView - Exception; unexpected");
                }
                return true;
            }
            return false;
        }
    };
    GralUserAction actionSetTextViewISO8859_1 = new GralUserAction("actionSetTextViewISO8859_1"){

        @Override
        public boolean userActionGui(int n, GralWidget gralWidget, Object ... objectArray) {
            if (n != 720964) {
                try {
                    FcmdView.this.format = '?';
                    FcmdView.this.presentContentText(iso8859_1);
                    FcmdView.this.format = 'w';
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    System.err.println("FcmdView.actionSetTextViewISO8859_1 - UnsupportedEncodingException; unexpected");
                }
                return true;
            }
            return false;
        }
    };
    GralUserAction actionSetEditable = new GralUserAction("actionSetEditable"){

        @Override
        public boolean userActionGui(int n, GralWidget gralWidget, Object ... objectArray) {
            if (KeyCode.isControlFunctionMouseUpOrMenu((int)n)) {
                FcmdView.this.widgContent.setEditable(true);
                FcmdView.this.bEditable = true;
                return true;
            }
            return false;
        }
    };
    GralUserAction actionSave = new GralUserAction("actionSave"){

        @Override
        public boolean userActionGui(int n, GralWidget gralWidget, Object ... objectArray) {
            if (FcmdView.this.bEditable) {
                try {
                    FileRemote fileRemote = FcmdView.this.main.currentFile();
                    WritableByteChannel writableByteChannel = fileRemote.openWrite(0L);
                    ByteBuffer byteBuffer = ByteBuffer.allocate(1200);
                    FcmdView.this.syncContentFromWidg();
                    int n2 = FcmdView.this.zContent;
                    int n3 = 0;
                    while (n2 > 0) {
                        int n4 = n2 >= 1200 ? 1200 : n2;
                        byteBuffer.put(FcmdView.this.uContent, n3, n4);
                        n2 -= n4;
                        n3 += n4;
                        byteBuffer.limit(n4);
                        byteBuffer.rewind();
                        writableByteChannel.write(byteBuffer);
                        byteBuffer.limit(byteBuffer.capacity());
                        byteBuffer.clear();
                    }
                    writableByteChannel.close();
                }
                catch (Exception exception) {
                    FcmdView.this.main._gralMng.writeLog(0, exception);
                }
            }
            return true;
        }
    };
    GralUserAction actionSaveTextAsUTF8unix = new GralUserAction("actionSaveTextAsUTF8unix"){

        @Override
        public boolean userActionGui(int n, GralWidget gralWidget, Object ... objectArray) {
            FcmdView.this.saveTextAs(utf8, endl_0a);
            return true;
        }
    };
    GralUserAction actionSaveTextAsWindows = new GralUserAction("actionSaveTextAsWindows"){

        @Override
        public boolean userActionGui(int n, GralWidget gralWidget, Object ... objectArray) {
            FcmdView.this.saveTextAs(iso8859_1, endl_0d0a);
            return true;
        }
    };
    GralUserAction actionSaveTextAsISO8859_1_unix = new GralUserAction("actionSaveTextAsISO8859_1_unix"){

        @Override
        public boolean userActionGui(int n, GralWidget gralWidget, Object ... objectArray) {
            FcmdView.this.saveTextAs(iso8859_1, endl_0d0a);
            return true;
        }
    };
    GralUserAction actionOnSetInvisible = new GralUserAction("view-setInvisible"){

        @Override
        public boolean exec(int n, GralWidget_ifc gralWidget_ifc, Object ... objectArray) {
            FcmdView.this.bVisible = false;
            FcmdView.this.nrQuickview = 0;
            FcmdView.this.btnQuickview.setState(GralButton.State.Off);
            return true;
        }
    };
    GralTextFieldUser_ifc userKeys = new GralTextFieldUser_ifc(){

        @Override
        public boolean userKey(int n, String string, int n2, int n3, int n4) {
            boolean bl = true;
            FcmdView.this.widgShowInfo.setText("" + n2);
            switch (n) {
                case 201326662: {
                    FcmdView.this.actionFind.userActionGui(720973, null, new Object[0]);
                    break;
                }
                default: {
                    bl = false;
                }
            }
            return bl;
        }
    };

    public FcmdView(Fcmd fcmd) {
        this.main = fcmd;
    }

    void buildWindowView() {
        this.main._gralMng.selectPanel("primaryWindow");
        this.main._gralMng.setPosition(10.0f, 0.0f, 10.0f, 0.0f, 1, 'r');
        int n = -1073725424;
        GralWindow gralWindow = this.main._gralMng.createWindow("windView", "view - The.file.Commander", n);
        gralWindow.addMenuBarItemGThread(null, "&File/&Save", this.actionSave);
        gralWindow.addMenuBarItemGThread(null, "&File/Save-as &UTF8-Unix-lf", this.actionSaveTextAsUTF8unix);
        gralWindow.addMenuBarItemGThread(null, "&File/Save-as &Windows (ISO-8859-1)", this.actionSaveTextAsWindows);
        gralWindow.addMenuBarItemGThread(null, "&File/Save-as &ISO-8859-1-Unix-lf", this.actionSaveTextAsISO8859_1_unix);
        gralWindow.addMenuBarItemGThread("view-Search", "&View/&Hex-Byte", this.actionSetHexView);
        gralWindow.addMenuBarItemGThread("view-Search", "&View/text-&Windows", this.actionSetTextViewISO8859_1);
        gralWindow.addMenuBarItemGThread("view-Search", "&View/text-&UTF", this.actionSetTextViewUTF8);
        gralWindow.addMenuBarItemGThread("view-Search", "&View/text-&ASCII-7", this.actionSetTextViewISO8859_1);
        gralWindow.addMenuBarItemGThread("view-Search", "&View/text-&Encoding", this.actionSetTextViewISO8859_1);
        gralWindow.addMenuBarItemGThread("view-Search", "&Edit/&Search", this.actionSetTextViewISO8859_1);
        gralWindow.addMenuBarItemGThread("view-Search", "&Edit/set &Writeable", this.actionSetEditable);
        this.main._gralMng.setPosition(0.5f, 2.5f, 1.0f, 20.0f, 0, 'r');
        this.widgFindText = this.main._gralMng.addTextField(null, true, null, null);
        this.main._gralMng.setPosition(0.5f, 2.5f, 22.0f, 16394.0f, 0, 'r', 1.0f);
        this.btnFind = this.main._gralMng.addButton(null, this.actionFind, null, null, "Search (ctrl-F)");
        this.btnWholeword = this.main._gralMng.addSwitchButton(null, "wholeWord - no", "wholeWord- yes", GralColor.getColor("wh"), GralColor.getColor("gn"));
        this.btnCase = this.main._gralMng.addSwitchButton(null, "case - no", "case - yes", GralColor.getColor("wh"), GralColor.getColor("gn"));
        this.btnQuickview = this.main._gralMng.addSwitchButton("qview", "qview", "qview", GralColor.getColor("wh"), GralColor.getColor("gn"));
        this.widgShowInfo = this.main._gralMng.addTextField(null, false, null, null);
        this.main._gralMng.setPosition(3.0f, 0.0f, 0.0f, 0.0f, 1, 'r');
        this.widgContent = this.main._gralMng.addTextBox("view-content", false, null, '.');
        this.widgContent.setUser(this.userKeys);
        this.widgContent.setTextStyle(GralColor.getColor("bk"), this.main._gralMng.propertiesGui.getTextFont(2.0f, 'm', 'n'));
        this.windView = gralWindow;
        this.windView.setActionOnSettingInvisible(this.actionOnSetInvisible);
        this.windView.setWindowVisible(false);
    }

    void view(FileRemote fileRemote) {
        this.file = this.main.currentFile();
        if (this.file != null) {
            long l = this.file.length();
            this.zContent = 0;
            ReadableByteChannel readableByteChannel = this.file.openRead(0L);
            try {
                if (readableByteChannel == null) {
                    this.widgContent.setText("File is not able to read:\n");
                    this.widgContent.append(this.file.getAbsolutePath());
                } else {
                    int n;
                    do {
                        this.tmpReadTransmissionBuffer.clear();
                        n = readableByteChannel.read(this.tmpReadTransmissionBuffer);
                        if (n <= 0) continue;
                        this.tmpReadTransmissionBuffer.rewind();
                        if (this.zContent + n > this.uContent.length) {
                            n = this.uContent.length - this.zContent;
                        }
                        if (n <= 0) continue;
                        this.tmpReadTransmissionBuffer.get(this.uContent, this.zContent, n);
                        this.zContent += n;
                    } while (n > 0);
                    readableByteChannel.close();
                    this.presentContent();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (!this.bVisible) {
            this.windView.setWindowVisible(true);
            this.bVisible = true;
        }
    }

    public void quickView() {
        if (this.btnQuickview.isOn()) {
            ++this.nrQuickview;
            this.widgShowInfo.setText("" + this.nrQuickview);
            this.view(null);
        }
    }

    void detectEncoding() {
        this.encodingContent = iso8859_1;
        this.format = (char)119;
        for (int i = 0; i < this.zContent; ++i) {
            byte by = this.uContent[i];
            if (by >= 32 || by < 0 || "\r\n\t".indexOf(by) >= 0) continue;
            this.encodingContent = null;
            return;
        }
    }

    void presentContent() throws IOException {
        this.widgContent.setEditable(false);
        this.bEditable = false;
        this.detectEncoding();
        if (this.encodingContent != null) {
            this.presentContentText(this.encodingContent);
        } else {
            this.widgContent.setText("file ...\n");
            this.cursorPos = 0;
            this.format = (char)104;
            this.presentContentHex();
        }
    }

    void presentContentHex() throws IOException {
        try {
            int n;
            String string = "file: " + this.file.getAbsolutePath() + "\n";
            this.widgContent.setText(string);
            int n2 = string.length();
            for (n = 0; n < 16 && n < this.uContent.length / 16; ++n) {
                this.formatterHex.reset();
                this.formatterHex.addHex((long)n, 4).add(": ");
                this.formatterHex.addHexLine(this.uContent, 16 * n, 16, (short)1);
                this.formatterHex.add("  ").addStringLine(this.uContent, 16 * n, 16, ascii7.name());
                this.widgContent.append(this.formatterHex.getContent()).append('\n');
            }
            n = n2 + 73 * (this.cursorPos / 16) + 6 + 3 * (this.cursorPos % 16);
            this.widgContent.setCursorPos(n);
        }
        catch (Exception exception) {
            this.widgContent.append(exception.getMessage());
        }
    }

    void presentContentText(Charset charset) throws UnsupportedEncodingException {
        this.encodingContent = charset;
        String string = new String(this.uContent, 0, this.zContent, charset);
        this.widgContent.setText(string, 0);
        this.widgContent.setCursorPos(this.cursorPos);
    }

    void syncContentFromWidg() {
        switch (this.format) {
            case 'h': {
                int n = this.widgContent.getCursorPos();
                break;
            }
            case 'w': {
                this.syncTextFromWidg(iso8859_1);
                break;
            }
            case 'u': {
                this.syncTextFromWidg(utf8);
                break;
            }
        }
    }

    void syncTextFromWidg(Charset charset) {
        int n;
        this.cursorPos = n = this.widgContent.getCursorPos();
        if (this.bEditable) {
            byte[] byArray;
            String string = this.widgContent.getText();
            int n2 = string.length();
            int n3 = -1;
            for (byte by : byArray = string.getBytes(charset)) {
                this.uContent[++n3] = by;
            }
            int n4 = this.zContent - 1;
            this.zContent = ++n3;
            while (n3 < n4) {
                this.uContent[++n3] = 0;
            }
        }
    }

    void saveTextAs(Charset charset, byte[] byArray) {
        try {
            String string;
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.uContent, 0, this.zContent);
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)byteArrayInputStream, this.encodingContent);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            FileRemote fileRemote = this.main.currentFile();
            WritableByteChannel writableByteChannel = fileRemote.openWrite(0L);
            ByteBuffer byteBuffer = ByteBuffer.allocate(1200);
            do {
                int n;
                int n2;
                if ((string = bufferedReader.readLine()) == null) continue;
                byte[] byArray2 = string.getBytes(charset);
                if (byteBuffer.remaining() < byArray2.length + 1) {
                    n2 = byteBuffer.position();
                    byteBuffer.limit(n2);
                    byteBuffer.rewind();
                    writableByteChannel.write(byteBuffer);
                    byteBuffer.limit(byteBuffer.capacity());
                    byteBuffer.clear();
                }
                n2 = 0;
                while ((n = byteBuffer.remaining()) < byArray2.length - n2 + 1) {
                    byteBuffer.put(byArray2, n2, n);
                    byteBuffer.limit(n);
                    byteBuffer.rewind();
                    writableByteChannel.write(byteBuffer);
                    byteBuffer.clear();
                    n2 += n;
                }
                byteBuffer.put(byArray2, n2, byArray2.length - n2).put(byArray);
            } while (string != null);
            int n = byteBuffer.position();
            byteBuffer.limit(n);
            byteBuffer.rewind();
            writableByteChannel.write(byteBuffer);
            byteBuffer.clear();
            writableByteChannel.close();
        }
        catch (Exception exception) {
            this.main._gralMng.writeLog(0, exception);
        }
    }

    void openQuickView(FileRemote fileRemote) {
        if (this.widgQuickView == null) {
            this.main.favorPathSelector.panelRight.tabbedPanelFileCards.addGridPanel("qview", "qview", 1, 1, 10, 10);
            this.main._gralMng.setPosition(1.0f, -1.0f, 0.0f, 0.0f, 1, 'd');
            this.widgQuickView = this.main._gralMng.addTextBox("qview-content", false, null, '.');
            this.widgQuickView.setText("quick view");
            this.widgQuickView.setFocus();
        } else {
            this.closeQuickView();
        }
    }

    void closeQuickView() {
        this.main.favorPathSelector.panelRight.tabbedPanelFileCards.removePanel("qview");
        this.widgQuickView.remove();
        this.widgQuickView = null;
    }
}

