/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.commander;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import org.vishia.commander.Fcmd;
import org.vishia.fileRemote.FileRemote;
import org.vishia.gral.base.GralTextBox;
import org.vishia.gral.base.GralWidget;
import org.vishia.gral.base.GralWindow;
import org.vishia.gral.ifc.GralColor;
import org.vishia.gral.ifc.GralUserAction;
import org.vishia.gral.ifc.GralWindow_ifc;
import org.vishia.util.StringFormatter;

public class FcmdEdit {
    protected final Fcmd main;
    private GralWindow_ifc windView;
    private GralTextBox widgContent;
    private final ByteBuffer byteBuffer = ByteBuffer.allocate(1200);
    private int nrofBytes;
    private byte[] buffer = new byte[1200];
    private final char format = (char)116;
    private static Charset ascii7 = Charset.forName("US-ASCII");
    private static Charset utf8 = Charset.forName("UTF8");
    private final StringFormatter formatterHex = new StringFormatter(120);
    GralUserAction actionOpenEdit = new GralUserAction("actionOpenEdit"){

        @Override
        public boolean userActionGui(int n, GralWidget gralWidget, Object ... objectArray) {
            if (n == 720981 || n == 720973) {
                FcmdEdit.this.openEdit(FcmdEdit.this.main.currentFile());
                return true;
            }
            return false;
        }
    };
    GralUserAction actionConvertUTF8unix = new GralUserAction("actionConvertUTF8unix"){

        @Override
        public boolean userActionGui(int n, GralWidget gralWidget, Object ... objectArray) {
            try {
                String string;
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(FcmdEdit.this.buffer);
                InputStreamReader inputStreamReader = new InputStreamReader(byteArrayInputStream);
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                FileRemote fileRemote = FcmdEdit.this.main.currentFile();
                WritableByteChannel writableByteChannel = fileRemote.openWrite(0L);
                ByteBuffer byteBuffer = ByteBuffer.allocate(1200);
                do {
                    int n2;
                    if ((string = bufferedReader.readLine()) == null) continue;
                    byte[] byArray = string.getBytes(utf8);
                    if (byteBuffer.remaining() < byArray.length + 1) {
                        byteBuffer.rewind();
                        writableByteChannel.write(byteBuffer);
                        byteBuffer.clear();
                    }
                    int n3 = 0;
                    while ((n2 = byteBuffer.remaining()) < byArray.length - n3 + 1) {
                        byteBuffer.put(byArray, n3, n2);
                        byteBuffer.rewind();
                        writableByteChannel.write(byteBuffer);
                        byteBuffer.clear();
                        n3 += n2;
                    }
                    byteBuffer.put(byArray, n3, byArray.length - n3).put((byte)10);
                } while (string != null);
                byteBuffer.rewind();
                writableByteChannel.write(byteBuffer);
                byteBuffer.clear();
                writableByteChannel.close();
            }
            catch (Exception exception) {
                FcmdEdit.this.main._gralMng.writeLog(0, exception);
            }
            return true;
        }
    };

    public FcmdEdit(Fcmd fcmd) {
        this.main = fcmd;
    }

    void buildWindow() {
        this.main._gralMng.selectPanel("primaryWindow");
        this.main._gralMng.setPosition(10.0f, 0.0f, 10.0f, 0.0f, 1, 'r');
        int n = -1073741824;
        GralWindow gralWindow = this.main._gralMng.createWindow("windView", "view - The.file.Commander", n);
        gralWindow.addMenuBarItemGThread("view-Search", "&Edit/&Search", this.actionOpenEdit);
        gralWindow.addMenuBarItemGThread("view-Search", "&Edit/set &Writeable", this.actionOpenEdit);
        gralWindow.addMenuBarItemGThread("view-Search", "&View/&Hex-Byte", this.actionOpenEdit);
        gralWindow.addMenuBarItemGThread("view-Search", "&View/text-&Windows", this.actionOpenEdit);
        gralWindow.addMenuBarItemGThread("view-Search", "&View/text-&UTF", this.actionOpenEdit);
        gralWindow.addMenuBarItemGThread("view-Search", "&View/text-&ASCII-7", this.actionOpenEdit);
        gralWindow.addMenuBarItemGThread("view-Search", "&View/text-&Encoding", this.actionOpenEdit);
        gralWindow.addMenuBarItemGThread(null, "&Save-as/UTF8-Unix-lf", this.actionConvertUTF8unix);
        this.main._gralMng.setPosition(0.0f, 0.0f, 0.0f, 0.0f, 1, 'r');
        this.widgContent = this.main._gralMng.addTextBox("view-content", false, null, '.');
        this.widgContent.setTextStyle(GralColor.getColor("bk"), this.main._gralMng.propertiesGui.getTextFont(2.0f, 'm', 'n'));
        this.windView = gralWindow;
        this.windView.setWindowVisible(false);
    }

    void openEdit(FileRemote fileRemote) {
        if (fileRemote != null) {
            long l = fileRemote.length();
            if (l > 1000000L) {
                l = 1000000L;
            }
            this.buffer = new byte[(int)l];
            int n = 0;
            ReadableByteChannel readableByteChannel = fileRemote.openRead(0L);
            try {
                if (readableByteChannel == null) {
                    this.widgContent.setText("File is not able to read:\n");
                    this.widgContent.append(fileRemote.getAbsolutePath());
                } else {
                    do {
                        this.byteBuffer.clear();
                        this.nrofBytes = readableByteChannel.read(this.byteBuffer);
                        if (this.nrofBytes <= 0) continue;
                        this.byteBuffer.rewind();
                        this.byteBuffer.get(this.buffer, n, this.nrofBytes);
                        n += this.nrofBytes;
                    } while (this.nrofBytes > 0);
                    readableByteChannel.close();
                    this.presentContent();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.windView.setWindowVisible(true);
    }

    void presentContent() throws IOException {
        this.widgContent.setText("file ...\n");
        this.presentContentHex();
    }

    void presentContentHex() throws IOException {
        try {
            for (int i = 0; i < 16 && i < this.buffer.length / 16; ++i) {
                this.formatterHex.reset();
                this.formatterHex.addHex((long)i, 4).add(": ");
                this.formatterHex.addHexLine(this.buffer, 16 * i, 16, (short)1);
                this.formatterHex.add("  ").addStringLine(this.buffer, 16 * i, 16, ascii7.name());
                this.widgContent.append(this.formatterHex.getContent()).append('\n');
            }
        }
        catch (Exception exception) {
            this.widgContent.append(exception.getMessage());
        }
    }

    void presentContentText() throws IOException {
        CharBuffer charBuffer = ascii7.decode(this.byteBuffer);
        try {
            while (true) {
                char c = charBuffer.get();
                this.widgContent.append(c);
            }
        }
        catch (Exception exception) {
            this.widgContent.append('?');
            return;
        }
    }
}

